/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.text.SimpleDateFormat;
import java.util.Date;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;

public class SJctrLastUpdateTimeModel
extends SJctrSimpleDataModel {
    public static final String KEY_DATE = "COM_DATE";
    public static final String KEY_DIFF_TIME = "COM_DIFF_TIME";
    public static final String GUID_LAST_UPDATE_TIME_UNKNOWN = "LAST_UPDATE_UNKNOWN";
    public static final int UNKNOWN_DIFF_TIME = -1;
    private static SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    public static String UNKNOWN_LAST_UPDATE_TIME = "----/--/-- --:--";
    private Date lastUpdateTime;

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        UNKNOWN_LAST_UPDATE_TIME = util.getGuidance(GUID_LAST_UPDATE_TIME_UNKNOWN);
    }

    @Override
    protected void makeModelDirect() {
    }

    @Override
    protected void makeDataObject() {
        long dTime;
        String strLastUpdateTime = UNKNOWN_LAST_UPDATE_TIME;
        int intDMinute = -1;
        if (this.lastUpdateTime != null && (dTime = System.currentTimeMillis() - this.lastUpdateTime.getTime()) >= 0L) {
            strLastUpdateTime = simpleDate.format(this.lastUpdateTime);
            intDMinute = (int)(dTime / 1000L / 60L);
        }
        Object viewData = this.getManageData();
        ((SJctrDataObject)viewData).setData(KEY_DATE, strLastUpdateTime);
        ((SJctrDataObject)viewData).setData(KEY_DIFF_TIME, intDMinute);
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date date) {
        this.lastUpdateTime = date;
        this.makeDataObject();
        this.setDirty();
        if (date == null) {
            this.getLogUty().putlog("setLastUpdateTime", "date is null");
        } else {
            this.getLogUty().putlog("setLastUpdateTime", "date:" + date.toString());
        }
    }

    public void setLastUpdateTime() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        this.setLastUpdateTime(date);
    }
}

