/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.comdialog.viewalusslus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.topwindow.comdialog.viewalusslus.model.SJctrViewAlusSlusTabModel;
import sanproject.sn2.controller.topwindow.comdialog.viewalusslus.model.SJctrViewAlusTableModel;
import sanproject.sn2.controller.topwindow.comdialog.viewalusslus.model.SJctrViewSlusTableModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.vvol.com.SJctrHDPDef;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrViewAlusSlusDC
extends SJctrDialogDataController
implements SJctrHDPDef {
    public static final int DISP_ID = 34664549;
    private static final String KEY_TAB = "COM_TAB";
    private static final String KEY_TABLE_ALUS = "COM_TABLE_ALUS";
    private static final String KEY_TABLE_SLUS = "COM_TABLE_SLUS";
    public static final String KEY_LDEV_LIST = "KEY_LDEV_LIST";
    private static final int ERROR_LDEV_ALUSLUNG = 205158;
    private SJctrRelatedDispDataObject _WarningMsg = null;

    public SJctrViewAlusSlusDC() throws SJcException {
        super(34664549);
        this.initDataModel();
        this.addDataObjectModel("COM_CHILD", new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>();
                if (SJctrViewAlusSlusDC.this._WarningMsg != null) {
                    retList.add(SJctrViewAlusSlusDC.this._WarningMsg);
                    SJctrViewAlusSlusDC.this._WarningMsg = null;
                }
                return retList;
            }
        });
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TAB, new SJctrViewAlusSlusTabModel());
        this.addDataObjectModel(KEY_TABLE_ALUS, new SJctrViewAlusTableModel());
        this.addDataObjectModel(KEY_TABLE_SLUS, new SJctrViewSlusTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(new SJmoGetLdevNicknameInfo()));
        set.add(this.createModelDirect(new SJmoGetLdevDetail()));
        set.add(this.createModelDirect(new SJmoGetRSGgetAllRsgs()));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper retDirect = new SJctrGetDirectWrapper(direct);
        return retDirect;
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        List<Object> wkldevList;
        List<?> selectData = this.getCache("KEY_SELECT_LDEV_INDEX");
        List<?> ldevDetailList = this.getCache(KEY_CLASS_GETLDEVDETAIL);
        List<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
        if (selectData != null && selectData.size() > 0) {
            wkldevList = selectData;
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
            boolean bWarnigMsg = false;
            for (SJmoLdevIndex sJmoLdevIndex : wkldevList) {
                int ldevIndex = Collections.binarySearch(ldevDetailList, sJmoLdevIndex);
                if (ldevIndex >= 0) {
                    SJmoLdevDetail ldev = (SJmoLdevDetail)ldevDetailList.get(ldevIndex);
                    SJctrLDEVDetail wkLDEV = new SJctrLDEVDetail();
                    wkLDEV.setDetailData(ldev);
                    if (wkLDEV.getBAlu() || wkLDEV.getBSlu()) {
                        ldevList.add(wkLDEV);
                        continue;
                    }
                    bWarnigMsg = true;
                    continue;
                }
                SJctrError error = new SJctrError(30, 22, 105134);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(sJmoLdevIndex, error);
                errColumnList.add(errColumn);
            }
            if (errColumnList.size() > 0) {
                this.output_errorList(errColumnList);
            }
            if (bWarnigMsg) {
                this.showWarningMsg(205158);
            }
            errColumnList = SJctrLdevUtility.getAluSluData(this, ldevList);
        } else {
            SJmoLdevDetail ldev;
            int i;
            wkldevList = new ArrayList();
            for (i = 0; i < ldevDetailList.size(); ++i) {
                ldev = (SJmoLdevDetail)ldevDetailList.get(i);
                SJctrLDEVDetail wkLDEV = new SJctrLDEVDetail();
                wkLDEV.setDetailData(ldev);
                if (!wkLDEV.getBAlu() && !wkLDEV.getBSlu()) continue;
                ((ArrayList)wkldevList).add(wkLDEV);
            }
            SJctrLdevUtility.getAluSluData(this, wkldevList);
            for (i = 0; i < ((ArrayList)wkldevList).size(); ++i) {
                ldev = (SJctrLDEVDetail)((ArrayList)wkldevList).get(i);
                ldevList.add(ldev);
            }
        }
        List<?> LDEVNameList = this.getCache(SJctrCVSMacro.KEY_CLASS_GETLDEVNICKNAMEINFO);
        if (LDEVNameList != null && LDEVNameList.size() != -1) {
            for (int i = 0; i < ldevList.size(); ++i) {
                SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)ldevList.get(i);
                int index = Collections.binarySearch(LDEVNameList, LDEVInf);
                if (index < 0) continue;
                SJmoLdevNicknameInfo sJmoLdevNicknameInfo = (SJmoLdevNicknameInfo)LDEVNameList.get(index);
                LDEVInf.setStrLdevName(sJmoLdevNicknameInfo.getStrNickname());
            }
        }
        Collections.sort(ldevList);
        List<?> allRsgsList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (allRsgsList.size() > 0) {
            ldevList = SJctrArrayGroupUtility.extractAvailableLdevList(ldevList, (SJmoRSGgetAllRsgs)allRsgsList.get(0), this.getOwner());
        }
        this.putCache(KEY_LDEV_LIST, ldevList);
        SJctrViewAlusSlusTabModel tab = (SJctrViewAlusSlusTabModel)this.getDataObjectModel(KEY_TAB);
        tab.initData();
        return true;
    }

    private void output_errorList(ArrayList<SJctrErrorColumnData> errColumnList) {
        SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = this.getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        try {
            errDC.setParameter(this.getRelatedDataController().get(0).getDataObjectModel("COM_TABLE"), errColumnList);
        }
        catch (Exception ex) {
            SJctrLogUty.info("SJctrViewAlusSlusDC", "output_errorList", "EXCEPTION");
        }
        SJctrErrorColumnData errColumnData = errColumnList.get(0);
        SJctrError error = errColumnData.getError();
        SJctrError errorExp = new SJctrError(error.getFunc(), error.getModule(), error.getError());
        SJcException exp = errorExp.createException();
        exp.setErrDisp(errDisp);
        throw exp;
    }

    protected void showWarningMsg(int iError) {
        String strFunc = Integer.toString(30);
        String strModo = Integer.toString(22);
        String strErr = Integer.toString(iError);
        this._WarningMsg = this.createMsgDialog(new SJcMessage(strFunc, strModo, strErr));
    }
}

