/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.information;

import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.model.node.SJctrItemCreateLabelAction;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.controller.topwindow.information.hardwares.SJctrInformationHardwaresSummaryModel;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrItemCreateLabelActionSubsystem
extends SJctrItemCreateLabelAction {
    private static final String GUID_BRACKET_L = "BRACKET_LEFT";
    private static final String GUID_BRACKET_R = "BRACKET_RIGHT";
    private static final String GUID_SN = "SERIAL_NUM_S";
    private static final String GUID_COLON = "COLON";

    @Override
    public String createLabel(SJctrNodeData nodeData, Object ... args) {
        SJmoSubsystemInfo systemInfo = null;
        List<?> subsystemInfoList = nodeData.getDataModel().getDataController().getModelData(SJmoGetSubsystemInfo.class);
        String label = "";
        if (subsystemInfoList != null && subsystemInfoList.size() > 0) {
            systemInfo = (SJmoSubsystemInfo)subsystemInfoList.get(0);
            SJctrComUtility util = nodeData.getDataModel().getComUtility();
            label = this.toLabel(util, systemInfo);
        }
        return label;
    }

    private String toLabel(SJctrComUtility util, SJmoSubsystemInfo info) {
        if (util == null || info == null) {
            return "?";
        }
        String name = SJctrInformationHardwaresSummaryModel.getSystemName(info);
        StringBuilder buf = new StringBuilder(name);
        buf.append(util.getGuidance(GUID_BRACKET_L));
        buf.append(util.getGuidance(GUID_SN));
        buf.append(util.getGuidance(GUID_COLON));
        buf.append(info.getDKCSNString());
        buf.append(util.getGuidance(GUID_BRACKET_R));
        return buf.toString();
    }
}

