/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.pool.poolvol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrArrayGroupColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrCacheModeColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrCapacityColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrDDMLdevLinkActionFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrDataDirectMappedLdevColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrDriveTypeColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrEncryptionColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrGetColumnIconCellObject;
import sanproject.sn2.controller.com.column.SJctrLdevColumnCellObject;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrLdevLinkActionFromLdevIndex;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrParentColumn;
import sanproject.sn2.controller.com.column.SJctrPgCapExpantioRateColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrPoolVolAttributeColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrPoolVolMappedCapacityColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrPoolVolStatusFromPoolLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrProvisioningTypeFromPoolLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrRaidLevelColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrRsgColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrShrinkableFromPoolLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrTierIDColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrVirtualizationModeColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.column.SJctrVirtualizationSpaceUsedColumnFromPoolLdevDetail;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPLSummaryModel;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolVolumesDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPoolVolumesTableModel
extends SJctrTableDataModel {
    @Override
    protected void initTable() {
        SJctrLdevIdColumnFromPoolLdevDetail ldevIdColumn = new SJctrLdevIdColumnFromPoolLdevDetail("COM_COL_LDEVID");
        ldevIdColumn.setItemInfo(3);
        SJctrLdevLinkActionFromLdevIndex ldevLinkAction = new SJctrLdevLinkActionFromLdevIndex();
        ldevIdColumn.setLinkAction(ldevLinkAction);
        SJctrLdevColumnCellObject ldevCell = new SJctrLdevColumnCellObject();
        ldevIdColumn.setCellObj(ldevCell);
        this.addColumn(ldevIdColumn);
        this.addColumn(new SJctrLdevNameColumnFromPoolLdevDetail("COM_COL_LDEVNAME"));
        this.addColumn(new SJctrPoolVolStatusFromPoolLdevDetailColumn("COM_COL_STATUS"));
        this.addColumn(new SJctrArrayGroupColumnFromPoolLdevDetail("COM_COL_ARYGRP"));
        SJctrParentColumn capacityColumn = new SJctrParentColumn("COM_COL_POOLVOL_CAP");
        capacityColumn.setPartsId("CAPACITY");
        this.addColumn(capacityColumn);
        SJctrCapacityColumnFromPoolLdevDetail usableColumn = new SJctrCapacityColumnFromPoolLdevDetail("COM_COL_POOLVOL_CAP_USABLE");
        usableColumn.setPartsId("USABLE");
        capacityColumn.addColumn(usableColumn);
        capacityColumn.addColumn(new SJctrPoolVolMappedCapacityColumnFromPoolLdevDetail("COM_COL_POOLVOL_CAP_MAPPED"));
        this.addColumn(new SJctrRaidLevelColumnFromPoolLdevDetail("COM_COL_RAIDLEV"));
        SJctrEmulationTypeColumnFromPoolLdevDetail emuTypeColum = new SJctrEmulationTypeColumnFromPoolLdevDetail("COM_COL_EMUTYPE");
        if (SJctrDataController.isHM()) {
            emuTypeColum.setSupportColumn(false);
        }
        this.addColumn(emuTypeColum);
        this.addColumn(new SJctrDriveTypeColumnFromPoolLdevDetail("COM_COL_DRTYPE"));
        this.addColumn(new SJctrTierIDColumnFromPoolLdevDetail("COM_COL_TIERID"));
        this.addColumn(new SJctrProvisioningTypeFromPoolLdevDetailColumn("COM_COL_VOLTYPE"));
        this.addColumn(new SJctrPoolVolAttributeColumnFromPoolLdevDetail("COM_COL_ATTR"));
        this.addColumn(new SJctrCacheModeColumnFromPoolLdevDetail("COM_COL_CACHEMODE"));
        this.addColumn(new SJctrShrinkableFromPoolLdevDetailColumn("COM_COL_SHRINK"));
        SJctrEncryptionColumnFromPoolLdevDetail encColumn = new SJctrEncryptionColumnFromPoolLdevDetail("COM_COL_ENCRYPTION");
        encColumn.setShowColumnDefault(false);
        this.addColumn(encColumn);
        SJctrVirtualizationModeColumnFromPoolLdevDetail virtualizationModeColumn = new SJctrVirtualizationModeColumnFromPoolLdevDetail("COM_COL_VIRTUAL_MODE");
        virtualizationModeColumn.setShowColumnDefault(false);
        this.addColumn(virtualizationModeColumn);
        SJctrVirtualizationSpaceUsedColumnFromPoolLdevDetail virtualizationSpaceUsedColumn = new SJctrVirtualizationSpaceUsedColumnFromPoolLdevDetail("COM_COL_VIRTUAL_SPACE_USED");
        virtualizationSpaceUsedColumn.setShowColumnDefault(false);
        this.addColumn(virtualizationSpaceUsedColumn);
        SJctrDataDirectMappedLdevColumnFromPoolLdevDetail ddmLdevColumn = new SJctrDataDirectMappedLdevColumnFromPoolLdevDetail("COM_COL_DM_LDEV");
        ddmLdevColumn.setShowColumnDefault(false);
        ddmLdevColumn.setItemInfo(2);
        SJctrDDMLdevLinkActionFromPoolLdevDetail ddmLdevLinkAction = new SJctrDDMLdevLinkActionFromPoolLdevDetail();
        ddmLdevColumn.setLinkAction(ddmLdevLinkAction);
        this.addColumn(ddmLdevColumn);
        this.addColumn(new SJctrRsgColumnFromPoolLdevDetail("COM_COL_RSG"));
        SJctrPgCapExpantioRateColumnFromPoolLdevDetail pgCapExpantioRateColumn = new SJctrPgCapExpantioRateColumnFromPoolLdevDetail("COM_COL_PHYSICAL_PG_EXP_RATE");
        SJctrGetColumnIconCellObject pgCapExpantioRateCelObj = new SJctrGetColumnIconCellObject();
        pgCapExpantioRateColumn.setCellObj(pgCapExpantioRateCelObj);
        pgCapExpantioRateColumn.setItemInfo(1);
        this.addColumn(pgCapExpantioRateColumn);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        List<Object> mainKeyList = new ArrayList();
        SJctrDataController dc = this.getDataController();
        SJctrPoolVolumesDC poolVolDC = (SJctrPoolVolumesDC)dc;
        SJctrPLSummaryModel plSmryMdl = new SJctrPLSummaryModel();
        plSmryMdl.m_PoolSelDC = poolVolDC;
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(super.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        SJmoPoolDetail poolDtl = plSmryMdl.getPoolDetailSummary(poolDtlList);
        ArrayList<SJmoPoolVolDetail> poolVolDtlList = new ArrayList<SJmoPoolVolDetail>(super.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        SJmoPoolVolDetail poolVolDtl = plSmryMdl.getPoolVolDetailSummary(poolVolDtlList);
        ArrayList poolVolInf = new ArrayList();
        if (null != poolVolDtl) {
            poolVolInf = poolVolDtl.getAlPoolInfo();
            this.setBasicData(SJctrPoolUtility.KEY_CLASS_POOLVOL_INFO, poolVolInf);
        }
        ArrayList<SJmoLdevDetail> ldevDtlListAll = new ArrayList<SJmoLdevDetail>(super.getBasicDataList(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        List<SJmoLdevDetail> ldevDtlList = plSmryMdl.getLdevDetailSummary(ldevDtlListAll, poolVolDtl);
        mainKeyList = this.makeMainKeyList(poolDtl, poolVolInf, ldevDtlList);
        boolean bCapacityFlg = true;
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        boolean iEmulation = false;
        for (int iCnt = 0; iCnt < ldevDtlList.size(); ++iCnt) {
            SJmoLdevDetail ldevDtl = ldevDtlList.get(iCnt);
            if (SJctrLdevUtility.isOpenVolume(ldevDtl)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrLdevUtility.isMFVolume(ldevDtl)) continue;
            bMFFlg = true;
        }
        this.setCapacityFlg(bCapacityFlg);
        this.setMainframeVolumeFlg(bMFFlg);
        this.setOpenVolumeFlg(bOpenFlg);
        this.setDpVolumeFlg(true);
        return mainKeyList;
    }

    public List<SJctrPoolLdevDetail> makeMainKeyList(SJmoPoolDetail poolDtl, List<SJmoPoolVolInfo> poolVolInfList, List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJctrPoolLdevDetail> mainKeyList = new ArrayList<SJctrPoolLdevDetail>();
        if (null != poolDtl && null != poolVolInfList && 0 != poolVolInfList.size() && null != ldevDtlList && 0 != ldevDtlList.size()) {
            Collections.sort(ldevDtlList);
            for (int iListCnt = 0; iListCnt < poolVolInfList.size(); ++iListCnt) {
                SJmoPoolVolInfo poolVolInf = poolVolInfList.get(iListCnt);
                int iLdevDtlIdx = Collections.binarySearch(ldevDtlList, poolVolInf);
                if (0 <= iLdevDtlIdx) {
                    SJmoLdevDetail ldevDtl = ldevDtlList.get(iLdevDtlIdx);
                    SJctrPoolLdevDetail poolldevDtl = new SJctrPoolLdevDetail();
                    poolldevDtl.setLdevIndex(ldevDtl.getSLdkc(), ldevDtl.getSCu(), ldevDtl.getSLdev());
                    poolldevDtl.setPoolLdevDetail(poolDtl, poolVolInf, ldevDtl);
                    mainKeyList.add(poolldevDtl);
                    continue;
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeMainKeyList", "LDEVID Not Found in SJmoLdevDetail");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeMainKeyList", "ModelData is null or size 0");
        }
        return mainKeyList;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void makeCapacityUnitInfo() {
    }
}

