/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.iscsi.iscsitarget;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrItemExpandListenerIscsiTarget
implements SJctrItemExpandListener {
    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String name = (String)event.getChangeObject();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        String parentNodePath = name + "\t";
        HashSet<String> keySet = new HashSet<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keySet) {
            if (!childeNodePath.startsWith(parentNodePath)) continue;
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String name = (String)event.getChangeObject();
        SJctrNodeData nodeData = dataModel.getNodePathToNodeDataMap().get(name);
        Object[] args = nodeData.getNodePathToArgsMap().get(name);
        SJmoPortDetail portInfo = (SJmoPortDetail)args[0];
        if (!SJctrIscsiUtility.isIscsiPort(portInfo)) {
            return;
        }
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        List<?> ptIscsiInfoList = nodeData.getDataModel().getDataController().getModelData(SJmoGetPortIscsiTargetInfo.class);
        if (null == ptIscsiInfoList) {
            return;
        }
        SJmoPortIscsiTargetInfo portIscsiTarget = (SJmoPortIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortIndex(ptIscsiInfoList, portInfo);
        SJctrDataController dc = dataModel.getDataController();
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (null == rsgDetailList || rsgDetailList.size() == 0) {
            return;
        }
        SJmoRSGgetAllRsgs allRsgs = (SJmoRSGgetAllRsgs)rsgDetailList.get(0);
        if (null == allRsgs) {
            return;
        }
        SJctrResourceGroupUtility rsgUti = new SJctrResourceGroupUtility(dc.getOwner(), allRsgs);
        List<SJmoIscsiTargetInfo> iscsiList = SJctrIscsiUtility.getRsgIscsiTargetList(portIscsiTarget, rsgUti);
        Collections.sort(iscsiList, new SJctrIscsiTargetAliasComparator());
        for (SJmoIscsiTargetInfo iscsi : iscsiList) {
            Object[] childeArgs = new Object[]{portInfo, iscsi};
            dataModel.addItem(childeNodeData, childeArgs);
        }
    }
}

