/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.vpm.paritygroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.vpm.paritygroups.SJctrClprSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrVPMResourcesSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_NUM_OF_CLPR = "COM_CLPR";
    public static final String KEY_GENERAL = "COM_GENERAL";
    public static final String KEY_GENERAL_PER = "COM_GENERAL_PER";
    public static final String KEY_RESIDENT = "COM_RESIDENT";
    public static final String KEY_RESIDENT_PER = "COM_RESIDENT_PER";
    public static final String KEY_TOTAL_SIZE = "COM_TOTAL_SIZE";
    public static final String KEY_PG_NUM = "COM_PG_NUM";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_TOTAL_RSC = "COM_TOTAL_RSC";
    public static final String KEY_NUM_OF_RESIDENT = "COM_NUM_OF_RESIDENT";
    private SummaryData summary;

    @Override
    public void makeDataObject() {
        if (SJctrDataController.isHM()) {
            this.getComUtility().getVPMUtility();
        }
        this.summary = new SummaryData();
        this.summary.clprInfoList = this.getBasicDataList(SJmoGetClprInfo.class);
        this.summary.clprSelDC = (SJctrClprSelectDC)this.getDataController();
        this.summary.capacityUtil = this.getComUtility().getCapacityUtility();
        this.summary.allPgList = this.getBasicDataList(SJmoGetPgDetail.class);
        this.summary.allLdevList = this.getBasicDataList(SJmoGetLdevDetail.class);
        SJctrUserController userCtrl = this.getDataController().getOwner();
        List<SJmoGetRSGgetAllRsgs> allRsgList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
        this.summary.resGropUtility = new SJctrResourceGroupUtility(userCtrl, (SJmoRSGgetAllRsgs)((Object)allRsgList.get(0)));
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        SJmoClprInfo clprInfo = new SJmoClprInfo();
        clprInfo.setSClpr((short)this.summary.clprSelDC.getSelectClpr());
        int iSearch = Collections.binarySearch(this.summary.clprInfoList, clprInfo);
        clprInfo = iSearch >= 0 ? this.summary.clprInfoList.get(iSearch) : null;
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_CLPR, this.getClprNameId(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_GENERAL, this.getGeneral(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_RESIDENT, this.getResident(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_SIZE, this.getTotalSize(clprInfo));
        String strGeneralPrm = "?";
        String strResidentPrm = "?";
        if (clprInfo != null) {
            int iPrm = 100;
            int iGeneralPrm = (int)Math.ceil((float)clprInfo.getICacheCapacity() / (float)(clprInfo.getICacheCapacity() + clprInfo.getIDCRCapacity()) * 100.0f);
            strGeneralPrm = String.valueOf(iGeneralPrm);
            strResidentPrm = String.valueOf(iPrm - iGeneralPrm);
        }
        ((SJctrDataObject)summaryData).setData(KEY_GENERAL_PER, "[" + strGeneralPrm + "%]");
        ((SJctrDataObject)summaryData).setData(KEY_RESIDENT_PER, "[" + strResidentPrm + "%]");
        ((SJctrDataObject)summaryData).setData(KEY_PG_NUM, this.getPgNum(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_NUM, this.getVvolnum(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_RSC, this.getTotalRscNum(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_RESIDENT, this.getResidentExtNum(clprInfo));
    }

    private String getClprNameId(SJmoClprInfo clprInfo) {
        String strRet = "?:?";
        if (clprInfo != null) {
            strRet = SJctrVpmUtility.toClprNameIdDisplay(clprInfo);
        }
        return strRet;
    }

    private String getGeneral(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null) {
            long lBlockSize = this.summary.capacityUtil.valueOf((long)(clprInfo.getICacheCapacity() - clprInfo.getIDCRCapacity()), SJctrCapacityUtility.UNIT.MB);
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getResident(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null) {
            long lBlockSize = this.summary.capacityUtil.valueOf((long)clprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getTotalSize(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null) {
            long lBlockSize = this.summary.capacityUtil.valueOf((long)clprInfo.getICacheCapacity(), SJctrCapacityUtility.UNIT.MB);
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getPgNum(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null && this.summary.resGropUtility != null && this.summary.allPgList != null) {
            ArrayList<SJmoPgIndex> exrractPgList = new ArrayList<SJmoPgIndex>(this.summary.resGropUtility.extractPg(this.summary.allPgList));
            strRet = String.valueOf(SJctrVpmUtility.getPgList(clprInfo, exrractPgList).size());
        }
        return strRet;
    }

    private String getVvolnum(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null && this.summary.resGropUtility != null && this.summary.allLdevList != null) {
            List<SJmoLdevIndex> exrractVvolList = new ArrayList<SJmoLdevIndex>(this.summary.resGropUtility.extractLdev(this.summary.allLdevList));
            exrractVvolList = SJctrVpmUtility.getVVolList(exrractVvolList);
            strRet = String.valueOf(SJctrVpmUtility.getVVolList(clprInfo, exrractVvolList).size());
        }
        return strRet;
    }

    private String getTotalRscNum(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null && this.summary.resGropUtility != null && this.summary.allPgList != null && this.summary.allLdevList != null) {
            ArrayList<SJmoPgIndex> exrractPgList = new ArrayList<SJmoPgIndex>(this.summary.resGropUtility.extractPg(this.summary.allPgList));
            List<SJmoLdevIndex> exrractVvolList = new ArrayList<SJmoLdevIndex>(this.summary.resGropUtility.extractLdev(this.summary.allLdevList));
            exrractVvolList = SJctrVpmUtility.getVVolList(exrractVvolList);
            strRet = String.valueOf(SJctrVpmUtility.getPgList(clprInfo, exrractPgList).size() + SJctrVpmUtility.getVVolList(clprInfo, exrractVvolList).size());
        }
        return strRet;
    }

    private String getResidentExtNum(SJmoClprInfo clprInfo) {
        String strRet = "?";
        if (clprInfo != null) {
            strRet = String.valueOf(clprInfo.getIDCRExtentLimit());
        }
        return strRet;
    }

    private class SummaryData {
        SJctrClprSelectDC clprSelDC = null;
        SJctrCapacityUtility capacityUtil = null;
        SJctrResourceGroupUtility resGropUtility = null;
        List<SJmoPgDetail> allPgList = null;
        List<SJmoLdevDetail> allLdevList = null;
        List<SJmoClprInfo> clprInfoList = null;

        private SummaryData() {
        }
    }
}

