/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmDC;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public abstract class SJctrWizardDataController
extends SJctrDataController {
    public static final String KEY_FOOTER = "COM_FOOTER";
    private static final String KEY_ROLLBACK = "COM_ROLLBACK";
    protected static final String KEY_CACHE_KEEP_UTIL_CLS = "KEY_CACHE_KEEP_UTIL_CLS";
    protected static final String KEY_CACHE_KEEP_RSV_DATA = "KEY_CACHE_KEEP_RSV_DATA";
    private Map<String, List<?>> currentCache;
    private Map<String, List<?>> oldCache;
    protected Map<String, List<?>> rscUtilRsvDataMap;
    protected List<String> utilList;
    private boolean chkEndFlg = false;
    private SJctrWizardWindowDC topWizard;
    private boolean settingDataFlg = false;
    private boolean putCacheFlg = false;

    public SJctrWizardDataController(int dispId) throws SJcException {
        super(dispId);
        this.initListener();
    }

    public boolean checkEndData() {
        boolean result = true;
        return result;
    }

    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        boolean result = false;
        return result;
    }

    public boolean checkStartData() {
        boolean result = true;
        return result;
    }

    @Override
    public void construct() throws SJcException {
        if (!this.isConstruct()) {
            this.wizardConctruct();
        }
        super.construct();
        this.updateFooter();
    }

    public abstract String getDispName();

    public void putCache(Class<?> key, List<?> list) {
        this.putCache(key.getName(), list);
    }

    public void putCache(String key, List<?> list) {
        Object obj;
        if (list != null && list.size() > 0 && (obj = list.get(0)) instanceof SJmoRscUtil) {
            this.putRscCache(key, (SJmoRscUtil)obj);
        }
        this.getWizardWindow().rollback();
        this.getProxy().putCache(key, list);
        if (this.settingDataFlg) {
            this.putCacheFlg = true;
        }
    }

    public List<?> getCache(Class<?> key) {
        return this.getCache(key.getName());
    }

    public List<?> getCache(String key) {
        return this.getProxy().getCache(key);
    }

    @Override
    public final boolean getRollBackInfo() {
        Boolean flg = Boolean.FALSE;
        Object obj = this.getManageData().getData(KEY_ROLLBACK);
        if (obj instanceof Boolean) {
            flg = (Boolean)obj;
        }
        return flg;
    }

    public void initNextTask(SJctrActionDefine[] actions) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel(KEY_FOOTER);
        if (dataModel instanceof SJctrFooterDataModel) {
            SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
            footer.initNextTask(actions);
        }
    }

    public void rollback() {
        this.currentCache.clear();
        this.clearData();
        this.getProxy().setCacheMap(this.oldCache);
        this.putCacheFlg = false;
        this.chkEndFlg = false;
    }

    public void selectNextTask(SJctrActionDefine action) {
    }

    public final void setRollBackInfo(boolean flg) {
        this.getManageData().setData(KEY_ROLLBACK, flg);
    }

    @Override
    protected final Map<SJctrGetDirectWrapper, List<?>> getDataInf(Set<SJctrGetDirectWrapper> directList) {
        Map<SJctrGetDirectWrapper, List<?>> map = super.getDataInf(directList);
        this.makeRscUtilCtrlData();
        return map;
    }

    public void resetRscUtil() {
        SJctrWizardWindowDC wizWindow = this.getWizardWindow();
        if (wizWindow != null && !wizWindow.isDoRollback()) {
            return;
        }
        this.resetRscUtilMain();
    }

    private void resetRscUtilMain() {
        SJctrLogUty.info(this.getClass().getSimpleName(), "resetRscUtilMain", "Start Reset Resource Utility!!");
        for (String rscUtilCls : this.utilList) {
            List<?> rscUtilList = this.getCache(rscUtilCls);
            if (rscUtilList != null && rscUtilList.size() > 0) {
                SJmoRscUtil rscUtil = (SJmoRscUtil)rscUtilList.get(0);
                rscUtil.clearModelData();
                rscUtil.renewModelData(rscUtil);
                rscUtil.clearRsvData();
                List<?> lsRsvData = this.rscUtilRsvDataMap.get(rscUtilCls);
                if (lsRsvData != null) {
                    rscUtil.setRsvData(lsRsvData);
                    SJctrLogUty.info(this.getClass().getSimpleName(), "resetRscUtilMain", "Reset Rsv Data : " + rscUtilCls);
                    continue;
                }
                SJctrLogUty.info(this.getClass().getSimpleName(), "resetRscUtilMain", "Rsv Data Miss : " + rscUtilCls);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "resetRscUtilMain", "Cache Miss : " + rscUtilCls);
        }
    }

    private void makeRscUtilCtrlData() {
        this.initUtilList();
        this.initUtilRsvDataMap();
    }

    protected void initUtilList() {
        this.utilList = new ArrayList<String>();
        List<String> utilClsList = this.getProxy().getRscUtilClsList();
        this.utilList.addAll(utilClsList);
        SJctrLogUty.info(this.getClass().getSimpleName(), "initUtilList", "Initialize utilList. size = " + this.utilList.size());
    }

    protected void initUtilRsvDataMap() {
        this.rscUtilRsvDataMap = new HashMap();
        for (String rscUtilCls : this.utilList) {
            List<?> rscUtilList = this.getCache(rscUtilCls);
            if (rscUtilList == null || rscUtilList.size() <= 0) continue;
            SJmoRscUtil rscUtil = (SJmoRscUtil)rscUtilList.get(0);
            List rsvData = rscUtil.getRsvData();
            ArrayList storeRsvData = new ArrayList(rsvData.size());
            storeRsvData.addAll(rsvData);
            this.rscUtilRsvDataMap.put(rscUtilCls, storeRsvData);
        }
    }

    @Override
    protected final Map<String, List<?>> putDialogCacheData() {
        HashMap retMap = new HashMap();
        retMap.put(KEY_CACHE_KEEP_UTIL_CLS, this.utilList);
        ArrayList rsvDataList = new ArrayList();
        rsvDataList.add(this.rscUtilRsvDataMap);
        retMap.put(KEY_CACHE_KEEP_RSV_DATA, rsvDataList);
        return retMap;
    }

    private void putRscCache(String utilCls, SJmoRscUtil rscUtil) {
        List lsRsvData = rscUtil.getRsvData();
        ArrayList saveRsvData = new ArrayList(lsRsvData.size());
        for (ArrayList lsRsvDataSub : lsRsvData) {
            ArrayList saveRsvDataSub = new ArrayList(lsRsvDataSub.size());
            saveRsvDataSub.addAll(lsRsvDataSub);
            saveRsvData.add(saveRsvDataSub);
        }
        this.rscUtilRsvDataMap.put(utilCls, saveRsvData);
        SJctrLogUty.info(this.getClass().getSimpleName(), "putRscCache", "Resource Util Cache stored. : " + utilCls);
    }

    @Override
    protected SJctrSimpleDataModel createRootDataModel() {
        return new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                SJctrWizardWindowDC wizDc = SJctrWizardDataController.this.getWizardWindow();
                if (wizDc != null) {
                    boolean rollBackInfo = false;
                    SJctrWizardDataController dc = wizDc.getNextIndexWizardDataController();
                    boolean nextConstruct = false;
                    if (dc != null) {
                        nextConstruct = dc.isSetData();
                    }
                    if (dc instanceof SJctrConfirmDC) {
                        rollBackInfo = false;
                    } else if (SJctrWizardDataController.this.isWizardDC(dc)) {
                        rollBackInfo = nextConstruct;
                    }
                    SJctrWizardDataController.this.setRollBackInfo(rollBackInfo);
                }
                return super.getDataObject(inputObject);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void setDataObject(Object setObject) {
                try {
                    SJctrWizardDataController.this.settingDataFlg = true;
                    super.setDataObject(setObject);
                }
                finally {
                    SJctrWizardDataController.this.settingDataFlg = false;
                }
            }
        };
    }

    private boolean isSetData() {
        return this.putCacheFlg || this.chkEndFlg;
    }

    private boolean isWizardDC(SJctrDataController dc) {
        boolean result = false;
        if (dc == null) {
            return result;
        }
        int dispId = dc.getDisplayId();
        if (SJctrWizardDataController.isDispKind(dispId, 0x1000000) || SJctrWizardDataController.isDispKind(dispId, 0x1100000)) {
            result = true;
        }
        return result;
    }

    protected SJctrWizardWindowDC getWizardWindow() {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        return dc;
    }

    public SJctrWizardWindowDC getTopWizard() {
        return this.topWizard;
    }

    public void setTopWizard(SJctrWizardWindowDC topWiz) {
        this.topWizard = topWiz;
    }

    protected void registerDataController(SJctrRelatedDispDataObject related) {
        SJctrWizardWindowDC topWiz = this.getTopWizard();
        if (topWiz != null) {
            topWiz.registerDataController(related);
        } else {
            this.getLogUty().putlog("registerDataController", "topWiz is null.");
        }
    }

    @Override
    public void finish() throws SJcException {
        this.topWizard = null;
        super.finish();
    }

    @Override
    public SJctrRelatedDispDataObject createDialog(Class<? extends SJctrDialogDataController> dialog, Map<String, List<?>> param) {
        SJctrRelatedDispDataObject related = super.createDialog(dialog, param);
        this.registerDataController(related);
        return related;
    }

    @Override
    protected void initProxy() {
        this.proxy = this.getWizardWindow().getProxy();
    }

    protected void updateFooter() {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel(KEY_FOOTER);
        if (dataModel instanceof SJctrFooterDataModel) {
            SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
            SJctrWizardWindowDC wizard = this.getWizardWindow();
            if (wizard != null) {
                footer.setEnableButton(SJctrFooterDataModel.Button.APPLY, wizard.isApply());
                footer.setEnableButton(SJctrFooterDataModel.Button.BACK, wizard.isBack());
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, wizard.isFinish());
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, wizard.isNext());
            }
            SJctrWizardDataController wizDc = null;
            if (wizard != null) {
                wizDc = wizard.getNextIndexWizardDataController();
            }
            if (wizDc instanceof SJctrConfirmDC) {
                footer.setTemporaryRollBackCheck(SJctrFooterDataModel.Button.FINISH, false);
            } else if (this.isWizardDC(wizDc)) {
                footer.setTemporaryRollBackCheck(SJctrFooterDataModel.Button.FINISH, true);
            } else {
                footer.setTemporaryRollBackCheck(SJctrFooterDataModel.Button.FINISH, false);
            }
            footer.setDirty();
        }
    }

    public void initCache() {
        this.oldCache = this.proxy.getCacheMap();
        this.currentCache = this.oldCache != null ? new HashMap(this.oldCache) : new HashMap();
        this.proxy.setCacheMap(this.currentCache);
    }

    protected void wizardConctruct() {
        this.initCache();
    }

    private void initListener() {
        this.addMessageEventListener(WIZ_MSG.BACK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardDataController.this.logUty.putlog("doMediatorAction", "WIZ_MSG.BACK");
                SJctrUserController uc = SJctrWizardDataController.this.getOwner();
                SJctrRelatedDispDataObject relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
                SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relatedDisp);
                if (dc.back()) {
                    SJctrSimpleDataModel rootModel = SJctrWizardDataController.this.getRootDataModel();
                    rootModel.clearDirty();
                    SJctrWizardDataController nowDc = dc.getNowWizardDataController();
                    nowDc.moveInit();
                    SJctrDataObject target = new SJctrDataObject();
                    target.setData("COM_CRUMB", null);
                    target.setData("COM_CHILD", null);
                    relatedDisp.target(target);
                    SJctrWizardDataController.this.addUpdateDisp(relatedDisp);
                }
            }
        });
        this.addMessageEventListener(WIZ_MSG.NEXT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                if (SJctrWizardDataController.this.preNextEvent(event, dstModel)) {
                    SJctrWizardDataController.this.nextEvent(event, dstModel);
                }
            }
        });
        this.addMessageEventListener(WIZ_MSG.FINISH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRelatedDispDataObject relatedDisp;
                SJctrUserController uc = SJctrWizardDataController.this.getOwner();
                SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class));
                SJctrWizardDataController nowDc = dc.getNowWizardDataController();
                boolean msgFlg = nowDc.checkFinishData(event, dstModel);
                if (!msgFlg) {
                    SJctrWizardDataController.this.finishEvent(event, dstModel);
                }
            }
        });
        this.addMessageEventListener(WIZ_MSG.CANCEL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardDataController.this.logUty.putlog("doMediatorAction", "WIZ_MSG.CANCEL");
                SJctrWizardDataController.this.closeEvent();
            }
        });
        this.addMessageEventListener(WIZ_MSG.CLOSE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardDataController.this.logUty.putlog("doMediatorAction", "WIZ_MSG.CLOSE");
                SJctrWizardDataController.this.closeEvent();
            }
        });
        this.addMessageEventListener(WIZ_MSG.SET_START, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardDataController.this.logUty.putlog("doMessageAction", "WIZ_MSG.SET_START");
                SJctrWizardDataController.this.setSettingDataFlg(true);
            }
        });
        this.addMessageEventListener(WIZ_MSG.SET_END, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardDataController.this.logUty.putlog("doMessageAction", "WIZ_MSG.SET_END");
                SJctrWizardDataController.this.setSettingDataFlg(false);
            }
        });
    }

    private void setSettingDataFlg(Boolean set) {
        this.settingDataFlg = set;
    }

    protected void closeEvent() {
        SJctrUserController uc = this.getOwner();
        if (uc != null) {
            SJctrWizardWindowDC dc = this.getWizardWindow();
            dc.abort();
            SJctrRelatedDispDataObject relateDisp = uc.removeRelatedDispData(dc.getuId());
            this.addUpdateDisp(relateDisp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrWizardDataController next;
        Class<? extends SJctrSubWizard> subWiz;
        SJctrSimpleDataModel rootModel = this.getRootDataModel();
        SJctrWizardDataController nextDc = this.getWizardWindow().getNextIndexWizardDataController();
        if (nextDc == null) {
            this.getLogUty().putlog("nextEvent", "nextDc is null");
            return;
        }
        if (!nextDc.isConstruct() || rootModel.isChange()) {
            this.chkEndFlg = false;
        }
        if (!this.chkEndFlg) {
            try {
                this.checkEndData();
                this.chkEndFlg = true;
            }
            catch (SJcException e) {
                this.chkEndFlg = false;
                throw e;
            }
        }
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relatedDisp);
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
        SJctrActionDefine action = footer.getNextTask();
        if (!(action == null || (subWiz = dc.getSubWizard(next = dc.getNextWizardDataController())) != null && subWiz.equals(action.getSubWizard()))) {
            dc.rollback();
            boolean addResult = dc.addSubWizard(action.getSubWizard());
            if (addResult) {
                SJctrSubWizard addSubWizard = dc.getSubWizard(action.getSubWizard());
                addSubWizard.setUnitSelect(dc.getParentDC().getUnitSelect());
                try {
                    this.selectNextTask(action);
                }
                catch (RuntimeException e) {
                    dc.removeSubWizard(action.getSubWizard());
                    throw e;
                }
            }
        }
        boolean next2 = false;
        try {
            SJctrWizardDataController nextDc2 = dc.getNextWizardDataController();
            if (nextDc2 == null) {
                this.getLogUty().putlog("nextEvent", "nextDc is null");
                return;
            }
            nextDc2.checkStartData();
            if (dc.next()) {
                SJctrSimpleDataModel rootModel2 = this.getRootDataModel();
                rootModel2.clearDirty();
                nextDc2.moveInit();
                SJctrDataObject target = new SJctrDataObject();
                target.setData("COM_CRUMB", null);
                target.setData("COM_CHILD", null);
                relatedDisp.target(target);
                this.addUpdateDisp(relatedDisp);
                next2 = true;
            } else {
                this.getLogUty().putlog("nextEvent", "next fail:" + nextDc2);
            }
        }
        finally {
            if (!next2 && action != null) {
                Class<? extends SJctrSubWizard> subWizard = action.getSubWizard();
                try {
                    dc.removeSubWizard(subWizard);
                }
                catch (Exception e1) {
                    this.getLogUty().putlog("nextEvent", "remove fail:" + subWizard, e1, 20000);
                }
            }
        }
    }

    public void finishEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject relatedDisp;
        SJctrUserController uc;
        SJctrWizardWindowDC dc;
        SJctrSimpleDataModel rootModel = this.getRootDataModel();
        SJctrWizardDataController nextDc = this.getWizardWindow().getNextIndexWizardDataController();
        if (nextDc == null) {
            this.getLogUty().putlog("finishEvent", "nextDc is null");
            return;
        }
        if (!nextDc.isConstruct() || rootModel.isChange()) {
            this.chkEndFlg = false;
        }
        if (!this.chkEndFlg) {
            try {
                this.checkEndData();
                this.chkEndFlg = true;
            }
            catch (SJcException e) {
                this.chkEndFlg = false;
                throw e;
            }
        }
        if ((dc = (SJctrWizardWindowDC)(uc = this.getOwner()).getDataController(relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class))).isNext()) {
            dc.rollback();
        }
        this.resetRscUtilMain();
        if (dc.confirm()) {
            SJctrWizardDataController nowDc = dc.getNowWizardDataController();
            try {
                nowDc.checkStartData();
                SJctrSimpleDataModel rootModel2 = this.getRootDataModel();
                rootModel2.clearDirty();
                nowDc.moveInit();
                SJctrDataObject target = new SJctrDataObject();
                target.setData("COM_CRUMB", null);
                target.setData("COM_CHILD", null);
                relatedDisp.target(target);
                this.addUpdateDisp(relatedDisp);
            }
            catch (RuntimeException e) {
                dc.back();
                dc.rollback();
                throw e;
            }
        }
    }

    public void moveInit() {
        if (!this.isConstruct()) {
            this.getLogUty().putlog("moveInit", "unconstruct");
            return;
        }
        this.resetControlData();
    }

    @Override
    public void setUnitSelect(String unitSelect) {
        super.setUnitSelect(unitSelect);
        SJctrWizardWindowDC wizardWindowDC = this.getWizardWindow();
        if (wizardWindowDC == null) {
            return;
        }
        Class<? extends SJctrSubWizard> subWizardCls = wizardWindowDC.getSubWizard(this);
        if (subWizardCls == null) {
            return;
        }
        SJctrSubWizard subWizard = wizardWindowDC.getSubWizard(subWizardCls);
        if (subWizard == null) {
            return;
        }
        subWizard.setUnitSelect(unitSelect);
    }

    protected boolean preNextEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        return true;
    }

    public static enum WIZ_MSG implements SJctrNotifyState
    {
        BACK,
        NEXT,
        FINISH,
        APPLY,
        CANCEL,
        OK,
        DLG_CANCEL,
        CLOSE,
        YES,
        NO,
        ADD_SUBWIZ,
        SET_START,
        SET_END;

    }
}

