/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.addroles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundRoleException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrRoleInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.addroles.SJctrAddRolesAvailableTableModel;
import sanproject.sn2.controller.wizard.account.addroles.SJctrAddRolesData;
import sanproject.sn2.controller.wizard.account.addroles.SJctrAddRolesExData;
import sanproject.sn2.controller.wizard.account.addroles.SJctrAddRolesSelectedTableModel;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrRoleInfoDef;
import sanproject.sn2.controller.wizard.account.com.SJctrRoleInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrTaskInfoDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpsSelectData;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;

public class SJctrAddRolesDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101151;
    private static final String COM_GUIDANCEKEY = "ACCOUNT/DISP_DI_115S-1";
    private static final String COM_TABLE_AVA = "COM_TABLE_AVAILABLE";
    private static final String COM_TABLE_SEL = "COM_TABLE_SELECTED";
    private static final String COM_ADD = "COM_ADD";
    private static final String COM_REMOVE = "COM_REMOVE";
    public static final String TITLE = "ROLE_ASSIGN";
    private boolean taskcombination = false;
    private boolean initAllRscGrp = false;
    private List<String> initialSelRoleList = null;

    public SJctrAddRolesDC() throws SJcException {
        super(0x1101151);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        String guidance = COM_GUIDANCEKEY;
        this.initGuidance(util, guidance);
    }

    public void initGuidance(SJctrComUtility util, String guidance) {
        super.initGuidance(util);
        SJctrDataObject manageData = this.getManageData();
        Object obj = new SJctrTaskInfoDataModel().getManageData();
        ((SJctrDataObject)obj).setData("COM_GUIDANCE", guidance);
        manageData.setData("COM_TASK_INFO", obj);
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_TABLE_AVA, new SJctrAddRolesAvailableTableModel());
        this.addDataObjectModel(COM_TABLE_SEL, new SJctrAddRolesSelectedTableModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddRolesDC.this.addAction();
                        if (SJctrAddRolesDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(0x1101151);
                            SJctrAddRolesDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        add.setRollBackCheck(true);
        this.addDataObjectModel(COM_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddRolesDC.this.removeAction();
                        if (SJctrAddRolesDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(0x1101151);
                            SJctrAddRolesDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        remove.setRollBackCheck(true);
        this.addDataObjectModel(COM_REMOVE, remove);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> selectedList = selectedTable.getAllRowData();
        boolean flg = true;
        if (selectedList.size() > SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_ROLE")) {
            flg = false;
        }
        if (selectedList.size() == 0) {
            flg = false;
        }
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.taskcombination) {
            if (flg) {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
            } else {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
            }
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        } else {
            if (selectedList.size() == this.initialSelRoleList.size()) {
                boolean flgtmp = true;
                for (SJctrRoleInfoDetail sJctrRoleInfoDetail : selectedList) {
                    boolean flgtmptmp = true;
                    for (String initialSelRole : this.initialSelRoleList) {
                        if (!sJctrRoleInfoDetail.getRoleName().equals(initialSelRole)) continue;
                        flgtmptmp = false;
                    }
                    if (!flgtmptmp) continue;
                    flgtmp = false;
                }
                if (flgtmp) {
                    flg = false;
                }
            }
            if (flg) {
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
            } else {
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            }
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        }
    }

    private void addAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> list = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(list);
        selectedTable.setRowSelectionList(list);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> list = selectedTable.getSelectedRowData();
        boolean flg = true;
        for (Object selectRow : list) {
            SJctrRoleInfoDetail roleInfoDetail = (SJctrRoleInfoDetail)selectRow;
            if (!SJctrRoleInfoDef.isTypeDefault(roleInfoDetail)) continue;
            flg = false;
        }
        if (flg) {
            list = selectedTable.removeSelectedRowData();
            availableTable.addRowDataTop(list);
            List<Object> selectedList = availableTable.getFilterData(list);
            availableTable.setRowSelectionList(selectedList);
            availableTable.setCurrentPage(Integer.toString(1));
        } else {
            String strFunc = String.valueOf(2);
            String strModule = String.valueOf(22);
            String strMsg = String.valueOf(106066);
            SJcMessage msg = new SJcMessage(strFunc, strModule, strMsg);
            SJctrRelatedDispDataObject relatedObj = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(relatedObj);
            msgDC.addButton(SJctrMessageDataController.MD_OK);
            this.addUpdateDisp(relatedObj);
        }
        this.updateFooter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache("KEY_CREATEUG_TASKCOMBINATION");
        if (dat != null) {
            this.taskcombination = true;
        }
        if (!this.taskcombination) {
            SJctrRoleInfoDetail roleInfoDetail;
            String strRole;
            String[] roles;
            dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDROLES_SELECT_DATA);
            if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_ADDROLES_SELECT_DATA)) {
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrUserGrpsSelectData userGrpsSelectData = (SJctrUserGrpsSelectData)dat.get(0);
            List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = userGrpsSelectData.getUserGrpInfoDetailList();
            if (userGrpInfoDetailList == null || userGrpInfoDetailList.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (UserGrp Info Detail List) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            int iListSize = userGrpInfoDetailList.size();
            String[] userGrpNames = new String[iListSize];
            for (int i = 0; i < iListSize; ++i) {
                userGrpNames[i] = userGrpInfoDetailList.get(i).getGroupName();
            }
            for (String userGrpName : userGrpNames) {
                boolean bRet = true;
                try {
                    bRet = SJctrUserInfoUtility.isExistGroup(userGrpName, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]isExistGroup() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(201, 22, 208003);
                    SJcException exception = err.createException();
                    throw exception;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]isExistGroup() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                if (bRet) continue;
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Exist Group.(" + userGrpName + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107011);
                SJcException exception = err.createException();
                throw exception;
            }
            ArrayList<Object> availableRoleList = new ArrayList<Object>();
            ArrayList<String> selectedRoleList = new ArrayList<String>();
            ArrayList<String[]> roleList = new ArrayList<String[]>();
            try {
                SJcUserGroupInfoContainer[] userGrpInfo = SJctrUserInfoUtility.getUserGroupInfo(userGrpNames, this);
                for (SJcUserGroupInfoContainer userGrpInfotmp : userGrpInfo) {
                    roleList.add(userGrpInfotmp.getRoleName());
                }
                this.initAllRscGrp = userGrpInfo[0].getAllRsrcGroup();
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGroupInfo() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(201, 22, 208003);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserGroupInfo() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            String[] allRoles = null;
            try {
                allRoles = SJctrUserInfoUtility.getRoleList(this);
            }
            catch (SJcNotFoundRoleException e) {
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(201, 22, 208003);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleList() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            for (String roleName : allRoles) {
                boolean bRet = true;
                for (Object[] objectArray : roleList) {
                    if (objectArray == null || objectArray.length <= 0) continue;
                    Arrays.sort(objectArray);
                    if (Arrays.binarySearch(objectArray, roleName) < 0) continue;
                    bRet = false;
                    break;
                }
                if (SJctrRoleInfoDef.isTypeDefault(roleName)) {
                    bRet = false;
                }
                if (bRet) {
                    availableRoleList.add(roleName);
                    continue;
                }
                selectedRoleList.add(roleName);
            }
            ArrayList<List<SJctrRoleInfoDetail>> rolelistfortable = new ArrayList<List<SJctrRoleInfoDetail>>();
            Map<String, SJctrRoleInfoDetail> roleInfoDetailMap = null;
            ArrayList<SJctrRoleInfoDetail> rolelist = new ArrayList<SJctrRoleInfoDetail>();
            if (!availableRoleList.isEmpty()) {
                void var17_63;
                SJctrError err;
                roles = availableRoleList.toArray(new String[0]);
                try {
                    roleInfoDetailMap = SJctrAccountInfoUty.getRoleInfoDetailList(roles, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    err = new SJctrError(201, 22, 208003);
                    SJcException sJcException = err.createException();
                    throw sJcException;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    err = new SJctrError(2, 22, 107010);
                    SJcException sJcException = err.createException();
                    throw sJcException;
                }
                String[] arr$ = roles;
                int len$ = arr$.length;
                boolean bl = false;
                while (var17_63 < len$) {
                    strRole = arr$[var17_63];
                    roleInfoDetail = roleInfoDetailMap.get(strRole);
                    if (roleInfoDetail != null) {
                        rolelist.add(roleInfoDetail);
                    }
                    ++var17_63;
                }
            }
            rolelistfortable.add(this.sortRole(rolelist));
            roleInfoDetailMap = null;
            rolelist = new ArrayList();
            if (!selectedRoleList.isEmpty()) {
                void var17_67;
                roles = selectedRoleList.toArray(new String[0]);
                try {
                    roleInfoDetailMap = SJctrAccountInfoUty.getRoleInfoDetailList(roles, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(201, 22, 208003);
                    SJcException sJcException = err.createException();
                    throw sJcException;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException sJcException = err.createException();
                    throw sJcException;
                }
                String[] arr$ = roles;
                int len$ = arr$.length;
                boolean bl = false;
                while (var17_67 < len$) {
                    strRole = arr$[var17_67];
                    roleInfoDetail = roleInfoDetailMap.get(strRole);
                    if (roleInfoDetail != null) {
                        rolelist.add(roleInfoDetail);
                    }
                    ++var17_67;
                }
            }
            rolelistfortable.add(this.sortRole(rolelist));
            this.initialSelRoleList = selectedRoleList;
            this.putCache(SJctrAccountDataMacro.CLASS_ROLE_INFO_DETAIL, rolelistfortable);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        ArrayList<Integer> list_disp;
        ArrayList<SJctrAddRolesData> list;
        String strMsg;
        String strModule;
        String strFunc;
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean result = true;
        SJctrError errInfo = null;
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> selectedList = selectedTable.getAllRowData();
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        List<Object> availableList = availableTable.getAllRowData();
        if (selectedList.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Selected Roles is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrRoleInfoDetail> selectRoleList = new ArrayList<SJctrRoleInfoDetail>();
        ArrayList errList = new ArrayList(selectedList.size());
        boolean allRsg = false;
        ArrayList<String> allRsgRoleList = new ArrayList<String>();
        allRsgRoleList.add("");
        for (Object selectRow : selectedList) {
            if (selectRow == null || !(selectRow instanceof SJctrRoleInfoDetail)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]illegal Row Data.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrRoleInfoDetail roleInfoDetail = (SJctrRoleInfoDetail)selectRow;
            String roleName = roleInfoDetail.getRoleName();
            if (roleName == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Role Name is Empty.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (SJctrRoleInfoDef.isTypeAllRsg(roleInfoDetail)) {
                allRsg = true;
            }
            selectRoleList.add(roleInfoDetail);
        }
        ArrayList<SJctrRoleInfoDetail> assignedRoleList = new ArrayList<SJctrRoleInfoDetail>();
        ArrayList<SJctrRoleInfoDetail> unassignedRoleList = new ArrayList<SJctrRoleInfoDetail>();
        if (!this.taskcombination) {
            assignedRoleList = new ArrayList();
            for (SJctrRoleInfoDetail roleInfoDetail : selectRoleList) {
                String chk = roleInfoDetail.getRoleName();
                if (this.initialSelRoleList.contains(chk)) continue;
                assignedRoleList.add(roleInfoDetail);
            }
            unassignedRoleList = new ArrayList();
            for (Object availRow : availableList) {
                if (availRow == null || !(availRow instanceof SJctrRoleInfoDetail)) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]illegal Row Data.", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                SJctrRoleInfoDetail roleInfoDetail = (SJctrRoleInfoDetail)availRow;
                String roleName = roleInfoDetail.getRoleName();
                if (roleName == null) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Role Name is Empty.", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                String chk = roleInfoDetail.getRoleName();
                if (!this.initialSelRoleList.contains(chk)) continue;
                unassignedRoleList.add(roleInfoDetail);
            }
        }
        if (!result) {
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        SJctrAddRolesData addRolesData = new SJctrAddRolesData();
        SJctrAddRolesExData addRolesExData = new SJctrAddRolesExData();
        if (this.taskcombination) {
            addRolesData.setRoleInfoDetailList(selectRoleList);
            addRolesData.setAllResourceGrp(allRsg);
        } else {
            addRolesExData.setRoleInfoDetailList(selectRoleList);
            addRolesExData.setAssignedRoleInfoDetailList(assignedRoleList);
            addRolesExData.setUnassignedRoleInfoDetailList(unassignedRoleList);
            addRolesExData.setAllResourceGrp(allRsg);
            addRolesExData.setAllResourceGrpBefore(this.initAllRscGrp);
        }
        if (!this.initAllRscGrp && allRsg) {
            strFunc = String.valueOf(2);
            strModule = String.valueOf(22);
            strMsg = String.valueOf(106067);
            SJcMessage msg = new SJcMessage(strFunc, strModule, strMsg);
            SJctrRelatedDispDataObject relatedObj = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(relatedObj);
            msgDC.addButton(SJctrMessageDataController.MD_OK);
            this.addUpdateDisp(relatedObj);
        } else if (this.initAllRscGrp && !allRsg) {
            strFunc = String.valueOf(2);
            strModule = String.valueOf(22);
            strMsg = String.valueOf(106072);
            SJcMessage msg = new SJcMessage(strFunc, strModule, strMsg);
            SJctrRelatedDispDataObject relatedObj = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(relatedObj);
            msgDC.addButton(SJctrMessageDataController.MD_OK);
            this.addUpdateDisp(relatedObj);
        }
        if (this.taskcombination) {
            if (this.checkBeforeContactData(addRolesData)) {
                list = new ArrayList<SJctrAddRolesData>();
                list.add(addRolesData);
                this.putCache(SJctrAccountDataMacro.WIZARD_ADDROLES_DATA, list);
                list_disp = new ArrayList<Integer>();
                list_disp.add(0x1101151);
                this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
            }
        } else if (this.checkBeforeContactData(addRolesExData)) {
            list = new ArrayList();
            list.add(addRolesExData);
            this.putCache(SJctrAccountDataMacro.WIZARD_ADDROLES_DATA, list);
            list_disp = new ArrayList();
            list_disp.add(0x1101151);
            this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrAddRolesData addRolesData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDROLES_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_ADDROLES_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrAddRolesData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrAddRolesData old_addRolesData = (SJctrAddRolesData)confirm_dat_obj;
            if (addRolesData.compareTo(old_addRolesData) != 0) {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has been changed.");
            } else {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has not been changed.");
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }

    public boolean checkContactData(List<?> dat, Class<?> cls) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + cls.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!obj.getClass().equals(cls)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkConstructData() {
        String strLogSubTitle = "checkContactData";
        if (this.taskcombination) {
            SJctrRoleInfoDetail roleInfoDetail;
            String[] roles;
            ArrayList<String> availableRoleList = new ArrayList<String>();
            ArrayList<String> selectedRoleList = new ArrayList<String>();
            String[] allRoles = null;
            try {
                allRoles = SJctrUserInfoUtility.getRoleList(this);
            }
            catch (SJcNotFoundRoleException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Not found Role.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(201, 22, 208003);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleList() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            for (String roleName : allRoles) {
                boolean bRet = true;
                if (SJctrRoleInfoDef.isTypeDefault(roleName)) {
                    bRet = false;
                }
                if (bRet) {
                    availableRoleList.add(roleName);
                    continue;
                }
                selectedRoleList.add(roleName);
            }
            ArrayList<List<SJctrRoleInfoDetail>> rolelistfortable = new ArrayList<List<SJctrRoleInfoDetail>>();
            Map<String, SJctrRoleInfoDetail> roleInfoDetailMap = null;
            ArrayList<SJctrRoleInfoDetail> rolelist = new ArrayList<SJctrRoleInfoDetail>();
            if (!availableRoleList.isEmpty()) {
                roles = availableRoleList.toArray(new String[0]);
                try {
                    roleInfoDetailMap = SJctrAccountInfoUty.getRoleInfoDetailList(roles, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(201, 22, 208003);
                    SJcException exception = err.createException();
                    throw exception;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                for (String strRole : roles) {
                    roleInfoDetail = roleInfoDetailMap.get(strRole);
                    if (roleInfoDetail == null) continue;
                    rolelist.add(roleInfoDetail);
                }
            }
            if (rolelist.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Available Roles is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            rolelistfortable.add(this.sortRole(rolelist));
            roleInfoDetailMap = null;
            rolelist = new ArrayList();
            if (!selectedRoleList.isEmpty()) {
                roles = selectedRoleList.toArray(new String[0]);
                try {
                    roleInfoDetailMap = SJctrAccountInfoUty.getRoleInfoDetailList(roles, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getRoleInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(201, 22, 208003);
                    SJcException exception = err.createException();
                    throw exception;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRoleInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                for (String strRole : roles) {
                    roleInfoDetail = roleInfoDetailMap.get(strRole);
                    if (roleInfoDetail == null) continue;
                    rolelist.add(roleInfoDetail);
                }
            }
            rolelistfortable.add(this.sortRole(rolelist));
            this.initialSelRoleList = selectedRoleList;
            this.putCache(SJctrAccountDataMacro.CLASS_ROLE_INFO_DETAIL, rolelistfortable);
        }
        return true;
    }

    private List<SJctrRoleInfoDetail> sortRole(List<SJctrRoleInfoDetail> rolelist) {
        ArrayList<SJctrRoleInfoDetail> newrolelist = new ArrayList<SJctrRoleInfoDetail>();
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, SJctrRoleInfoDetail> map = new HashMap<String, SJctrRoleInfoDetail>();
        SJctrRoleInfoDetailUtility roleInfoDetailUty = this.getComUtility().getRoleInfoDetailUtility();
        for (SJctrRoleInfoDetail roleinfo : rolelist) {
            map.put(roleInfoDetailUty.toRoleNameDisplay(roleinfo), roleinfo);
            list.add(roleInfoDetailUty.toRoleNameDisplay(roleinfo));
        }
        Collections.sort(list);
        for (String rolename : list) {
            newrolelist.add((SJctrRoleInfoDetail)map.get(rolename));
        }
        return newrolelist;
    }
}

