/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.createuser;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserAccountDataModel;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserAuthServDataModel;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserData;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserPwdDataModel;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserReEntPwdDataModel;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserSelectData;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserUserIDDataModel;

public class SJctrCreateUserDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100911;
    private static final String COM_USER_ID = "COM_USER_ID";
    private static final String COM_ACC = "COM_ACC";
    private static final String COM_AUTH = "COM_AUTH";
    private static final String COM_PW = "COM_PW";
    private static final String COM_PW_RE = "COM_PW_RE";
    private static final String COM_TITLE = "COM_TITLE";
    public static final String COM_CHECKBOX = "COM_CHECKBOX";
    public static final String TITLE = "CREATE_USER";

    public SJctrCreateUserDC() throws SJcException {
        super(0x1100911);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_USER_ID, new SJctrCreateUserUserIDDataModel());
        this.addDataObjectModel(COM_ACC, new SJctrCreateUserAccountDataModel());
        this.addDataObjectModel(COM_AUTH, new SJctrCreateUserAuthServDataModel());
        this.addDataObjectModel(COM_PW, new SJctrCreateUserPwdDataModel());
        this.addDataObjectModel(COM_PW_RE, new SJctrCreateUserReEntPwdDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_USER_NOTIFY_STATE.SELECT_LOCAL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateUserDC.this.changeAuthServRadioButton("COM_LOCAL");
            }
        });
        this.addMessageEventListener(CREATE_USER_NOTIFY_STATE.SELECT_EXTERNAL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateUserDC.this.changeAuthServRadioButton("COM_EXTERNAL");
            }
        });
    }

    private void changeAuthServRadioButton(String ButtonKey) {
        SJctrCreateUserPwdDataModel pwdDataModel = (SJctrCreateUserPwdDataModel)this.getDataObjectModel(COM_PW);
        SJctrTextLabelDataModel pwdSelectable = (SJctrTextLabelDataModel)pwdDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrTextBoxDataModel pwdTextBox = (SJctrTextBoxDataModel)pwdDataModel.getDataModel(COM_PW);
        SJctrCreateUserReEntPwdDataModel reEntPwdDataModel = (SJctrCreateUserReEntPwdDataModel)this.getDataObjectModel(COM_PW_RE);
        SJctrTextLabelDataModel reEntPwdSelectable = (SJctrTextLabelDataModel)reEntPwdDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrTextBoxDataModel reEntPwdTextBox = (SJctrTextBoxDataModel)reEntPwdDataModel.getDataModel(COM_PW_RE);
        if (ButtonKey.equals("COM_LOCAL")) {
            pwdSelectable.setEnable(true);
            pwdTextBox.setEnable(true);
            reEntPwdSelectable.setEnable(true);
            reEntPwdTextBox.setEnable(true);
        } else if (ButtonKey.equals("COM_EXTERNAL")) {
            pwdTextBox.setValue("");
            reEntPwdTextBox.setValue("");
            pwdSelectable.setEnable(false);
            pwdTextBox.setEnable(false);
            reEntPwdSelectable.setEnable(false);
            reEntPwdTextBox.setEnable(false);
        }
        pwdDataModel.setDirtyAll();
        reEntPwdDataModel.setDirtyAll();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_CREATEUSER_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrCreateUserSelectData createUserSelectData = (SJctrCreateUserSelectData)dat.get(0);
        SJctrUserGrpInfoDetail userGrpInfoDetail = createUserSelectData.getUserGrpInfoDetail();
        if (userGrpInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_GRP_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrCreateUserUserIDDataModel userIDDataModel = (SJctrCreateUserUserIDDataModel)this.getDataObjectModel(COM_USER_ID);
        SJctrTextBoxDataModel userIDTextBox = (SJctrTextBoxDataModel)userIDDataModel.getDataModel(COM_USER_ID);
        SJctrCreateUserAccountDataModel accountDataModel = (SJctrCreateUserAccountDataModel)this.getDataObjectModel(COM_ACC);
        SJctrRadioButtonGroupDataModel accountRadioButton = (SJctrRadioButtonGroupDataModel)accountDataModel.getDataModel(COM_ACC);
        SJctrCreateUserAuthServDataModel authServDataModel = (SJctrCreateUserAuthServDataModel)this.getDataObjectModel(COM_AUTH);
        SJctrRadioButtonGroupDataModel authServRadioButton = (SJctrRadioButtonGroupDataModel)authServDataModel.getDataModel(COM_AUTH);
        SJctrCreateUserPwdDataModel pwdDataModel = (SJctrCreateUserPwdDataModel)this.getDataObjectModel(COM_PW);
        SJctrTextBoxDataModel pwdTextBox = (SJctrTextBoxDataModel)pwdDataModel.getDataModel(COM_PW);
        SJctrCreateUserReEntPwdDataModel reEntPwdDataModel = (SJctrCreateUserReEntPwdDataModel)this.getDataObjectModel(COM_PW_RE);
        SJctrTextBoxDataModel reEntPwdTextBox = (SJctrTextBoxDataModel)reEntPwdDataModel.getDataModel(COM_PW_RE);
        String userID = userIDTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        String password = pwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        String ReEntPwd = reEntPwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        boolean bAccount = false;
        if (!accountRadioButton.isSelect("COM_ACTIVE")) {
            if (!accountRadioButton.isSelect("COM_LOCKED")) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Select Account Radio Button.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105213);
                SJcException exception = err.createException();
                throw exception;
            }
            bAccount = false;
        } else {
            bAccount = true;
        }
        int iAuthServ = 0;
        if (!authServRadioButton.isSelect("COM_LOCAL")) {
            if (!authServRadioButton.isSelect("COM_EXTERNAL")) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Select Authentication Server Radio Button.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105214);
                SJcException exception = err.createException();
                throw exception;
            }
            iAuthServ = SJcAccountConst.INT_AUTHPTN_EXTERNAL;
        } else {
            try {
                SJcAccountChkUty.chkPassword(password);
            }
            catch (SJcParamErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Password String", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105215);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!password.equals(ReEntPwd)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Re-enter Password String", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105216);
                SJcException exception = err.createException();
                throw exception;
            }
            iAuthServ = SJcAccountConst.INT_AUTHPTN_LOCAL;
        }
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_CREATEUSER_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrCreateUserSelectData createUserSelectData = (SJctrCreateUserSelectData)dat.get(0);
        SJctrUserGrpInfoDetail userGrpInfoDetail = createUserSelectData.getUserGrpInfoDetail();
        if (userGrpInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_GRP_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserInfoDetail userInfoDetail = new SJctrUserInfoDetail();
        userInfoDetail.setUserName(userID);
        userInfoDetail.setEnable(bAccount);
        userInfoDetail.setAuthPtn(iAuthServ);
        userInfoDetail.setPassword(password);
        SJctrCreateUserData createUserData = new SJctrCreateUserData();
        createUserData.setUserInfoDetail(userInfoDetail);
        createUserData.setUserGrpInfoDetail(userGrpInfoDetail);
        if (this.checkBeforeContactData(createUserData)) {
            ArrayList<SJctrCreateUserData> list = new ArrayList<SJctrCreateUserData>();
            list.add(createUserData);
            this.putCache(SJctrAccountDataMacro.WIZARD_CREATEUSER_DATA, list);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkContactData(List<?> dat) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CREATEUSER_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!(obj instanceof SJctrCreateUserSelectData)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrCreateUserData createUserData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_CREATEUSER_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CREATEUSER_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrCreateUserData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrCreateUserData old_createUserData = (SJctrCreateUserData)confirm_dat_obj;
            if (createUserData.compareTo(old_createUserData) != 0) {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has been changed.");
            } else {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has not been changed.");
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }

    public static enum CREATE_USER_NOTIFY_STATE implements SJctrNotifyState
    {
        SELECT_LOCAL,
        SELECT_EXTERNAL;

    }
}

