/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupradius;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExTrialException;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalTrial;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrMsgCodeDef;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;
import sanproject.sn2.controller.wizard.account.extauth.com.file.SJctrCertificationFileUpload;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrCertifyFileNameDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrExistDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrNASAddressDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrPasswordDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrProtocolComboBoxDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrProtocolDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResult2DataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResultDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTextDataModel;
import sanproject.sn2.controller.wizard.account.extauth.setupradius.SJctrRadiusServerConfirmData;

public class SJctrRadiusServerDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16826416;
    public static final String TITLE = "SETUP_SERVER";
    public static final String KEY_BROWSE_BTN = "COM_BROWSE_BTN";
    public static final String KEY_TEST_BTN = "COM_TEST_BTN";
    SJctrExtAuthServerInfo extAuthServerInfo = null;
    SJctrProtocolDataModel protocolDataModel = null;
    SJctrTextDataModel priHostNameDataModel = null;
    SJctrPasswordDataModel secretDataModel = null;
    SJctrPasswordDataModel reSecretDataModel = null;
    SJctrNASAddressDataModel nasAddressRadioDataModel = null;
    SJctrTextDataModel nasAddressDataModel = null;
    SJctrTextDataModel priPortNumberDataModel = null;
    SJctrTextDataModel timeoutDataModel = null;
    SJctrTextDataModel retriesDataModel = null;
    SJctrExistDataModel secServerDataModel = null;
    SJctrTextDataModel secHostNameDataModel = null;
    SJctrTextDataModel secPortNumberDataModel = null;
    SJctrExistDataModel authorizeDataModel = null;
    SJctrCertifyFileNameDataModel certifyFileNameDataModel = null;
    SJctrCertificationFileUpload fileUpload = null;
    SJctrExistDataModel extDnsLookupDataModel = null;
    SJctrProtocolComboBoxDataModel extProtocolDataModel = null;
    SJctrTextDataModel extPriHostNameDataModel = null;
    SJctrTextDataModel extPriPortNumberDataModel = null;
    SJctrTextDataModel extDomainNameDataModel = null;
    SJctrTextDataModel extBaseDnDataModel = null;
    SJctrTextDataModel extSearchDnDataModel = null;
    SJctrPasswordDataModel extPasswordDataModel = null;
    SJctrPasswordDataModel extRePasswordDataModel = null;
    SJctrTextDataModel extTimeoutDataModel = null;
    SJctrTextDataModel extIntervalDataModel = null;
    SJctrTextDataModel extRetriesDataModel = null;
    SJctrTextDataModel testUserNameDataModel = null;
    SJctrPasswordDataModel testPasswordDataModel = null;
    SJctrTestResultDataModel testResultDataModel = null;
    SJctrTestResult2DataModel testResult2DataModel = null;
    public static int RESULT_NORMAL = 0;
    public static int RADIUS_NON_HOSTNAME = SJctrMsgCodeDef.NON_HOSTNAME;
    public static int RADIUS_OVER_LENGTH_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_HOSTNAME;
    public static int RADIUS_INVALID_HOSTNAME = SJctrMsgCodeDef.INVALID_HOSTNAME;
    public static int RADIUS_NON_PORT = SJctrMsgCodeDef.NON_PORT;
    public static int RADIUS_INVALID_PORT = SJctrMsgCodeDef.INVALID_PORT;
    public static int RADIUS_NOT_RANGE_PORT = SJctrMsgCodeDef.NOT_RANGE_PORT;
    public static int RADIUS_NON_SECRET = SJctrMsgCodeDef.NON_SECRET;
    public static int RADIUS_OVER_LENGTH_SECRET = SJctrMsgCodeDef.OVER_LENGTH_SECRET;
    public static int RADIUS_INVALID_SECRET = SJctrMsgCodeDef.INVALID_SECRET;
    public static int RADIUS_NON_RESECRET = SJctrMsgCodeDef.NON_RESECRET;
    public static int RADIUS_OVER_LENGTH_RESECRET = SJctrMsgCodeDef.OVER_LENGTH_RESECRET;
    public static int RADIUS_INVALID_RESECRET = SJctrMsgCodeDef.INVALID_RESECRET;
    public static int RADIUS_NOT_EQUAL_SECRET = SJctrMsgCodeDef.NOT_EQUAL_SECRET;
    public static int RADIUS_NON_NASADDRESS = SJctrMsgCodeDef.NON_NASADDRESS;
    public static int RADIUS_OVER_LENGTH_NASADDR = SJctrMsgCodeDef.OVER_LENGTH_NASADDR;
    public static int RADIUS_INVALID_NASADDRESS = SJctrMsgCodeDef.INVALID_NASADDRESS;
    public static int RADIUS_INVALID_IPv4 = SJctrMsgCodeDef.INVALID_IPv4;
    public static int RADIUS_INVALID_IPv6 = SJctrMsgCodeDef.INVALID_IPv6;
    public static int RADIUS_NON_TIMEOUTE = SJctrMsgCodeDef.NON_TIMEOUTE;
    public static int RADIUS_INVALID_TIMEOUT = SJctrMsgCodeDef.INVALID_TIMEOUT;
    public static int RADIUS_NOT_RANGE_TIMEOUT = SJctrMsgCodeDef.NOT_RANGE_TIMEOUT;
    public static int RADIUS_NON_RETRIES = SJctrMsgCodeDef.NON_RETRIES;
    public static int RADIUS_INVALID_RETRIES = SJctrMsgCodeDef.INVALID_RETRIES;
    public static int RADIUS_NOT_RANGE_RETRIES = SJctrMsgCodeDef.NOT_RANGE_RETRIES;
    public static int RADIUS_NON_SEC_HOSTNAME = SJctrMsgCodeDef.NON_SEC_HOSTNAME;
    public static int RADIUS_OVER_LENGTH_SEC_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_SEC_HOSTNAME;
    public static int RADIUS_INVALID_SEC_HOSTNAME = SJctrMsgCodeDef.INVALID_SEC_HOSTNAME;
    public static int RADIUS_NON_SEC_PORT = SJctrMsgCodeDef.NON_SEC_PORT;
    public static int RADIUS_INVALID_SEC_PORT = SJctrMsgCodeDef.INVALID_SEC_PORT;
    public static int RADIUS_NOT_RANGE_SEC_PORT = SJctrMsgCodeDef.NOT_RANGE_SEC_PORT;
    public static int RADIUS_NON_CFFILE = SJctrMsgCodeDef.NON_EXT_CFFILE;
    public static int RADIUS_INVALID_CFFILE = SJctrMsgCodeDef.INVALID_EXT_CFFILE;
    public static int RADIUS_NOT_SELECT_LDAPS = SJctrMsgCodeDef.NOT_EXT_SELECT_LDAPS;
    public static int RADIUS_NON_EXT_HOSTNAME = SJctrMsgCodeDef.NON_EXT_HOSTNAME;
    public static int RADIUS_OVER_LENGTH_EXT_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_EXT_HOSTNAME;
    public static int RADIUS_INVALID_EXT_HOSTNAME = SJctrMsgCodeDef.INVALID_EXT_HOSTNAME;
    public static int RADIUS_NON_EXT_PORT = SJctrMsgCodeDef.NON_EXT_PORT;
    public static int RADIUS_INVALID_EXT_PORT = SJctrMsgCodeDef.INVALID_EXT_PORT;
    public static int RADIUS_NOT_RANGE_EXT_PORT = SJctrMsgCodeDef.NOT_RANGE_EXT_PORT;
    public static int RADIUS_NON_EXT_DOMAIN = SJctrMsgCodeDef.NON_EXT_DOMAIN;
    public static int RADIUS_OVER_LENGTH_EXT_DOMAIN = SJctrMsgCodeDef.OVER_LENGTH_EXT_DOMAIN;
    public static int RADIUS_INVALID_EXT_DOMAIN = SJctrMsgCodeDef.INVALID_EXT_DOMAIN;
    public static int RADIUS_NON_EXT_BASEDN = SJctrMsgCodeDef.NON_EXT_BASEDN;
    public static int RADIUS_OVER_LENGTH_EXT_BASEDN = SJctrMsgCodeDef.OVER_LENGTH_EXT_BASEDN;
    public static int RADIUS_INVALID_EXT_BASEDN = SJctrMsgCodeDef.INVALID_EXT_BASEDN;
    public static int RADIUS_NON_EXT_SEARCHDN = SJctrMsgCodeDef.NON_EXT_SEARCHDN;
    public static int RADIUS_OVER_LENGTH_EXT_SEARCHDN = SJctrMsgCodeDef.OVER_LENGTH_EXT_SEARCHDN;
    public static int RADIUS_INVALID_EXT_SEARCHDN = SJctrMsgCodeDef.INVALID_EXT_SEARCHDN;
    public static int RADIUS_NON_EXT_PASSWORD = SJctrMsgCodeDef.NON_EXT_PASSWORD;
    public static int RADIUS_OVER_LENGTH_EXT_PASSWORD = SJctrMsgCodeDef.OVER_LENGTH_EXT_PASSWORD;
    public static int RADIUS_INVALID_EXT_PASSWORD = SJctrMsgCodeDef.INVALID_EXT_PASSWORD;
    public static int RADIUS_NON_EXT_REPASSWORD = SJctrMsgCodeDef.NON_EXT_REPASSWORD;
    public static int RADIUS_OVER_LENGTH_EXT_REPASSWORD = SJctrMsgCodeDef.OVER_LENGTH_EXT_REPASSWORD;
    public static int RADIUS_INVALID_EXT_REPASSWORD = SJctrMsgCodeDef.INVALID_EXT_REPASSWORD;
    public static int RADIUS_NOT_EQUAL_PASSWORD = SJctrMsgCodeDef.NOT_EQUAL_EXT_PASSWORD;
    public static int RADIUS_NON_EXT_TIMEOUTE = SJctrMsgCodeDef.NON_EXT_TIMEOUTE;
    public static int RADIUS_INVALID_EXT_TIMEOUT = SJctrMsgCodeDef.INVALID_EXT_TIMEOUT;
    public static int RADIUS_NOT_RANGE_EXT_TIMEOUT = SJctrMsgCodeDef.NOT_RANGE_EXT_TIMEOUT;
    public static int RADIUS_NON_EXT_INTERVAL = SJctrMsgCodeDef.NON_EXT_INTERVAL;
    public static int RADIUS_INVALID_EXT_INTERVAL = SJctrMsgCodeDef.INVALID_EXT_INTERVAL;
    public static int RADIUS_NOT_RANGE_EXT_INTERVAL = SJctrMsgCodeDef.NOT_RANGE_EXT_INTERVAL;
    public static int RADIUS_NON_EXT_RETRIES = SJctrMsgCodeDef.NON_EXT_RETRIES;
    public static int RADIUS_INVALID_EXT_RETRIES = SJctrMsgCodeDef.INVALID_EXT_RETRIES;
    public static int RADIUS_NOT_RANGE_EXT_RETRIES = SJctrMsgCodeDef.NOT_RANGE_EXT_RETRIES;
    public static int RADIUS_NON_USERNAME = SJctrMsgCodeDef.NON_USERNAME;
    public static int RADIUS_OVERLENGTH_USERNAME = SJctrMsgCodeDef.OVERLENGTH_USERNAME;
    public static int RADIUS_INVALID_USERNAME = SJctrMsgCodeDef.INVALID_USERNAME;
    public static int RADIUS_NON_TPASSWORD = SJctrMsgCodeDef.NON_TPASSWORD;
    public static int RADIUS_OVERLENGTH_TPASSWORD = SJctrMsgCodeDef.OVERLENGTH_TPASSWORD;
    public static int RADIUS_INVALID_TPASSWORD = SJctrMsgCodeDef.INVALID_TPASSWORD;
    boolean debug_testresult = false;

    public SJctrRadiusServerDC() throws SJcException {
        super(16826416);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_AUTH_PROT_INF", new SJctrProtocolDataModel());
        this.addDataObjectModel("COM_PRI_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SECRET_KEY", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_RE_SECRET_KEY", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_NAS_ADDR", new SJctrNASAddressDataModel());
        this.addDataObjectModel("COM_NAS_ADDR_TXT", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PRI_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TOV", new SJctrTextDataModel());
        this.addDataObjectModel("COM_RET_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEC_SRV_AUTH", new SJctrExistDataModel());
        this.addDataObjectModel("COM_SEC_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEC_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_AUTH_INF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_CERTIFICATES", new SJctrCertifyFileNameDataModel());
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BROWSE_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRadiusServerDC.this.browseAction();
            }
        });
        this.addDataObjectModel("COM_DNSINF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_EXT_AUTH_PROT_INF", new SJctrProtocolComboBoxDataModel());
        this.addDataObjectModel("COM_EXT_PRI_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_PRI_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_DOMAIN_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_BASE_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEARCH_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_RE_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_EXT_TOV", new SJctrTextDataModel());
        this.addDataObjectModel("COM_RET_INTERVAL", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_RET_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_PASS", new SJctrPasswordDataModel());
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_TEST_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRadiusServerDC.this.testAction();
            }
        });
        this.addDataObjectModel("COM_TEST_RESULT", new SJctrTestResultDataModel());
        this.addDataObjectModel("COM_TEST_RESULT2", new SJctrTestResult2DataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void browseAction() {
        this.fileUpload = new SJctrCertificationFileUpload();
        this.fileUpload.setFileNameDataModel(this.certifyFileNameDataModel);
        SJctrRelatedDispDataObject relatedDisp = null;
        relatedDisp = this.createFileUpload(this.fileUpload);
        this.addUpdateDisp(relatedDisp);
    }

    private void testAction() {
        int errcode = this.checkSetting();
        if (errcode == RESULT_NORMAL) {
            errcode = this.checkTestSetting();
        }
        if (errcode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseRadiusConfiguration setConfig_pri = null;
        SJbaseRadiusConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseRadiusConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseRadiusConfiguration>();
        setConfig_pri = (SJbaseRadiusConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseRadiusConfiguration();
        }
        this.updateRadiusSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyRadiusConfig(setConfig_pri);
            this.updateRadiusSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        String displayFileName = "-";
        if (this.authorizeDataModel.isSelectEnable()) {
            displayFileName = this.certifyFileNameDataModel.getDisplayFileName();
        }
        info.setCertifyFullPathName(displayFileName);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_RADIUS);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        String name = this.testUserNameDataModel.getValue();
        String pass = this.testPasswordDataModel.getValue();
        String priErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_RADIUS;
        int priErrorCode = RESULT_NORMAL;
        SJcLogUty.getLogger().info("SJctrRadiusServerDC", "SJctrRadiusServerDC", "ConnectTest(Primary)", "Test start.");
        try {
            SJbaseRadiusConfiguration conf = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (this.authorizeDataModel.isSelectEnable()) {
                SJbaseExternalTrial.externalRadiusConnect(name, pass, conf, gconf);
            } else {
                SJbaseExternalTrial.externalRadiusConnect(name, pass, conf);
            }
        }
        catch (SJbaseExTrialException e) {
            priErrorType = e.getServerType();
            priErrorCode = e.getErrCode();
        }
        SJcLogUty.getLogger().info("SJctrRadiusServerDC", "SJctrRadiusServerDC", "ConnectTest(Primary)", "Test end. result=" + priErrorType + ":" + priErrorCode);
        boolean execSecondary = false;
        String secErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_RADIUS;
        int secErrorCode = RESULT_NORMAL;
        if (priErrorCode == RESULT_NORMAL && this.secServerDataModel.isSelectEnable()) {
            SJcLogUty.getLogger().info("SJctrRadiusServerDC", "SJctrRadiusServerDC", "ConnectTest(Secondary)", "Test start.");
            try {
                SJbaseRadiusConfiguration conf = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                if (this.authorizeDataModel.isSelectEnable()) {
                    SJbaseExternalTrial.externalRadiusConnect(name, pass, conf, gconf);
                } else {
                    SJbaseExternalTrial.externalRadiusConnect(name, pass, conf);
                }
            }
            catch (SJbaseExTrialException e) {
                secErrorType = e.getServerType();
                secErrorCode = e.getErrCode();
            }
            execSecondary = true;
            SJcLogUty.getLogger().info("SJctrRadiusServerDC", "SJctrRadiusServerDC", "ConnectTest(Secondary)", "Test end. result=" + secErrorType + ":" + secErrorCode);
        }
        if (this.debug_testresult) {
            Properties debug_properties = new Properties();
            String confFileName = "C:\\DKC200\\others\\exauth.properties";
            try {
                debug_properties.load(new FileInputStream(confFileName));
            }
            catch (Exception e) {
                // empty catch block
            }
            priErrorType = debug_properties.getProperty("TestPrimaryErrorType");
            priErrorCode = Integer.parseInt(debug_properties.getProperty("TestPrimaryErrorType"));
            execSecondary = Boolean.valueOf(debug_properties.getProperty("TestExecuteSecondary"));
            secErrorType = debug_properties.getProperty("TestSecondaryErrorType");
            secErrorCode = Integer.parseInt(debug_properties.getProperty("TestSecondaryErrorCode"));
        }
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        boolean result = false;
        if (priErrorCode == RESULT_NORMAL) {
            result = true;
        }
        this.testResultDataModel.setTestResut(result);
        String[] guidekey = new String[]{"", ""};
        guidekey = SJctrExtAuthServerUtility.isTrailServerTypeRadius(priErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.RADIUSTestResult, priErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, priErrorCode);
        this.testResultDataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDirty();
        if (execSecondary && this.secServerDataModel.isSelectEnable()) {
            result = false;
            if (secErrorCode == RESULT_NORMAL) {
                result = true;
            }
            this.testResult2DataModel.setTestResut(result);
            guidekey = new String[]{"", ""};
            guidekey = SJctrExtAuthServerUtility.isTrailServerTypeRadius(secErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.RADIUSTestResult, secErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, secErrorCode);
            this.testResult2DataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDirty();
        }
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        SJbaseExternalFile config = new SJbaseExternalFile();
        HashMap<String, SJbaseConfiguration> config_map = null;
        HashMap<String, SJbaseGroupConfiguration> config_group_map = null;
        SJbaseRadiusConfiguration config_data = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        String type = config.getType();
        if (SJctrExtAuthServerUtility.isServerTypeRadius(type)) {
            config_map = config.getConfiguration(type);
            config_group_map = config.getGroupConfiguration(type);
            if (config_map != null && (config_data = (SJbaseRadiusConfiguration)config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY)) != null) {
                info.setServerType(type);
                SJbaseConfiguration pri_conf = null;
                SJbaseConfiguration sec_conf = null;
                if (config_map != null) {
                    pri_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setConfiguration(pri_conf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setConfiguration(sec_conf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                SJbaseGroupConfiguration pri_gconf = null;
                SJbaseGroupConfiguration sec_gconf = null;
                if (config_group_map != null) {
                    pri_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setGroupConfiguration(pri_gconf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setGroupConfiguration(sec_gconf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
            }
        }
        this.extAuthServerInfo = info;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.protocolDataModel = (SJctrProtocolDataModel)this.getDataObjectModel("COM_AUTH_PROT_INF");
        this.priHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_HOST_NAME");
        this.secretDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_SECRET_KEY");
        this.reSecretDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_RE_SECRET_KEY");
        this.nasAddressRadioDataModel = (SJctrNASAddressDataModel)this.getDataObjectModel("COM_NAS_ADDR");
        this.nasAddressDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_NAS_ADDR_TXT");
        this.priPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_PORT_NUM");
        this.priPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.priPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.timeoutDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TOV");
        this.timeoutDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MIN));
        this.timeoutDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MAX));
        this.retriesDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_RET_NUM");
        this.retriesDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MIN));
        this.retriesDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MAX));
        this.secServerDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_SEC_SRV_AUTH");
        this.secHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_HOST_NAME");
        this.secPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_PORT_NUM");
        this.secPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.secPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.authorizeDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_EXT_AUTH_INF");
        this.certifyFileNameDataModel = (SJctrCertifyFileNameDataModel)this.getDataObjectModel("COM_CERTIFICATES");
        this.extDnsLookupDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_DNSINF");
        this.extProtocolDataModel = (SJctrProtocolComboBoxDataModel)this.getDataObjectModel("COM_EXT_AUTH_PROT_INF");
        this.extPriHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_PRI_HOST_NAME");
        this.extPriPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_PRI_PORT_NUM");
        this.extPriPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.extPriPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.extDomainNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_DOMAIN_NAME");
        this.extTimeoutDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_TOV");
        this.extTimeoutDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MIN));
        this.extTimeoutDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MAX));
        this.extIntervalDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_RET_INTERVAL");
        this.extIntervalDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN));
        this.extIntervalDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX));
        this.extRetriesDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_RET_NUM");
        this.extRetriesDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MIN));
        this.extRetriesDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MAX));
        this.extBaseDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_BASE_DN");
        this.extSearchDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEARCH_DN");
        this.extPasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_PASSWORD");
        this.extRePasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_RE_PASSWORD");
        this.testUserNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TEST_NAME");
        this.testPasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_TEST_PASS");
        this.testResultDataModel = (SJctrTestResultDataModel)this.getDataObjectModel("COM_TEST_RESULT");
        this.testResultDataModel.setEnable(true);
        this.testResultDataModel.setTestResut(true);
        this.testResult2DataModel = (SJctrTestResult2DataModel)this.getDataObjectModel("COM_TEST_RESULT2");
        this.testResult2DataModel.setEnable(true);
        this.testResult2DataModel.setTestResut(true);
        this.initialSettings();
        this.initialSettings_Authorize();
        this.initialSettings_Test();
        return ret;
    }

    private void initialSettings() {
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        SJbaseRadiusConfiguration config_pri = (SJbaseRadiusConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseRadiusConfiguration config_sec = (SJbaseRadiusConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        boolean initialSetting = false;
        if (config_pri == null) {
            config_pri = this.extAuthServerInfo.getDefaultRadiusConfig();
            initialSetting = true;
        }
        this.protocolDataModel.selectPap();
        String name = config_pri.getProtocol();
        if (SJctrExtAuthServerUtility.isPapProtocol(name)) {
            this.protocolDataModel.selectPap();
        } else if (SJctrExtAuthServerUtility.isChapProtocol(name)) {
            this.protocolDataModel.selectChap();
        }
        String value = config_pri.getHost();
        this.priHostNameDataModel.setValue(value);
        value = new String(config_pri.getSecret());
        this.secretDataModel.setValue(value);
        value = new String(config_pri.getSecret());
        this.reSecretDataModel.setValue(value);
        this.nasAddressRadioDataModel.selectIdentifier();
        if (SJctrExtAuthServerUtility.isIPv4(config_pri.getAttributes())) {
            this.nasAddressRadioDataModel.selectIPv4();
        } else if (SJctrExtAuthServerUtility.isIPv6(config_pri.getAttributes())) {
            this.nasAddressRadioDataModel.selectIPv6();
        }
        value = extAuthServerUtility.getRadiusAttribute(config_pri.getAttributes());
        if (value.equals("?")) {
            value = "";
        }
        this.nasAddressDataModel.setValue(value);
        value = String.valueOf(config_pri.getPort());
        this.priPortNumberDataModel.setValue(value);
        value = String.valueOf(config_pri.getTimeout());
        this.timeoutDataModel.setValue(value);
        value = String.valueOf(config_pri.getRetryTimes());
        this.retriesDataModel.setValue(value);
        if (config_sec != null) {
            this.secServerDataModel.selectEnable();
        } else {
            if (initialSetting) {
                this.secServerDataModel.selectEnable();
            } else {
                this.secServerDataModel.selectDisable();
            }
            config_sec = this.extAuthServerInfo.getDefaultRadiusConfig();
        }
        value = config_sec.getHost();
        this.secHostNameDataModel.setValue(value);
        value = String.valueOf(config_sec.getPort());
        this.secPortNumberDataModel.setValue(value);
    }

    private void initialSettings_Authorize() {
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        SJbaseLdapGroupConfiguration config_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (config_pri != null) {
            this.authorizeDataModel.selectEnable();
        } else {
            this.authorizeDataModel.selectDisable();
            config_pri = this.extAuthServerInfo.getDefaultGroupLdapConfig();
        }
        this.certifyFileNameDataModel.setFixed(true, true);
        String value = comUtility.getGuidance("COMMON", "FIXED_TEXT_BROWSE_BTN");
        this.certifyFileNameDataModel.setDisplayFileName(value);
        if (SJctrExtAuthServerUtility.isInvalidStr(config_pri.getDnsLookup())) {
            this.extDnsLookupDataModel.selectEnable();
        } else {
            this.extDnsLookupDataModel.selectDisable();
        }
        String protocol = this.extProtocolDataModel.getSelectionName(config_pri.getProtocol());
        this.extProtocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS, comUtility.getGuidance("COMMON", "STARTTLS"));
        this.extProtocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_LDAPS, comUtility.getGuidance("COMMON", "LDAPS"));
        if (protocol.equals("")) {
            this.extProtocolDataModel.setSelection(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS);
        } else {
            this.extProtocolDataModel.setSelection(protocol);
        }
        String value2 = "";
        if (this.extDnsLookupDataModel.isSelectDisable()) {
            value2 = config_pri.getHost();
        }
        this.extPriHostNameDataModel.setValue(value2);
        value2 = "";
        if (this.extDnsLookupDataModel.isSelectDisable()) {
            value2 = String.valueOf(config_pri.getPort());
        }
        if (protocol.equals("")) {
            value2 = String.valueOf(SJctrExtAuthServerInfo.RADIUS_PORT_NUMBER_DEF);
        }
        this.extPriPortNumberDataModel.setValue(value2);
        value2 = config_pri.getDomainName();
        this.extDomainNameDataModel.setValue(value2);
        value2 = config_pri.getSearchDN();
        this.extBaseDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserDN();
        this.extSearchDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        this.extPasswordDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        this.extRePasswordDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getTimeout());
        this.extTimeoutDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryInterval());
        this.extIntervalDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryTimes());
        this.extRetriesDataModel.setValue(value2);
        if (this.authorizeDataModel.isSelectDisable()) {
            // empty if block
        }
    }

    private void initialSettings_Test() {
        this.testUserNameDataModel.setValue("");
        this.testPasswordDataModel.setValue("");
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        int errcode = this.checkSetting();
        if (errcode != RESULT_NORMAL) {
            ret = false;
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseRadiusConfiguration setConfig_pri = null;
        SJbaseRadiusConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseRadiusConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseRadiusConfiguration>();
        setConfig_pri = (SJbaseRadiusConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseRadiusConfiguration();
        }
        this.updateRadiusSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyRadiusConfig(setConfig_pri);
            this.updateRadiusSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        String displayFileName = "-";
        if (this.authorizeDataModel.isSelectEnable()) {
            displayFileName = this.certifyFileNameDataModel.getDisplayFileName();
        }
        if (this.fileUpload == null || this.fileUpload.getOriginFileName() == "") {
            displayFileName = "";
        }
        info.setCertifyFullPathName(displayFileName);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_RADIUS);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        ArrayList<SJctrRadiusServerConfirmData> confirmDataList = new ArrayList<SJctrRadiusServerConfirmData>(1);
        SJctrRadiusServerConfirmData confirmData = new SJctrRadiusServerConfirmData(info);
        confirmDataList.add(confirmData);
        this.putCache(SJctrRadiusServerConfirmData.RADIUS_SERVER_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    private int checkSetting() {
        String searchDn;
        String domain;
        String host;
        String port;
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
        String host2 = this.priHostNameDataModel.getValue();
        if (host2 == null || host2.length() <= 0) {
            errcode = RADIUS_NON_HOSTNAME;
            return errcode;
        }
        if (!validUtil.isValid(host2, SJctrValidatorUtility.Length_1to255)) {
            errcode = RADIUS_OVER_LENGTH_HOSTNAME;
            return errcode;
        }
        if (!validUtil.isValid(host2, SJctrValidatorUtility.HostName)) {
            errcode = RADIUS_INVALID_HOSTNAME;
            return errcode;
        }
        String secret = this.secretDataModel.getValue();
        if (secret == null || secret.length() <= 0) {
            errcode = RADIUS_NON_SECRET;
            return errcode;
        }
        if (!validUtil.isValid(secret, SJctrValidatorUtility.Length_1to256)) {
            errcode = RADIUS_OVER_LENGTH_SECRET;
            return errcode;
        }
        if (!validUtil.isValid(secret, SJctrValidatorUtility.Secret)) {
            errcode = RADIUS_INVALID_SECRET;
            return errcode;
        }
        String resecret = this.reSecretDataModel.getValue();
        if (resecret == null || resecret.length() <= 0) {
            errcode = RADIUS_NON_RESECRET;
            return errcode;
        }
        if (!validUtil.isValid(resecret, SJctrValidatorUtility.Length_1to256)) {
            errcode = RADIUS_OVER_LENGTH_RESECRET;
            return errcode;
        }
        if (!validUtil.isValid(resecret, SJctrValidatorUtility.ReSecret)) {
            errcode = RADIUS_INVALID_RESECRET;
            return errcode;
        }
        if (!secret.equals(resecret)) {
            errcode = RADIUS_NOT_EQUAL_SECRET;
            return errcode;
        }
        String address = this.nasAddressDataModel.getValue();
        if (address == null || address.length() <= 0) {
            errcode = RADIUS_NON_NASADDRESS;
            return errcode;
        }
        if (this.nasAddressRadioDataModel.isSelectIdentifier()) {
            if (!validUtil.isValid(address, SJctrValidatorUtility.Length_1to256)) {
                errcode = RADIUS_OVER_LENGTH_NASADDR;
                return errcode;
            }
            if (!validUtil.isValid(address, SJctrValidatorUtility.NAS_Identifier)) {
                errcode = RADIUS_INVALID_NASADDRESS;
                return errcode;
            }
        } else if (this.nasAddressRadioDataModel.isSelectIPv4()) {
            SJctrIpAddrUtility.IPv4 ipv4 = new SJctrIpAddrUtility.IPv4();
            ipv4.toRegularWithUsableCheck(address);
        } else if (this.nasAddressRadioDataModel.isSelectIPv6()) {
            SJctrIpAddrUtility.IPv6 ipv6 = new SJctrIpAddrUtility.IPv6();
            ipv6.toRegularWithUsableCheck(address);
        }
        if ((port = this.priPortNumberDataModel.getValue()) == null || port.length() <= 0) {
            errcode = RADIUS_NON_PORT;
            return errcode;
        }
        if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
            errcode = RADIUS_INVALID_PORT;
            return errcode;
        }
        int portvalue = Integer.valueOf(port);
        if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
            errcode = RADIUS_NOT_RANGE_PORT;
            return errcode;
        }
        String timeout = this.timeoutDataModel.getValue();
        if (timeout == null || timeout.length() <= 0) {
            errcode = RADIUS_NON_TIMEOUTE;
            return errcode;
        }
        if (!validUtil.isValid(timeout, SJctrValidatorUtility.Timeout)) {
            errcode = RADIUS_INVALID_TIMEOUT;
            return errcode;
        }
        int timeoutvalue = Integer.valueOf(timeout);
        if (timeoutvalue < SJctrExtAuthServerInfo.TIMEOUT_MIN || SJctrExtAuthServerInfo.TIMEOUT_MAX < timeoutvalue) {
            errcode = RADIUS_NOT_RANGE_TIMEOUT;
            return errcode;
        }
        String retries = this.retriesDataModel.getValue();
        if (retries == null || retries.length() <= 0) {
            errcode = RADIUS_NON_RETRIES;
            return errcode;
        }
        if (!validUtil.isValid(retries, SJctrValidatorUtility.Retries)) {
            errcode = RADIUS_INVALID_RETRIES;
            return errcode;
        }
        int retriesvalue = Integer.valueOf(retries);
        if (retriesvalue < SJctrExtAuthServerInfo.RETRY_TIMES_MIN || SJctrExtAuthServerInfo.RETRY_TIMES_MAX < retriesvalue) {
            errcode = RADIUS_NOT_RANGE_RETRIES;
            return errcode;
        }
        if (this.secServerDataModel.isSelectEnable()) {
            host = this.secHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = RADIUS_NON_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = RADIUS_OVER_LENGTH_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = RADIUS_INVALID_SEC_HOSTNAME;
                return errcode;
            }
            port = this.secPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = RADIUS_NON_SEC_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = RADIUS_INVALID_SEC_PORT;
                return errcode;
            }
            portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = RADIUS_NOT_RANGE_SEC_PORT;
                return errcode;
            }
        }
        if (this.authorizeDataModel.isSelectDisable()) {
            return errcode;
        }
        if (this.fileUpload != null && this.fileUpload.getOriginFileName() != "") {
            String full = this.certifyFileNameDataModel.getDisplayFileName();
            if (full == null || full.length() <= 0) {
                errcode = RADIUS_NON_CFFILE;
                return errcode;
            }
            if (!validUtil.isValid(full, SJctrValidatorUtility.nFullPathName)) {
                errcode = RADIUS_INVALID_CFFILE;
                return errcode;
            }
        }
        if (this.extDnsLookupDataModel.isSelectEnable()) {
            String name = this.extProtocolDataModel.getSelection();
            if (SJctrExtAuthServerUtility.isLdapsProtocol(name)) {
                errcode = RADIUS_NOT_SELECT_LDAPS;
                return errcode;
            }
        } else {
            host = this.extPriHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = RADIUS_NON_EXT_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = RADIUS_OVER_LENGTH_EXT_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = RADIUS_INVALID_EXT_HOSTNAME;
                return errcode;
            }
            port = this.extPriPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = RADIUS_NON_EXT_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = RADIUS_INVALID_EXT_PORT;
                return errcode;
            }
            portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = RADIUS_NOT_RANGE_EXT_PORT;
                return errcode;
            }
        }
        if ((domain = this.extDomainNameDataModel.getValue()) == null || domain.length() <= 0) {
            errcode = RADIUS_NON_EXT_DOMAIN;
            return errcode;
        }
        if (!validUtil.isValid(domain, SJctrValidatorUtility.Length_1to255)) {
            errcode = RADIUS_OVER_LENGTH_EXT_DOMAIN;
            return errcode;
        }
        if (!validUtil.isValid(domain, SJctrValidatorUtility.DomainName)) {
            errcode = RADIUS_INVALID_EXT_DOMAIN;
            return errcode;
        }
        String baseDn = this.extBaseDnDataModel.getValue();
        if (baseDn != null && baseDn.length() > 0) {
            if (!validUtil.isValid(baseDn, SJctrValidatorUtility.Length_1to255)) {
                errcode = RADIUS_OVER_LENGTH_EXT_BASEDN;
                return errcode;
            }
            if (!validUtil.isValid(baseDn, SJctrValidatorUtility.BaseDN)) {
                errcode = RADIUS_INVALID_EXT_BASEDN;
                return errcode;
            }
        }
        if ((searchDn = this.extSearchDnDataModel.getValue()) == null || searchDn.length() <= 0) {
            errcode = RADIUS_NON_EXT_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.Length_1to255)) {
            errcode = RADIUS_OVER_LENGTH_EXT_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.SearchDN)) {
            errcode = RADIUS_INVALID_EXT_SEARCHDN;
            return errcode;
        }
        String password = this.extPasswordDataModel.getValue();
        if (password == null || password.length() <= 0) {
            errcode = RADIUS_NON_EXT_PASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Length_1to256)) {
            errcode = RADIUS_OVER_LENGTH_EXT_PASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Password)) {
            errcode = RADIUS_INVALID_EXT_PASSWORD;
            return errcode;
        }
        String rePassword = this.extRePasswordDataModel.getValue();
        if (rePassword == null || rePassword.length() <= 0) {
            errcode = RADIUS_NON_EXT_REPASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Length_1to256)) {
            errcode = RADIUS_OVER_LENGTH_EXT_REPASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Password)) {
            errcode = RADIUS_INVALID_EXT_REPASSWORD;
            return errcode;
        }
        if (!password.equals(rePassword)) {
            errcode = RADIUS_NOT_EQUAL_PASSWORD;
            return errcode;
        }
        String timeout2 = this.extTimeoutDataModel.getValue();
        if (timeout2 == null || timeout2.length() <= 0) {
            errcode = RADIUS_NON_EXT_TIMEOUTE;
            return errcode;
        }
        if (!validUtil.isValid(timeout2, SJctrValidatorUtility.Timeout)) {
            errcode = RADIUS_INVALID_EXT_TIMEOUT;
            return errcode;
        }
        int timeoutvalue2 = Integer.valueOf(timeout2);
        if (timeoutvalue2 < SJctrExtAuthServerInfo.TIMEOUT_MIN || SJctrExtAuthServerInfo.TIMEOUT_MAX < timeoutvalue2) {
            errcode = RADIUS_NOT_RANGE_EXT_TIMEOUT;
            return errcode;
        }
        String interval = this.extIntervalDataModel.getValue();
        if (interval == null || interval.length() <= 0) {
            errcode = RADIUS_NON_EXT_INTERVAL;
            return errcode;
        }
        if (!validUtil.isValid(interval, SJctrValidatorUtility.Timeout)) {
            errcode = RADIUS_INVALID_EXT_INTERVAL;
            return errcode;
        }
        int intervalvalue = Integer.valueOf(interval);
        if (intervalvalue < SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN || SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX < intervalvalue) {
            errcode = RADIUS_NOT_RANGE_EXT_INTERVAL;
            return errcode;
        }
        String retries2 = this.extRetriesDataModel.getValue();
        if (retries2 == null || retries2.length() <= 0) {
            errcode = RADIUS_NON_EXT_RETRIES;
            return errcode;
        }
        if (!validUtil.isValid(retries2, SJctrValidatorUtility.Retries)) {
            errcode = RADIUS_INVALID_EXT_RETRIES;
            return errcode;
        }
        int retriesvalue2 = Integer.valueOf(retries2);
        if (retriesvalue2 < SJctrExtAuthServerInfo.RETRY_TIMES_MIN || SJctrExtAuthServerInfo.RETRY_TIMES_MAX < retriesvalue2) {
            errcode = RADIUS_NOT_RANGE_EXT_RETRIES;
            return errcode;
        }
        return errcode;
    }

    private int checkTestSetting() {
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility varidUtil = new SJctrValidatorUtility();
        String name = this.testUserNameDataModel.getValue();
        String password = this.testPasswordDataModel.getValue();
        if (name == null || name.length() <= 0) {
            errcode = RADIUS_NON_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.Length_1to128)) {
            errcode = RADIUS_OVERLENGTH_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.TestUserName)) {
            errcode = RADIUS_INVALID_USERNAME;
            return errcode;
        }
        if (password == null || password.length() <= 0) {
            errcode = RADIUS_NON_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.Length_1to128)) {
            errcode = RADIUS_OVERLENGTH_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.TestPassword)) {
            errcode = RADIUS_INVALID_TPASSWORD;
            return errcode;
        }
        return errcode;
    }

    private void updateRadiusSetting(String key, SJbaseRadiusConfiguration conf) {
        conf.setServerName(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        String protocol = SJctrExtAuthServerInfo.PROTOCOL_PAP;
        if (this.protocolDataModel.isSelectChap()) {
            protocol = SJctrExtAuthServerInfo.PROTOCOL_CHAP;
        }
        conf.setProtocol(protocol);
        byte[] secret = this.secretDataModel.getValue().getBytes();
        conf.setSecret(secret);
        String attriube = this.nasAddressDataModel.getValue();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(SJctrExtAuthServerInfo.RADIUS_ATTR_IDENTIFIER, SJctrExtAuthServerInfo.BLANK);
        attributes.put(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv4, SJctrExtAuthServerInfo.BLANK);
        attributes.put(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv6, SJctrExtAuthServerInfo.BLANK);
        String attrkey = "";
        if (this.nasAddressRadioDataModel.isSelectIdentifier()) {
            attrkey = SJctrExtAuthServerInfo.RADIUS_ATTR_IDENTIFIER;
        } else if (this.nasAddressRadioDataModel.isSelectIPv4()) {
            attrkey = SJctrExtAuthServerInfo.RADIUS_ATTR_IPv4;
        } else if (this.nasAddressRadioDataModel.isSelectIPv6()) {
            attrkey = SJctrExtAuthServerInfo.RADIUS_ATTR_IPv6;
        }
        attributes.put(attrkey, attriube);
        conf.setAttributes(attributes);
        String host = this.priHostNameDataModel.getValue();
        conf.setHost(host);
        String strport = this.priPortNumberDataModel.getValue();
        int port = Integer.parseInt(strport);
        conf.setPort(port);
        int timeout = Integer.parseInt(this.timeoutDataModel.getValue());
        conf.setTimeout(timeout);
        int retryTimes = Integer.parseInt(this.retriesDataModel.getValue());
        conf.setRetryTimes(retryTimes);
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            conf.setServerName(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
            String sechost = "";
            int secport = SJctrExtAuthServerInfo.INVALID_VALUE;
            if (this.secServerDataModel.isSelectEnable()) {
                sechost = this.secHostNameDataModel.getValue();
                String strsecport = this.secPortNumberDataModel.getValue();
                if (strsecport.length() > 0) {
                    secport = Integer.parseInt(strsecport);
                }
            }
            conf.setHost(sechost);
            conf.setPort(secport);
        }
    }

    private void updateLdapGroupSetting(String key, SJbaseLdapGroupConfiguration conf) {
        String dnsLookup = SJctrExtAuthServerUtility.FALSE_DATA;
        if (this.extDnsLookupDataModel.isSelectEnable()) {
            dnsLookup = SJctrExtAuthServerUtility.TRUE_DATA;
        }
        conf.setDnsLookup(dnsLookup);
        String protocol = this.extProtocolDataModel.getSelection();
        conf.setProtocol(protocol);
        String host = "";
        int port = SJctrExtAuthServerInfo.INVALID_VALUE;
        if (this.extDnsLookupDataModel.isSelectDisable()) {
            host = this.extPriHostNameDataModel.getValue();
            String strport = this.extPriPortNumberDataModel.getValue();
            if (strport.length() > 0) {
                port = Integer.parseInt(strport);
            }
        }
        conf.setHost(host);
        conf.setPort(port);
        String domainName = this.extDomainNameDataModel.getValue();
        conf.setDomainName(domainName);
        String baseDN = this.extBaseDnDataModel.getValue();
        conf.setSearchDN(baseDN);
        String searchUserDN = this.extSearchDnDataModel.getValue();
        conf.setSearchUserDN(searchUserDN);
        String searchUserPassword = this.extPasswordDataModel.getValue();
        conf.setSearchUserPassword(searchUserPassword);
        int timeout = Integer.parseInt(this.extTimeoutDataModel.getValue());
        conf.setTimeout(timeout);
        int retryInterval = Integer.parseInt(this.extIntervalDataModel.getValue());
        conf.setRetryInterval(retryInterval);
        int retryTimes = Integer.parseInt(this.extRetriesDataModel.getValue());
        conf.setRetryTimes(retryTimes);
    }
}

