/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.selectresources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTableModel;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrRsgSelectLdevsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595462;
    private static final String DISP_TITLE = "LDEV_SEL";
    private static final String KEY_TABLE_AVAIL_LDEVS = "COM_TABLE_AVAIL_LDEVS";
    private static final String KEY_TABLE_SEL_LDEVS = "COM_TABLE_SEL_LDEVS";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_LDEV_SELECTION_INF = "COM_LDEV_SELECTION_INF";
    private static final String KEY_SEL_RESOURCE_EXIT_DISP_ID = "COM_SEL_RESOURCE_EXIT_DISP_ID";

    public SJctrRsgSelectLdevsDC() throws SJcException {
        super(33595462);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrRsgLdevsTableModel availableTable = new SJctrRsgLdevsTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAIL_LDEVS, availableTable);
        SJctrRsgLdevsTableModel selectedTable = new SJctrRsgLdevsTableModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_LDEVS, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRsgSelectLdevsDC.this.fireMessageEvent(SELECT_LDEVS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRsgSelectLdevsDC.this.fireMessageEvent(SELECT_LDEVS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_LDEVS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgSelectLdevsDC.this.addAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SELECT_LDEVS_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgSelectLdevsDC.this.removeAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        List<?> selectionInfo = this.getCache(KEY_LDEV_SELECTION_INF);
        List availableTableList = (List)selectionInfo.get(0);
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        availableTable.setBasicDataList(availableTableList);
        List selectedTableList = (List)selectionInfo.get(1);
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        selectedTable.setBasicDataList(selectedTableList);
        ArrayList makeUnitList = new ArrayList(availableTableList.size() + selectedTableList.size());
        makeUnitList.addAll(availableTableList);
        makeUnitList.addAll(selectedTableList);
        SJctrRsgUtility.makeLdevCapacityUnit(availableTable, makeUnitList);
        SJctrRsgUtility.makeLdevCapacityUnit(selectedTable, makeUnitList);
        return true;
    }

    private void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        List<Object> addData = availableTable.removeSelectedRowData();
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        selectedTable.addRowData(addData, 0);
        List<Object> selectingList = selectedTable.getFilterData(addData);
        selectedTable.setRowSelectionList(selectingList);
        selectedTable.setCurrentPage(Integer.toString(1));
        selectedTable.setVScrollReset(true);
        selectedTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        List<Object> removeData = selectedTable.removeSelectedRowData();
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        availableTable.addRowData(removeData, 0);
        List<Object> selectingList = availableTable.getFilterData(removeData);
        availableTable.setRowSelectionList(selectingList);
        availableTable.setCurrentPage(Integer.toString(1));
        availableTable.setVScrollReset(true);
        availableTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    @Override
    public boolean checkEndData() {
        ArrayList<Integer> dispIdInfo = new ArrayList<Integer>();
        dispIdInfo.add(33595462);
        this.putCache(KEY_SEL_RESOURCE_EXIT_DISP_ID, dispIdInfo);
        ArrayList<List<Object>> selectionInfo = new ArrayList<List<Object>>();
        SJctrRsgLdevsTableModel availableTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_AVAIL_LDEVS);
        List<Object> availableList = availableTable.getAllRowData();
        selectionInfo.add(availableList);
        SJctrRsgLdevsTableModel selectedTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
        List<Object> selectedList = selectedTable.getAllRowData();
        selectionInfo.add(selectedList);
        this.checkDedupPoolVol(availableList, selectedList);
        this.putCache(KEY_LDEV_SELECTION_INF, selectionInfo);
        return true;
    }

    private void checkDedupPoolVol(List<?> availableList, List<?> selectedList) {
        SJmoHDPRelation relation;
        int index;
        short iPoolID;
        HashSet<Integer> dedupPoolIDList = new HashSet<Integer>();
        List<?> poolDetailList = this.getCache(SJmoGetPoolDetail.class);
        List<?> LDEVRelationList = this.getCache(SJmoGetHDPRelation.class);
        block0: for (SJctrRsgLdevInfo selRsgLdev : selectedList) {
            if (selRsgLdev.getbPoolVol()) {
                iPoolID = selRsgLdev.getSPoolID();
                for (SJmoPoolDetail poolDetail : poolDetailList) {
                    if (poolDetail.getPoolId() != iPoolID) continue;
                    if (!poolDetail.isPoolDedup()) continue block0;
                    dedupPoolIDList.add(Integer.valueOf(iPoolID));
                    continue block0;
                }
                continue;
            }
            if (!selRsgLdev.getBFPTVol() || (index = Collections.binarySearch(LDEVRelationList, selRsgLdev)) < 0) continue;
            relation = (SJmoHDPRelation)LDEVRelationList.get(index);
            dedupPoolIDList.add(relation.getIPoolId());
        }
        for (SJctrRsgLdevInfo availableRsgLdev : availableList) {
            if (availableRsgLdev.getbPoolVol()) {
                iPoolID = availableRsgLdev.getSPoolID();
                if (!dedupPoolIDList.contains(iPoolID)) continue;
                SJctrError err = new SJctrError(207, 22, 205175);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!availableRsgLdev.getBFPTVol() || (index = Collections.binarySearch(LDEVRelationList, availableRsgLdev)) < 0 || !dedupPoolIDList.contains((relation = (SJmoHDPRelation)LDEVRelationList.get(index)).getIPoolId())) continue;
            SJctrError err = new SJctrError(207, 22, 205175);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static enum SELECT_LDEVS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

