/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl.SJctrCreatePGsDC;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsAutoCopyBackModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsCachePartitionModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsEncryptionModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsInitialParityGroupIdModel;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.model.SJctrEditPGsVirtModeModel;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilInnerPg;

public class SJctrChangeSettingDC
extends SJctrDialogDataController {
    private SJctrCreatePGsInitialParityGroupIdModel initialPGId;
    private SJctrCreatePGsCachePartitionModel cachePartition;
    private SJctrCreatePGsEncryptionModel encryption;
    private SJctrEditPGsVirtModeModel virtualization;
    private SJctrCreatePGsAutoCopyBackModel autoCopyBack;
    private SJctrCheckBoxDataModel pgIdCheckBox;
    private SJctrCheckBoxDataModel clprCheckBox;
    private SJctrCheckBoxDataModel encCheckBox;
    private SJctrCheckBoxAreaDataModel vmCheckBox;
    private SJctrCheckBoxDataModel autoCopybaxkCheckBox;
    private boolean isEncSame;
    private boolean isVMSame;
    private boolean isCopybackSame;
    private boolean isClprSame;
    private boolean isInitFb4PgIdSame;
    private int initEncValue;
    private boolean initVMValue;
    private int initCopybackValue;
    private short initClprValue;
    private int initFb4Value;
    private int initPgIdValue;

    public SJctrChangeSettingDC() throws SJcException {
        super(33595538);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("PG", "TSK_DD92");
    }

    private void initDataModel() {
        this.initialPGId = new SJctrCreatePGsInitialParityGroupIdModel();
        this.addDataObjectModel("COM_INITIAL_PG_ID", this.initialPGId);
        this.pgIdCheckBox = new SJctrCheckBoxDataModel();
        this.addDataObjectModel("COM_PGID_CHECKBOX", this.pgIdCheckBox);
        this.cachePartition = new SJctrCreatePGsCachePartitionModel();
        this.addDataObjectModel("COM_CACHE_PARTITION", this.cachePartition);
        this.clprCheckBox = new SJctrCheckBoxDataModel();
        this.addDataObjectModel("COM_CLPR_CHECKBOX", this.clprCheckBox);
        this.encryption = new SJctrCreatePGsEncryptionModel();
        this.addDataObjectModel("COM_ENCRYPTION", this.encryption);
        this.encCheckBox = new SJctrCheckBoxDataModel();
        this.addDataObjectModel("COM_ENCRYPTION_CHECKBOX", this.encCheckBox);
        this.virtualization = new SJctrEditPGsVirtModeModel();
        this.addDataObjectModel("COM_VIRTUALIZATION", this.virtualization);
        this.vmCheckBox = new SJctrCheckBoxAreaDataModel();
        this.addDataObjectModel("COM_VIRTUALIZATION_CHECKBOX", this.vmCheckBox);
        this.autoCopyBack = new SJctrCreatePGsAutoCopyBackModel();
        this.addDataObjectModel("COM_AUTO_COPYBACK", this.autoCopyBack);
        this.autoCopybaxkCheckBox = new SJctrCheckBoxDataModel();
        this.addDataObjectModel("COM_AUTO_COPYBACK_CHECKBOX", this.autoCopybaxkCheckBox);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public boolean checkEndData() {
        if (!this.isValidInput()) {
            SJctrLogUty.warn(this.getClass().getName(), "checkEndData", "User input is not correct");
            throw SJctrParityGroupUtility.createPgException(205099);
        }
        List pgInfos = SJctrParityGroupUtility.getModifiableCache(this, "KEY_CANDIDATE_PGINFO");
        SJctrParityGroupUtility.CandidatePgInfo pgInfo = (SJctrParityGroupUtility.CandidatePgInfo)pgInfos.get(0);
        List<SJmoPgDetail> selectedPgs = SJctrParityGroupUtility.getModifiableCache(this, "KEY_SELECTED_PGS");
        List<SJmoPgScatteredInfo> scatlist = pgInfo.getScattered();
        HashMap<String, String> scatMap = new HashMap<String, String>();
        HashMap<String, Integer> scatIndexMap = new HashMap<String, Integer>();
        ArrayList<SJmoPgScatteredInfo> new_ScatList = new ArrayList<SJmoPgScatteredInfo>();
        LinkedHashSet<Integer> pgIndexes = new LinkedHashSet<Integer>();
        for (SJmoPgDetail pg : selectedPgs) {
            pgIndexes.add(pg.getIndex());
        }
        block1: for (SJmoPgScatteredInfo pgscat : scatlist) {
            for (SJmoPgDetail selpg : selectedPgs) {
                if (selpg.getPG() != pgscat.getPG() || selpg.getFB4() != pgscat.getFB4()) continue;
                ArrayList scatteredPgs = pgscat.getAlPgIndex();
                for (SJmoPgIndex memberPg : scatteredPgs) {
                    if (pgIndexes.contains(memberPg.getIndex())) continue;
                    pgIndexes.add(memberPg.getIndex());
                }
                continue block1;
            }
        }
        ArrayList<SJmoPgDetail> used = new ArrayList<SJmoPgDetail>();
        List createdPgs = SJctrParityGroupUtility.getCache(this, SJmoGetPgDetail.class);
        used.addAll(createdPgs);
        for (SJmoPgDetail candidate : pgInfo.getPgs()) {
            if (pgIndexes.contains(candidate.getIndex())) continue;
            used.add(candidate);
        }
        String outpg = "";
        String outenc = "";
        String outvm = "";
        String outcb = "";
        boolean prtflg = false;
        List<Object> unusedPgIds = new ArrayList();
        if (this.pgIdCheckBox.isSelect()) {
            int initFb4 = this.initialPGId.getInputFb4();
            int initPgid = this.initialPGId.getInputPgid();
            int maxFb4 = this.initialPGId.getFb4MaxValue();
            int maxPgid = this.initialPGId.getPgidMaxValue();
            List<?> wkInPgList = this.getCache(SJctrCreatePGsDC.KEY_CLASS_INNERPG_UTIL);
            SJmoRscUtilInnerPg wkInPg = (SJmoRscUtilInnerPg)wkInPgList.get(0);
            unusedPgIds = SJctrParityGroupUtility.findUnusedPg(pgIndexes.size(), initFb4, initPgid, maxFb4, maxPgid, used, wkInPg, pgIndexes);
            if (unusedPgIds.size() != pgIndexes.size()) {
                SJctrLogUty.warn(this.getClass().getName(), "checkEndData", "PG ID is not enough");
                throw SJctrParityGroupUtility.createPgException(206176);
            }
            outpg = " PG:" + initFb4 + "-" + initPgid;
            prtflg = true;
        }
        int inputAutoCopyBackValue = this.autoCopyBack.getInputAutoCopyBackValue();
        int inputEncryptionValue = this.encryption.getInputEncryptionValue();
        int inputVMValue = this.virtualization.getInputVirtModeValue();
        short inputClpr = this.cachePartition.getInputClpr();
        if (this.encCheckBox.isSelect() && this.vmCheckBox.isSelectCheckBox()) {
            if (inputEncryptionValue == 1 && inputVMValue == 1) {
                SJctrLogUty.warn(this.getClass().getName(), "checkEndData", "User input is not correct");
                throw SJctrParityGroupUtility.createPgException(205210);
            }
        } else if (this.encCheckBox.isSelect() || this.vmCheckBox.isSelectCheckBox()) {
            for (int i = 0; i < pgInfo.getPgs().size(); ++i) {
                SJmoPgDetail pg = pgInfo.getPgs().get(i);
                SJmoPgEncryptionInfo enc = pgInfo.getPgEncs().get(i);
                if (!pgIndexes.contains(pg.getIndex()) || (!this.encCheckBox.isSelect() || inputEncryptionValue != 1 || !pg.getBVirtMode()) && (!this.vmCheckBox.isSelectCheckBox() || inputVMValue != 1 || enc.getEncrypt() != 1)) continue;
                SJctrLogUty.warn(this.getClass().getName(), "checkEndData", "User input is not correct");
                throw SJctrParityGroupUtility.createPgException(205210);
            }
        }
        int pgid = 0;
        for (int i = 0; i < pgInfo.getPgs().size(); ++i) {
            SJmoPgDetail pg = pgInfo.getPgs().get(i);
            SJmoPgEncryptionInfo enc = pgInfo.getPgEncs().get(i);
            if (!pgIndexes.contains(pg.getIndex())) continue;
            if (this.encCheckBox.isSelect()) {
                enc.setEncrypt(inputEncryptionValue);
            }
            if (this.vmCheckBox.isSelectCheckBox()) {
                boolean bInputVMValue = inputVMValue == 1;
                pg.setBVirtMode(bInputVMValue);
            }
            if (this.clprCheckBox.isSelect()) {
                pg.setCLPR(inputClpr);
            }
            if (this.autoCopybaxkCheckBox.isSelect()) {
                pg.setCopybackMode(inputAutoCopyBackValue);
            }
            if (this.pgIdCheckBox.isSelect()) {
                int ifb4 = pg.getFB4();
                int ipg = pg.getPG();
                int new_ifb4 = ((int[])unusedPgIds.get(pgid))[0];
                int new_ipg = ((int[])unusedPgIds.get(pgid))[1];
                SJmoPgDetail newPg = this.getNewPgDetailData(pg, new_ifb4, new_ipg);
                pgInfo.getPgs().remove(i);
                pgInfo.getPgs().add(i, newPg);
                enc.setFB4(new_ifb4);
                enc.setPG(new_ipg);
                SJmoPgEncryptionInfo newEnc = this.getNewPgEncryptionInfoData(enc);
                pgInfo.getPgEncs().remove(i);
                pgInfo.getPgEncs().add(i, newEnc);
                if (scatlist.size() > 0) {
                    int j;
                    String topPgIndexKey = (String)scatMap.get(pg.getIndexKey());
                    if (topPgIndexKey != null) {
                        for (j = 0; j < new_ScatList.size(); ++j) {
                            SJmoPgScatteredInfo new_scat = (SJmoPgScatteredInfo)new_ScatList.get(j);
                            if (new_scat.getIndexKey() != topPgIndexKey) continue;
                            ArrayList new_pgs = new_scat.getAlPgIndex();
                            new_pgs.add(newPg);
                            break;
                        }
                    } else {
                        for (j = 0; j < scatlist.size(); ++j) {
                            SJmoPgScatteredInfo scat = pgInfo.getScattered().get(j);
                            if (scat.getFB4() != ifb4 || scat.getPG() != ipg) continue;
                            SJmoPgScatteredInfo newScat = this.getNewPgScatteredInfoData(scat, newPg);
                            scatIndexMap.put(newPg.getIndexKey(), j);
                            ArrayList pgs = scat.getAlPgIndex();
                            for (int k = 0; k < pgs.size(); ++k) {
                                scatMap.put(((SJmoPgIndex)pgs.get(k)).getIndexKey(), newScat.getIndexKey());
                            }
                            new_ScatList.add(newScat);
                            break;
                        }
                    }
                }
            }
            ++pgid;
        }
        if (new_ScatList.size() > 0) {
            for (SJmoPgScatteredInfo new_scatInfo : new_ScatList) {
                int index = (Integer)scatIndexMap.get(new_scatInfo.getIndexKey());
                scatlist.remove(index);
                scatlist.add(index, new_scatInfo);
            }
        }
        this.putCache("KEY_CANDIDATE_PGINFO", pgInfos);
        if (this.encCheckBox.isSelect()) {
            outenc = " Encryption:" + (inputEncryptionValue == 1 ? "Enable" : "Disable");
            prtflg = true;
        }
        if (this.vmCheckBox.isSelectCheckBox()) {
            outvm = " Virtualization Mode:" + (inputVMValue == 1 ? "Enable" : "Disable");
            prtflg = true;
        }
        if (this.autoCopybaxkCheckBox.isSelect()) {
            outcb = " Copy-back-Mode:" + (inputAutoCopyBackValue == SJctrParityGroupUtility.RMI_VALUE_COPYBACK_ENABLED ? "Enable" : "Disable");
            prtflg = true;
        }
        if (prtflg) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkEndData", "Change Settings Request" + outpg + outenc + outvm + outcb);
        }
        return true;
    }

    private SJmoPgEncryptionInfo getNewPgEncryptionInfoData(SJmoPgEncryptionInfo enc) {
        SJmoPgEncryptionInfo newEnc = new SJmoPgEncryptionInfo();
        newEnc.setEncrypt(enc.getEncrypt());
        newEnc.setFB4(enc.getFB4());
        newEnc.setPG(enc.getPG());
        return newEnc;
    }

    private SJmoPgDetail getNewPgDetailData(SJmoPgDetail pg, int iFB4, int iPG) {
        SJmoPgDetail newPg = new SJmoPgDetail();
        newPg.setFB4(iFB4);
        newPg.setPG(iPG);
        newPg.setCLPR(pg.getCLPR());
        newPg.setRaidLevel(pg.getRaidLevel());
        newPg.setBVirtMode(pg.getBVirtMode());
        newPg.setBVirtSupport(pg.getBVirtSupport());
        newPg.setCopybackMode(pg.getCopybackMode());
        newPg.setBaseEmulationType(pg.getBaseEmulationType());
        newPg.setDriveType(pg.getDriveType());
        newPg.setHDDrpm(pg.getHDDrpm());
        newPg.setHDDType(pg.getHDDType());
        return newPg;
    }

    private SJmoPgScatteredInfo getNewPgScatteredInfoData(SJmoPgScatteredInfo scat, SJmoPgDetail newPg) {
        SJmoPgScatteredInfo newInfo = new SJmoPgScatteredInfo();
        newInfo.setFB4(newPg.getFB4());
        newInfo.setPG(newPg.getPG());
        ArrayList<SJmoPgDetail> pgList = new ArrayList<SJmoPgDetail>();
        pgList.add(newPg);
        newInfo.setAlPgIndex(pgList);
        return newInfo;
    }

    private boolean isValidInput() {
        boolean bInputVMValue;
        boolean pgIdChecked = this.pgIdCheckBox.isSelect();
        int inputFb4Value = this.initialPGId.getInputFb4();
        int inputPgIdValue = this.initialPGId.getInputPgid();
        if (pgIdChecked && (inputFb4Value == -1 || inputPgIdValue == -1)) {
            return false;
        }
        boolean autoCopybackChecked = this.autoCopybaxkCheckBox.isSelect();
        int inputAutoCopyBackValue = this.autoCopyBack.getInputAutoCopyBackValue();
        if (autoCopybackChecked && inputAutoCopyBackValue == -1) {
            return false;
        }
        boolean encChecked = this.encCheckBox.isSelect();
        int inputEncryptionValue = this.encryption.getInputEncryptionValue();
        if (encChecked && inputEncryptionValue == -1) {
            return false;
        }
        boolean vmChecked = this.vmCheckBox.isSelectCheckBox();
        int inputVMValue = this.virtualization.getInputVirtModeValue();
        if (vmChecked && inputVMValue == -1) {
            return false;
        }
        boolean clprChecked = this.clprCheckBox.isSelect();
        short inputClprValue = this.cachePartition.getInputClpr();
        if (clprChecked && inputClprValue == -1) {
            return false;
        }
        if (pgIdChecked && this.isInitFb4PgIdSame && inputFb4Value == this.initFb4Value && this.isInitFb4PgIdSame && inputPgIdValue == this.initPgIdValue) {
            return false;
        }
        if (autoCopybackChecked && this.isCopybackSame && inputAutoCopyBackValue == this.initCopybackValue) {
            return false;
        }
        if (encChecked && this.isEncSame && inputEncryptionValue == this.initEncValue) {
            return false;
        }
        boolean bl = bInputVMValue = inputVMValue == 1;
        if (vmChecked && this.isVMSame && bInputVMValue == this.initVMValue) {
            return false;
        }
        return !clprChecked || !this.isClprSame || inputClprValue != this.initClprValue;
    }

    @Override
    public boolean checkConstructData() {
        List pgInfo = SJctrParityGroupUtility.getModifiableCache(this, "KEY_CANDIDATE_PGINFO");
        if (pgInfo == null || pgInfo.size() != 1) {
            SJctrLogUty.warn(this.getClass().getName(), "checkConstructData", "pgInfo is empty");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        List<SJmoPgDetail> selectedPg = SJctrParityGroupUtility.getModifiableCache(this, "KEY_SELECTED_PGS");
        if (selectedPg == null || selectedPg.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getName(), "checkConstructData", "selectedPg is empty");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        List<SJmoClprInfo> clprs = SJctrParityGroupUtility.getCache(this, SJmoGetClprInfo.class);
        Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> scatteredPgInfo = SJctrParityGroupUtility.createScatteredPgInfo((SJctrParityGroupUtility.CandidatePgInfo)pgInfo.get(0), clprs);
        SJctrParityGroupUtility.PgPdevInfo representativePg = scatteredPgInfo.get(selectedPg.get(0).getIndex()).getRepresentativePg();
        this.initEncValue = representativePg.getEnc().getEncrypt();
        this.initVMValue = representativePg.getPg().getBVirtMode();
        this.initCopybackValue = representativePg.getPg().getCopybackMode();
        this.initClprValue = representativePg.getPg().getCLPR();
        this.isEncSame = true;
        this.isVMSame = true;
        this.isCopybackSame = true;
        this.isClprSame = true;
        boolean isVMActive = true;
        for (SJmoPgDetail pg : selectedPg) {
            SJctrParityGroupUtility.ScatteredPgInfo info = scatteredPgInfo.get(pg.getIndex());
            this.isEncSame &= info.getRepresentativePg().getEnc().getEncrypt() == this.initEncValue;
            this.isVMSame &= info.getRepresentativePg().getPg().getBVirtMode() == this.initVMValue;
            this.isCopybackSame &= info.getRepresentativePg().getPg().getCopybackMode() == this.initCopybackValue;
            this.isClprSame &= info.getRepresentativePg().getPg().getCLPR() == this.initClprValue;
            if (info.getRepresentativePg().getPg().getBVirtSupport()) continue;
            isVMActive = false;
        }
        SJcRoleResourceContainer roleResource = this.getOwner().getAuthorizeContainer().getRoleResourceContainer();
        SJctrLicenseContainer license = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        this.encryption.setEditable(roleResource.checkAuthority(46) && license.checkPP(SJctrLicenseContainer.PPID_ENCRYPTION) && this.encryption.checkPolicy(this));
        if (this.isEncSame) {
            this.encryption.setInputEncryptionValue(this.initEncValue);
        }
        this.encryption.setDirtyAll();
        if (!isVMActive) {
            this.vmCheckBox.setEnableCheckBox(false);
            this.virtualization.setEnable(false);
        }
        if (this.isVMSame) {
            this.virtualization.setInputVirtModeValue(this.initVMValue);
        }
        this.vmCheckBox.setDirtyAll();
        this.virtualization.setDirtyAll();
        if (this.isCopybackSame) {
            this.autoCopyBack.setInputCopybackValue(this.initCopybackValue);
            this.autoCopyBack.setDirtyAll();
        }
        if (this.isClprSame) {
            this.cachePartition.refreshData(clprs);
            this.cachePartition.setInputClpr(this.initClprValue);
            this.cachePartition.setDirtyAll();
        } else {
            this.cachePartition.refreshData(clprs);
            this.cachePartition.setDirtyAll();
        }
        boolean bl = this.isInitFb4PgIdSame = selectedPg.size() == 1;
        if (this.isInitFb4PgIdSame) {
            this.initFb4Value = representativePg.getPg().getFB4();
            this.initPgIdValue = representativePg.getPg().getPG();
            this.initialPGId.setInputFb4(this.initFb4Value);
            this.initialPGId.setInputPgid(this.initPgIdValue);
        } else {
            this.initFb4Value = -1;
            this.initPgIdValue = -1;
        }
        this.initialPGId.refreshData();
        this.initialPGId.setDirtyAll();
        return true;
    }
}

