/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPdevUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.arraygroup.assignSDs.model.SJctrAssignSDsSelectData;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.SJctrPGDriveData;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.SJctrSelectedPGData;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl.SJctrChangeSettingDC;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl.SJctrParityGroupPropertiesDC;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsAutoCopyBackModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsCachePartitionModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsDriveBoxTypeModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsDriveKindModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsDriveSelectTypeModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsDriveSelectionModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsEncryptionModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsInitialDriveBoxModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsInitialParityGroupIdModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsNumOfPGsModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsRaidLevelModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsSelectedPGsTableModel;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrPGPropertyDriveTableModel;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.model.SJctrEditPGsVirtModeModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrDispID;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetDriveBoxInfo;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilInnerPg;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilPdev;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoDriveBoxInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;
import sanproject.sn2.model.data.volume.SJmoVdevLdevInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilInnerPg;
import sanproject.sn2.modelrc.util.SJmoRscUtilPdev;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrCreatePGsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1011101;
    static final String KEY_CANDIDATE_PGINFO = "KEY_CANDIDATE_PGINFO";
    private static final long MAX_LBA_SIZE_NF2K_14TB = 0x333332FFFFL;
    private static final long NF_COMPRESSION_RATE4 = 4L;
    private static final long NF_COMPRESSION_RATE8 = 8L;
    public static final Class KEY_CLASS_PDEV_UTIL = SJmoGetRscUtilPdev.class;
    public static final Class KEY_CLASS_INNERPG_UTIL = SJmoGetRscUtilInnerPg.class;
    static final String KEY_SELECTED_PGS = "KEY_SELECTED_PGS";
    public static final String KEY_SELECTED_PGINFO = "KEY_SELECTED_PGINFO";
    public static final String KEY_SELECTED_PGINFO_FOR_CONFIRM = "KEY_SELECTED_PGINFO_FOR_CONFIRM";
    private SJctrCreatePGsDriveBoxTypeModel driveBoxType;
    private SJctrCreatePGsRaidLevelModel raidLevel;
    private SJctrCreatePGsDriveKindModel driveTypeKind;
    private SJctrCreatePGsDriveSelectionModel driveSelection;
    private SJctrCreatePGsNumOfPGsModel numOfPGs;
    private SJctrCreatePGsDriveSelectTypeModel driveSelectType;
    private SJctrCreatePGsInitialParityGroupIdModel initialPGId;
    private SJctrCreatePGsInitialDriveBoxModel initialDriveBox;
    private SJctrCreatePGsCachePartitionModel cachePartition;
    private SJctrCreatePGsEncryptionModel encryption;
    private SJctrEditPGsVirtModeModel virtualization;
    private SJctrCreatePGsAutoCopyBackModel autoCopyBack;
    private SJctrPGPropertyDriveTableModel availableDrvsTable;
    private SJctrCreatePGsSelectedPGsTableModel selectedPGsTable;
    private SJctrTextLabelDataModel numOfSelect;

    public SJctrCreatePGsDC() {
        super(0x1011101);
        this.initDataModel();
        this.initListener();
    }

    protected void initDataModel() {
        this.driveBoxType = new SJctrCreatePGsDriveBoxTypeModel();
        this.addDataObjectModel("COM_DRIVE_BOX_TYPE", this.driveBoxType);
        this.raidLevel = new SJctrCreatePGsRaidLevelModel();
        this.addDataObjectModel("COM_RDLV", this.raidLevel);
        this.driveTypeKind = new SJctrCreatePGsDriveKindModel();
        this.addDataObjectModel("COM_DRIVE_TYPE_CODE", this.driveTypeKind);
        this.driveSelection = new SJctrCreatePGsDriveSelectionModel();
        this.addDataObjectModel("COM_DRIVE_SELECTION", this.driveSelection);
        this.numOfPGs = new SJctrCreatePGsNumOfPGsModel();
        this.addDataObjectModel("COM_NUM_OF_PG", this.numOfPGs);
        this.driveSelectType = new SJctrCreatePGsDriveSelectTypeModel();
        this.addDataObjectModel("COM_DRIVE_SELECT_TYPE", this.driveSelectType);
        this.availableDrvsTable = new SJctrPGPropertyDriveTableModel();
        this.addDataObjectModel("COM_AVAILABLE_DRIVES_TBL", this.availableDrvsTable);
        this.initialPGId = new SJctrCreatePGsInitialParityGroupIdModel();
        this.addDataObjectModel("COM_INITIAL_PG_ID", this.initialPGId);
        this.initialDriveBox = new SJctrCreatePGsInitialDriveBoxModel();
        this.addDataObjectModel("COM_INITIAL_DRIVE_BOX", this.initialDriveBox);
        this.cachePartition = new SJctrCreatePGsCachePartitionModel();
        this.addDataObjectModel("COM_CACHE_PARTITION", this.cachePartition);
        this.encryption = new SJctrCreatePGsEncryptionModel();
        this.addDataObjectModel("COM_ENCRYPTION", this.encryption);
        this.virtualization = new SJctrEditPGsVirtModeModel();
        this.addDataObjectModel("COM_VIRTUALIZATION", this.virtualization);
        this.autoCopyBack = new SJctrCreatePGsAutoCopyBackModel();
        this.addDataObjectModel("COM_AUTO_COPYBACK", this.autoCopyBack);
        this.selectedPGsTable = new SJctrCreatePGsSelectedPGsTableModel();
        this.addDataObjectModel("COM_SELECTED_PG_TBL", this.selectedPGsTable);
        this.numOfSelect = new SJctrTextLabelDataModel();
        this.addDataObjectModel("COM_NUM_OF_SELECT", this.numOfSelect);
        for (final Message msg : Message.values()) {
            SJctrButtonDataModel button = new SJctrButtonDataModel();
            this.addDataObjectModel(msg.notify, button);
            button.addItemSelectListener(new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrCreatePGsDC.this.fireMessageEvent(msg);
                }
            });
        }
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        this.updateFooterButtons();
    }

    protected boolean updateFooterButtons() {
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfoCache = this.getCandidatePgInfoCache();
        boolean isFooterButtonEnabled = !candidatePgInfoCache.getPgs().isEmpty();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, isFooterButtonEnabled);
        footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, isFooterButtonEnabled);
        return isFooterButtonEnabled;
    }

    private void initListener() {
        for (final Message msg : Message.values()) {
            this.addMessageEventListener(msg, new SJctrMessageEventListener(){

                @Override
                public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                    switch (msg) {
                        case ADD: {
                            SJctrCreatePGsDC.this.addAction(event, dstModel);
                            break;
                        }
                        case DETAIL: {
                            SJctrCreatePGsDC.this.detailAction(event, dstModel);
                            break;
                        }
                        case CHANGE_SETTINGS: {
                            SJctrCreatePGsDC.this.changeSettingsAction(event, dstModel);
                            break;
                        }
                        case CONCATENATE: {
                            SJctrCreatePGsDC.this.concatenateAction(event, dstModel);
                            break;
                        }
                        case REMOVE: {
                            SJctrCreatePGsDC.this.removeAction(event, dstModel);
                            break;
                        }
                        case LEFT_CHANGE_W_RAID_LEVEL: {
                            SJctrCreatePGsDC.this.leftChangeAction(event, dstModel, true);
                            break;
                        }
                        case LEFT_CHANGE_WO_RAID_LEVEL: {
                            SJctrCreatePGsDC.this.leftChangeAction(event, dstModel, false);
                            break;
                        }
                        case LEFT_CHANGE_ENC: {
                            SJctrCreatePGsDC.this.leftChangeEncAction(event, dstModel);
                        }
                    }
                }
            });
        }
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                List pgInfos = (List)param.get(SJctrCreatePGsDC.KEY_CANDIDATE_PGINFO);
                SJctrCreatePGsDC.this.putCandidatePgInfoCache((SJctrParityGroupUtility.CandidatePgInfo)pgInfos.get(0));
                List<SJmoPgDetail> candidatePgs = ((SJctrParityGroupUtility.CandidatePgInfo)pgInfos.get(0)).getPgs();
                List<?> inpgUtilList = SJctrCreatePGsDC.this.getCache(KEY_CLASS_INNERPG_UTIL);
                SJmoRscUtilInnerPg rscPg = (SJmoRscUtilInnerPg)inpgUtilList.get(0);
                SJctrCreatePGsDC.this.resetRscUtil();
                ArrayList<SJmoPgDetail> addPgList = new ArrayList<SJmoPgDetail>();
                for (int i = 0; i < candidatePgs.size(); ++i) {
                    SJmoPgDetail pg = candidatePgs.get(i);
                    pg.setIDataMode(2);
                    addPgList.add(pg);
                }
                ArrayList<ArrayList<SJmoPgDetail>> storePgRscList = new ArrayList<ArrayList<SJmoPgDetail>>();
                storePgRscList.add(addPgList);
                rscPg.clearRsvData();
                rscPg.setRsvData(storePgRscList);
                inpgUtilList = new ArrayList();
                inpgUtilList.add(rscPg);
                SJctrCreatePGsDC.this.putCache(KEY_CLASS_INNERPG_UTIL, inpgUtilList);
                SJctrCreatePGsDC.this.refreshModel();
            }
        });
    }

    private void leftChangeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel, boolean shouldRaidLevelUpdate) {
        Set<String> inputDriveTypeCodes = this.driveTypeKind.getInputDriveTypeCodes();
        int inputDriveBoxType = this.driveBoxType.getInputDriveBoxType();
        boolean isAuto = this.driveSelection.isInputValueAuto();
        if (shouldRaidLevelUpdate) {
            this.raidLevel.refreshData(this.countFreePdev(inputDriveTypeCodes, -2));
            this.raidLevel.setDirtyAll();
        }
        SJctrParityGroupUtility.RaidLevel inputRaidLevel = this.raidLevel.getInputRaidLevelValue();
        if (isAuto) {
            boolean isDisperse = this.driveSelectType.isInputValueDisperse();
            this.numOfPGs.setMaxValue(this.countNumOfPgs(inputDriveTypeCodes, inputDriveBoxType, inputRaidLevel, isDisperse));
            this.numOfPGs.setDirtyAll();
        } else {
            TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> pdevs = this.getAvailableDriveboxPdevMap(inputDriveTypeCodes, -2);
            this.availableDrvsTable.setupFreePdevData(pdevs.values());
            this.availableDrvsTable.setDirtyAll();
            this.numOfSelect.setLabel(Integer.toString(inputRaidLevel == null ? 0 : inputRaidLevel.getRequiredPdevNumber()));
            this.numOfSelect.setDirtyAll();
        }
        this.leftChangeEncAction(event, dstModel);
        this.encryption.setDirtyAll();
    }

    protected void leftChangeEncAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Set<String> inputDriveTypeCodes = this.driveTypeKind.getInputDriveTypeCodes();
        SJctrParityGroupUtility.RaidLevel inputRaidLevel = this.raidLevel.getInputRaidLevelValue();
        this.virtualization.refreshData(inputDriveTypeCodes, inputRaidLevel);
        if (!this.virtualization.getEnableRadioButton()) {
            this.virtualization.setInputVirtModeValue(false);
        } else if (this.encryption.getInputEncryptionValue() == 1) {
            this.virtualization.setEnable("COM_ENABLE", false);
            this.virtualization.setInputVirtModeValue(false);
        }
        this.virtualization.setDirtyAll();
    }

    private void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<SJctrSelectedPGData> basicDataList = this.getSelectedRowData();
        List<SJmoPgDetail> selectedPgs = this.selectePgsFromCandidate(basicDataList);
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        List<SJmoPgDetail> candidatePgs = candidatePgInfo.getPgs();
        List<SJmoPgEncryptionInfo> candidateEncs = candidatePgInfo.getPgEncs();
        List<SJmoPgScatteredInfo> candidateScattered = candidatePgInfo.getScattered();
        List<List<SJmoPdevDetail>> candidatePdevs = candidatePgInfo.getPdevs();
        TreeSet deletePgPdevIndexes = new TreeSet(Collections.reverseOrder());
        TreeSet deleteScatteredIndexs = new TreeSet(Collections.reverseOrder());
        List<?> inpgUtilList = this.getCache(KEY_CLASS_INNERPG_UTIL);
        SJmoRscUtilInnerPg rscPg = (SJmoRscUtilInnerPg)inpgUtilList.get(0);
        List<?> pdevUtilList = this.getCache(KEY_CLASS_PDEV_UTIL);
        SJmoRscUtilPdev rscPdev = (SJmoRscUtilPdev)pdevUtilList.get(0);
        this.resetRscUtil();
        ArrayList<SJmoPgDetail> removePgList = new ArrayList<SJmoPgDetail>();
        ArrayList removePdevList = new ArrayList();
        block0: for (SJmoPgDetail pg : selectedPgs) {
            int i;
            for (i = 0; i < candidatePgs.size(); ++i) {
                if (pg.getIndex() != candidatePgs.get(i).getIndex()) continue;
                deletePgPdevIndexes.add(i);
                break;
            }
            for (i = 0; i < candidateScattered.size(); ++i) {
                for (SJmoPgIndex index : candidateScattered.get(i).getAlPgIndex()) {
                    if (pg.getIndex() != index.getIndex()) continue;
                    deleteScatteredIndexs.add(i);
                    continue block0;
                }
            }
        }
        Iterator<SJmoPgDetail> i$ = deleteScatteredIndexs.iterator();
        while (i$.hasNext()) {
            int scatteredIndex = (Integer)((Object)i$.next());
            block5: for (SJmoPgIndex pgIndex : candidateScattered.get(scatteredIndex).getAlPgIndex()) {
                for (int i = 0; i < candidatePgs.size(); ++i) {
                    if (pgIndex.getIndex() != candidatePgs.get(i).getIndex()) continue;
                    deletePgPdevIndexes.add(i);
                    continue block5;
                }
            }
        }
        i$ = deletePgPdevIndexes.iterator();
        while (i$.hasNext()) {
            int index = (Integer)((Object)i$.next());
            removePgList.add(candidatePgs.get(index));
            removePdevList.addAll(candidatePdevs.get(index));
            candidatePgs.remove(index);
            candidateEncs.remove(index);
            candidatePdevs.remove(index);
        }
        i$ = deleteScatteredIndexs.iterator();
        while (i$.hasNext()) {
            int index = (Integer)((Object)i$.next());
            candidateScattered.remove(index);
        }
        ArrayList<ArrayList<SJmoPgDetail>> storePgRscList = new ArrayList<ArrayList<SJmoPgDetail>>();
        storePgRscList.add(removePgList);
        rscPg.delRsvData(storePgRscList);
        inpgUtilList = new ArrayList();
        inpgUtilList.add(rscPg);
        this.putCache(KEY_CLASS_INNERPG_UTIL, inpgUtilList);
        ArrayList storePdevRscList = new ArrayList();
        storePdevRscList.add(removePdevList);
        rscPdev.delRsvData(storePdevRscList);
        pdevUtilList = new ArrayList();
        pdevUtilList.add(rscPdev);
        this.putCache(KEY_CLASS_PDEV_UTIL, pdevUtilList);
        this.putCandidatePgInfoCache(candidatePgInfo);
        this.refreshModel();
    }

    private void concatenateAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<SJctrSelectedPGData> basicDataList = this.getSelectedRowData();
        this.checkSelectedRowCount("concatenateAction", 2, 4, basicDataList, 206195);
        List<SJmoPgDetail> selectedPgs = this.selectePgsFromCandidate(basicDataList);
        final SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        final List<SJmoPgScatteredInfo> candidateScattered = candidatePgInfo.getScattered();
        List<SJmoClprInfo> clprs = SJctrParityGroupUtility.getCache(this, SJmoGetClprInfo.class);
        Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> info = SJctrParityGroupUtility.createScatteredPgInfo(candidatePgInfo, clprs);
        SJmoPgDetail representativePg = selectedPgs.get(0);
        SJctrParityGroupUtility.ScatteredPgInfo representativePgInfo = info.get(representativePg.getIndex());
        int raidLevel = representativePg.getRaidLevel();
        byte driveType = representativePg.getDriveType();
        int driveRpm = representativePg.getHDDrpm();
        long driveSize = representativePg.getPDEVSize();
        int encryption = representativePgInfo.getRepresentativePg().getEnc().getEncrypt();
        boolean virtualizationMode = representativePg.getBVirtMode();
        int copybackMode = representativePg.getCopybackMode();
        short clpr = representativePg.getCLPR();
        final ArrayList<SJmoPgScatteredInfo> scattereds = new ArrayList<SJmoPgScatteredInfo>();
        final ArrayList<SJmoPgDetail> pgs = new ArrayList<SJmoPgDetail>();
        for (SJmoPgDetail pg : selectedPgs) {
            SJctrParityGroupUtility.ScatteredPgInfo scattered = info.get(pg.getIndex());
            if (pg.getRaidLevel() != raidLevel) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "raidLevel is not correct");
                throw SJctrParityGroupUtility.createPgException(206172);
            }
            if (pg.getDriveType() != driveType || pg.getHDDrpm() != driveRpm || pg.getPDEVSize() != driveSize) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "driveType is not correct");
                throw SJctrParityGroupUtility.createPgException(206173);
            }
            if (scattered.getRepresentativePg().getEnc().getEncrypt() != encryption) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "encryption is not correct");
                throw SJctrParityGroupUtility.createPgException(206174);
            }
            if (pg.getBVirtMode() != virtualizationMode) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "virtualizationMode is not correct");
                throw SJctrParityGroupUtility.createPgException(206286);
            }
            if (pg.getCopybackMode() != copybackMode) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "copybackMode is not correct");
                throw SJctrParityGroupUtility.createPgException(206175);
            }
            if (pg.getCLPR() != clpr) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "CLPR is not correct");
                throw SJctrParityGroupUtility.createPgException(206345);
            }
            for (SJctrParityGroupUtility.PgPdevInfo pgpdev : scattered.getPgPdevs()) {
                pgs.add(pgpdev.getPg());
            }
            if (!scattered.isConcatenatedPg()) continue;
            scattereds.add(scattered.getScatteredInfo());
        }
        SJctrParityGroupUtility.RaidLevel level = SJctrParityGroupUtility.RaidLevel.findByRmiValue(representativePg.getRaidLevel());
        switch (level.getSupportConcatenate()) {
            case 1: {
                if (pgs.size() == 2) break;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "# of PG is not 2");
                throw SJctrParityGroupUtility.createPgException(205098);
            }
            case 2: {
                if (pgs.size() == 2 || pgs.size() == 4) break;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "# of PG is not 2 or 4");
                throw SJctrParityGroupUtility.createPgException(205098);
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "concatenateAction", "Unsupported Raid level");
                throw SJctrParityGroupUtility.createPgException(205100);
            }
        }
        String strFuncID = Integer.toString(213);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(209022);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                Collections.sort(pgs, new Comparator<SJmoPgDetail>(){

                    @Override
                    public int compare(SJmoPgDetail o1, SJmoPgDetail o2) {
                        return o1.getIndex() - o2.getIndex();
                    }
                });
                for (SJmoPgScatteredInfo delete : scattereds) {
                    candidateScattered.remove(delete);
                }
                SJmoPgScatteredInfo newInfo = new SJmoPgScatteredInfo();
                ArrayList<SJmoPgIndex> index = new ArrayList<SJmoPgIndex>();
                for (int i = 0; i < pgs.size(); ++i) {
                    SJmoPgIndex pg = (SJmoPgIndex)pgs.get(i);
                    if (i == 0) {
                        newInfo.setFB4(pg.getFB4());
                        newInfo.setPG(pg.getPG());
                    }
                    index.add(pg);
                }
                newInfo.setAlPgIndex(index);
                candidateScattered.add(newInfo);
                SJctrCreatePGsDC.this.putCandidatePgInfoCache(candidatePgInfo);
                SJctrCreatePGsDC.this.refreshModel();
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private List<SJctrSelectedPGData> getSelectedRowData() {
        return this.selectedPGsTable.getSelectedRowData();
    }

    private void detailAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<SJctrSelectedPGData> basicDataList = this.getSelectedRowData();
        SJmoPgDetail selectedPg = this.selectePgsFromCandidate(basicDataList).get(0);
        List<SJmoClprInfo> clprs = SJctrParityGroupUtility.getCache(this, SJmoGetClprInfo.class);
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> info = SJctrParityGroupUtility.createScatteredPgInfo(candidatePgInfo, clprs);
        SJctrParityGroupUtility.ScatteredPgInfo scatteredPgInfo = info.get(selectedPg.getIndex());
        List driveBoxInfo = SJctrParityGroupUtility.getCache(this, SJmoGetDriveBoxInfo.class);
        HashMap map = new HashMap();
        map.putAll(this.getProxy().getCacheMap());
        map.put(KEY_SELECTED_PGINFO, Arrays.asList(scatteredPgInfo));
        map.put(SJctrCreatePGsDC.class.toString(), driveBoxInfo);
        SJctrRelatedDispDataObject related = super.createDialog(SJctrParityGroupPropertiesDC.class, map);
        this.registerDataController(related);
        this.addUpdateDisp(related);
    }

    private void changeSettingsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.validateInput();
        List<SJctrSelectedPGData> basicDataList = this.getSelectedRowData();
        List<SJmoPgDetail> selectedPgs = this.selectePgsFromCandidate(basicDataList);
        HashMap map = new HashMap();
        map.putAll(this.getProxy().getCacheMap());
        map.put(KEY_SELECTED_PGS, selectedPgs);
        SJctrRelatedDispDataObject related = super.createDialog(SJctrChangeSettingDC.class, map);
        this.registerDataController(related);
        this.addUpdateDisp(related);
    }

    private void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String validateInput = this.validateInput();
        if (validateInput != null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "User input is not correct:" + validateInput);
            throw SJctrParityGroupUtility.createPgException(205097);
        }
        this.createPgsData();
        this.refreshModel();
    }

    private String validateInput() {
        if (this.driveTypeKind.getInputDriveTypeCodes() == null) {
            return "driveTypeKind";
        }
        SJctrParityGroupUtility.RaidLevel raidLevelValue = this.raidLevel.getInputRaidLevelValue();
        if (raidLevelValue == null) {
            return "raidLevel";
        }
        if (this.driveSelection.isInputValueAuto()) {
            if (this.numOfPGs.getInputValue() == -1) {
                return "numOfPGs";
            }
            if (this.driveBoxType.isInputDriveBoxTypeInvalid()) {
                return "driveBoxType";
            }
            if (this.initialDriveBox.getInputValue() == -1) {
                return "initialDriveBox";
            }
        } else if (this.availableDrvsTable.getSelectedRowData().size() != raidLevelValue.getRequiredPdevNumber()) {
            return "availableDrvsTable";
        }
        if (this.initialPGId.getInputFb4() == -1) {
            return "initialPGId#fb4";
        }
        if (this.initialPGId.getInputPgid() == -1) {
            return "initialPGId#pgid";
        }
        if (this.cachePartition.getInputClpr() == -1) {
            return "cachePartition";
        }
        if (this.encryption.isEditable() && this.encryption.getInputEncryptionValue() == -1) {
            return "encryption";
        }
        if (this.virtualization.getInputVirtModeValue() == -1) {
            return "virtualization";
        }
        if (this.autoCopyBack.getInputAutoCopyBackValue() == -1) {
            return "autoCopyBack";
        }
        return null;
    }

    private void createPgsData() {
        int numOfPgs;
        PdevSelectionLogic logic;
        if (this.driveSelection.isInputValueAuto()) {
            logic = this.driveSelectType.isInputValueDisperse() ? new AutoDispersePdevSelectionLogic() : new AutoLinearPdevSelectionLogic();
            numOfPgs = this.numOfPGs.getInputValue();
        } else {
            logic = new ManualPdevSelectionLogic();
            numOfPgs = 1;
        }
        List<int[]> unused = this.findUnusedPgIdsList(numOfPgs);
        if (unused.size() != numOfPgs) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createPgsData", "PGID is not enough");
            throw SJctrParityGroupUtility.createPgException(206170);
        }
        logic.init();
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        SJctrParityGroupUtility.RaidLevel inputRaidLevel = this.raidLevel.getInputRaidLevelValue();
        int inputCopyback = this.autoCopyBack.getInputAutoCopyBackValue();
        int inputEncryption = this.encryption.getInputEncryptionValue();
        short inputClpr = this.cachePartition.getInputClpr();
        int inputVM = this.virtualization.getInputVirtModeValue();
        boolean inputVirtSupport = this.virtualization.getDisableRadioButton();
        int numOfPdev = inputRaidLevel.getRequiredPdevNumber();
        List<?> inpgUtilList = this.getCache(KEY_CLASS_INNERPG_UTIL);
        SJmoRscUtilInnerPg rscPg = (SJmoRscUtilInnerPg)inpgUtilList.get(0);
        List<?> pdevUtilList = this.getCache(KEY_CLASS_PDEV_UTIL);
        SJmoRscUtilPdev rscPdev = (SJmoRscUtilPdev)pdevUtilList.get(0);
        this.resetRscUtil();
        ArrayList<SJmoPgDetail> addPgList = new ArrayList<SJmoPgDetail>();
        ArrayList<SJmoPdevDetail> addPdevList = new ArrayList<SJmoPdevDetail>();
        for (int[] ids : unused) {
            List<SJmoPdevDetail> selectedPdevs = logic.selectPdevs(numOfPdev);
            if (selectedPdevs.size() != numOfPdev) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createPgsData", "PDEV is not enough");
                throw SJctrParityGroupUtility.createPgException(206171);
            }
            SJmoPgDetail pg = new SJmoPgDetail();
            pg.setFB4(ids[0]);
            pg.setPG(ids[1]);
            pg.setCLPR(inputClpr);
            pg.setRaidLevel(inputRaidLevel.getRmiValue());
            pg.setCopybackMode(inputCopyback);
            pg.setBaseEmulationType(625);
            pg.setDriveType(selectedPdevs.get(0).getDriveType());
            pg.setHDDrpm(selectedPdevs.get(0).getHDDrpm());
            pg.setHDDType(selectedPdevs.get(0).getHDDKind());
            pg.setPDEVSize(selectedPdevs.get(0).getHDDCapa2());
            boolean bInputVM = inputVM == 1;
            pg.setBVirtMode(bInputVM);
            pg.setBVirtSupport(inputVirtSupport);
            SJmoPgEncryptionInfo enc = new SJmoPgEncryptionInfo();
            enc.setFB4(ids[0]);
            enc.setPG(ids[1]);
            enc.setEncrypt(inputEncryption);
            candidatePgInfo.getPgs().add(pg);
            candidatePgInfo.getPgEncs().add(enc);
            candidatePgInfo.getPdevs().add(selectedPdevs);
            pg.setIDataMode(2);
            addPgList.add(pg);
            addPdevList.addAll(selectedPdevs);
        }
        ArrayList<ArrayList<SJmoPgDetail>> storePgRscList = new ArrayList<ArrayList<SJmoPgDetail>>();
        storePgRscList.add(addPgList);
        rscPg.setRsvData(storePgRscList);
        inpgUtilList = new ArrayList();
        inpgUtilList.add(rscPg);
        this.putCache(KEY_CLASS_INNERPG_UTIL, inpgUtilList);
        ArrayList<ArrayList<SJmoPdevDetail>> storePdevRscList = new ArrayList<ArrayList<SJmoPdevDetail>>();
        storePdevRscList.add(addPdevList);
        rscPdev.setRsvData(storePdevRscList);
        pdevUtilList = new ArrayList();
        pdevUtilList.add(rscPdev);
        this.putCache(KEY_CLASS_PDEV_UTIL, pdevUtilList);
        this.putCandidatePgInfoCache(candidatePgInfo);
    }

    private List<int[]> findUnusedPgIdsList(int numOfPgs) {
        int initFb4 = this.initialPGId.getInputFb4();
        int initPgid = this.initialPGId.getInputPgid();
        int maxFb4 = this.initialPGId.getFb4MaxValue();
        int maxPgid = this.initialPGId.getPgidMaxValue();
        ArrayList<SJmoPgDetail> used = new ArrayList<SJmoPgDetail>();
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        List createdPgs = SJctrParityGroupUtility.getCache(this, SJmoGetPgDetail.class);
        used.addAll(createdPgs);
        used.addAll(candidatePgInfo.getPgs());
        return SJctrParityGroupUtility.findUnusedPg(numOfPgs, initFb4, initPgid, maxFb4, maxPgid, used, this.getRscInnerPgUty(), null);
    }

    private Set<Integer> createPdevKeyList(List<List<SJmoPdevDetail>> pdevLists) {
        HashSet<Integer> usedPdev = new HashSet<Integer>();
        for (List<SJmoPdevDetail> pdevs : pdevLists) {
            for (SJmoPdevDetail pdev : pdevs) {
                usedPdev.add(pdev.getKeyIndex());
            }
        }
        return usedPdev;
    }

    private TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> getAvailableDriveboxPdevMap(Set<String> driveTypeCodes, int driveBoxType) {
        TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> ret = new TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev>();
        List<SJmoDriveBoxInfo> driveBoxes = SJctrParityGroupUtility.getCache(this, SJmoGetDriveBoxInfo.class);
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPdevDetail.class);
        Set<Integer> usedPdevKeys = this.createPdevKeyList(this.getCandidatePgInfoCache().getPdevs());
        if (driveTypeCodes.isEmpty() || driveBoxType == -1) {
            return ret;
        }
        SJmoRscUtilPdev pdevUtil = this.getRscPdevUty();
        boolean inputDriveBoxTypeAny = driveBoxType == -2;
        for (SJmoDriveBoxInfo db : driveBoxes) {
            if (!(inputDriveBoxTypeAny || db.getDriveBoxType() == driveBoxType || db.getDriveBoxType() == 8 && driveBoxType == 9 || db.getDriveBoxType() == 9 && driveBoxType == 8)) continue;
            SJctrParityGroupUtility.DriveBoxPdev dbpdev = new SJctrParityGroupUtility.DriveBoxPdev();
            dbpdev.setDriveBox(db);
            block1: for (int[] driveId : db.getDriveIds()) {
                int cdev = driveId[0];
                int rdev = driveId[1];
                for (SJmoPdevDetail pdev : pdevDetails) {
                    if (pdev.getCDEV() != cdev || pdev.getRDEV() != rdev) continue;
                    if (!driveTypeCodes.contains(pdev.getHDDKind()) || !SJctrPdevUtility.isFreeDriveKind(pdev) || !SJctrPdevUtility.isNormalStatus(pdev) || usedPdevKeys.contains(pdev.getKeyIndex()) || 0 != pdevUtil.chkCRID(pdev)) continue block1;
                    dbpdev.getPdevs().add(pdev);
                    continue block1;
                }
            }
            Collections.sort(dbpdev.getPdevs(), new Comparator<SJmoPdevDetail>(){

                @Override
                public int compare(SJmoPdevDetail o1, SJmoPdevDetail o2) {
                    return o1.getRDEV() - o2.getRDEV();
                }
            });
            if (dbpdev.getPdevs().isEmpty()) continue;
            ret.put(db.getDriveBoxId(), dbpdev);
        }
        return ret;
    }

    private TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> getAllDriveboxPdevMap() {
        TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> ret = new TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev>();
        List<SJmoDriveBoxInfo> driveBoxes = SJctrParityGroupUtility.getCache(this, SJmoGetDriveBoxInfo.class);
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPdevDetail.class);
        for (SJmoDriveBoxInfo db : driveBoxes) {
            SJctrParityGroupUtility.DriveBoxPdev dbpdev = new SJctrParityGroupUtility.DriveBoxPdev();
            dbpdev.setDriveBox(db);
            block1: for (int[] driveId : db.getDriveIds()) {
                int cdev = driveId[0];
                int rdev = driveId[1];
                for (SJmoPdevDetail pdev : pdevDetails) {
                    if (pdev.getCDEV() != cdev || pdev.getRDEV() != rdev) continue;
                    dbpdev.getPdevs().add(pdev);
                    continue block1;
                }
            }
            Collections.sort(dbpdev.getPdevs(), new Comparator<SJmoPdevDetail>(){

                @Override
                public int compare(SJmoPdevDetail o1, SJmoPdevDetail o2) {
                    return o1.getRDEV() - o2.getRDEV();
                }
            });
            ret.put(db.getDriveBoxId(), dbpdev);
        }
        return ret;
    }

    private TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> getUsedDriveboxPdevMap() {
        TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> ret = new TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev>();
        List<SJmoDriveBoxInfo> driveBoxes = SJctrParityGroupUtility.getCache(this, SJmoGetDriveBoxInfo.class);
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPdevDetail.class);
        Set<Integer> usedPdevKeys = this.createPdevKeyList(this.getCandidatePgInfoCache().getPdevs());
        SJmoRscUtilPdev pdevUtil = this.getRscPdevUty();
        for (SJmoDriveBoxInfo db : driveBoxes) {
            SJctrParityGroupUtility.DriveBoxPdev dbpdev = new SJctrParityGroupUtility.DriveBoxPdev();
            dbpdev.setDriveBox(db);
            block1: for (int[] driveId : db.getDriveIds()) {
                int cdev = driveId[0];
                int rdev = driveId[1];
                for (SJmoPdevDetail pdev : pdevDetails) {
                    if (pdev.getCDEV() != cdev || pdev.getRDEV() != rdev) continue;
                    if (!SJctrPdevUtility.isFreeDriveKind(pdev)) {
                        dbpdev.getPdevs().add(pdev);
                        continue block1;
                    }
                    if (!SJctrPdevUtility.isNormalStatus(pdev)) {
                        dbpdev.getPdevs().add(pdev);
                        continue block1;
                    }
                    if (usedPdevKeys.contains(pdev.getKeyIndex())) {
                        dbpdev.getPdevs().add(pdev);
                        continue block1;
                    }
                    if (0 == pdevUtil.chkCRID(pdev)) continue block1;
                    dbpdev.getPdevs().add(pdev);
                    continue block1;
                }
            }
            Collections.sort(dbpdev.getPdevs(), new Comparator<SJmoPdevDetail>(){

                @Override
                public int compare(SJmoPdevDetail o1, SJmoPdevDetail o2) {
                    return o1.getRDEV() - o2.getRDEV();
                }
            });
            ret.put(db.getDriveBoxId(), dbpdev);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        List<?> pdevUtilList;
        boolean rtn = super.checkConstructData();
        this.refreshModel();
        List<?> pgUtilList = this.getCache(KEY_CLASS_INNERPG_UTIL);
        if (pgUtilList == null || pgUtilList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoRscUtilInnerPg not found.");
            rtn = false;
        }
        if ((pdevUtilList = this.getCache(KEY_CLASS_PDEV_UTIL)) == null || pdevUtilList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoRscUtilPdev not found.");
            rtn = false;
        }
        return rtn;
    }

    public void refreshModel() {
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPdevDetail.class);
        List<SJmoClprInfo> clprs = SJctrParityGroupUtility.getCache(this, SJmoGetClprInfo.class);
        List<SJmoDriveBoxInfo> driveBoxInfo = SJctrParityGroupUtility.getCache(this, SJmoGetDriveBoxInfo.class);
        List pgUtilList = SJctrParityGroupUtility.getCache(this, SJmoGetRscUtilInnerPg.class);
        List pdevUtilList = SJctrParityGroupUtility.getCache(this, SJmoGetRscUtilPdev.class);
        SJctrParityGroupUtility.CandidatePgInfo candidatePgInfo = this.getCandidatePgInfoCache();
        Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> info = SJctrParityGroupUtility.createScatteredPgInfo(candidatePgInfo, clprs);
        this.initialPGId.setInputFb4(1);
        this.initialPGId.setInputPgid(1);
        this.initialPGId.refreshData();
        this.initialPGId.setDirtyAll();
        this.driveTypeKind.refreshData(pdevDetails);
        this.driveTypeKind.setDirtyAll();
        Set<String> inputDriveTypeCodes = this.driveTypeKind.getInputDriveTypeCodes();
        this.raidLevel.refreshData(this.countFreePdev(inputDriveTypeCodes, -2));
        this.raidLevel.setDirtyAll();
        SJctrParityGroupUtility.RaidLevel inputRaidLevel = this.raidLevel.getInputRaidLevelValue();
        this.virtualization.refreshData(inputDriveTypeCodes, inputRaidLevel);
        this.virtualization.setInputVirtModeValue(false);
        this.virtualization.setDirtyAll();
        boolean isAuto = this.driveSelection.isInputValueAuto();
        if (isAuto) {
            this.driveBoxType.refreshData(driveBoxInfo);
            this.driveBoxType.setDirtyAll();
            this.initialDriveBox.refreshData(driveBoxInfo);
            this.initialDriveBox.setDirtyAll();
            this.driveSelectType.refreshData();
            this.driveSelectType.setDirtyAll();
            int inputDriveBoxType = this.driveBoxType.getInputDriveBoxType();
            boolean isDisperse = this.driveSelectType.isInputValueDisperse();
            this.numOfPGs.setMaxValue(this.countNumOfPgs(inputDriveTypeCodes, inputDriveBoxType, inputRaidLevel, isDisperse));
            this.numOfPGs.setDirtyAll();
        } else {
            TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> pdevs = this.getAvailableDriveboxPdevMap(inputDriveTypeCodes, -2);
            this.availableDrvsTable.setupFreePdevData(pdevs.values());
            this.availableDrvsTable.setDirtyAll();
            this.numOfSelect.setLabel(Integer.toString(inputRaidLevel == null ? 0 : inputRaidLevel.getRequiredPdevNumber()));
            this.numOfSelect.setDirtyAll();
        }
        SJcRoleResourceContainer roleResource = this.getOwner().getAuthorizeContainer().getRoleResourceContainer();
        SJctrLicenseContainer license = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        this.encryption.setEditable(roleResource.checkAuthority(46) && license.checkPP(SJctrLicenseContainer.PPID_ENCRYPTION) && this.encryption.checkPolicy(this));
        this.encryption.setInputEncryptionEnabled(false);
        this.encryption.setDirtyAll();
        this.autoCopyBack.setInputCopybackEnabled(true);
        this.autoCopyBack.setDirtyAll();
        this.cachePartition.refreshData(clprs);
        this.cachePartition.setDirtyAll();
        this.selectedPGsTable.refreshData(info);
        this.selectedPGsTable.setDirtyAll();
        if (!this.updateFooterButtons()) {
            return;
        }
        List<Map> list = Arrays.asList(info);
        this.putCache(KEY_SELECTED_PGINFO_FOR_CONFIRM, list);
        ArrayList<SJmoPgDetail> idxList = new ArrayList<SJmoPgDetail>();
        ArrayList<SJmoPdevDetail> pdevList = new ArrayList<SJmoPdevDetail>();
        ArrayList<SJmoPgScatteredInfo> pgScatteredInfoList = new ArrayList<SJmoPgScatteredInfo>();
        ArrayList<SJmoVdevDetail> vdevList = new ArrayList<SJmoVdevDetail>();
        ArrayList<SJmoPgDetail> pgDtlList = new ArrayList<SJmoPgDetail>();
        ArrayList<SJmoPgEncryptionInfo> pgEncInfoList = new ArrayList<SJmoPgEncryptionInfo>();
        for (SJctrParityGroupUtility.ScatteredPgInfo pgInfo : info.values()) {
            idxList.add(pgInfo.getRepresentativePg().getPg());
            if (pgInfo.isConcatenatedPg()) {
                pgScatteredInfoList.add(pgInfo.getScatteredInfo());
            }
            for (SJctrParityGroupUtility.PgPdevInfo pgPdevInfo : pgInfo.getPgPdevs()) {
                pgDtlList.add(pgPdevInfo.getPg());
                pdevList.addAll(pgPdevInfo.getPdevs());
                SJmoVdevDetail vdev = new SJmoVdevDetail();
                vdev.setFB4(pgPdevInfo.getPg().getFB4());
                vdev.setPG(pgPdevInfo.getPg().getPG());
                vdev.setIVdev(1);
                ArrayList<SJmoVdevLdevInfo> alVdevLdev = new ArrayList<SJmoVdevLdevInfo>();
                SJmoVdevLdevInfo vdevLdevInfo = new SJmoVdevLdevInfo();
                byte status = 3;
                vdevLdevInfo.setByLdevStatus(status);
                vdevLdevInfo.setLTotalLbaSize(0L);
                vdev.setAlVdevLdev(alVdevLdev);
                int numOfDataDrive = SJctrParityGroupUtility.RaidLevel.findByRmiValue(pgPdevInfo.getPg().getRaidLevel()).getDataDriveNumber();
                if (pgPdevInfo.getPg().getDriveType() == 9) {
                    if (pgPdevInfo.getPg().getBVirtMode()) {
                        vdevLdevInfo.setLTotalLbaSize(this.getVdevTotalLbaSizeCompressed(pgPdevInfo.getPdevs().get(0), numOfDataDrive));
                    } else {
                        vdevLdevInfo.setLTotalLbaSize(this.getVdevTotalLbaSizeUncompressed(pgPdevInfo.getPdevs().get(0), numOfDataDrive));
                    }
                    vdev.setLVdevPhyLbaSize(this.getVdevTotalLbaSizeUncompressed(pgPdevInfo.getPdevs().get(0), numOfDataDrive));
                } else {
                    vdevLdevInfo.setLTotalLbaSize(this.getVdevTotalLbaSize(pgPdevInfo.getPdevs().get(0), numOfDataDrive));
                }
                SJmoPgEncryptionInfo encryptionInfo = pgPdevInfo.getEnc();
                if (Collections.binarySearch(pgEncInfoList, encryptionInfo) < 0) {
                    pgEncInfoList.add(encryptionInfo);
                }
                alVdevLdev.add(vdevLdevInfo);
                vdevList.add(vdev);
            }
        }
        ArrayList<SJmoPdevDetail> unselected = new ArrayList<SJmoPdevDetail>();
        SJmoRscUtilPdev rscPdev = this.getRscPdevUty();
        for (SJmoPdevDetail pdev : pdevDetails) {
            if (pdevList.contains(pdev) || (!SJctrPdevUtility.isSpareDriveKind(pdev) || SJctrPdevUtility.isReservedStatus(pdev)) && (!SJctrPdevUtility.isFreeDriveKind(pdev) || !SJctrPdevUtility.isNormalStatus(pdev)) || 0 != rscPdev.chkCRID(pdev)) continue;
            unselected.add(pdev);
        }
        SJctrAssignSDsSelectData asdData = new SJctrAssignSDsSelectData();
        asdData.setTargetPdevDetails(unselected);
        this.putCache(SJctrAssignSDsSelectData.class, Arrays.asList(asdData));
        SJctrArrayGroupIndexComparator aGComparator = new SJctrArrayGroupIndexComparator();
        Collections.sort(idxList, aGComparator);
        Collections.sort(pgDtlList, aGComparator);
        Collections.sort(pdevList, aGComparator);
        Collections.sort(pgScatteredInfoList, aGComparator);
        Collections.sort(vdevList, aGComparator);
        Collections.sort(pgEncInfoList, aGComparator);
        this.putCache("KEY_SELECT_ARRAYGROUP_ID", idxList);
        this.putCache("KEY_SELECT_PG_DETAIL", pgDtlList);
        this.putCache("KEY_MEMBER_PDEV_DETAIL", pdevList);
        this.putCache("KEY_CREATE_PG_SCATTERED", pgScatteredInfoList);
        this.putCache("KEY_MEMBER_VDEV_DETAIL", vdevList);
        this.putCache("KEY_CREATE_PG_ENCRYPTION", pgEncInfoList);
        SJctrDispID disp = new SJctrDispID(0x1011101);
        disp.setIType(SJctrDispID.TYPE_BASIC);
        this.putCache("KEY_SELECT_DISPID", Arrays.asList(disp));
    }

    public void checkRsg0User() {
        Map<String, SJctrUserGrpInfoDetail> userGrpInfoDetailMap = SJctrRsgUtility.getUserGroupsInfo(this.logUty);
        SJctrUserController uc = this.getOwner();
        String myUserID = uc.getUserSession().getUserName();
        boolean myUserRsg0Flg = false;
        if (userGrpInfoDetailMap != null) {
            Collection<SJctrUserGrpInfoDetail> userGroupColect = userGrpInfoDetailMap.values();
            for (SJctrUserGrpInfoDetail userGroupInfo : userGroupColect) {
                String[] userGrpNames;
                ArrayList<String[]> usersInGroupList;
                String[] userIDs;
                boolean userGroupRsg0Flg = false;
                String useGroupName = userGroupInfo.getGroupName();
                if (userGroupInfo.getAllRsrcGroup()) {
                    userGroupRsg0Flg = true;
                } else {
                    int[] rsgIds = userGroupInfo.getRsrcGroupID();
                    if (rsgIds != null && rsgIds.length > 0) {
                        for (int rsgId : rsgIds) {
                            if (0 != rsgId) continue;
                            userGroupRsg0Flg = true;
                        }
                    }
                }
                if (!userGroupRsg0Flg || (userIDs = (String[])(usersInGroupList = SJcUserGroupInfoUty.getUserInUserGroup(userGrpNames = new String[]{useGroupName})).get(0)) == null || userIDs.length <= 0) continue;
                for (String userID : userIDs) {
                    if (!userID.equals(myUserID)) continue;
                    return;
                }
            }
        }
        if (!myUserRsg0Flg) {
            throw SJctrParityGroupUtility.createPgException(205247);
        }
    }

    private long getVdevTotalLbaSize(SJmoPdevDetail pdev, int numOfDataDrive) {
        long totalLbaSize = 0L;
        for (int i = 0; i < numOfDataDrive; ++i) {
            totalLbaSize += pdev.getHDDCapa2() / 512L * 512L;
        }
        return totalLbaSize;
    }

    private long getVdevTotalLbaSizeUncompressed(SJmoPdevDetail pdev, int numOfDataDrive) {
        long totalLbaSize = 0L;
        for (int i = 0; i < numOfDataDrive; ++i) {
            totalLbaSize += ((pdev.getHDDCapa2() + 1L) / 8L - 1L) / 512L * 512L;
        }
        return totalLbaSize;
    }

    private long getVdevTotalLbaSizeCompressed(SJmoPdevDetail pdev, int numOfDataDrive) {
        long compressionRate = this.getCompressionRate(pdev);
        long totalLbaSize = this.getVdevTotalLbaSizeUncompressed(pdev, numOfDataDrive) * compressionRate;
        return totalLbaSize;
    }

    private long getCompressionRate(SJmoPdevDetail pdev) {
        if (pdev.getHDDCapa2() < 0x333332FFFFL) {
            return 8L;
        }
        return 4L;
    }

    private int countFreePdev(Set<String> driveTypeCodes, int driveBoxType) {
        int freePdevCount = 0;
        TreeMap<Integer, SJctrParityGroupUtility.DriveBoxPdev> avaiableDriveboxPdevMap = this.getAvailableDriveboxPdevMap(driveTypeCodes, driveBoxType);
        for (SJctrParityGroupUtility.DriveBoxPdev dbpdev : avaiableDriveboxPdevMap.values()) {
            freePdevCount += dbpdev.getPdevs().size();
        }
        return freePdevCount;
    }

    private int countNumOfPgs(Set<String> driveTypeCodes, int driveBoxType, SJctrParityGroupUtility.RaidLevel level, boolean isAutoDisperse) {
        if (level == null) {
            return 0;
        }
        PdevSelectionLogic logic = isAutoDisperse ? new AutoDispersePdevSelectionLogic() : new AutoLinearPdevSelectionLogic();
        logic.init();
        int ret = 0;
        int freePdevCount = this.countFreePdev(driveTypeCodes, driveBoxType);
        int numOfPdev = level.getRequiredPdevNumber();
        int maxPg = freePdevCount / numOfPdev;
        List<int[]> list = this.findUnusedPgIdsList(maxPg);
        for (int i = 0; i < list.size(); ++i) {
            List<SJmoPdevDetail> selectedPdevs = logic.selectPdevs(numOfPdev);
            if (selectedPdevs.size() != numOfPdev) {
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(SJctrGetSystemOption.class));
        set.add(this.createModelDirect(SJmoGetPgDetail.class));
        set.add(this.createModelDirect(SJmoGetPgEncryptionInfo.class));
        set.add(this.createModelDirect(SJmoGetPdevDetail.class));
        set.add(this.createModelDirect(SJmoGetClprInfo.class));
        set.add(this.createModelDirect(SJmoGetPgScatteredInfo.class));
        set.add(this.createModelDirect(SJmoGetDriveBoxInfo.class));
        set.add(this.createModelDirect(SJmoGetEncryptionKeyInfoMgr.class));
        set.add(this.createModelDirect(KEY_CLASS_INNERPG_UTIL));
        set.add(this.createModelDirect(KEY_CLASS_PDEV_UTIL));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "Unexpected error");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        catch (IllegalAccessException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "Unexpected error");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        return retValue;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", "CREATE_PG");
    }

    private List<SJmoPgDetail> selectePgsFromCandidate(List<SJctrSelectedPGData> basicDataList) {
        ArrayList<SJmoPgDetail> ret = new ArrayList<SJmoPgDetail>();
        List<SJmoPgDetail> candidatePgs = this.getCandidatePgInfoCache().getPgs();
        for (SJctrSelectedPGData selectedPg : basicDataList) {
            String[] text = selectedPg.getPgId().split("-");
            int fb4 = SJctrParityGroupUtility.toInt(text[0], -1);
            int pgid = SJctrParityGroupUtility.toInt(text[1], -1);
            ret.add(SJctrParityGroupUtility.findPg(candidatePgs, fb4, pgid));
        }
        return ret;
    }

    private void checkSelectedRowCount(String method, int rangeMin, int rangeMax, List<SJctrSelectedPGData> basicDataList, int errorCode) {
        int size = basicDataList.size();
        if (size < rangeMin || rangeMax != -1 && rangeMax < size) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), method, "Select Row = " + size);
            throw SJctrParityGroupUtility.createPgException(errorCode);
        }
    }

    private void putCandidatePgInfoCache(SJctrParityGroupUtility.CandidatePgInfo info) {
        List<SJctrParityGroupUtility.CandidatePgInfo> list = Arrays.asList(info);
        this.putCache(KEY_CANDIDATE_PGINFO, list);
    }

    protected SJctrParityGroupUtility.CandidatePgInfo getCandidatePgInfoCache() {
        List pgInfo = SJctrParityGroupUtility.getModifiableCache(this, KEY_CANDIDATE_PGINFO);
        if (pgInfo.isEmpty()) {
            pgInfo.add(new SJctrParityGroupUtility.CandidatePgInfo());
        }
        return (SJctrParityGroupUtility.CandidatePgInfo)pgInfo.get(0);
    }

    private SJmoRscUtilInnerPg getRscInnerPgUty() {
        List<?> wkInPgList = this.getCache(KEY_CLASS_INNERPG_UTIL);
        SJmoRscUtilInnerPg wkInPg = (SJmoRscUtilInnerPg)wkInPgList.get(0);
        return wkInPg;
    }

    private SJmoRscUtilPdev getRscPdevUty() {
        List<?> wkPDEVList = this.getCache(KEY_CLASS_PDEV_UTIL);
        SJmoRscUtilPdev wkPdev = (SJmoRscUtilPdev)wkPDEVList.get(0);
        return wkPdev;
    }

    private class ManualPdevSelectionLogic
    implements PdevSelectionLogic {
        private List<SJmoPdevDetail> pdevs;

        private ManualPdevSelectionLogic() {
        }

        @Override
        public void init() {
            this.pdevs = new ArrayList<SJmoPdevDetail>();
            List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(SJctrCreatePGsDC.this, SJmoGetPdevDetail.class);
            HashMap<String, SJmoPdevDetail> map = new HashMap<String, SJmoPdevDetail>();
            for (SJmoPdevDetail pdev : pdevDetails) {
                map.put(pdev.getHDDLocation(), pdev);
            }
            List<Object> basicDataList = SJctrCreatePGsDC.this.availableDrvsTable.getSelectedRowData();
            for (SJctrPGDriveData sJctrPGDriveData : basicDataList) {
                this.pdevs.add((SJmoPdevDetail)map.get(sJctrPGDriveData.getLocation()));
            }
        }

        @Override
        public List<SJmoPdevDetail> selectPdevs(int numOfPdev) {
            ArrayList<SJmoPdevDetail> ret = new ArrayList<SJmoPdevDetail>();
            for (int i = 0; i < this.pdevs.size() && i < numOfPdev; ++i) {
                SJmoPdevDetail pdev = this.pdevs.get(i);
                pdev.setIDataMode(2);
                ret.add(pdev);
            }
            return ret;
        }
    }

    private class AutoDispersePdevSelectionLogic
    implements PdevSelectionLogic {
        int[][] DRIVE_BOX_MAP = null;
        private final int[][] DRIVE_BOX_MAP_HM = new int[][]{{0, 1, 2, 3, 24, 25, 26, 27}, {4, 5, 6, 7, 28, 29, 30, 31}, {8, 9, 10, 11, 32, 33, 34, 35}, {12, 13, 14, 15, 36, 37, 38, 39}, {16, 17, 18, 19, 40, 41, 42, 43}, {20, 21, 22, 23, 44, 45, 46, 47}};
        private final int[][] DRIVE_BOX_MAP_AFA_M = new int[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 13}, {14, 15}, {16, 17}, {18, 19}, {20, 21}, {22, 23}};
        private int row;
        private int col;
        private Set<Integer> usedPdev = new HashSet<Integer>();
        private Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> avaiableDriveboxPdevMap;
        private Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> allDriveboxPdevMap;
        private final int productModel = SJsncProductModelUty.getProductModel();
        boolean judgeAFA = false;
        private final int AFA_MODEL_UNKNOWN = 0;
        private final int AFA_MODEL_H = 1;
        private final int AFA_MODEL_H_OPT = 2;
        private final int AFA_MODEL_M = 3;
        int AFAModel;
        int firstDBF2ID;
        private final int LOWER = 0;
        private final int HIGHER = 1;
        int dbf2Order;

        private AutoDispersePdevSelectionLogic() {
        }

        private boolean judgeAFAProcess(int initialDriveBoxID) {
            boolean ret = false;
            int[][] LOCAL_DRIVE_BOX_MAP = new int[][]{{0, 1, 2, 3, 24, 25, 26, 27}, {4, 5, 6, 7, 28, 29, 30, 31}, {8, 9, 10, 11, 32, 33, 34, 35}, {12, 13, 14, 15, 36, 37, 38, 39}, {16, 17, 18, 19, 40, 41, 42, 43}, {20, 21, 22, 23, 44, 45, 46, 47}};
            int local_row = 0;
            int local_col = 0;
            boolean[][] DBF2_MAP = new boolean[][]{{false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false}};
            for (int j = 0; j < LOCAL_DRIVE_BOX_MAP.length; ++j) {
                for (int i = 0; i < LOCAL_DRIVE_BOX_MAP[j].length; ++i) {
                    int driveBoxType;
                    int driveBoxId = LOCAL_DRIVE_BOX_MAP[j][i];
                    SJctrParityGroupUtility.DriveBoxPdev driveBoxPdev = this.allDriveboxPdevMap.get(driveBoxId);
                    if (driveBoxPdev == null || (driveBoxType = driveBoxPdev.getDriveBox().getDriveBoxType()) != 8 && driveBoxType != 9) continue;
                    DBF2_MAP[j][i] = true;
                }
            }
            local_row = 0;
            block2: for (int[] tuple : LOCAL_DRIVE_BOX_MAP) {
                local_col = 0;
                for (int elem : tuple) {
                    if (elem == initialDriveBoxID) break block2;
                    ++local_col;
                }
                ++local_row;
            }
            if (this.productModel == 60) {
                SJctrParityGroupUtility.DriveBoxPdev bsc00DriveBoxPdev = this.allDriveboxPdevMap.get(0);
                SJctrParityGroupUtility.DriveBoxPdev bsc01DriveBoxPdev = this.allDriveboxPdevMap.get(1);
                SJctrParityGroupUtility.DriveBoxPdev bsc02DriveBoxPdev = this.allDriveboxPdevMap.get(2);
                SJctrParityGroupUtility.DriveBoxPdev bsc03DriveBoxPdev = this.allDriveboxPdevMap.get(3);
                SJctrParityGroupUtility.DriveBoxPdev opt24DriveBoxPdev = this.allDriveboxPdevMap.get(24);
                SJctrParityGroupUtility.DriveBoxPdev opt25DriveBoxPdev = this.allDriveboxPdevMap.get(25);
                SJctrParityGroupUtility.DriveBoxPdev opt26DriveBoxPdev = this.allDriveboxPdevMap.get(26);
                SJctrParityGroupUtility.DriveBoxPdev opt27DriveBoxPdev = this.allDriveboxPdevMap.get(27);
                if (!(bsc00DriveBoxPdev == null && bsc01DriveBoxPdev == null && bsc02DriveBoxPdev == null && bsc03DriveBoxPdev == null || opt24DriveBoxPdev == null && opt25DriveBoxPdev == null && opt26DriveBoxPdev == null && opt27DriveBoxPdev == null)) {
                    if (DBF2_MAP[local_row][0] || DBF2_MAP[local_row][1] || DBF2_MAP[local_row][2] || DBF2_MAP[local_row][3] || DBF2_MAP[local_row][4] || DBF2_MAP[local_row][5] || DBF2_MAP[local_row][6] || DBF2_MAP[local_row][7]) {
                        ret = true;
                    }
                } else if (local_row % 2 == 0) {
                    if (local_col % 8 < 4) {
                        if (DBF2_MAP[local_row][0] || DBF2_MAP[local_row][1] || DBF2_MAP[local_row][2] || DBF2_MAP[local_row][3] || DBF2_MAP[local_row + 1][0] || DBF2_MAP[local_row + 1][1] || DBF2_MAP[local_row + 1][2] || DBF2_MAP[local_row + 1][3]) {
                            ret = true;
                        }
                    } else if (DBF2_MAP[local_row][4] || DBF2_MAP[local_row][5] || DBF2_MAP[local_row][6] || DBF2_MAP[local_row][7] || DBF2_MAP[local_row + 1][4] || DBF2_MAP[local_row + 1][5] || DBF2_MAP[local_row + 1][6] || DBF2_MAP[local_row + 1][7]) {
                        ret = true;
                    }
                } else if (local_col % 8 < 4) {
                    if (DBF2_MAP[local_row - 1][0] || DBF2_MAP[local_row - 1][1] || DBF2_MAP[local_row - 1][2] || DBF2_MAP[local_row - 1][3] || DBF2_MAP[local_row][0] || DBF2_MAP[local_row][1] || DBF2_MAP[local_row][2] || DBF2_MAP[local_row][3]) {
                        ret = true;
                    }
                } else if (DBF2_MAP[local_row - 1][4] || DBF2_MAP[local_row - 1][5] || DBF2_MAP[local_row - 1][6] || DBF2_MAP[local_row - 1][7] || DBF2_MAP[local_row][4] || DBF2_MAP[local_row][5] || DBF2_MAP[local_row][6] || DBF2_MAP[local_row][7]) {
                    ret = true;
                }
            } else if (this.productModel == 40) {
                if (local_row % 2 == 0) {
                    if (DBF2_MAP[local_row][0] || DBF2_MAP[local_row][1] || DBF2_MAP[local_row][2] || DBF2_MAP[local_row][3] || DBF2_MAP[local_row + 1][0] || DBF2_MAP[local_row + 1][1] || DBF2_MAP[local_row + 1][2] || DBF2_MAP[local_row + 1][3]) {
                        ret = true;
                    }
                } else if (DBF2_MAP[local_row - 1][0] || DBF2_MAP[local_row - 1][1] || DBF2_MAP[local_row - 1][2] || DBF2_MAP[local_row - 1][3] || DBF2_MAP[local_row][0] || DBF2_MAP[local_row][1] || DBF2_MAP[local_row][2] || DBF2_MAP[local_row][3]) {
                    ret = true;
                }
            } else {
                ret = false;
            }
            return ret;
        }

        private int getAFAModel() {
            int ret = 0;
            switch (this.productModel) {
                case 60: {
                    SJctrParityGroupUtility.DriveBoxPdev bsc00DriveBoxPdev = this.allDriveboxPdevMap.get(0);
                    SJctrParityGroupUtility.DriveBoxPdev bsc01DriveBoxPdev = this.allDriveboxPdevMap.get(1);
                    SJctrParityGroupUtility.DriveBoxPdev bsc02DriveBoxPdev = this.allDriveboxPdevMap.get(2);
                    SJctrParityGroupUtility.DriveBoxPdev bsc03DriveBoxPdev = this.allDriveboxPdevMap.get(3);
                    SJctrParityGroupUtility.DriveBoxPdev opt24DriveBoxPdev = this.allDriveboxPdevMap.get(24);
                    SJctrParityGroupUtility.DriveBoxPdev opt25DriveBoxPdev = this.allDriveboxPdevMap.get(25);
                    SJctrParityGroupUtility.DriveBoxPdev opt26DriveBoxPdev = this.allDriveboxPdevMap.get(26);
                    SJctrParityGroupUtility.DriveBoxPdev opt27DriveBoxPdev = this.allDriveboxPdevMap.get(27);
                    if (!(bsc00DriveBoxPdev == null && bsc01DriveBoxPdev == null && bsc02DriveBoxPdev == null && bsc03DriveBoxPdev == null || opt24DriveBoxPdev == null && opt25DriveBoxPdev == null && opt26DriveBoxPdev == null && opt27DriveBoxPdev == null)) {
                        ret = 2;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 40: {
                    ret = 3;
                    break;
                }
                default: {
                    ret = 0;
                }
            }
            return ret;
        }

        private int judgeDbf2Order(Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> avaiableDBPdevMap, Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> usedDBPdevMap, Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> allDBPdevMap, int firstDBF2ID) {
            int freePdevNumDbf2B;
            int freePdevNumDbf2A;
            int dbf2Order = 0;
            SJctrParityGroupUtility.DriveBoxPdev driveBoxPdevDbf2A = avaiableDBPdevMap.get(firstDBF2ID);
            SJctrParityGroupUtility.DriveBoxPdev driveBoxPdevDbf2B = avaiableDBPdevMap.get(firstDBF2ID + 1);
            if (driveBoxPdevDbf2A == null) {
                freePdevNumDbf2A = 0;
            } else {
                freePdevNumDbf2A = driveBoxPdevDbf2A.getPdevs().size();
                List<SJmoPdevDetail> pdevListDbf2A = driveBoxPdevDbf2A.getPdevs();
                for (SJmoPdevDetail pdev : pdevListDbf2A) {
                    if (!this.usedPdev.contains(pdev.getKeyIndex())) continue;
                    --freePdevNumDbf2A;
                }
            }
            if (driveBoxPdevDbf2B == null) {
                freePdevNumDbf2B = 0;
            } else {
                freePdevNumDbf2B = driveBoxPdevDbf2B.getPdevs().size();
                List<SJmoPdevDetail> pdevListDbf2B = driveBoxPdevDbf2B.getPdevs();
                for (SJmoPdevDetail pdev : pdevListDbf2B) {
                    if (!this.usedPdev.contains(pdev.getKeyIndex())) continue;
                    --freePdevNumDbf2B;
                }
            }
            SJctrParityGroupUtility.DriveBoxPdev usedDriveBoxPdevDbf2A = usedDBPdevMap.get(firstDBF2ID);
            SJctrParityGroupUtility.DriveBoxPdev usedDriveBoxPdevDbf2B = usedDBPdevMap.get(firstDBF2ID + 1);
            SJctrParityGroupUtility.DriveBoxPdev allDriveBoxPdevDbf2A = allDBPdevMap.get(firstDBF2ID);
            SJctrParityGroupUtility.DriveBoxPdev allDriveBoxPdevDbf2B = allDBPdevMap.get(firstDBF2ID + 1);
            int usedPdevNumDbf2A = usedDriveBoxPdevDbf2A == null ? 0 : usedDriveBoxPdevDbf2A.getPdevs().size();
            if (allDriveBoxPdevDbf2A != null) {
                List<SJmoPdevDetail> pdevListDbf2A = allDriveBoxPdevDbf2A.getPdevs();
                for (SJmoPdevDetail pdev : pdevListDbf2A) {
                    if (!this.usedPdev.contains(pdev.getKeyIndex())) continue;
                    ++usedPdevNumDbf2A;
                }
            }
            int usedPdevNumDbf2B = usedDriveBoxPdevDbf2B == null ? 0 : usedDriveBoxPdevDbf2B.getPdevs().size();
            if (allDriveBoxPdevDbf2A != null) {
                List<SJmoPdevDetail> pdevListDbf2B = allDriveBoxPdevDbf2B.getPdevs();
                for (SJmoPdevDetail pdev : pdevListDbf2B) {
                    if (!this.usedPdev.contains(pdev.getKeyIndex())) continue;
                    ++usedPdevNumDbf2B;
                }
            }
            dbf2Order = usedPdevNumDbf2A <= usedPdevNumDbf2B ? (0 < freePdevNumDbf2A ? 0 : (0 < freePdevNumDbf2B ? 1 : 0)) : (0 < freePdevNumDbf2B ? 1 : (0 < freePdevNumDbf2A ? 0 : 0));
            return dbf2Order;
        }

        @Override
        public void init() {
            int inputInitialDriveBox = SJctrCreatePGsDC.this.initialDriveBox.getInputValue();
            Set<String> inputDriveTypeCodes = SJctrCreatePGsDC.this.driveTypeKind.getInputDriveTypeCodes();
            int inputDriveBoxType = SJctrCreatePGsDC.this.driveBoxType.getInputDriveBoxType();
            this.avaiableDriveboxPdevMap = SJctrCreatePGsDC.this.getAvailableDriveboxPdevMap(inputDriveTypeCodes, inputDriveBoxType);
            this.allDriveboxPdevMap = SJctrCreatePGsDC.this.getAllDriveboxPdevMap();
            this.judgeAFA = this.judgeAFAProcess(inputInitialDriveBox);
            if (this.judgeAFA) {
                this.AFAModel = this.getAFAModel();
                if (this.AFAModel == 3) {
                    this.DRIVE_BOX_MAP = new int[12][2];
                    this.DRIVE_BOX_MAP = this.DRIVE_BOX_MAP_AFA_M;
                } else {
                    this.DRIVE_BOX_MAP = new int[6][8];
                    this.DRIVE_BOX_MAP = this.DRIVE_BOX_MAP_HM;
                }
            } else {
                this.DRIVE_BOX_MAP = new int[6][8];
                this.DRIVE_BOX_MAP = this.DRIVE_BOX_MAP_HM;
            }
            block0: for (int[] tuple : this.DRIVE_BOX_MAP) {
                this.col = 0;
                for (int elem : tuple) {
                    if (elem == inputInitialDriveBox) break block0;
                    ++this.col;
                }
                ++this.row;
            }
            if (this.judgeAFA) {
                this.firstDBF2ID = -1;
                block2: for (int j = this.row; j < this.DRIVE_BOX_MAP.length; ++j) {
                    for (int i = this.col; i < this.DRIVE_BOX_MAP[j].length; ++i) {
                        int driveBoxType;
                        int driveBoxId = this.DRIVE_BOX_MAP[j][i];
                        SJctrParityGroupUtility.DriveBoxPdev driveBoxPdev = this.allDriveboxPdevMap.get(driveBoxId);
                        if (driveBoxPdev == null || (driveBoxType = driveBoxPdev.getDriveBox().getDriveBoxType()) != 8) continue;
                        this.firstDBF2ID = this.DRIVE_BOX_MAP[j][i];
                        break block2;
                    }
                }
            }
        }

        @Override
        public List<SJmoPdevDetail> selectPdevs(int numOfPdev) {
            ArrayList<Integer> driveBoxSubTuple = new ArrayList<Integer>();
            int pdevNumInTuple = 0;
            if (this.judgeAFA) {
                TreeMap usedDriveboxPdevMap = SJctrCreatePGsDC.this.getUsedDriveboxPdevMap();
                this.dbf2Order = this.judgeDbf2Order(this.avaiableDriveboxPdevMap, usedDriveboxPdevMap, this.allDriveboxPdevMap, this.firstDBF2ID);
                int roopMax = this.AFAModel == 3 ? (this.row % 4 == 0 ? 4 : (this.row % 4 == 1 ? 3 : (this.row % 4 == 2 ? 2 : 1))) : (this.AFAModel == 2 ? 1 : (this.row % 2 == 0 ? 2 : 1));
                for (int roopcount = 0; roopcount < roopMax; ++roopcount) {
                    int selectDriveBoxType;
                    SJctrParityGroupUtility.DriveBoxPdev driveBoxPdev;
                    int driveBoxId;
                    int i;
                    for (i = 0; i < this.DRIVE_BOX_MAP[this.row + roopcount].length; ++i) {
                        driveBoxId = this.DRIVE_BOX_MAP[this.row + roopcount][i];
                        driveBoxPdev = this.avaiableDriveboxPdevMap.get(driveBoxId);
                        if (roopcount == 0 && i < this.col || driveBoxPdev == null) continue;
                        selectDriveBoxType = driveBoxPdev.getDriveBox().getDriveBoxType();
                        if (selectDriveBoxType == 8) {
                            if (this.dbf2Order != 0) continue;
                            driveBoxSubTuple.add(driveBoxId);
                            pdevNumInTuple += driveBoxPdev.getPdevs().size();
                            continue;
                        }
                        if (selectDriveBoxType == 9) {
                            if (this.dbf2Order != 1) continue;
                            driveBoxSubTuple.add(driveBoxId);
                            pdevNumInTuple += driveBoxPdev.getPdevs().size();
                            continue;
                        }
                        driveBoxSubTuple.add(driveBoxId);
                        pdevNumInTuple += driveBoxPdev.getPdevs().size();
                    }
                    for (i = 0; i < this.DRIVE_BOX_MAP[this.row + roopcount].length; ++i) {
                        driveBoxId = this.DRIVE_BOX_MAP[this.row + roopcount][i];
                        driveBoxPdev = this.avaiableDriveboxPdevMap.get(driveBoxId);
                        if (roopcount == 0 && i < this.col || driveBoxPdev == null) continue;
                        selectDriveBoxType = driveBoxPdev.getDriveBox().getDriveBoxType();
                        if (selectDriveBoxType == 8) {
                            if (this.dbf2Order != 1) continue;
                            driveBoxSubTuple.add(driveBoxId);
                            pdevNumInTuple += driveBoxPdev.getPdevs().size();
                            continue;
                        }
                        if (selectDriveBoxType != 9 || this.dbf2Order != 0) continue;
                        driveBoxSubTuple.add(driveBoxId);
                        pdevNumInTuple += driveBoxPdev.getPdevs().size();
                    }
                }
            } else {
                for (int i = this.col; i < this.DRIVE_BOX_MAP[this.row].length; ++i) {
                    int driveBoxId = this.DRIVE_BOX_MAP[this.row][i];
                    SJctrParityGroupUtility.DriveBoxPdev driveBoxPdev = this.avaiableDriveboxPdevMap.get(driveBoxId);
                    if (driveBoxPdev == null) continue;
                    driveBoxSubTuple.add(driveBoxId);
                    pdevNumInTuple += driveBoxPdev.getPdevs().size();
                }
            }
            ArrayList<SJmoPdevDetail> ret = new ArrayList<SJmoPdevDetail>();
            SJmoRscUtilPdev pdevUtil = SJctrCreatePGsDC.this.getRscPdevUty();
            int nextIndex = 0;
            HashSet<Integer> scanedPdev = new HashSet<Integer>();
            block4: while (scanedPdev.size() != pdevNumInTuple && ret.size() != numOfPdev) {
                int currentDriveBox = (Integer)driveBoxSubTuple.get(nextIndex);
                List<SJmoPdevDetail> list = this.avaiableDriveboxPdevMap.get(currentDriveBox).getPdevs();
                nextIndex = (nextIndex + 1) % driveBoxSubTuple.size();
                for (SJmoPdevDetail pdev : list) {
                    int index;
                    if (0 != pdevUtil.chkCRID(pdev) || scanedPdev.contains(index = pdev.getKeyIndex())) continue;
                    scanedPdev.add(index);
                    if (this.usedPdev.contains(index)) continue;
                    this.usedPdev.add(index);
                    pdev.setIDataMode(2);
                    ret.add(pdev);
                    continue block4;
                }
            }
            return ret;
        }
    }

    private class AutoLinearPdevSelectionLogic
    implements PdevSelectionLogic {
        private Set<Integer> usedPdev = new HashSet<Integer>();
        private Map<Integer, SJctrParityGroupUtility.DriveBoxPdev> avaiableDriveboxPdevMap;

        private AutoLinearPdevSelectionLogic() {
        }

        @Override
        public void init() {
            Set<String> inputDriveTypeCodes = SJctrCreatePGsDC.this.driveTypeKind.getInputDriveTypeCodes();
            int inputDriveBoxType = SJctrCreatePGsDC.this.driveBoxType.getInputDriveBoxType();
            this.avaiableDriveboxPdevMap = SJctrCreatePGsDC.this.getAvailableDriveboxPdevMap(inputDriveTypeCodes, inputDriveBoxType);
        }

        @Override
        public List<SJmoPdevDetail> selectPdevs(int numOfPdev) {
            ArrayList<SJmoPdevDetail> ret = new ArrayList<SJmoPdevDetail>();
            HashSet<Integer> scanedPdev = new HashSet<Integer>();
            SJmoRscUtilPdev pdevUtil = SJctrCreatePGsDC.this.getRscPdevUty();
            int initDriveBox = SJctrCreatePGsDC.this.initialDriveBox.getInputValue();
            for (SJctrParityGroupUtility.DriveBoxPdev driveboxPdev : this.avaiableDriveboxPdevMap.values()) {
                SJmoDriveBoxInfo driveBox = driveboxPdev.getDriveBox();
                if (driveBox.getDriveBoxId() < initDriveBox) continue;
                for (SJmoPdevDetail pdev : driveboxPdev.getPdevs()) {
                    int index;
                    if (ret.size() == numOfPdev) {
                        return ret;
                    }
                    if (0 != pdevUtil.chkCRID(pdev) || scanedPdev.contains(index = pdev.getKeyIndex())) continue;
                    scanedPdev.add(index);
                    if (this.usedPdev.contains(index)) continue;
                    this.usedPdev.add(index);
                    pdev.setIDataMode(2);
                    ret.add(pdev);
                }
            }
            return ret;
        }
    }

    private static interface PdevSelectionLogic {
        public void init();

        public List<SJmoPdevDetail> selectPdevs(int var1);
    }

    private static enum Message implements SJctrNotifyState
    {
        ADD("COM_ADD"),
        CHANGE_SETTINGS("COM_CHANGE_SETTINGS"),
        DETAIL("COM_DETAIL"),
        REMOVE("COM_REMOVE"),
        CONCATENATE("COM_CONCATENATE"),
        LEFT_CHANGE_W_RAID_LEVEL("COM_LEFT_CHANGE_W_RAID_LEVEL"),
        LEFT_CHANGE_WO_RAID_LEVEL("COM_LEFT_CHANGE_WO_RAID_LEVEL"),
        LEFT_CHANGE_ENC("COM_LEFT_CHANGE_ENC");

        private String notify;

        private Message(String name) {
            this.notify = name;
        }
    }
}

