/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.deletepgs.cntl;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.forcibly.com.SJctrForciblyAC;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrDeletePGsAC
extends SJctrForciblyAC {
    private static final long serialVersionUID = 4216657139467226401L;
    private List<SJctrPGDetail> pgDetailList;
    private List<SJctrError> resultData = new ArrayList<SJctrError>();

    public SJctrDeletePGsAC(List<SJctrPGDetail> pgDetailList) {
        this.pgDetailList = pgDetailList;
    }

    @Override
    public int getLeadTime() {
        return 65;
    }

    @Override
    public ArrayList<?> getSetList() {
        try {
            ArrayList<SanRequest> list = new ArrayList<SanRequest>();
            SanRequest request = this.newRequest("MNTdeleteParityGroups");
            SanList pgList = request.newList("ParityGroups");
            for (SJmoPgIndex sJmoPgIndex : this.pgDetailList) {
                SanObject pg = pgList.addObj();
                pg.putIntArray("Id", new int[]{sJmoPgIndex.getFB4(), sJmoPgIndex.getPG()});
            }
            list.add(request);
            return list;
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSetList", "Failed to build set list", e);
            return new ArrayList();
        }
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        try {
            SJctrKeyValueErrorInfo errorInfo;
            SanResponse response = (SanResponse)resultObject;
            if (response != null && (errorInfo = new SJctrKeyValueErrorInfo(response)).getErrorCode() != 0) {
                SJctrError error = errorInfo.createError();
                this.setError(error);
                SanList parityGroups = response.getList("ParityGroups");
                if (parityGroups != null) {
                    for (SanObject pg : parityGroups) {
                        boolean find = false;
                        for (SJmoPgIndex sJmoPgIndex : this.pgDetailList) {
                            int[] pgIds = pg.getIntArray("Id");
                            if (sJmoPgIndex.getFB4() != pgIds[0] || sJmoPgIndex.getPG() != pgIds[1]) continue;
                            SanObject pgErrorInfo = pg.getObj("ErrorInfo");
                            SJctrError createError = new SJctrKeyValueErrorInfo(pgErrorInfo).createError();
                            this.resultData.add(createError);
                            find = true;
                            break;
                        }
                        if (find) continue;
                        this.resultData.add(new SJctrError(error.getFunc(), error.getModule(), 0));
                    }
                }
            }
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", e);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }
}

