/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.confirm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPasswordDC;
import sanproject.sn2.controller.com.SJctrPasswordInterface;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksDC;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardCrumbTrailModel;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmChildModel;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmFooterModel;

public class SJctrConfirmDC
extends SJctrWizardDataController
implements SJctrPasswordInterface {
    public static final int DISP_ID = 0x100000F;
    public static final String KEY_TASK = "COM_TASK";
    public static final String KEY_CHILD = "COM_CHILD";
    private static final String ID_DISP = "CONFIRM";
    private static final String ID_TASKNAME = "DISP_TASK_NAME_MAX_CHAR";
    public static final int ERR_HISTQUEUE_ALLPROTECT = 109003;
    private static final Class<? extends SJctrDataController> CLASS_WIZARD_DC = SJctrWizardWindowDC.class;
    private SJctrSubWizard subWizard = null;
    private SJcException PassCheckResult = null;

    public SJctrConfirmDC() throws SJcException {
        super(0x100000F);
        this.initDataModel();
        this.initListener();
        this.setRestoreFlg(true);
    }

    @Override
    public void finish() throws SJcException {
        SJctrConfirmChildModel child = (SJctrConfirmChildModel)this.getDataObjectModel(KEY_CHILD);
        child.removeAllConfirmDataController();
        super.finish();
    }

    public void addConfirmDataController(SJctrRelatedDispDataObject related) {
        SJctrConfirmChildModel child = (SJctrConfirmChildModel)this.getDataObjectModel(KEY_CHILD);
        child.addConfirmDataController(related);
    }

    @Override
    public boolean checkStartData() {
        SJctrUserController uc = this.getOwner();
        SJctrConfirmChildModel child = (SJctrConfirmChildModel)this.getDataObjectModel(KEY_CHILD);
        List list = (List)child.getDataObject(null);
        boolean allResult = true;
        for (SJctrRelatedDispDataObject related : list) {
            SJctrConfirmDataController confirm = (SJctrConfirmDataController)uc.getDataController(related);
            confirm.checkStartData();
        }
        return allResult;
    }

    @Override
    public void resetControlData() {
        SJctrUserController uc = this.getOwner();
        SJctrConfirmChildModel child = (SJctrConfirmChildModel)this.getDataObjectModel(KEY_CHILD);
        List list = (List)child.getDataObject(null);
        for (SJctrRelatedDispDataObject related : list) {
            SJctrConfirmDataController confirm = (SJctrConfirmDataController)uc.getDataController(related);
            confirm.resetControlData();
        }
        super.resetControlData();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(ID_DISP);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TASK);
        textBox.setLabel(util.getGuidance(ID_TASKNAME));
    }

    @Override
    public void rollback() {
        this.getWizardWindow().makeTask();
        SJctrConfirmChildModel child = (SJctrConfirmChildModel)this.getDataObjectModel(KEY_CHILD);
        child.rollbackAllConfirmDataController();
        child.removeAllConfirmDataController();
        super.rollback();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TASK, new SJctrTextBoxDataModel(){
            {
                this.addTextChangeListener(new SJctrTextChangeListener(){

                    @Override
                    public void textChanged(SJctrTextBoxEvent event) {
                        SJctrTask task = SJctrConfirmDC.this.getWizardWindow().getTask();
                        task.setName(event.getText());
                    }
                });
                this.setRestoreFlg(false);
            }

            @Override
            public void makeDataObject() {
                String taskName = SJctrConfirmDC.this.createDefaultTaskName();
                this.setValue(taskName);
            }
        });
        this.addDataObjectModel(KEY_CHILD, new SJctrConfirmChildModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrConfirmFooterModel());
    }

    private String createDefaultTaskName() {
        SJctrWizardWindowDC wizDc = this.getWizardWindow();
        SJctrSubWizard subWizard = wizDc.getFirstSubWizard();
        String taskName = "";
        if (subWizard != null) {
            SJctrGuidance guidance = subWizard.getTaskNameGuidance();
            taskName = guidance.getGuidanceEN();
        }
        String defaultTaskName = SJctrTask.createDefaultTaskName(taskName);
        wizDc.getTask().setName(defaultTaskName);
        return defaultTaskName;
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.APPLY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrConfirmDC.this.logUty.putlog("doMediatorAction", "WIZ_MSG.APPLY");
                SJctrConfirmDC.this.applyEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(CONFIRM_DC_MSG.RETURN_APPLY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrConfirmDC.this.logUty.putlog("doMessageAction", "CONFIRM_DC_MSG.RETURN_APPLY");
                SJctrConfirmDC.this.applyAfterWarningDialogEvent();
            }
        });
    }

    public void applyEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(CLASS_WIZARD_DC);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        dc.getTask().checkTaskName();
        if (this.checkPassword()) {
            Map<String, List<?>> param = null;
            SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrPasswordDC.class, param);
            this.addUpdateDisp(relatedObj);
            return;
        }
        if (!dc.apply()) {
            this.logUty.putlog("doMediatorAction", "apply fail");
        }
        if (!dc.isHistoryAccept()) {
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(109003);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject relatedObj = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(relatedObj);
            SJctrItemSelectListener listener = this.initApplyWarnDialogOKListener();
            msgDC.addButton(SJctrMessageDataController.MD_OK, listener);
            this.addUpdateDisp(relatedObj);
            return;
        }
        SJctrTopWindowDC topDc = this.getTopWindow();
        SJctrRelatedDispDataObject relatedWiz = uc.removeRelatedDispData(dc.getuId());
        this.addUpdateDisp(relatedWiz);
        SJctrConfirmFooterModel footer = (SJctrConfirmFooterModel)this.getDataObjectModel("COM_FOOTER");
        if (footer.isJumpTaskWindow()) {
            topDc.moveDisplay(SJctrTasksDC.class);
            this.addUpdateDisp(topDc.getUpdateDisp());
        }
    }

    public void autoApplyEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(CLASS_WIZARD_DC);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        dc.getTask().checkTaskName();
        if (!dc.apply()) {
            this.logUty.putlog("doMediatorAction", "apply fail");
        }
        if (!dc.isHistoryAccept()) {
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(109003);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJcException ex = new SJcException();
            ex.setMsg(msg);
            throw ex;
        }
        uc.removeRelatedDispData(dc.getuId());
    }

    public void autoApplyEventForAuthError(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(CLASS_WIZARD_DC);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        dc.getTask().checkTaskName();
        if (!dc.autoApply()) {
            this.logUty.putlog("doMediatorAction", "apply fail");
        }
        if (!dc.isHistoryAccept()) {
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(109003);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJcException ex = new SJcException();
            ex.setMsg(msg);
            throw ex;
        }
        uc.removeRelatedDispData(dc.getuId());
    }

    private SJctrItemSelectListener initApplyWarnDialogOKListener() {
        SJctrItemSelectListener listener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrConfirmDC.this.fireMessageEvent(CONFIRM_DC_MSG.RETURN_APPLY);
            }
        };
        return listener;
    }

    public void applyAfterWarningDialogEvent() {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(CLASS_WIZARD_DC);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        SJctrTopWindowDC topDc = this.getTopWindow();
        SJctrRelatedDispDataObject relatedWiz = uc.removeRelatedDispData(dc.getuId());
        SJctrRelatedDispDataObject msgRelDisp = uc.getRelatedDispData(SJctrMessageDataController.class);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(msgRelDisp);
        msgDC.addUpdateDispParent(relatedWiz);
        SJctrConfirmFooterModel footer = (SJctrConfirmFooterModel)this.getDataObjectModel("COM_FOOTER");
        if (footer.isJumpTaskWindow()) {
            topDc.moveDisplay(SJctrTasksDC.class);
            msgDC.addUpdateDispParent(topDc.getUpdateDisp());
        }
    }

    private void setSubWizard() {
        SJctrWizardCrumbTrailModel crum = (SJctrWizardCrumbTrailModel)this.getWizardWindow().getDataObjectModel("COM_CRUMB");
        Collection<SJctrSubWizard> subWizards = crum.getSubWizardList();
        SJctrSubWizard[] subs = new SJctrSubWizard[subWizards.size()];
        subs = subWizards.toArray(subs);
        this.subWizard = subs[0];
        for (SJctrSubWizard sub : subs) {
            if (sub.getPassId() == "DISABLE") continue;
            this.subWizard = sub;
        }
    }

    @Override
    public String getPassId() {
        if (this.subWizard == null) {
            this.setSubWizard();
        }
        return this.subWizard.getPassId();
    }

    @Override
    public boolean hasPassDetailId() {
        if (this.subWizard == null) {
            this.setSubWizard();
        }
        return this.subWizard.hasPassDetailId();
    }

    @Override
    public short getPassDetailId() {
        if (this.subWizard == null) {
            this.setSubWizard();
        }
        return this.subWizard.getPassDetailId();
    }

    @Override
    public String getPassGuidanceId() {
        if (this.subWizard == null) {
            this.setSubWizard();
        }
        return this.subWizard.getPassGuidanceId();
    }

    @Override
    public Integer getPassIconId() {
        if (this.subWizard == null) {
            this.setSubWizard();
        }
        return this.subWizard.getPassIconId();
    }

    @Override
    public void setPassCheckResult(SJcException e) {
        this.PassCheckResult = e;
    }

    @Override
    public List<SJctrRelatedDispDataObject> getUpdateDispInfo() {
        this.applyEvent(null, null);
        return this.getUpdataDispList();
    }

    private boolean checkPassword() {
        if (this.getPassId().equals("DISABLE")) {
            return false;
        }
        return this.PassCheckResult == null || !this.PassCheckResult.getMsg().getMsgID().equals("0");
    }

    public static enum CONFIRM_DC_MSG implements SJctrNotifyState
    {
        RETURN_APPLY;

    }
}

