/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;

public class SJctrPoolDetail
extends SJmoPoolDetail
implements SJctrCVSMacro {
    static final long serialVersionUID = 892763255247894425L;
    private int iVolSize = 0;
    private ArrayList addLDEV = new ArrayList();
    private ArrayList fptList = new ArrayList();
    private SJmoPoolVolDetail PoolVolDetail;

    public SJctrPoolDetail() {
    }

    public SJctrPoolDetail(byte byDataMode) {
        super.setIDataMode(byDataMode);
    }

    public void setData(SJmoPoolDetail pool) {
        super.setIDataMode(pool.getIDataMode());
        this.setPoolCapa(pool.getPoolCapa());
        this.setPoolFixThreshold(pool.getPoolFixThreshold());
        this.setPoolGrainSize(pool.getPoolGrainSize());
        this.setPoolId(pool.getPoolId());
        this.setPoolKind(pool.getPoolKind());
        this.setPoolStatus(pool.getPoolStatus());
        this.setPoolThreshold(pool.getPoolThreshold());
        this.setPoolUsed(pool.getPoolUsed());
        this.setPoolVolNum(pool.getPoolVolNum());
        this.setPoolPages(pool.getPoolPages());
        this.setPoolUsedPages(pool.getPoolUsedPages());
        this.setLPoolReservedPages(pool.getLPoolReservedPages());
        this.setAouUsed(pool.getAouUsed());
        this.setPageSize(pool.getPageSize());
        this.setMaxSubscription(pool.getMaxSubscription());
        this.setDriveAttribute(pool.getDriveAttribute());
        this.setRaidLevel(pool.getRaidLevel());
        this.setPoolName(pool.getPoolName());
        this.setITierControlInfo(pool.getITierControlInfo());
        if (this.getPoolFixThreshold() == -1) {
            this.setPoolFixThreshold((short)80);
        }
        this.setSPoolThresholdMode(pool.getSPoolThresholdMode());
        this.setSPoolDepletionThreshold(pool.getSPoolDepletionThreshold());
        this.setEmulationType(pool.getEmulationType());
        this.setSExternalMixCompatible(pool.getSExternalMixCompatible());
        this.setAlPoolPgKind(pool.getAlPoolPgKind());
        this.setAlTierInfo(pool.getAlTierInfo());
        this.setByMonEndPeriodHour(pool.getByMonEndPeriodHour());
        this.setByMonEndPeriodMin(pool.getByMonEndPeriodMin());
        this.setByMonStartPeriodHour(pool.getByMonStartPeriodHour());
        this.setByMonStartPeriodMin(pool.getByMonStartPeriodMin());
        this.setByRelocateEndPeriodHour(pool.getByRelocateEndPeriodHour());
        this.setByRelocateEndPeriodMin(pool.getByRelocateEndPeriodMin());
        this.setByRelocateStartPeriodHour(pool.getByRelocateStartPeriodHour());
        this.setByRelocateStartPeriodMin(pool.getByRelocateStartPeriodMin());
        this.setIExecutionCycle(pool.getIExecutionCycle());
        this.setITierRelocatePolicy(pool.getITierRelocatePolicy());
        this.setLPoolOptionFlag(pool.getLPoolOptionFlag());
        this.setIEncrypt(pool.getIEncrypt());
        this.setBPoolDedup(pool.isPoolDedup());
        this.setAlFptVolInfo(pool.getAlFptVolInfo());
        this.setbEnableVirtMode(pool.getbEnableVirtMode());
    }

    public void setHDPRelationByPool(SJmoHDPRelationByPool pool) {
        this.iVolSize = pool.getAlDPVOLInfo().size();
    }

    public int getVolSize() {
        return this.iVolSize + this.addLDEV.size();
    }

    public void addVolSize(SJctrLDEVDetail ldev) {
        this.addLDEV.add(ldev);
    }

    public void delVolSize(SJctrLDEVDetail ldev) {
        for (int i = 0; i < this.addLDEV.size(); ++i) {
            SJctrLDEVDetail wkLdev = (SJctrLDEVDetail)this.addLDEV.get(i);
            if (wkLdev.getSLdkc() != ldev.getSLdkc() || wkLdev.getSCu() != ldev.getSCu() || wkLdev.getSLdev() != ldev.getSLdev()) continue;
            this.addLDEV.remove(i);
            break;
        }
    }

    public int getRemainingNum(long lTotalSize) {
        long rtn = 63232 - this.getVolSize();
        if (this.getMaxSubscription() != 65535) {
            long wkSizeKB = lTotalSize / 2L;
            long lPage = wkSizeKB / this.getPageSize();
            if (wkSizeKB % this.getPageSize() > 0L) {
                ++lPage;
            }
            long wkTotalSize = lPage * this.getPageSize() * 2L;
            long Num = this.getRemainingTotalLBA() / wkTotalSize;
            if (rtn > Num) {
                rtn = Num;
            }
        }
        return (int)rtn;
    }

    public long getRemainingTotalLBA(int iCount) {
        long remTotalLBA = this.getRemainingTotalLBA();
        long rtn = remTotalLBA / (long)iCount;
        if (rtn > this.getLdevMaxSize() || remTotalLBA == -1L) {
            rtn = this.getLdevMaxSize();
        }
        return rtn;
    }

    private long getRemainingTotalLBA() {
        long rtn = -1L;
        if (this.getMaxSubscription() != 65535) {
            long wkTotalRemaining = this.getPoolPages() * (long)this.getMaxSubscription() / 100L;
            long wkRemaining = wkTotalRemaining - this.getAouUsed() - this.getAddVolPages();
            rtn = wkRemaining * this.getPageSize();
            rtn *= 2L;
        }
        return rtn;
    }

    public long getRemainingTotalLBA_Expand(List LDEVList) {
        long remTotalLBA = this.getRemainingTotalExpandLBA(LDEVList);
        long rtn = remTotalLBA / (long)LDEVList.size();
        long remTotalKB = rtn / 2L;
        long remTotalPage = remTotalKB / this.getPageSize();
        if ((rtn = remTotalPage * this.getPageSize() * 2L) > this.getLdevMaxSize() || remTotalLBA == -1L) {
            rtn = this.getLdevMaxSize();
        }
        return rtn;
    }

    private long getRemainingTotalExpandLBA(List LDEVList) {
        long rtn = -1L;
        if (this.getMaxSubscription() != 65535) {
            long wkTotalRemaining = this.getPoolPages() * (long)this.getMaxSubscription() / 100L;
            long wkRemaining = wkTotalRemaining - this.getAouUsed() + this.getAddVolPages(LDEVList);
            rtn = wkRemaining * this.getPageSize();
            rtn *= 2L;
        }
        return rtn;
    }

    private long getAddVolPages(List LDEVList) {
        long rtn = 0L;
        for (int i = 0; i < LDEVList.size(); ++i) {
            SJctrLDEVDetail wkLdev = (SJctrLDEVDetail)LDEVList.get(i);
            long wkSizeKB = wkLdev.getLTotalLBA() / 2L;
            long lPage = wkSizeKB / this.getPageSize();
            if (wkSizeKB % this.getPageSize() > 0L) {
                ++lPage;
            }
            rtn += lPage;
        }
        return rtn;
    }

    public long getAddVolPages() {
        long rtn = 0L;
        for (int i = 0; i < this.addLDEV.size(); ++i) {
            SJctrLDEVDetail wkLdev = (SJctrLDEVDetail)this.addLDEV.get(i);
            long wkSizeKB = wkLdev.getLTotalLBA() / 2L;
            long lPage = wkSizeKB / this.getPageSize();
            if (wkSizeKB % this.getPageSize() > 0L) {
                ++lPage;
            }
            rtn += lPage;
        }
        return rtn;
    }

    public boolean isBasic() {
        boolean rtn = true;
        if (this.getRaidLevel() == 8) {
            rtn = false;
        }
        if (this.getSExternalMixCompatible() == 1) {
            rtn = true;
        }
        return rtn;
    }

    public boolean isPbTSM() {
        boolean rtn = false;
        if ((this.getITierControlInfo() & 0x80) != 0) {
            rtn = true;
        }
        return rtn;
    }

    public boolean isHrt() {
        boolean rtn = false;
        if ((this.getITierControlInfo() & 0x10) != 0) {
            rtn = true;
        }
        return rtn;
    }

    public long getLdevMaxSize() {
        long rtn = 0L;
        rtn = this.isOpen() ? 549785403392L : 459916800L;
        return rtn;
    }

    public String getEmuTypeName() {
        String rtn = "";
        rtn = this.isOpen() ? "OPEN-V" : "3390-A";
        return rtn;
    }

    public boolean isOpen() {
        boolean rtn = false;
        if (this.getEmulationType() == 0) {
            rtn = true;
        }
        return rtn;
    }

    public long getMinSize() {
        long rtn = 0L;
        rtn = this.isOpen() ? 96000L : 1740L;
        return rtn;
    }

    public long getPoolLBA() {
        return super.getPoolPages() * super.getPageSize() * 2L;
    }

    public long getPoolUsedLBA() {
        return (super.getPoolUsedPages() + super.getLPoolReservedPages()) * super.getPageSize() * 2L;
    }

    public boolean isDmAttri() {
        boolean rtn = false;
        if ((super.getLPoolOptionFlag() & 0x20000000L) > 0L) {
            rtn = true;
        }
        return rtn;
    }

    public void setFptList(ArrayList fptList) {
        this.fptList = fptList;
    }

    public long getFptVolPages() {
        long rtn = 0L;
        for (int i = 0; i < this.fptList.size(); ++i) {
            SJctrLDEVDetail wkLdev = (SJctrLDEVDetail)this.fptList.get(i);
            long wkSizeKB = wkLdev.getLTotalLBA() / 2L;
            long lPage = wkSizeKB / this.getPageSize();
            if (wkSizeKB % this.getPageSize() > 0L) {
                ++lPage;
            }
            rtn += lPage;
        }
        return rtn;
    }

    public long getFptVolSize() {
        return this.getFptVolPages() * this.getPageSize() * 2L;
    }

    public ArrayList getFptList() {
        return this.fptList;
    }

    public void setPoolVolDetail(SJmoPoolVolDetail PoolVolDetail) {
        this.PoolVolDetail = PoolVolDetail;
    }

    public SJmoPoolVolDetail getPoolVolDetail() {
        return this.PoolVolDetail;
    }
}

