/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.addcomm.SJctrAddCommunityDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.addmanager.SJctrAddManagerDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.addtrap.SJctrAddSNMPTrapDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.changecomm.SJctrChangeCommunityDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.chgtrap.SJctrChangeSNMPTrapsDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrSNMPDialogData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPManagersTableModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsContactModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsExtensionSNMPModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsLocationModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsManagersModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPSettingsStorageSystemNameModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPTableRowData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPTrapSettingsModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPTrapSettingsTableModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SjctrSNMPSettingsTestTrapButtonModel;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.sn2.controller.wizard.tabmanage.sub.SJctrTabManageSubDC;

public class SJctrSNMPSettingsSubDC
extends SJctrTabManageSubDC
implements SJctrEditAlertDef {
    private static final int SINGLE_ROW = 1;
    private boolean isManagersEdited = false;
    private boolean isTrapEdited = false;
    private SJctrCheckBoxDataModel editFlg;
    private SJctrSNMPSettingsExtensionSNMPModel extSNMP;
    private SJctrSNMPSettingsStorageSystemNameModel sysName;
    private SJctrSNMPSettingsContactModel contact;
    private SJctrSNMPSettingsLocationModel location;
    private SJctrSNMPTrapSettingsModel trapModel;
    private SJctrSNMPSettingsManagersModel managerModel;
    private SjctrSNMPSettingsTestTrapButtonModel testBtn;

    public SJctrSNMPSettingsSubDC(SJctrTabManageDataController managerDC) throws SJcException {
        super(managerDC);
    }

    @Override
    public String getTabName() {
        return this.getOwner().getComUtility().getGuidance("SNMP");
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.PUSH_MANAGER_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isManagersEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionAddManager();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.PUSH_MANAGER_DEL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isManagersEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionDeleteManager();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_TRAP_ADD_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionAddSNMPTraps();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_TRAP_CHG_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionChangeSNMPTraps();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_TRAP_DEL_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionDeleteSNMPTraps();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_COMMUNITY_ADD_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionAddCommunity();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_COMMUNITY_CHG_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionChangeCommunity();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.SELECT_COMMUNITY_DEL_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.isTrapEdited = true;
                SJctrSNMPSettingsSubDC.this.doActionDeleteCommunity();
            }
        });
        this.addMessageEventListener(NOTIFY_SNMP_SETTINGS.PUSH_TEST_TRAP, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSNMPSettingsSubDC.this.doActionSendTestTrap();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrSNMPSettingsData data = this.getSNMPSettingsData();
        this.extSNMP.updateDataModel();
        this.extSNMP.setSelectedRadioButton(data.getExtensionSNMP());
        this.sysName.updateDataModel();
        this.sysName.setSysnameText(data.getStorageSystemName());
        this.contact.updateDataModel();
        this.contact.setContactText(data.getContact());
        this.location.updateDataModel();
        this.location.setLocationText(data.getLocation());
        this.trapModel.updateDataModel();
        boolean isAllowed = this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(33);
        if (!isAllowed) {
            this.extSNMP.setEnableAll(false);
            this.sysName.setEnableAll(false);
            this.contact.setEnableAll(false);
            this.location.setEnableAll(false);
            this.trapModel.setEnableAll(false);
            this.managerModel.setEnableAll(false);
            this.testBtn.setEnableAll(false);
        }
        return true;
    }

    @Override
    public void createInheritedData(SJctrMultiInheritedData data) {
        List<?> list = this.getCache(KEY_CLASS_SNMP_SETTINGS);
        SJctrSNMPSettingsData settingData = (SJctrSNMPSettingsData)list.get(0);
        SJctrSNMPSettingsExtensionSNMPModel extensionModel = (SJctrSNMPSettingsExtensionSNMPModel)this.getDataObjectModel("COM_EXTENSION_SNMP");
        settingData.setExtensionSNMP(extensionModel.getSelectedRadioButton());
        SJctrSNMPSettingsStorageSystemNameModel systemName = (SJctrSNMPSettingsStorageSystemNameModel)this.getDataObjectModel("COM_SYSNAME");
        settingData.setStorageSystemName(systemName.getSysnameText());
        SJctrSNMPSettingsContactModel contact = (SJctrSNMPSettingsContactModel)this.getDataObjectModel("COM_CONTACT");
        settingData.setContact(contact.getContactText());
        SJctrSNMPSettingsLocationModel location = (SJctrSNMPSettingsLocationModel)this.getDataObjectModel("COM_SNMP_LOCATION");
        settingData.setLocation(location.getLocationText());
        SJctrCheckBoxDataModel isSNMPEdited = (SJctrCheckBoxDataModel)this.getDataObjectModel("COM_SNMP_EDITED");
        settingData.setSNMPEdited(isSNMPEdited.isSelect());
        settingData.setManagersEdited(this.isManagersEdited);
        settingData.setTrapEdited(this.isTrapEdited);
        data.putInheritedData(KEY_CLASS_SNMP_SETTINGS, list);
    }

    private SJctrSNMPSettingsData getSNMPSettingsData() {
        SJctrSNMPSettingsData data = new SJctrSNMPSettingsData(SJctrEditAlertUtility.getIPSecurityInfo());
        ArrayList<SJctrSNMPSettingsData> array = new ArrayList<SJctrSNMPSettingsData>();
        array.add(data);
        this.putCache(KEY_CLASS_SNMP_SETTINGS, array);
        return data;
    }

    @Override
    public boolean checkEndData() {
        boolean isCorrect = true;
        SJctrSNMPSettingsStorageSystemNameModel systemName = (SJctrSNMPSettingsStorageSystemNameModel)this.getDataObjectModel("COM_SYSNAME");
        isCorrect &= systemName.chkData();
        SJctrSNMPSettingsContactModel contact = (SJctrSNMPSettingsContactModel)this.getDataObjectModel("COM_CONTACT");
        isCorrect &= contact.chkData();
        SJctrSNMPSettingsLocationModel location = (SJctrSNMPSettingsLocationModel)this.getDataObjectModel("COM_SNMP_LOCATION");
        return isCorrect &= location.chkData();
    }

    @Override
    public Map<String, SJctrDataObjectModel<?>> getDataObjects() {
        LinkedHashMap map = new LinkedHashMap();
        this.editFlg = new SJctrCheckBoxDataModel();
        map.put("COM_SNMP_EDITED", this.editFlg);
        this.extSNMP = new SJctrSNMPSettingsExtensionSNMPModel();
        map.put("COM_EXTENSION_SNMP", this.extSNMP);
        this.sysName = new SJctrSNMPSettingsStorageSystemNameModel();
        map.put("COM_SYSNAME", this.sysName);
        this.contact = new SJctrSNMPSettingsContactModel();
        map.put("COM_CONTACT", this.contact);
        this.location = new SJctrSNMPSettingsLocationModel();
        map.put("COM_SNMP_LOCATION", this.location);
        this.trapModel = new SJctrSNMPTrapSettingsModel();
        map.put("COM_TRAP_TABLE", this.trapModel);
        this.managerModel = new SJctrSNMPSettingsManagersModel();
        map.put("COM_MGR_TABLE", this.managerModel);
        this.testBtn = new SjctrSNMPSettingsTestTrapButtonModel();
        map.put("COM_SNMP_TEST", this.testBtn);
        return map;
    }

    public void doActionAddManager() {
        SJctrSNMPManagersTableModel managersTableModel = ((SJctrSNMPSettingsManagersModel)this.getDataObjectModel("COM_MGR_TABLE")).getTable();
        if (managersTableModel.getRowCount() == 32) {
            SJctrEditAlertUtility.errorMsg(3, 22, 205031);
        }
        SJctrSNMPDialogData dialogData = this.getSNMPDialogData(null);
        this.openSNMPDialog(SJctrAddManagerDialogDC.class, dialogData);
    }

    public void doActionDeleteManager() {
        SJctrSNMPManagersTableModel managersTableModel = ((SJctrSNMPSettingsManagersModel)this.getDataObjectModel("COM_MGR_TABLE")).getTable();
        List<?> dataList = this.getCache(KEY_CLASS_SNMP_SETTINGS);
        SJctrSNMPSettingsData snmpData = (SJctrSNMPSettingsData)this.getCache(KEY_CLASS_SNMP_SETTINGS).get(0);
        Map<String, Integer> managers = snmpData.getManagersData();
        for (Object obj : managersTableModel.getSelectedRowData()) {
            SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)obj;
            managers.remove(row.getIP());
        }
        this.putCache(KEY_CLASS_SNMP_SETTINGS, dataList);
        managersTableModel.doRefresh();
    }

    public void doActionAddSNMPTraps() {
        SJctrSNMPDialogData dialogData = this.getSNMPDialogData(null);
        this.openSNMPDialog(SJctrAddSNMPTrapDialogDC.class, dialogData);
    }

    public void doActionChangeSNMPTraps() {
        SJctrSNMPTrapSettingsTableModel trapTableModel = ((SJctrSNMPTrapSettingsModel)this.getDataObjectModel("COM_TRAP_TABLE")).getTable();
        List<Object> selectedList = trapTableModel.getSelectedRowData();
        SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)selectedList.get(0);
        String preAddr = row.getIP();
        String preComm = row.getCommunity();
        boolean isMultiAddr = false;
        boolean isMultiComm = false;
        for (Object obj : selectedList) {
            row = (SJctrSNMPTableRowData)obj;
            String addr = row.getIP();
            String comm = row.getCommunity();
            if ("-".equals(addr)) {
                preAddr = addr;
            }
            isMultiAddr |= !preAddr.equals(addr);
            isMultiComm |= !preComm.equals(comm);
        }
        if (isMultiAddr && isMultiComm) {
            SJctrEditAlertUtility.errorMsg(3, 22, 205029);
            return;
        }
        SJctrSNMPDialogData dialogData = this.getSNMPDialogData(selectedList);
        if (selectedList.size() == 1) {
            dialogData.setSelectedType(SJctrSNMPDialogData.SELECTED_ROWS_TYPE.SINGLE);
        } else if (isMultiAddr) {
            dialogData.setSelectedType(SJctrSNMPDialogData.SELECTED_ROWS_TYPE.MULTI_ADDRESS);
        } else {
            dialogData.setSelectedType(SJctrSNMPDialogData.SELECTED_ROWS_TYPE.MULTI_COMMUNITY);
        }
        this.openSNMPDialog(SJctrChangeSNMPTrapsDialogDC.class, dialogData);
    }

    public void doActionDeleteSNMPTraps() {
        SJctrSNMPTrapSettingsTableModel trapTableModel = ((SJctrSNMPTrapSettingsModel)this.getDataObjectModel("COM_TRAP_TABLE")).getTable();
        List<?> dataList = this.getCache(KEY_CLASS_SNMP_SETTINGS);
        SJctrSNMPSettingsData snmpData = (SJctrSNMPSettingsData)this.getCache(KEY_CLASS_SNMP_SETTINGS).get(0);
        Map<String, Map<String, Integer>> trapData = snmpData.getTrapTableData();
        for (Object obj : trapTableModel.getSelectedRowData()) {
            SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)obj;
            Map<String, Integer> addrMap = trapData.get(row.getCommunity());
            addrMap.remove(row.getIP());
        }
        this.putCache(KEY_CLASS_SNMP_SETTINGS, dataList);
        trapTableModel.doRefresh();
    }

    public void doActionAddCommunity() {
        SJctrSNMPSettingsData data = (SJctrSNMPSettingsData)this.getCache(KEY_CLASS_SNMP_SETTINGS).get(0);
        if (data.getTrapTableData().size() == 32) {
            SJctrEditAlertUtility.errorMsg(3, 22, 205025);
        }
        SJctrSNMPDialogData dialogData = this.getSNMPDialogData(null);
        this.openSNMPDialog(SJctrAddCommunityDialogDC.class, dialogData);
    }

    public void doActionChangeCommunity() {
        SJctrSNMPTrapSettingsTableModel trapTableModel = ((SJctrSNMPTrapSettingsModel)this.getDataObjectModel("COM_TRAP_TABLE")).getTable();
        SJctrSNMPDialogData dialogData = this.getSNMPDialogData(trapTableModel.getSelectedRowData());
        this.openSNMPDialog(SJctrChangeCommunityDialogDC.class, dialogData);
    }

    public void doActionDeleteCommunity() {
        SJctrSNMPTrapSettingsTableModel trapTableModel = ((SJctrSNMPTrapSettingsModel)this.getDataObjectModel("COM_TRAP_TABLE")).getTable();
        List<?> dataList = this.getCache(KEY_CLASS_SNMP_SETTINGS);
        SJctrSNMPSettingsData snmpData = (SJctrSNMPSettingsData)this.getCache(KEY_CLASS_SNMP_SETTINGS).get(0);
        Map<String, Map<String, Integer>> trapData = snmpData.getTrapTableData();
        for (Object obj : trapTableModel.getSelectedRowData()) {
            SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)obj;
            String target = row.getCommunity();
            if (!trapData.containsKey(target)) continue;
            trapData.remove(target);
        }
        this.putCache(KEY_CLASS_SNMP_SETTINGS, dataList);
        trapTableModel.doRefresh();
    }

    public void doActionSendTestTrap() {
        SJctrError err = new SJctrError(3, 22, 209003);
        Exception cause = null;
        try {
            SJctrEditAlertUtility.sendTestTrap();
        }
        catch (Exception e) {
            err = new SJctrError(3, 22, 205040);
            cause = e;
        }
        SJcException exp = err.createException();
        if (cause != null) {
            exp.initCause(cause);
        }
        throw exp;
    }

    @Override
    public void doActionDialogClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Object notifyObj = event.getNofifyObject();
        if (notifyObj instanceof Map) {
            Map map = (Map)notifyObj;
            List dialogDataList = (List)map.get("COM_DIALOG_DATA");
            SJctrSNMPDialogData dialogData = (SJctrSNMPDialogData)dialogDataList.get(0);
            List<?> dataList = this.getCache(KEY_CLASS_SNMP_SETTINGS);
            SJctrSNMPSettingsData snmpData = (SJctrSNMPSettingsData)dataList.get(0);
            snmpData.setManagersData(dialogData.getManagersTableData());
            snmpData.setTrapTableData(dialogData.getTrapTableData());
            this.putCache(KEY_CLASS_SNMP_SETTINGS, dataList);
            ((SJctrSNMPSettingsManagersModel)this.getDataObjectModel("COM_MGR_TABLE")).getTable().doRefresh();
            ((SJctrSNMPTrapSettingsModel)this.getDataObjectModel("COM_TRAP_TABLE")).getTable().doRefresh();
        }
    }

    private void openSNMPDialog(Class<? extends SJctrDialogDataController> dialogClass, SJctrSNMPDialogData dialogData) {
        ArrayList<SJctrSNMPDialogData> list = new ArrayList<SJctrSNMPDialogData>();
        list.add(dialogData);
        HashMap dataMap = new HashMap();
        dataMap.put("COM_DIALOG_DATA", list);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(dialogClass, dataMap);
        this.addUpdateDisp(relatedObj);
    }

    private SJctrSNMPDialogData getSNMPDialogData(List<Object> selectedList) {
        SJctrSNMPDialogData data = new SJctrSNMPDialogData();
        SJctrSNMPSettingsData snmpData = (SJctrSNMPSettingsData)this.getCache(KEY_CLASS_SNMP_SETTINGS).get(0);
        data.setManagersTableData(snmpData.getManagersData());
        data.setTrapTableData(snmpData.getTrapTableData());
        data.setSelectedList(selectedList);
        return data;
    }

    public static enum NOTIFY_SNMP_SETTINGS implements SJctrNotifyState
    {
        PUSH_MANAGER_ADD,
        PUSH_MANAGER_DEL,
        SELECT_TRAP_ADD_MENU,
        SELECT_TRAP_CHG_MENU,
        SELECT_TRAP_DEL_MENU,
        SELECT_COMMUNITY_ADD_MENU,
        SELECT_COMMUNITY_CHG_MENU,
        SELECT_COMMUNITY_DEL_MENU,
        PUSH_TEST_TRAP;

    }
}

