/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.addtrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrAddTrapCommunityModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrAddTrapIPAddressModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrSNMPDialogData;

public class SJctrAddSNMPTrapDialogDC
extends SJctrDialogDataController
implements SJctrEditAlertDef {
    private SJctrAddTrapIPAddressModel trap;
    private SJctrAddTrapCommunityModel community;
    private SJctrButtonDataModel dummyButton;

    public SJctrAddSNMPTrapDialogDC() throws SJcException {
        super(33595512);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.trap = new SJctrAddTrapIPAddressModel();
        this.addDataObjectModel("COM_TRAP_IP", this.trap);
        this.community = new SJctrAddTrapCommunityModel();
        this.addDataObjectModel("COM_COMMUNITY", this.community);
        this.dummyButton = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_DUMMY_BTN", this.dummyButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.dummyButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddSNMPTrapDialogDC.this.fireMessageEvent(NOTIFY_ADD_SNMP_TRAP.UPDATE_IP_COMBO);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_ADD_SNMP_TRAP.UPDATE_IP_COMBO, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddSNMPTrapDialogDC.this.doActionUpdataTrapCombo();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        SJctrSNMPDialogData dialogData = this.getDialogData();
        dialogData.getTrapTableData();
        ArrayList<String> communityList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, Integer>> entry : dialogData.getTrapTableData().entrySet()) {
            communityList.add(entry.getKey());
        }
        this.community.updateComboList(communityList);
        this.trap.updateDataModel();
        this.updateTrapCombo();
        return true;
    }

    @Override
    public boolean checkEndData() {
        this.trap.chkData();
        this.community.chkData();
        this.checkConflict();
        return true;
    }

    @Override
    public String getDispName() {
        return this.getOwner().getComUtility().getGuidance("ADD_SNMP_TRAP");
    }

    private void doActionUpdataTrapCombo() {
        this.updateTrapCombo();
        this.trap.setDirtyAll();
    }

    private void updateTrapCombo() {
        int addrType = this.trap.getAddressType();
        SJctrSNMPDialogData dialogData = this.getDialogData();
        Map<String, Map<String, Integer>> trapTableData = dialogData.getTrapTableData();
        Map<String, Integer> managerTableData = dialogData.getManagersTableData();
        ArrayList<String> tmpAddressList = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : managerTableData.entrySet()) {
            String addr = entry.getKey();
            if (addrType != managerTableData.get(addr)) continue;
            tmpAddressList.add(addr);
        }
        String currentCom = this.community.getCommunityText();
        Map<Object, Object> addrMap = trapTableData.containsKey(currentCom) ? trapTableData.get(currentCom) : new HashMap();
        ArrayList<String> addressList = new ArrayList<String>();
        for (String addr : tmpAddressList) {
            if (addrMap.containsKey(addr)) continue;
            addressList.add(addr);
        }
        this.trap.updateComboList(addressList);
    }

    private boolean checkConflict() {
        SJctrAddTrapIPAddressModel addressModel = (SJctrAddTrapIPAddressModel)this.getDataObjectModel("COM_TRAP_IP");
        String addrText = addressModel.getAddressText();
        int addrType = addressModel.getAddressType();
        String community = ((SJctrAddTrapCommunityModel)this.getDataObjectModel("COM_COMMUNITY")).getCommunityText();
        SJctrSNMPDialogData dialogData = this.getDialogData();
        Map<String, Map<String, Integer>> trapTableData = dialogData.getTrapTableData();
        addrText = dialogData.getRegularAddr(addrText, addrType);
        if (trapTableData.containsKey(community)) {
            Map<String, Integer> addrMap = trapTableData.get(community);
            if (addrMap.size() == 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205028);
            }
            if (!dialogData.checkAddressConflict(addrText, addrType, addrMap)) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205026);
            }
            addrMap.put(addrText, addrType);
        } else {
            if (trapTableData.size() == 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205025);
            }
            HashMap<String, Integer> ipMap = new HashMap<String, Integer>();
            ipMap.put(addrText, addrType);
            trapTableData.put(community, ipMap);
        }
        return true;
    }

    private SJctrSNMPDialogData getDialogData() {
        List<?> dataList = this.getCache("COM_DIALOG_DATA");
        return (SJctrSNMPDialogData)dataList.get(0);
    }

    public static enum NOTIFY_ADD_SNMP_TRAP implements SJctrNotifyState
    {
        UPDATE_IP_COMBO;

    }
}

