/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.data.SetSysLog;
import sanproject.serverux.data.SysLogServSet;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlMultiStratumFormElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogDef;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrEditAuditSyslogSettingData;

public class SJctrEditAuditSyslogAuditLog
implements Serializable,
SJctrGuidIdDefinition,
SJctrEditAuditLogDef {
    private static final long serialVersionUID = 1L;
    static final String FUNCTION_NAME = "ADT_FC_ADTSET";
    public static String[][] KeyTable_BasicInfo = new String[][]{{"COMMON", "ADT_SET_SYSLOG_SERVER"}, {"COMMON", "ADT_NUM_OF_SERVERS"}};
    public static String[][] KeyTable_DtlInfo_Common = new String[][]{{"COMMON", "TRANSFER_PROTOCOL"}, {"COMMON", "LOCATION_IDNTF_NAME"}, {"COMMON", "OUTPUT_DETAIL_INFO"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}, {"COMMON", "PRIMARY_SERVER"}, {"COMMON", "SECONDARY_SERVER"}};
    public static String[][] KeyTable_DtlInfo_Server = new String[][]{{"COMMON", "ADT_SERVER_TYPE"}, {"COMMON", "ADT_OUT_FLAG"}, {"COMMON", "ADT_IP_VERSION"}, {"COMMON", "IP_ADDRESS"}, {"COMMON", "PORT_NUMBER"}, {"COMMON", "CLIENT_CRT_FILE_NAME"}, {"COMMON", "ROOT_CRT_FILE_NAME"}};
    public static String[][] AdtGuideKeyTable = new String[][]{{"COMMON", "ENABLE"}, {"COMMON", "DISABLE"}, {"COMMON", "ADT_UDP"}, {"COMMON", "ADT_TLS_1_2"}, {"COMMON", "PRIMARY"}, {"COMMON", "SECONDARY"}, {"COMMON", "IPV4"}, {"COMMON", "IPV6"}};
    private static final int INDEX_DISPID = 0;
    private static final int INDEX_PARTSID = 1;
    private Map<String, String> TitleEnGuideMap = null;
    private Map<String, String> DataEnGuideMap = null;
    HashMap<String, String> addition = null;
    private List<String> commonInfo = new ArrayList<String>();
    private String headServer = "";
    private String detailServer = "";
    private String footer = "";
    private boolean flgChangePrimary;
    private boolean flgChangeSecondary;
    private int numOfServers;

    public SJctrEditAuditSyslogAuditLog() {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleEnGuideMap = new HashMap<String, String>();
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_BasicInfo));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Common));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Server));
        this.DataEnGuideMap = new HashMap<String, String>();
        this.DataEnGuideMap = guidance.getGuidance(AdtGuideKeyTable);
        this.addition = new HashMap();
        this.flgChangePrimary = false;
        this.flgChangeSecondary = false;
        this.numOfServers = 0;
    }

    public void setAdditionData(SJbaseUserSession userSession) {
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    public SJcAuditLogCtrlMultiStratumFormElemCon createElemCon() {
        SJcAuditLogCtrlMultiStratumFormElemCon elemCon = new SJcAuditLogCtrlMultiStratumFormElemCon();
        elemCon.setFunctionName(FUNCTION_NAME);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_SET_SYSLOG_SERVER");
        String opeName = this.TitleEnGuideMap.get(key);
        elemCon.setOperationName(opeName);
        elemCon.setOperationParameter("");
        elemCon.setAdditionalInfo(this.addition);
        for (String log : this.commonInfo) {
            elemCon.setLog(log);
            elemCon.addStratum();
        }
        if (this.flgChangePrimary || this.flgChangeSecondary) {
            elemCon.setLog(this.headServer);
            elemCon.setLog(this.detailServer);
            elemCon.setLog(this.footer);
        }
        return elemCon;
    }

    public void setPrintData(SJctrEditAuditSyslogSettingData syslogData) {
        this.setCommonInfo(syslogData);
        this.setServerHeader();
        this.setServerInfo(syslogData);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_NUM_OF_SERVERS");
        this.footer = "," + this.TitleEnGuideMap.get(key) + "=" + this.numOfServers;
    }

    private void setServerInfo(SJctrEditAuditSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        String primary = this.getPrimaryServerLog(syslogData);
        if (this.flgChangePrimary) {
            buf.append(primary);
            ++this.numOfServers;
        }
        String secondary = this.getSecondaryServerLog(syslogData);
        if (this.flgChangeSecondary) {
            if (this.flgChangePrimary) {
                buf.append(",");
            }
            buf.append(secondary);
            ++this.numOfServers;
        }
        buf.append("]");
        this.detailServer = buf.toString();
    }

    private boolean getServerSettingInfo(SysLogServSet srvSet, StringBuffer buf) {
        String key;
        boolean changeFlg = false;
        if (srvSet.B_On_change) {
            key = srvSet.B_On ? SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE") : SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            buf.append(this.DataEnGuideMap.get(key));
            changeFlg = true;
        }
        buf.append(",");
        if (srvSet.B_IPv6_change) {
            key = srvSet.B_IPv6 ? SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV6") : SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV4");
            buf.append(this.DataEnGuideMap.get(key));
            changeFlg = true;
        }
        buf.append(",");
        if (srvSet.B_IP_Add_change) {
            buf.append(srvSet.strIPAddrStr);
            changeFlg = true;
        }
        buf.append(",");
        if (srvSet.B_Port_change) {
            buf.append(srvSet.I_Port);
            changeFlg = true;
        }
        buf.append(",");
        return changeFlg;
    }

    private String getPrimaryServerLog(SJctrEditAuditSyslogSettingData syslogData) {
        SetSysLog applyData = syslogData.getAppliedData();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "PRIMARY");
        String serverType = this.DataEnGuideMap.get(key);
        buf.append(serverType);
        buf.append(",");
        SysLogServSet srvSet = applyData.syslogservset[0];
        this.flgChangePrimary = this.getServerSettingInfo(srvSet, buf);
        if (syslogData.isUploadedClientPrimary()) {
            buf.append(syslogData.getClientFilePrimary());
            this.flgChangePrimary = true;
        }
        buf.append(",");
        if (syslogData.isUploadedRootPrimary()) {
            buf.append(syslogData.getRootFilePrimary());
            this.flgChangePrimary = true;
        }
        buf.append("}");
        return buf.toString();
    }

    private String getSecondaryServerLog(SJctrEditAuditSyslogSettingData syslogData) {
        SetSysLog applyData = syslogData.getAppliedData();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "SECONDARY");
        String serverType = this.DataEnGuideMap.get(key);
        buf.append(serverType);
        buf.append(",");
        SysLogServSet srvSet = applyData.syslogservset[1];
        this.flgChangeSecondary = this.getServerSettingInfo(srvSet, buf);
        if (syslogData.isUploadedClientSecondary()) {
            buf.append(syslogData.getClientFileSecondary());
            this.flgChangeSecondary = true;
        }
        buf.append(",");
        if (syslogData.isUploadedRootSecondary()) {
            buf.append(syslogData.getRootFileSecondary());
            this.flgChangeSecondary = true;
        }
        buf.append("}");
        return buf.toString();
    }

    private void setServerHeader() {
        StringBuffer bufHeader = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_Server.length; ++index) {
            String key = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_Server[index][0], KeyTable_DtlInfo_Server[index][1]);
            bufHeader.append(this.TitleEnGuideMap.get(key));
            if (index == KeyTable_DtlInfo_Server.length - 1) break;
            bufHeader.append(",");
        }
        this.headServer = "{" + bufHeader.toString() + "}" + "=" + "\n";
    }

    private void setCommonInfo(SJctrEditAuditSyslogSettingData syslogData) {
        String key;
        StringBuffer buf;
        SetSysLog applyData = syslogData.getAppliedData();
        if (applyData.B_TransportType_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "TRANSFER_PROTOCOL");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            if (applyData.sTransportType == 2) {
                key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_TLS_1_2");
                buf.append(this.DataEnGuideMap.get(key));
            } else if (applyData.sTransportType == 1) {
                key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_UDP");
                buf.append(this.DataEnGuideMap.get(key));
            }
            this.commonInfo.add(buf.toString());
        }
        if (applyData.B_Location_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LOCATION_IDNTF_NAME");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            buf.append(applyData.S_Location);
            this.commonInfo.add(buf.toString());
        }
        if (applyData.B_Detail_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "OUTPUT_DETAIL_INFO");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            key = applyData.B_Detail ? SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE") : SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            buf.append(this.DataEnGuideMap.get(key));
            this.commonInfo.add(buf.toString());
        }
        if (applyData.B_Timeout_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "TIMEOUT");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            buf.append(applyData.sTimeout);
            this.commonInfo.add(buf.toString());
        }
        if (applyData.B_RetryInterval_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "RETRY_INTERVAL");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            buf.append(applyData.sRetryInterval);
            this.commonInfo.add(buf.toString());
        }
        if (applyData.B_Retry_change) {
            buf = new StringBuffer();
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "RETRY_TIMES");
            buf.append(this.TitleEnGuideMap.get(key));
            buf.append("=");
            buf.append(applyData.sRetry);
            this.commonInfo.add(buf.toString());
        }
    }
}

