/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.createkeys;

import java.util.List;
import java.util.Set;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysAC;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysConfirmDC;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysDC;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysOnServerAuditLog;
import sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys.SJctrAutoBackupKeysToServerAC;
import sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys.SJctrAutoDeleteBackupServerAuditLog;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrCreateKeysSubWizard
extends SJctrSubWizard
implements SJctrEncryptionKeyDef {
    private boolean bFinish = false;

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{KEY_CLASS_CREATEKEY_DC};
        return clsList;
    }

    @Override
    public Class<?> getConfirmClass() {
        return SJctrCreateKeysConfirmDC.class;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "CREATEKEY");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        return super.getModelDirect();
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrRelatedDispDataObject createKeysDO;
        SJctrUserController uc = wizard.getOwner();
        SJctrCreateKeysDC createKeysDC = (SJctrCreateKeysDC)uc.getDataController(createKeysDO = uc.getRelatedDispData(KEY_CLASS_CREATEKEY_DC));
        if (createKeysDC == null) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        List<?> lstNo = createKeysDC.getCache(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo subInfo_No = (SJmoSubsystemInfo)lstNo.get(0);
        String strNo = subInfo_No.getDKCSNAddString();
        int keyNum = 0;
        List<?> encryptionKeys = createKeysDC.getProxy().getCache("KEY_CREATE_KEYS");
        if (encryptionKeys != null && !encryptionKeys.isEmpty()) {
            String strKeyNum = (String)encryptionKeys.get(0);
            keyNum = Integer.parseInt(strKeyNum);
        }
        SJctrCreateKeysAC ac = new SJctrCreateKeysAC(strNo, keyNum);
        ac.setApplyList(encryptionKeys);
        SJbaseUserSession userSession = (SJbaseUserSession)uc.getUserSession();
        SJctrCreateKeysOnServerAuditLog adtLog = new SJctrCreateKeysOnServerAuditLog(userSession);
        ac.setAdtLog(adtLog);
        SJctrRelatedDispDataObject related = uc.createRelatedDispData(this.getConfirmClass());
        wizard.addConfirmData(ac, related);
        boolean autoBackupFlg = false;
        List<?> lDescription = createKeysDC.getProxy().getCache("KEY_AUTOBACKUP_DESCRIPTION");
        if (lDescription != null && !lDescription.isEmpty()) {
            autoBackupFlg = true;
            SJkmsBackupInfo backupInfo = (SJkmsBackupInfo)lDescription.get(0);
            SJctrAutoBackupKeysToServerAC autobkAc = SJctrEncryptionKeysUtility.createAutoBackupAC(uc, backupInfo);
            SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog autoBkAdt = new SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog((SJbaseUserSession)uc.getUserSession());
            autobkAc.setBackRestAdtLog(autoBkAdt);
            SJctrAutoDeleteBackupServerAuditLog autoDelAdt = new SJctrAutoDeleteBackupServerAuditLog((SJbaseUserSession)uc.getUserSession());
            autobkAc.setDeleteAdtLog(autoDelAdt);
            wizard.addConfirmData(autobkAc, related);
        }
        SJctrDataController dataCtrl = wizard.getOwner().getDataController(related);
        if (this.bFinish && dataCtrl instanceof SJctrCreateKeysConfirmDC && !autoBackupFlg) {
            ((SJctrCreateKeysConfirmDC)dataCtrl).showWarningMsg();
        }
    }

    private SJcException createErrorTableDialog(List<SJctrErrorColumnData> errorList, SJctrWizardWindowDC wizDc) {
        SJctrDataController parentDc = wizDc.getParentDC();
        SJctrTableDataModel baseTable = (SJctrTableDataModel)parentDc.getDataObjectModel("COM_TABLE");
        SJctrRelatedDispDataObject related = wizDc.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = wizDc.getOwner();
        SJctrErrorDataController errorDc = (SJctrErrorDataController)uc.getDataController(related);
        errorDc.setParameter(baseTable, errorList);
        SJctrError repError = errorDc.getRepresentativeError(errorList, 5);
        SJcException ex = repError.createException();
        ex.setErrDisp(related);
        return ex;
    }

    public void setBFiish(boolean bFinish) {
        this.bFinish = bFinish;
    }
}

