/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.ctrl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrBackupKeysToServerDC
extends SJctrWizardDataController
implements SJctrEncryptionKeyDef {
    public SJctrBackupKeysToServerDC() {
        super(17830801);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrTextBoxDataModel commentText = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_DESCRIPTION", commentText);
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    @Override
    public boolean checkConstructData() {
        List<?> km1_Info = null;
        km1_Info = this.getCache("KEY_SELECT_DISPID");
        if (km1_Info != null) {
            return true;
        }
        List<SJmoEncryptionKeyInfoMgr> keyInfoList = null;
        keyInfoList = this.getCache(SJmoGetEncryptionKeyInfoMgr.class);
        if (keyInfoList == null || keyInfoList.isEmpty()) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkConstructData", "EncryptionKey Null");
            SJctrEncryptionKeysUtility.createErrorDialog(105471);
        }
        SJmoEncryptionKeyInfoMgr keyInfo = (SJmoEncryptionKeyInfoMgr)keyInfoList.get(0);
        ArrayList alEncryptionKeyInfoDEK = keyInfo.getAlEncryptionKeyInfoDEK();
        ArrayList alEncryptionKeyInfoCEK = keyInfo.getAlEncryptionKeyInfoCEK();
        ArrayList alEncryptionKeyInfoKEK = keyInfo.getAlEncryptionKeyInfoKEK();
        SJmoEncryptionKeyGenerationInfo chkPolicy = keyInfo.getGenerationInfo();
        if (chkPolicy.getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(keyInfoList);
        if (alEncryptionKeyInfoDEK.isEmpty() && alEncryptionKeyInfoCEK.isEmpty() && alEncryptionKeyInfoKEK.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "EncryptionKey isEmpty");
            SJctrEncryptionKeysUtility.createErrorDialog(105471);
        }
        if (km1_Info == null && !SJctrEncryptionKeysUtility.kmsServerIsEnabled()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "kmsServer is False");
            SJctrEncryptionKeysUtility.createErrorDialog(105462);
        }
        return true;
    }

    @Override
    public String getDispName() {
        String taskName = this.getComUtility().getGuidance("BACKUP_KEYS_TO_SERVER");
        return taskName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        set.add(this.createModelDirect(KEY_CLASS_SUBSYSTEM_INFO));
        return set;
    }

    public SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        try {
            SJmoGetKind_IF kind = reqClass.newInstance();
            SJmoGetRange_IF range = null;
            List filterList = null;
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return directWrapper;
    }

    @Override
    public boolean checkEndData() {
        boolean rtn = true;
        SJctrTextBoxDataModel textData = null;
        textData = (SJctrTextBoxDataModel)this.getDataObjectModel("COM_DESCRIPTION");
        if (textData == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkEndData", "textData Null");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        String strComment = null;
        strComment = textData.getValue();
        if (strComment != null && strComment.contains("AutoBackup_")) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkEndData", "textData contains \"RegularBackup_\" ");
            SJctrEncryptionKeysUtility.createErrorDialog(206344);
        }
        SJkmsBackupInfo backupInfo = new SJkmsBackupInfo();
        backupInfo.setBackupComment(strComment);
        ArrayList<SJkmsBackupInfo> commentList = new ArrayList<SJkmsBackupInfo>();
        commentList.add(backupInfo);
        this.putCache("COM_DESCRIPTION", commentList);
        this.chkBtn(false);
        return rtn;
    }

    public void chkBtn(boolean bFlg) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel("COM_FOOTER");
        SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(bFlg);
    }
}

