/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.retrybackupkeys;

import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys.SJctrAutoBackupKeysToServerAC;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.kms.common.SJkmsBackupInfo;

public class SJctrRetryBackupKeysToServerAC
extends SJctrAutoBackupKeysToServerAC
implements SJctrEncryptionKeyDef {
    public SJctrRetryBackupKeysToServerAC(String productNum, SJkmsBackupInfo backupInfo) {
        super(productNum, backupInfo);
        this.backupAdtTitle = SJctrEncryptionAuditLogUty.EncryptionOperation.REGULARBACKUPKEYS_TO_SERVER;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        boolean errorFlg = false;
        SJctrError error = null;
        if (!this.backup_Info.getKmipModeFlg()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal Server Type");
            error = new SJctrError(101, 22, 206336);
            this.setError(error);
        }
        if (!this.backup_Info.getBackupUserEnabledFlg()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal User");
            if (error == null) {
                error = new SJctrError(101, 22, 206337);
                this.setError(error);
            }
        }
        if (!this.backup_Info.getUserRole()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal Role");
            if (error == null) {
                error = new SJctrError(101, 22, 206338);
                this.setError(error);
            }
        }
        if (!this.backup_Info.getBackupLisence()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "License Error Encryption License Key");
            if (error == null) {
                error = new SJctrError(101, 22, 206339);
                this.setError(error);
            }
        }
        if (!errorFlg) {
            super.applyStart(supplier);
        } else {
            String taskName = null;
            taskName = super.getTaskName();
            SJkmsBackupInfo backupResult = this.backup_Info;
            backupResult.setUUID("-");
            SJcException preChkError = error.createException();
            SJcAuditLogApplyElemCon elemCon = SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(this.backupAdtTitle, taskName, backupResult, this.backRestAudit, preChkError);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            adtLogger.putLog(elemCon);
        }
    }
}

