/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addtohostgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrPortHGTblKey_PortComparator;
import sanproject.sn2.controller.com.comparator.SJctrWwnComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.addtohostgroups.SJctrAddtoHGConfirmData;
import sanproject.sn2.controller.wizard.lunm.addtohostgroups.SJctrAvailableHGTableModel;
import sanproject.sn2.controller.wizard.lunm.addtohostgroups.SJctrSelectedHGTableModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrAddtoHGDC
extends SJctrWizardDataController {
    public static final String TITLE = "DISP_DI2S_TITLE";
    protected static final int DISP_ID = 0x1100021;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final Class<?> KEY_CLASS_SELECT_WWN = SJmoWwn.class;
    public static final String KEY_TABLE = "COM_TABLE";
    public static int ADDTOHG_ERR1 = 107001;
    public static int ADDTOHG_ERR2 = 105070;
    public static int ADDTOHG_ERR3 = 105070;
    public static int ADDTOHG_ERR4 = 105071;
    public static int ADDTOHG_ERR5 = 105073;
    public static int ADDTOHG_ERR6 = 105072;
    static final SJctrWwnComparator WWN_COMP = new SJctrWwnComparator();
    static final SJctrPortHGTblKey_PortComparator PTHGTBLKEY_PORT_COMP = new SJctrPortHGTblKey_PortComparator();
    List<SJmoWwn> selectWwnList = null;

    public SJctrAddtoHGDC() throws SJcException {
        super(0x1100021);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> targetList = this.getCache(KEY_CLASS_SELECT_WWN);
        if (targetList == null) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (targetList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        for (Object wwnObj : targetList) {
            if (wwnObj instanceof SJmoWwn) continue;
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (ret) {
            this.selectWwnList = targetList;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJcException exp;
        boolean ret = true;
        SJctrError errInfo = null;
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = parentTbl.getSelectedRowData();
        HashSet<String> wwnCheckList = new HashSet<String>(this.selectWwnList.size());
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.selectWwnList.size());
        for (Object selectRow : selectedRowList) {
            SJctrErrorColumnData errData;
            SJctrError err;
            String strWwn;
            Comparable tblKey;
            SJmoWwn wwnInfo = null;
            if (selectRow instanceof SJctrPortHostGroupWwnTableKey) {
                tblKey = (SJctrPortHostGroupWwnTableKey)selectRow;
                wwnInfo = ((SJctrPortHostGroupWwnTableKey)tblKey).getWwnInfo();
                strWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
                if (wwnCheckList.add(strWwn)) continue;
                ret = false;
                err = new SJctrError(10, 22, ADDTOHG_ERR2);
                if (errInfo == null) {
                    errInfo = err;
                }
                errData = new SJctrErrorColumnData(tblKey, err);
                errList.add(errData);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", " Same WWN Selected. (WWN" + strWwn + ")");
                continue;
            }
            tblKey = (SJctrPortWwnTableKey)selectRow;
            wwnInfo = ((SJctrPortWwnTableKey)tblKey).getWwnInfo();
            strWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
            if (wwnCheckList.add(strWwn)) continue;
            ret = false;
            err = new SJctrError(10, 22, ADDTOHG_ERR2);
            if (errInfo == null) {
                errInfo = err;
            }
            errData = new SJctrErrorColumnData(tblKey, err);
            errList.add(errData);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", " Same WWN Selected. (WWN" + strWwn + ")");
        }
        if (ret) {
            HashSet<String> nameCheckList = new HashSet<String>(this.selectWwnList.size());
            for (Object selectRow : selectedRowList) {
                SJctrErrorColumnData errData;
                SJctrError err;
                String strName;
                Comparable tblKey;
                SJmoWwn wwnInfo = null;
                if (selectRow instanceof SJctrPortHostGroupWwnTableKey) {
                    tblKey = (SJctrPortHostGroupWwnTableKey)selectRow;
                    wwnInfo = ((SJctrPortHostGroupWwnTableKey)tblKey).getWwnInfo();
                    strName = wwnInfo.getStrWWNNickName();
                    if (strName.length() == 0 || nameCheckList.add(strName)) continue;
                    ret = false;
                    err = new SJctrError(10, 22, ADDTOHG_ERR3);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    errData = new SJctrErrorColumnData(tblKey, err);
                    errList.add(errData);
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", " Same WWNNickName Selected. (WWNNickName" + strName + ")");
                    continue;
                }
                tblKey = (SJctrPortWwnTableKey)selectRow;
                wwnInfo = ((SJctrPortWwnTableKey)tblKey).getWwnInfo();
                strName = wwnInfo.getStrWWNNickName();
                if (strName.length() == 0 || nameCheckList.add(strName)) continue;
                ret = false;
                err = new SJctrError(10, 22, ADDTOHG_ERR3);
                if (errInfo == null) {
                    errInfo = err;
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", " Same WWNNickName Selected. (WWNNickName" + strName + ")");
                }
                errData = new SJctrErrorColumnData(tblKey, err);
                errList.add(errData);
            }
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        if (ret) {
            ret = false;
            List<?> portAttributeList = this.getCache(SJmoGetPortAttributeInfo.class);
            for (SJmoPortAttributeInfo portAttr : portAttributeList) {
                byte portKind = portAttr.getByPortKind();
                if (portKind != 3 && portKind != 4 && portKind != 9) continue;
                ret = true;
                break;
            }
            if (!ret) {
                this.getLogUty().putlog("checkConstructData", "no Target Port or RCU Target Port");
                SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR4);
                exp = err.createException();
                throw exp;
            }
        }
        ArrayList targetList = new ArrayList();
        this.putCache("KEY_TARGET_HG_INFO", targetList);
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<?> selectedList = this.getCache("KEY_TARGET_HG_INFO");
        if (selectedList == null || selectedList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR5);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache("KEY_TARGET_HG_INFO");
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetailList, targetHg, this);
        return ret;
    }

    public SJctrAddtoHGConfirmData addtoHGData() {
        List<?> selectedList = this.getCache("KEY_TARGET_HG_INFO");
        List<?> portDtl = this.getCache(SJmoGetPortDetail.class);
        List<?> portAttr = this.getCache(SJmoGetPortAttributeInfo.class);
        ArrayList<SJctrPortHostGroupTableKey> selectHGList = new ArrayList<SJctrPortHostGroupTableKey>(selectedList.size());
        ArrayList<SJmoPortDetail> selectPotDtlList = new ArrayList<SJmoPortDetail>(selectedList.size());
        ArrayList<SJmoPortAttributeInfo> selectPotAttrList = new ArrayList<SJmoPortAttributeInfo>(selectedList.size());
        for (Object selectData : selectedList) {
            int attrIndex;
            SJctrPortHostGroupTableKey selectHG = (SJctrPortHostGroupTableKey)selectData;
            SJmoPortHostGroupInfo port = selectHG.getPortHostGroupInfo();
            int dtlIndex = Collections.binarySearch(portDtl, port);
            if (dtlIndex >= 0) {
                selectPotDtlList.add((SJmoPortDetail)portDtl.get(dtlIndex));
            }
            if ((attrIndex = Collections.binarySearch(portAttr, port)) >= 0) {
                selectPotAttrList.add((SJmoPortAttributeInfo)portAttr.get(attrIndex));
            }
            SJctrPortHostGroupTableKey createPortHG = null;
            SJmoHostGroupInfo createHG = null;
            try {
                createHG = (SJmoHostGroupInfo)selectHG.getHostGroupInfo().clone();
            }
            catch (Exception e) {
                this.getLogUty().putlog("createAltPathsData", "SJmoLdevDetail clone fail", e, 20000);
                continue;
            }
            ArrayList orgWwnList = selectHG.getHostGroupInfo().getAlHostGroupWwn();
            ArrayList<SJmoWwn> wwnList = new ArrayList<SJmoWwn>(orgWwnList.size() + this.selectWwnList.size());
            wwnList.addAll(orgWwnList);
            wwnList.addAll(this.selectWwnList);
            createHG.setAlHostGroupWwn(wwnList);
            createPortHG = new SJctrPortHostGroupTableKey(selectHG.getPortHostGroupInfo(), createHG);
            selectHGList.add(createPortHG);
        }
        Collections.sort(selectPotDtlList);
        Collections.sort(selectPotAttrList);
        Collections.sort(selectHGList);
        SJctrAddtoHGConfirmData confirmData = new SJctrAddtoHGConfirmData();
        confirmData.setPortHGList(selectHGList);
        confirmData.setWwnList(this.selectWwnList);
        confirmData.setPortDetailList(selectPotDtlList);
        confirmData.setPortAttributeList(selectPotAttrList);
        ArrayList<SJctrAddtoHGConfirmData> confirmDataList = new ArrayList<SJctrAddtoHGConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrAddtoHGConfirmData.class, confirmDataList);
        return confirmData;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableHGTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedHGTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddtoHGDC.this.addAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddtoHGDC.this.removeAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_REMOVE, remove);
    }

    private void addAction() {
        SJctrPortHostGroupTableKey addTblData;
        boolean result = true;
        SJctrError errInfo = null;
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> addList = avaliableTable.getSelectedRowData();
        List<Object> selectList = selectedTable.getTargetRowData();
        Collections.sort(addList, PTHGTBLKEY_PORT_COMP);
        Collections.sort(selectList, PTHGTBLKEY_PORT_COMP);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(addList.size());
        block0: for (Object addData : addList) {
            addTblData = (SJctrPortHostGroupTableKey)addData;
            int portCnt = 0;
            for (Object chechData : addList) {
                SJctrPortHostGroupTableKey checkTblData = (SJctrPortHostGroupTableKey)chechData;
                if (addTblData.getPortHostGroupInfo().getSPort() == checkTblData.getPortHostGroupInfo().getSPort()) {
                    ++portCnt;
                }
                if (portCnt < 2) continue;
                result = false;
                SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR6);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrErrorColumnData errData = new SJctrErrorColumnData(addTblData, err);
                errList.add(errData);
                continue block0;
            }
        }
        if (result) {
            for (Object addData : addList) {
                addTblData = (SJctrPortHostGroupTableKey)addData;
                int index = Collections.binarySearch(selectList, addTblData, PTHGTBLKEY_PORT_COMP);
                if (index < 0) continue;
                result = false;
                SJctrError err = new SJctrError(10, 22, ADDTOHG_ERR2);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrErrorColumnData errData = new SJctrErrorColumnData(addTblData, err);
                errList.add(errData);
            }
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(avaliableTable, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        List<Object> list = avaliableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(list);
        List<Object> okList = list;
        List<?> targetList = this.getCache("KEY_TARGET_HG_INFO");
        okList.addAll(targetList);
        Collections.sort(okList);
        this.putCache("KEY_TARGET_HG_INFO", okList);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = selectedTable.removeSelectedRowData();
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        avaliableTable.addRowDataTop(list);
        List<Object> delList = list;
        ArrayList targetList = new ArrayList(this.getCache("KEY_TARGET_HG_INFO"));
        Collections.sort(delList);
        for (int i = delList.size() - 1; i >= 0; --i) {
            SJctrPortHostGroupTableKey key = (SJctrPortHostGroupTableKey)delList.get(i);
            int index = Collections.binarySearch(targetList, key);
            if (index >= 0) {
                targetList.remove(index);
                continue;
            }
            this.logUty.putlog("REMOVE Action", "Not found from cache list: " + key);
        }
        this.putCache("KEY_TARGET_HG_INFO", targetList);
        this.updateFooter();
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    ArrayList<Object> getAvailableTableData() {
        ArrayList<Object> retList = new ArrayList<Object>(256);
        List<?> portHGList = this.getCache(SJmoGetPortHostGroupInfo.class);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        List<?> portAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        for (SJmoPortHostGroupInfo portHGInfo : portHGList) {
            SJmoPortDetail Detail;
            int portIndex;
            SJmoPortAttributeInfo portAttr;
            byte portKind;
            int attrIndex = Collections.binarySearch(portAttrList, portHGInfo);
            if (attrIndex < 0 || (portKind = (portAttr = (SJmoPortAttributeInfo)portAttrList.get(attrIndex)).getByPortKind()) != 3 && portKind != 4 && portKind != 9 || (portIndex = Collections.binarySearch(portDetailList, portHGInfo)) < 0 || SJctrPortUtility.isHnasPort(Detail = (SJmoPortDetail)portDetailList.get(portIndex)) || !this.isAvailablePort(portHGInfo)) continue;
            ArrayList hgList = portHGInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : hgList) {
                hgIndex.setSPort(hgInfo.getSPort());
                hgIndex.setSHostGroup(hgInfo.getSHostGroup());
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) continue;
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(portHGInfo, hgInfo);
                retList.add(tableKey);
            }
        }
        retList.trimToSize();
        return retList;
    }

    boolean isAvailablePort(SJmoPortHostGroupInfo portHG) {
        boolean ret = true;
        ArrayList<SJmoWwn> allWwnList = new ArrayList<SJmoWwn>(SJctrPortUtility.PORT_WWN_MAX);
        ArrayList<String> nickNameList = new ArrayList<String>(SJctrPortUtility.PORT_WWN_MAX);
        ArrayList hgList = portHG.getAlPortHostGroup();
        for (SJmoHostGroupInfo hgInfo : hgList) {
            ArrayList wwnList = hgInfo.getAlHostGroupWwn();
            for (SJmoWwn wwn : wwnList) {
                allWwnList.add(wwn);
                nickNameList.add(wwn.getStrWWNNickName());
            }
        }
        allWwnList.trimToSize();
        Collections.sort(allWwnList, WWN_COMP);
        if (allWwnList.size() + this.selectWwnList.size() > SJctrPortUtility.PORT_WWN_MAX) {
            ret = false;
        }
        if (ret) {
            for (SJmoWwn targetWwn : this.selectWwnList) {
                int wwnIndex = Collections.binarySearch(allWwnList, targetWwn, WWN_COMP);
                if (wwnIndex >= 0) {
                    ret = false;
                    break;
                }
                if (targetWwn.getStrWWNNickName().length() == 0 || !nickNameList.contains(targetWwn.getStrWWNNickName())) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance("LUNM", TITLE);
        return dispName;
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_AVAILABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddtoHGDC.this.getDataObjectModel(SJctrAddtoHGDC.KEY_TABLE_AVAILABLE);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddtoHGDC.this.makeHGProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_SELECTED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddtoHGDC.this.getDataObjectModel(SJctrAddtoHGDC.KEY_TABLE_SELECTED);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddtoHGDC.this.makeHGProperty(selectedRows);
            }
        });
    }

    private void makeHGProperty(List<Object> selectedRowList) {
        if (selectedRowList.size() == 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
            return;
        }
        if (selectedRowList.size() > 1) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRowList.size());
            return;
        }
        SJctrHGPropertySelectData hgProperty = new SJctrHGPropertySelectData();
        SJctrPortHostGroupTableKey tblKeyData = (SJctrPortHostGroupTableKey)selectedRowList.get(0);
        SJmoPortDetail portDtl = this.searchPortDtl(tblKeyData.getPortHostGroupInfo());
        hgProperty.setData(portDtl, tblKeyData.getHostGroupInfo());
        ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
        dialogList.add(hgProperty);
        HashMap map = new HashMap();
        map.put("HG_PROPERTY_SELECT_DATA", dialogList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrHGPropertyDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    SJmoPortDetail searchPortDtl(SJmoPortIndex port) {
        SJmoPortDetail portDtl = null;
        List<?> portDtlList = this.getCache(SJmoGetPortDetail.class);
        int dtlIndex = Collections.binarySearch(portDtlList, port);
        if (dtlIndex >= 0) {
            portDtl = (SJmoPortDetail)portDtlList.get(dtlIndex);
        }
        return portDtl;
    }

    public static enum SELECT_HG_MSG implements SJctrNotifyState
    {
        ADD,
        REMOVE,
        DETAIL_AVAILABLE,
        DETAIL_SELECTED;

    }
}

