/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createhgs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrRsgDataModel;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.modelrc.util.SJmoRscUtilHostGrp;

public class SJctrPortHostGroupWwnData
implements Serializable {
    private final BitSet hgIdSet = new BitSet(SJctrPortUtility.PORT_HOSTGROUP_MAX);
    private final Set<String> hgNameSet = new HashSet<String>(SJctrPortUtility.PORT_HOSTGROUP_MAX / 3 * 4 + 1);
    private final Set<String> wwnStringSet = new HashSet<String>(SJctrPortUtility.PORT_WWN_MAX / 3 * 4 + 1);
    private final Set<String> hostNameSet = new HashSet<String>(SJctrPortUtility.PORT_WWN_MAX / 3 * 4 + 1);

    SJctrPortHostGroupWwnData() {
    }

    boolean addHostGroup(SJmoHostGroupInfo hgInfo) {
        boolean ret = true;
        this.hgIdSet.set(hgInfo.getSHostGroup());
        this.hgNameSet.add(hgInfo.getStrHostgroupNickName());
        for (SJmoWwn oneWwn : hgInfo.getAlHostGroupWwn()) {
            this.wwnStringSet.add(SJctrComUtility.toWWNDisplay(oneWwn));
            if (oneWwn.getStrWWNNickName().length() == 0) continue;
            this.hostNameSet.add(oneWwn.getStrWWNNickName());
        }
        return ret;
    }

    boolean removeHostGroup(SJmoHostGroupInfo hgInfo) {
        boolean ret = true;
        this.hgIdSet.clear(hgInfo.getSHostGroup());
        this.hgNameSet.remove(hgInfo.getStrHostgroupNickName());
        for (SJmoWwn oneWwn : hgInfo.getAlHostGroupWwn()) {
            this.wwnStringSet.remove(SJctrComUtility.toWWNDisplay(oneWwn));
            this.hostNameSet.remove(oneWwn.getStrWWNNickName());
        }
        return ret;
    }

    boolean containsHgName(String hgName) {
        return this.hgNameSet.contains(hgName);
    }

    boolean containsWwn(SJmoWwn wwn) {
        String wwnStr = SJctrComUtility.toWWNDisplay(wwn);
        return this.wwnStringSet.contains(wwnStr) || this.hostNameSet.contains(wwn.getStrWWNNickName());
    }

    short acquireHgId(SJmoRscUtilHostGrp rscutilhg, short sPort, SJctrResourceGroupUtility rsgUtil, SJctrRsgDataModel rsgDataModel) {
        short sHostgr = 0;
        int chkHgId = 3;
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        int rsgConboData = rsgDataModel.getSelectionRsgId();
        boolean anyFlg = rsgConboData != -1;
        boolean loopFlg = false;
        while (!loopFlg && sHostgr < SJctrPortUtility.PORT_HOSTGROUP_MAX) {
            if ((sHostgr = (short)((short)this.hgIdSet.nextClearBit(sHostgr))) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
            hgIndex.setSHostGroup(sHostgr);
            hgIndex.setSPort(sPort);
            int rsgId = rsgUtil.getRsgId(hgIndex);
            loopFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (anyFlg) {
                loopFlg &= rsgId == rsgConboData;
            }
            if (loopFlg &= (chkHgId = rscutilhg.chkHostGrpID(sPort, sHostgr)) == 0) continue;
            sHostgr = (short)(sHostgr + 1);
        }
        return sHostgr;
    }

    List<String> getWwnStringList() {
        ArrayList<String> retList = new ArrayList<String>(this.wwnStringSet.size());
        retList.addAll(this.wwnStringSet);
        return retList;
    }

    List<String> getHostNameList() {
        ArrayList<String> retList = new ArrayList<String>(this.hostNameSet.size());
        retList.addAll(this.hostNameSet);
        return retList;
    }
}

