/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrWwnComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrEditHostData;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrEditHostSelectData;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrHbaWwnDataModel;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrHostNameDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrEditHostDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100121;
    private static final String KEY_HBAWWNINF = "COM_HBAWWNINF";
    private static final String KEY_HOSTNAMEINF = "COM_HOSTNAMEINF";
    private static final String KEY_ALLCHG_WWN = "COM_ALLCHG_WWN";
    private static final String KEY_CHKBOX_ALLCHG_WWN = "DISP_APPLY_SAME_SETTINGS";
    public static final String TITLE = "DISP_DI12S_TITLE";
    List<SJmoPortHostGroupInfo> targetPortHgInfoList = new ArrayList<SJmoPortHostGroupInfo>();
    SJctrHbaWwnDataModel hbaWwnDataModel = null;
    SJctrHostNameDataModel hostNameDataModel = null;
    static final SJctrWwnComparator wwnComparator = new SJctrWwnComparator();
    public static int EDITHOST_ERR1 = 107003;
    public static int EDITHOST_ERR2 = 107003;
    public static int EDITHOST_ERR3 = 106501;
    public static int EDITHOST_ERR4 = 106510;
    public static int EDITHOST_ERR5 = 105075;
    public static int EDITHOST_ERR6 = 105076;
    public static int EDITHOST_ERR7 = 107002;
    public static int EDITHOST_ERR8 = 105297;
    public static int EDITHOST_ERR9 = 107003;
    public static int EDITHOST_ERR10 = 105304;
    public static int EDITHOST_ERR_PORT_ATTR = 105019;
    public static int EDITHOST_ERR_SysRSG_HG = 205164;

    public SJctrEditHostDC() throws SJcException {
        super(0x1100121);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HBAWWNINF, new SJctrHbaWwnDataModel());
        this.addDataObjectModel(KEY_HOSTNAMEINF, new SJctrHostNameDataModel());
        this.addDataObjectModel(KEY_ALLCHG_WWN, new SJctrCheckBoxDataModel("Apply same settings to the HBA WWN in other Ports"));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_WWN);
        checkBox.setLabel(util.getGuidance("LUNM", KEY_CHKBOX_ALLCHG_WWN));
    }

    @Override
    public boolean checkStartData() {
        List<?> dat = this.getCache(SJctrEditHostSelectData.class);
        if (dat == null) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (dat.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        Object selectObj = null;
        selectObj = dat.get(0);
        if (!(selectObj instanceof SJctrEditHostSelectData)) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrEditHostSelectData selectData = null;
        selectData = selectObj;
        SJmoPortHostGroupInfo portHostGroup = selectData.getPortHostGroupInfo();
        if (portHostGroup == null) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList hostGroupList = portHostGroup.getAlPortHostGroup();
        if (hostGroupList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList wwnList = ((SJmoHostGroupInfo)hostGroupList.get(0)).getAlHostGroupWwn();
        if (wwnList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        List<?> dat = this.getCache(SJctrEditHostSelectData.class);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR7);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJctrEditHostSelectData selectData = (SJctrEditHostSelectData)dat.get(0);
        SJmoPortHostGroupInfo selectPortHgInfo = selectData.getPortHostGroupInfo();
        ArrayList selectHgInfoList = selectPortHgInfo.getAlPortHostGroup();
        if (selectHgInfoList.size() != 1) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList selectWwnList = ((SJmoHostGroupInfo)selectHgInfoList.get(0)).getAlHostGroupWwn();
        if (selectWwnList.size() != 1) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        Collections.sort(modelPortDetailList);
        int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortHgInfo);
        if (portDetailIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR3);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> modelPortAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
        Collections.sort(modelPortAttrList);
        int portAttrIndex = Collections.binarySearch(modelPortAttrList, selectPortHgInfo);
        if (portAttrIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR3);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortAttributeInfo seletcPortAttr = (SJmoPortAttributeInfo)modelPortAttrList.get(portAttrIndex);
        byte portKind = seletcPortAttr.getByPortKind();
        if (portKind == 5 || portKind == 6) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_PORT_ATTR);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoHostGroupInfo selectHgInfo = (SJmoHostGroupInfo)selectHgInfoList.get(0);
        SJmoWwn selectWwn = (SJmoWwn)selectWwnList.get(0);
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        hgIndex.setSPort(selectPortHgInfo.getSPort());
        hgIndex.setSHostGroup(selectHgInfo.getSHostGroup());
        boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
        if (!rsgFlg) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
        if (sysRsgFlg) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_SysRSG_HG);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> modelPortHgInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        Collections.sort(modelPortHgInfoList);
        int portHgInfoIndex = Collections.binarySearch(modelPortHgInfoList, selectPortHgInfo);
        if (portHgInfoIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR3);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortHostGroupInfo modelPortHgInfo = (SJmoPortHostGroupInfo)modelPortHgInfoList.get(portHgInfoIndex);
        ArrayList modelHgInfoList = modelPortHgInfo.getAlPortHostGroup();
        boolean result = false;
        for (SJmoHostGroupInfo modelHgInfo : modelHgInfoList) {
            if (modelHgInfo.getSHostGroup() != selectHgInfo.getSHostGroup()) continue;
            ArrayList modelWwnList = modelHgInfo.getAlHostGroupWwn();
            for (SJmoWwn modelWwn : modelWwnList) {
                if (0 != wwnComparator.compare(modelWwn, selectWwn)) continue;
                ArrayList<SJmoWwn> setWwnList = new ArrayList<SJmoWwn>();
                setWwnList.add(selectWwn);
                SJmoHostGroupInfo setHgInfo = new SJmoHostGroupInfo();
                setHgInfo.setAlHostGroupWwn(setWwnList);
                ArrayList<SJmoHostGroupInfo> setHgInfoList = new ArrayList<SJmoHostGroupInfo>();
                setHgInfo.setBtOption(selectHgInfo.getBtOption());
                setHgInfo.setByHostMode(selectHgInfo.getByHostMode());
                setHgInfo.setSHostGroup(selectHgInfo.getSHostGroup());
                setHgInfo.setStrHostgroupNickName(selectHgInfo.getStrHostgroupNickName());
                setHgInfo.setStrHostModeDisplayName(selectHgInfo.getStrHostModeDisplayName());
                setHgInfoList.add(setHgInfo);
                SJmoPortHostGroupInfo setPortHgInfo = new SJmoPortHostGroupInfo();
                setPortHgInfo.setSPort(selectPortHgInfo.getSPort());
                setPortHgInfo.setAlPortHostGroup(setHgInfoList);
                this.targetPortHgInfoList.add(setPortHgInfo);
                result = true;
                break;
            }
            if (!result) continue;
            break;
        }
        if (!result) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR4);
            SJcException exp = err.createException();
            throw exp;
        }
        this.hbaWwnDataModel = (SJctrHbaWwnDataModel)this.getDataObjectModel(KEY_HBAWWNINF);
        this.hostNameDataModel = (SJctrHostNameDataModel)this.getDataObjectModel(KEY_HOSTNAMEINF);
        SJctrTextBoxDataModel hbaWwnTextBox = (SJctrTextBoxDataModel)this.hbaWwnDataModel.getDataModel("COM_HBAWWN");
        SJctrTextBoxDataModel hostNameTextBox = (SJctrTextBoxDataModel)this.hostNameDataModel.getDataModel("COM_HOSTNAME");
        String wwnValue = this.getComUtility().getPortUtility().toWWNDisplay(selectWwn);
        hbaWwnTextBox.setValue(wwnValue);
        String hostNameValue = this.getComUtility().getPortUtility().toHostNameDisplay(selectWwn);
        hostNameTextBox.setValue(hostNameValue);
        SJctrCheckBoxDataModel sameSettingDataModel = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_WWN);
        sameSettingDataModel.setSelect(true);
        return true;
    }

    @Override
    public boolean checkEndData() {
        ArrayList<SJmoWwn> alBeforeHostGroupWwn;
        ArrayList modelHgInfoList;
        SJmoPortHostGroupInfo modelPortHgInfo;
        SJctrCheckBoxDataModel sameSettingDataModel = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_WWN);
        SJctrCheckBoxDataModel hbaWwnCheckBox = (SJctrCheckBoxDataModel)this.hbaWwnDataModel.getDataModel("COM_CHECKBOX");
        SJctrCheckBoxDataModel hostNameCheckBox = (SJctrCheckBoxDataModel)this.hostNameDataModel.getDataModel("COM_CHECKBOX");
        SJctrTextBoxDataModel hbaWwnTextBox = (SJctrTextBoxDataModel)this.hbaWwnDataModel.getDataModel("COM_HBAWWN");
        SJctrTextBoxDataModel hostNameTextBox = (SJctrTextBoxDataModel)this.hostNameDataModel.getDataModel("COM_HOSTNAME");
        if (!hbaWwnCheckBox.isSelect() && !hostNameCheckBox.isSelect()) {
            return false;
        }
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>();
        ArrayList<SJmoPortHostGroupInfo> confirmBeforePortHgInfoList = new ArrayList<SJmoPortHostGroupInfo>();
        ArrayList<SJmoPortHostGroupInfo> confirmPortHgInfoList = new ArrayList<SJmoPortHostGroupInfo>();
        SJmoPortHostGroupInfo selectPortHgInfo = this.targetPortHgInfoList.get(0);
        ArrayList selectHgInfoList = selectPortHgInfo.getAlPortHostGroup();
        SJmoHostGroupInfo selectHgInfo = (SJmoHostGroupInfo)selectHgInfoList.get(0);
        ArrayList selectWwnList = selectHgInfo.getAlHostGroupWwn();
        SJmoWwn selectWwn = (SJmoWwn)selectWwnList.get(0);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR9);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        Collections.sort(modelPortDetailList);
        int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortHgInfo);
        if (portDetailIndex >= 0) {
            SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
            confirmPortDetailList.add(modelPortDetail);
        }
        List<?> modelPortHgInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        Collections.sort(modelPortHgInfoList);
        int portHgInfoIndex = Collections.binarySearch(modelPortHgInfoList, selectPortHgInfo);
        if (portHgInfoIndex >= 0) {
            modelPortHgInfo = (SJmoPortHostGroupInfo)modelPortHgInfoList.get(portHgInfoIndex);
            modelHgInfoList = modelPortHgInfo.getAlPortHostGroup();
            boolean result = false;
            for (SJmoHostGroupInfo modelHgInfo : modelHgInfoList) {
                if (modelHgInfo.getSHostGroup() != selectHgInfo.getSHostGroup()) continue;
                ArrayList modelWwnList = modelHgInfo.getAlHostGroupWwn();
                for (SJmoWwn modelWwn : modelWwnList) {
                    if (0 != wwnComparator.compare(modelWwn, selectWwn)) continue;
                    SJmoPortHostGroupInfo beforePortHostGroupInfo = null;
                    SJmoHostGroupInfo beforeHostGroupInfo = null;
                    SJmoWwn beforeWwn = null;
                    SJmoPortHostGroupInfo createPortHostGroupInfo = null;
                    SJmoHostGroupInfo createHostGroupInfo = null;
                    SJmoWwn createWwn = null;
                    try {
                        beforePortHostGroupInfo = (SJmoPortHostGroupInfo)modelPortHgInfo.clone();
                        beforeHostGroupInfo = (SJmoHostGroupInfo)modelHgInfo.clone();
                        beforeWwn = (SJmoWwn)modelWwn.clone();
                        createPortHostGroupInfo = (SJmoPortHostGroupInfo)modelPortHgInfo.clone();
                        createHostGroupInfo = (SJmoHostGroupInfo)modelHgInfo.clone();
                        createWwn = (SJmoWwn)modelWwn.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        this.getLogUty().putlog("editHostData", "HostGroupInfo clone fail", e, 40000);
                        continue;
                    }
                    alBeforeHostGroupWwn = new ArrayList(1);
                    alBeforeHostGroupWwn.add(beforeWwn);
                    beforeHostGroupInfo.setAlHostGroupWwn(alBeforeHostGroupWwn);
                    ArrayList<SJmoHostGroupInfo> alBeforePortHostGroup = new ArrayList<SJmoHostGroupInfo>(1);
                    alBeforePortHostGroup.add(beforeHostGroupInfo);
                    beforePortHostGroupInfo.setAlPortHostGroup(alBeforePortHostGroup);
                    confirmBeforePortHgInfoList.add(beforePortHostGroupInfo);
                    ArrayList<SJmoWwn> alHostGroupWwn = new ArrayList<SJmoWwn>(1);
                    alHostGroupWwn.add(createWwn);
                    createHostGroupInfo.setAlHostGroupWwn(alHostGroupWwn);
                    ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>(1);
                    alPortHostGroup.add(createHostGroupInfo);
                    createPortHostGroupInfo.setAlPortHostGroup(alPortHostGroup);
                    confirmPortHgInfoList.add(createPortHostGroupInfo);
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
        }
        if (sameSettingDataModel.isSelect()) {
            for (portHgInfoIndex = 0; portHgInfoIndex < modelPortHgInfoList.size(); ++portHgInfoIndex) {
                SJmoPortAttributeInfo seletcPortAttr;
                byte portKind;
                modelPortHgInfo = (SJmoPortHostGroupInfo)modelPortHgInfoList.get(portHgInfoIndex);
                modelHgInfoList = modelPortHgInfo.getAlPortHostGroup();
                SJmoPortIndex beforePortHostGroupInfo = null;
                SJmoHostGroupInfo beforeHostGroupInfo = null;
                SJmoWwn beforeWwn = null;
                SJmoPortHostGroupInfo createPortHostGroupInfo = null;
                SJmoHostGroupInfo createHostGroupInfo = null;
                SJmoWwn createWwn = null;
                if (modelPortHgInfo.getSPort() == selectPortHgInfo.getSPort()) continue;
                List<?> modelPortAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
                Collections.sort(modelPortAttrList);
                int portAttrIndex = Collections.binarySearch(modelPortAttrList, modelPortHgInfo);
                if (portAttrIndex < 0 || (portKind = (seletcPortAttr = (SJmoPortAttributeInfo)modelPortAttrList.get(portAttrIndex)).getByPortKind()) == 5 || portKind == 6) continue;
                ArrayList<SJmoHostGroupInfo> alBeforePortHostGroup = new ArrayList<SJmoHostGroupInfo>();
                ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>();
                for (SJmoHostGroupInfo modelHgInfo : modelHgInfoList) {
                    alBeforeHostGroupWwn = new ArrayList<SJmoWwn>();
                    ArrayList<SJmoWwn> alHostGroupWwn = new ArrayList<SJmoWwn>();
                    ArrayList modelWwnList = modelHgInfo.getAlHostGroupWwn();
                    for (SJmoWwn modelWwn : modelWwnList) {
                        if (0 != wwnComparator.compare(modelWwn, selectWwn)) continue;
                        try {
                            beforePortHostGroupInfo = (SJmoPortHostGroupInfo)modelPortHgInfo.clone();
                            beforeHostGroupInfo = (SJmoHostGroupInfo)modelHgInfo.clone();
                            beforeWwn = (SJmoWwn)modelWwn.clone();
                            createPortHostGroupInfo = (SJmoPortHostGroupInfo)modelPortHgInfo.clone();
                            createHostGroupInfo = (SJmoHostGroupInfo)modelHgInfo.clone();
                            createWwn = (SJmoWwn)modelWwn.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            this.getLogUty().putlog("editHostData", "PortHostGroupInfo clone fail", e, 40000);
                            continue;
                        }
                        alBeforeHostGroupWwn.add(beforeWwn);
                        alHostGroupWwn.add(createWwn);
                    }
                    if (alHostGroupWwn.size() <= 0) continue;
                    beforeHostGroupInfo.setAlHostGroupWwn(alBeforeHostGroupWwn);
                    createHostGroupInfo.setAlHostGroupWwn(alHostGroupWwn);
                    alBeforePortHostGroup.add(beforeHostGroupInfo);
                    alPortHostGroup.add(createHostGroupInfo);
                }
                if (alPortHostGroup.size() <= 0) continue;
                hgIndex.setSPort(beforePortHostGroupInfo.getSPort());
                hgIndex.setSHostGroup(beforeHostGroupInfo.getSHostGroup());
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) {
                    SJctrError err = new SJctrError(10, 22, EDITHOST_ERR10);
                    SJcException exp = err.createException();
                    throw exp;
                }
                ((SJmoPortHostGroupInfo)beforePortHostGroupInfo).setAlPortHostGroup(alBeforePortHostGroup);
                createPortHostGroupInfo.setAlPortHostGroup(alPortHostGroup);
                confirmBeforePortHgInfoList.add((SJmoPortHostGroupInfo)beforePortHostGroupInfo);
                confirmPortHgInfoList.add(createPortHostGroupInfo);
                portDetailIndex = Collections.binarySearch(modelPortDetailList, createPortHostGroupInfo);
                if (portDetailIndex < 0) continue;
                SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
                confirmPortDetailList.add(modelPortDetail);
            }
        }
        for (portHgInfoIndex = 0; portHgInfoIndex < confirmPortHgInfoList.size(); ++portHgInfoIndex) {
            SJmoPortHostGroupInfo confirmPortHgInfo = (SJmoPortHostGroupInfo)confirmPortHgInfoList.get(portHgInfoIndex);
            ArrayList confirmHgInfoList = confirmPortHgInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo confirmHgInfo : confirmHgInfoList) {
                ArrayList confirmWwnList = confirmHgInfo.getAlHostGroupWwn();
                for (SJmoWwn confirmWwn : confirmWwnList) {
                    if (hbaWwnCheckBox.isSelect()) {
                        byte[] byWwn = SJctrComUtility.toByteFromString(hbaWwnTextBox.getValue());
                        confirmWwn.setByWWN(byWwn);
                    }
                    if (!hostNameCheckBox.isSelect()) continue;
                    String strHostName = hostNameTextBox.getValue();
                    confirmWwn.setStrWWNNickName(strHostName);
                }
            }
        }
        for (portHgInfoIndex = 0; portHgInfoIndex < confirmPortHgInfoList.size(); ++portHgInfoIndex) {
            SJmoPortHostGroupInfo confirmBeforePortHgInfo = (SJmoPortHostGroupInfo)confirmBeforePortHgInfoList.get(portHgInfoIndex);
            ArrayList confirmBeforeHgInfoList = confirmBeforePortHgInfo.getAlPortHostGroup();
            SJmoPortHostGroupInfo confirmPortHgInfo = (SJmoPortHostGroupInfo)confirmPortHgInfoList.get(portHgInfoIndex);
            ArrayList confirmHgInfoList = confirmPortHgInfo.getAlPortHostGroup();
            for (int hgInfoIndex = 0; hgInfoIndex < confirmHgInfoList.size(); ++hgInfoIndex) {
                SJmoHostGroupInfo confirmBeforeHgInfo = (SJmoHostGroupInfo)confirmBeforeHgInfoList.get(hgInfoIndex);
                ArrayList confirmBeforeWwnList = confirmBeforeHgInfo.getAlHostGroupWwn();
                SJmoHostGroupInfo confirmHgInfo = (SJmoHostGroupInfo)confirmHgInfoList.get(hgInfoIndex);
                ArrayList confirmWwnList = confirmHgInfo.getAlHostGroupWwn();
                for (int wwnIndex = 0; wwnIndex < confirmWwnList.size(); ++wwnIndex) {
                    SJcException exp;
                    SJmoWwn confirmWwn;
                    SJmoWwn confirmBeforeWwn = (SJmoWwn)confirmBeforeWwnList.get(wwnIndex);
                    if (0 != wwnComparator.compare(confirmBeforeWwn, confirmWwn = (SJmoWwn)confirmWwnList.get(wwnIndex)) && !this.checkExistHbaWwn(modelPortHgInfoList, confirmPortHgInfo, confirmWwn)) {
                        SJctrError err = new SJctrError(10, 22, EDITHOST_ERR5);
                        exp = err.createException();
                        throw exp;
                    }
                    if ("".equals(confirmWwn.getStrWWNNickName()) || confirmBeforeWwn.getStrWWNNickName().equals(confirmWwn.getStrWWNNickName()) || this.checkExistHostName(modelPortHgInfoList, confirmPortHgInfo, confirmWwn)) continue;
                    SJctrError err = new SJctrError(10, 22, EDITHOST_ERR6);
                    exp = err.createException();
                    throw exp;
                }
            }
        }
        Collections.sort(confirmPortDetailList);
        Collections.sort(confirmBeforePortHgInfoList);
        Collections.sort(confirmPortHgInfoList);
        SJctrEditHostData confirmData = new SJctrEditHostData();
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setBeforePortHgInfoList(confirmBeforePortHgInfoList);
        confirmData.setPortHgInfoList(confirmPortHgInfoList);
        ArrayList<SJctrEditHostData> confirmDataList = new ArrayList<SJctrEditHostData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditHostData.class, confirmDataList);
        return true;
    }

    private boolean checkExistHbaWwn(List portHgInfoList, SJmoPortHostGroupInfo portHgInfo, SJmoWwn wwn) {
        boolean ret = true;
        int index = Collections.binarySearch(portHgInfoList, portHgInfo);
        if (index >= 0) {
            SJmoPortHostGroupInfo modelPortHgInfo = (SJmoPortHostGroupInfo)portHgInfoList.get(index);
            ArrayList modelHgInfoList = modelPortHgInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo modelHgInfo : modelHgInfoList) {
                ArrayList modelWwnList = modelHgInfo.getAlHostGroupWwn();
                for (SJmoWwn modelWwn : modelWwnList) {
                    if (0 != wwnComparator.compare(modelWwn, wwn)) continue;
                    ret = false;
                    return ret;
                }
            }
        }
        return ret;
    }

    private boolean checkExistHostName(List portHgInfoList, SJmoPortHostGroupInfo portHgInfo, SJmoWwn wwn) {
        boolean ret = true;
        int index = Collections.binarySearch(portHgInfoList, portHgInfo);
        if (index >= 0) {
            SJmoPortHostGroupInfo modelPortHgInfo = (SJmoPortHostGroupInfo)portHgInfoList.get(index);
            ArrayList modelHgInfoList = modelPortHgInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo modelHgInfo : modelHgInfoList) {
                ArrayList modelWwnList = modelHgInfo.getAlHostGroupWwn();
                for (SJmoWwn modelWwn : modelWwnList) {
                    if (!modelWwn.getStrWWNNickName().equals(wwn.getStrWWNNickName())) continue;
                    ret = false;
                    return ret;
                }
            }
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

