/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editportsiscsi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrBaseCheckRadioDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrBaseCheckRadioEnableDisableDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrChannelSpeedDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsKindAC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsSelectData;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrPortAttributeDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.SJctrEditIscsiPortsData;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrBaseCheckComboDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrBaseCheckTextDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrIpv6LocalAddrDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrIsnsIpAddrDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrSecretDataModel;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.datamodel.SJctrVlanDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrEditIscsiPortsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100181;
    private static final String KEY_IPV4ADDR = "COM_IPV4_ADDR";
    private static final String KEY_IPV4MASK = "COM_IPV4_SUBNET_MASK";
    private static final String KEY_IPV4DEFGATEWAY = "COM_IPV4_DEF_GATEWAY";
    private static final String KEY_IPV6MODE = "COM_IPV6_MODE";
    private static final String KEY_IPV6LINK = "COM_IPV6_LINK_LOCAL_ADR";
    private static final String KEY_IPV6GLOBAL = "COM_IPV6_GLOBAL_ADR";
    private static final String KEY_IPV6GLOBAL1 = "COM_IPV6_GLOBAL_ADR1";
    private static final String KEY_IPV6GLOBAL2 = "COM_IPV6_GLOBAL_ADR2";
    private static final String KEY_IPV6DEFGATEWAY = "COM_IPV6_DEF_GATEWAY";
    private static final String KEY_ATTRIBUTEINF = "COM_ATTRIBUTEINF";
    private static final String KEY_SECURITYINF = "COM_SECURITYINF";
    private static final String KEY_SPEEDINF = "COM_SPEEDINF";
    private static final String KEY_TCPPORTNUM = "COM_TCP_PT_NUM";
    private static final String KEY_SELECTACK = "COM_SEL_ACK";
    private static final String KEY_DELAYACK = "COM_DELAY_ACK";
    private static final String KEY_MAX_WIN_SIZE = "COM_MAX_WIN_SIZE";
    private static final String KEY_MAX_WIN_SIZE_CMBBOX = "COM_MAX_WIN_SIZE_CMB";
    private static final String KEY_ETH_NET_MTU_SIZE = "COM_ETH_NET_MTU_SIZE";
    private static final String KEY_ETH_NET_MTU_SIZE_CMBBOX = "COM_ETH_NET_MTU_SIZE_CMB";
    private static final String KEY_KEEP_ALIVE_TIMER = "COM_KEEP_ALIVE_TIMER";
    private static final String KEY_VLAN_TAG_MODE = "COM_VLAN_TAG_MODE";
    private static final String KEY_ISNS_SRV = "COM_ISNS_SRV";
    private static final String KEY_ISNS_IPADDR = "COM_ISNS_ADDR";
    private static final String KEY_ISNS_PORTNUM = "COM_ISNS_TCP_PT_NUM";
    private static final String KEY_USER_NAME = "COM_USER_NAME";
    private static final String KEY_SECRET = "COM_SECRET";
    public static final String TITLE = "DISP_DI13S_TITLE";
    public static final String KEY_MIN = "COM_MIN";
    public static final String KEY_MAX = "COM_MAX";
    public static final String KEY_RADIO_AUTO = "COM_AUTO";
    public static final String KEY_RADIO_MANUAL = "COM_MANUAL";
    public static final String KEY_MIN_ONE = "1";
    public static final String KEY_TCP_MAX = "65535";
    public static final String KEY_VLAN_MAX = "4094";
    public static final String KEY_KAT_MIN = "30";
    public static final String KEY_KAT_MAX = "64800";
    List<SJmoPortAttributeInfo> targetPortAttributeInfoList = new ArrayList<SJmoPortAttributeInfo>();
    List<SJmoPortDetail> targetPortDetailList = new ArrayList<SJmoPortDetail>();
    SJctrPortUtility portUtil = null;
    SJctrBaseCheckTextDataModel ipv4AddrDataModel = null;
    SJctrBaseCheckTextDataModel ipv4SubnetDataModel = null;
    SJctrBaseCheckTextDataModel ipv4GatewayDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel ipv6ModeDataModel = null;
    SJctrIpv6LocalAddrDataModel ipv6LocalAddrDataModel = null;
    SJctrBaseCheckRadioDataModel ipv6GlobalAddrDataModel = null;
    SJctrBaseCheckTextDataModel ipv6GlobalAddr1DataModel = null;
    SJctrBaseCheckTextDataModel ipv6GlobalAddr2DataModel = null;
    SJctrBaseCheckTextDataModel ipv6GatewayDataModel = null;
    SJctrPortAttributeDataModel portAttributeDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel portSecurityDataModel = null;
    SJctrChannelSpeedDataModel portSpeedDataModel = null;
    SJctrBaseCheckTextDataModel tcpPortNumberDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel selectiveAckDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel delayedAckDataModel = null;
    SJctrBaseCheckComboDataModel maxWindowSizeDataModel = null;
    SJctrBaseCheckComboDataModel ethernetMtuSizeDataModel = null;
    SJctrBaseCheckTextDataModel keepAliveTimerDataModel = null;
    SJctrVlanDataModel vlanDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel isnsServerDataModel = null;
    SJctrIsnsIpAddrDataModel isnsIpAddrDataModel = null;
    SJctrBaseCheckTextDataModel isnsTcpNumDataModel = null;
    SJctrBaseCheckTextDataModel chapUserNameDataModel = null;
    SJctrSecretDataModel secretDataModel = null;
    public static int EDITISCSIPORTS_ERR_INVALID_DATA_LV4 = 107002;
    public static int EDITISCSIPORTS_ERR_SELECTED_PORT_NOT_FOUND = 106501;
    public static int EDITISCSIPORTS_ERR_SELECTED_PORT_ISNOT_ISCSI = 205104;
    public static int EDITISCSIPORTS_ERR_NOT_SUPPORTED_SPEED = 105081;
    public static int EDITISCSIPORTS_ERR_NOT_AUTHORIZED = 105204;
    public static int EDITISCSIPORTS_ERR_SELECTED_PORT_RSG = 105296;
    public static int EDITISCSIPORTS_ERR_LUN_EXISTS = 105080;
    public static int EDITISCSIPORTS_MSG_PORT_SECURITY_ON = 106073;
    public static int EDITISCSIPORTS_MSG_PORT_SECURITY_OFF = 106074;
    public static int EDITISCSIPORTS_MSG_IPV6_DISABLE = 205107;
    public static int EDITISCSIPORTS_MSG_ISNSSERVER_DISABLE = 205108;
    public static int EDITISCSIPORTS_ERR_INVALID_DATA_LV7 = 107001;
    public static int EDITISCSIPORTS_ERR_RE_ENTER_SECRET = 206001;
    public static int EDITISCSIPORTS_ERR_INVALID_CHAPUSERNAME = 206002;
    public static int EDITISCSIPORTS_ERR_INVALID_SECRET = 206003;
    SJctrDataController parentDC = null;
    SJctrTableDataModel parentTbl = null;
    public static final String KEY_TABLE = "COM_TABLE";
    List<SJmoChaDetail> modelChaDetailList = null;
    HashMap<Short, SJmoChaDetail> portchaDataMap = null;
    HashSet<String> notDisplayChannelSpeedMap = null;
    boolean defaultIsnsMode = false;
    boolean defaultIPv6Mode = false;
    public static final String IPV6_LOCAL_HEARD = "FE80:0000:0000:0000:";
    static String[][] itemListMaxWinSize = new String[][]{{"64", "64KB"}, {"128", "128KB"}, {"256", "256KB"}, {"512", "512KB"}, {"1024", "1024KB"}};
    static String[][] itemListMTU = new String[][]{{"1500", "1500Bytes"}, {"4500", "4500Bytes"}, {"9000", "9000Bytes"}};
    private static final Pattern patternChapUserName = Pattern.compile("[0-9a-zA-Z\\.\\-\\+@_=:/\\[\\]~\\s]{1,223}");
    private static final Pattern patternSecret = Pattern.compile("[0-9a-zA-Z\\.\\-\\+@_=:/\\[\\]~\\s]{12,32}");

    public SJctrEditIscsiPortsDC() throws SJcException {
        super(0x1100181);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_IPV4ADDR, new SJctrBaseCheckTextDataModel("COM_IPV4_ADDR_TXT"));
        this.addDataObjectModel(KEY_IPV4MASK, new SJctrBaseCheckTextDataModel("COM_IPV4_SUBNET_MASK_TXT"));
        this.addDataObjectModel(KEY_IPV4DEFGATEWAY, new SJctrBaseCheckTextDataModel("COM_IPV4_DEF_GATEWAY_TXT"));
        this.addDataObjectModel(KEY_IPV6MODE, new SJctrBaseCheckRadioEnableDisableDataModel("COM_IPV6_MODE_RDO"));
        this.addDataObjectModel(KEY_IPV6LINK, new SJctrIpv6LocalAddrDataModel());
        this.addDataObjectModel(KEY_IPV6GLOBAL, new SJctrBaseCheckRadioDataModel("COM_IPV6_GLOBAL_ADR_RDO", KEY_RADIO_AUTO, KEY_RADIO_MANUAL));
        this.addDataObjectModel(KEY_IPV6GLOBAL1, new SJctrBaseCheckTextDataModel("COM_IPV6_GLOBAL_ADR1_TXT"));
        this.addDataObjectModel(KEY_IPV6GLOBAL2, new SJctrBaseCheckTextDataModel("COM_IPV6_GLOBAL_ADR2_TXT"));
        this.addDataObjectModel(KEY_IPV6DEFGATEWAY, new SJctrBaseCheckTextDataModel("COM_IPV6_DEF_GATEWAY_TXT"));
        this.addDataObjectModel(KEY_ATTRIBUTEINF, new SJctrPortAttributeDataModel());
        this.addDataObjectModel(KEY_SECURITYINF, new SJctrBaseCheckRadioEnableDisableDataModel("COM_SECURITY"));
        this.addDataObjectModel(KEY_SPEEDINF, new SJctrChannelSpeedDataModel());
        this.addDataObjectModel(KEY_TCPPORTNUM, new SJctrBaseCheckTextDataModel("COM_TCP_PT_NUM_TXT"));
        this.addDataObjectModel(KEY_SELECTACK, new SJctrBaseCheckRadioEnableDisableDataModel("COM_SEL_ACK_RDO"));
        this.addDataObjectModel(KEY_DELAYACK, new SJctrBaseCheckRadioEnableDisableDataModel("COM_DELAY_ACK_RDO"));
        this.addDataObjectModel(KEY_MAX_WIN_SIZE, new SJctrBaseCheckComboDataModel(KEY_MAX_WIN_SIZE_CMBBOX));
        this.addDataObjectModel(KEY_ETH_NET_MTU_SIZE, new SJctrBaseCheckComboDataModel(KEY_ETH_NET_MTU_SIZE_CMBBOX));
        this.addDataObjectModel(KEY_KEEP_ALIVE_TIMER, new SJctrBaseCheckTextDataModel("COM_KEEP_ALIVE_TIMER_TXT"));
        this.addDataObjectModel(KEY_VLAN_TAG_MODE, new SJctrVlanDataModel());
        this.addDataObjectModel(KEY_ISNS_SRV, new SJctrBaseCheckRadioEnableDisableDataModel("COM_ISNS_SRV_RDO"));
        this.addDataObjectModel(KEY_ISNS_IPADDR, new SJctrIsnsIpAddrDataModel());
        this.addDataObjectModel(KEY_ISNS_PORTNUM, new SJctrBaseCheckTextDataModel("COM_ISNS_TCP_PT_NUM_TXT"));
        this.addDataObjectModel(KEY_USER_NAME, new SJctrBaseCheckTextDataModel("COM_USER_NAME_TXT"));
        this.addDataObjectModel(KEY_SECRET, new SJctrSecretDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (dat == null || dat.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
            SJcException exp = err.createException();
            throw exp;
        }
        Object selectObj = null;
        selectObj = dat.get(0);
        if (!(selectObj instanceof SJctrEditPortsSelectData)) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrEditPortsSelectData selectData = null;
        selectData = selectObj;
        List<SJmoPortIndex> portIndexList = selectData.getPortIndexList();
        if (portIndexList == null || portIndexList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        boolean result = true;
        SJctrError errInfo = null;
        if (this.portUtil == null) {
            this.portUtil = this.getComUtility().getPortUtility();
        }
        this.parentDC = this.getWizardWindow().getParentDC();
        this.parentTbl = (SJctrTableDataModel)this.parentDC.getDataObjectModel(KEY_TABLE);
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        SJctrEditPortsSelectData selectData = (SJctrEditPortsSelectData)dat.get(0);
        List<SJmoPortIndex> selectPortIndexList = selectData.getPortIndexList();
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        List<?> modelPortAttributeInfoList = this.getCache(SJmoGetPortAttributeInfo.class);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectPortIndexList.size());
        for (SJmoPortIndex selectPortIndex : selectPortIndexList) {
            SJctrErrorColumnData errData;
            SJctrError err;
            int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortIndex);
            int portAttrIndex = Collections.binarySearch(modelPortAttributeInfoList, selectPortIndex);
            if (portDetailIndex < 0 || portAttrIndex < 0) {
                result = false;
                SJctrError err2 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_SELECTED_PORT_NOT_FOUND);
                SJctrErrorColumnData errData2 = new SJctrErrorColumnData(selectPortIndex, err2);
                errList.add(errData2);
                continue;
            }
            SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
            SJmoPortAttributeInfo modelPortAttributeInfo = (SJmoPortAttributeInfo)modelPortAttributeInfoList.get(portAttrIndex);
            int rsgId = rsgUtil.getRsgId(selectPortIndex);
            boolean rsgFlg = rsgUtil.chkResourceGroup(rsgId);
            if (!rsgFlg) {
                result = false;
                err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_SELECTED_PORT_RSG);
                errData = new SJctrErrorColumnData(selectPortIndex, err);
                errList.add(errData);
                continue;
            }
            if (!SJctrPortUtility.isIscsiPort(modelPortDetail)) {
                result = false;
                err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_SELECTED_PORT_ISNOT_ISCSI);
                errData = new SJctrErrorColumnData(selectPortIndex, err);
                errList.add(errData);
                continue;
            }
            this.targetPortDetailList.add(modelPortDetail);
            this.targetPortAttributeInfoList.add(modelPortAttributeInfo);
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(this.parentTbl, errList);
            errInfo = errDc.getRepresentativeError(errList, 4);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.ipv4AddrDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV4ADDR);
        this.ipv4SubnetDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV4MASK);
        this.ipv4GatewayDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV4DEFGATEWAY);
        this.ipv6ModeDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_IPV6MODE);
        this.ipv6LocalAddrDataModel = (SJctrIpv6LocalAddrDataModel)this.getDataObjectModel(KEY_IPV6LINK);
        this.ipv6GlobalAddrDataModel = (SJctrBaseCheckRadioDataModel)this.getDataObjectModel(KEY_IPV6GLOBAL);
        this.ipv6GlobalAddr1DataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV6GLOBAL1);
        this.ipv6GlobalAddr2DataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV6GLOBAL2);
        this.ipv6GatewayDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_IPV6DEFGATEWAY);
        this.portAttributeDataModel = (SJctrPortAttributeDataModel)this.getDataObjectModel(KEY_ATTRIBUTEINF);
        this.portSecurityDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_SECURITYINF);
        this.portSpeedDataModel = (SJctrChannelSpeedDataModel)this.getDataObjectModel(KEY_SPEEDINF);
        this.tcpPortNumberDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_TCPPORTNUM);
        this.selectiveAckDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_SELECTACK);
        this.delayedAckDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_DELAYACK);
        this.maxWindowSizeDataModel = (SJctrBaseCheckComboDataModel)this.getDataObjectModel(KEY_MAX_WIN_SIZE);
        this.ethernetMtuSizeDataModel = (SJctrBaseCheckComboDataModel)this.getDataObjectModel(KEY_ETH_NET_MTU_SIZE);
        this.keepAliveTimerDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_KEEP_ALIVE_TIMER);
        this.vlanDataModel = (SJctrVlanDataModel)this.getDataObjectModel(KEY_VLAN_TAG_MODE);
        this.isnsServerDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_ISNS_SRV);
        this.isnsIpAddrDataModel = (SJctrIsnsIpAddrDataModel)this.getDataObjectModel(KEY_ISNS_IPADDR);
        this.isnsTcpNumDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_ISNS_PORTNUM);
        this.chapUserNameDataModel = (SJctrBaseCheckTextDataModel)this.getDataObjectModel(KEY_USER_NAME);
        this.secretDataModel = (SJctrSecretDataModel)this.getDataObjectModel(KEY_SECRET);
        this.createPortChaData();
        this.createPortAttributeComboBox();
        this.createPortSpeedComboBox();
        this.createWindowScaleComboBox();
        this.createEthernetMTUComboBox();
        this.createDefaultValue();
        return result;
    }

    private void createPortChaData() {
        this.modelChaDetailList = this.getCache(SJmoGetChaDetail.class);
        this.portchaDataMap = new HashMap();
        this.notDisplayChannelSpeedMap = new HashSet();
        for (SJmoPortDetail checkPortDetail : this.targetPortDetailList) {
            for (SJmoChaDetail modelChaDetail : this.modelChaDetailList) {
                short sCHAClusterNumber = SJctrPortUtility.getPortToCluster(checkPortDetail.getSPort());
                short sCHANumber = SJctrPortUtility.getPortToCHANumber(checkPortDetail.getSPort());
                if (modelChaDetail.getSCHAClusterNumber() != sCHAClusterNumber || modelChaDetail.getSCHANumber() != sCHANumber) continue;
                this.portchaDataMap.put(checkPortDetail.getSPort(), modelChaDetail);
                byte byPackageType = modelChaDetail.getByCHAPackageType();
                byte sfpDataTransferRate = checkPortDetail.getSFPDataTransferRate();
                List<Byte> notSupportList = SJctrEditPortsKindAC.getNotSupportChannelSpeed(byPackageType, sfpDataTransferRate);
                for (Byte notSupport : notSupportList) {
                    String name = Byte.toString(notSupport);
                    this.notDisplayChannelSpeedMap.add(name);
                }
            }
        }
    }

    private void createPortAttributeComboBox() {
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (((SJctrEditPortsSelectData)dat.get(0)).getPortIndexList().size() > 1) {
            portAttributeComboBox.addItem("");
        }
        portAttributeComboBox.addItem(Byte.toString((byte)3), this.getComUtility().getGuidance("TARGET"));
        portAttributeComboBox.addItem(Byte.toString((byte)9), this.getComUtility().getGuidance("UNIVERSAL"));
    }

    private void createPortSpeedComboBox() {
        SJctrComboBoxDataModel portSpeedComboBox = (SJctrComboBoxDataModel)this.portSpeedDataModel.getDataModel("COM_SPEED");
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (((SJctrEditPortsSelectData)dat.get(0)).getPortIndexList().size() > 1) {
            portSpeedComboBox.addItem("");
        }
        String name = "";
        String label = "";
        name = Byte.toString((byte)3);
        label = this.portUtil.toChannelSpeedDisplay((byte)3, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            portSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)1);
        label = this.portUtil.toChannelSpeedDisplay((byte)1, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            portSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)10);
        label = this.portUtil.toChannelSpeedDisplay((byte)10, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            portSpeedComboBox.addItem(name, label);
        }
    }

    public void createWindowScaleComboBox() {
        SJctrComboBoxDataModel windowScaleComboBox = this.maxWindowSizeDataModel.getComboBoxDataModel();
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (((SJctrEditPortsSelectData)dat.get(0)).getPortIndexList().size() > 1) {
            windowScaleComboBox.addItem("");
        }
        for (int i = 0; i < itemListMaxWinSize.length; ++i) {
            windowScaleComboBox.addItem(itemListMaxWinSize[i][0], itemListMaxWinSize[i][1]);
        }
    }

    public void createEthernetMTUComboBox() {
        SJctrComboBoxDataModel ethernetMtuComboBox = this.ethernetMtuSizeDataModel.getComboBoxDataModel();
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (((SJctrEditPortsSelectData)dat.get(0)).getPortIndexList().size() > 1) {
            ethernetMtuComboBox.addItem("");
        }
        for (int i = 0; i < itemListMTU.length; ++i) {
            ethernetMtuComboBox.addItem(itemListMTU[i][0], itemListMTU[i][1]);
        }
    }

    private void createDefaultValue() {
        String strEthernetMtuSize;
        String strMaxWinSize;
        String strSpeedName;
        HashSet<String> setV4IPAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV4SubnetMask = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV4GateWayAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setV6Mode = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setV6LinkAddressMode = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV6LinkAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setV6GlobalAddressMode = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV6GlobalAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV6GlobalAddress2 = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setV6GateWayAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setPortSecuritySwitch = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Byte> setPortSpeed = new HashSet<Byte>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setTcpPortNumber = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setSelectiveAck = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setDelayedAck = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setMaxWinSize = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setEthernetMtuSize = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setKeepAliveTimer = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setVlanTagging = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setVlanId = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<Boolean> setIsnsServerMode = new HashSet<Boolean>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setIsnsIpType = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setIsnsIpAddress = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        HashSet<Integer> setIsnsTcpPortNumber = new HashSet<Integer>(SJctrPortUtility.PORT_MAX);
        HashSet<String> setChapUserName = new HashSet<String>(SJctrPortUtility.PORT_MAX);
        int[] invalidIpv6Address = new int[8];
        int[] invalidIpv4Address = new int[4];
        boolean vportMode = false;
        for (SJmoPortDetail portDtl : this.targetPortDetailList) {
            setV4IPAddress.add(SJctrPortUtility.toDispIPv4(portDtl.getIV4IPAddress()));
            if (!Arrays.equals(portDtl.getIV4NetMaskAddress(), invalidIpv4Address)) {
                setV4SubnetMask.add(SJctrPortUtility.toDispIPv4(portDtl.getIV4NetMaskAddress()));
            }
            setV4GateWayAddress.add(SJctrPortUtility.toDispIPv4(portDtl.getIV4GateWayAddress()));
            setV6Mode.add(portDtl.getBV6Mode());
            setV6LinkAddressMode.add(portDtl.getBV6LinkAddressMode());
            if (!portDtl.getBV6LinkAddressMode() && !Arrays.equals(portDtl.getIV6LinkAddressManual(), invalidIpv6Address)) {
                String strV6LinkAddress = SJctrPortUtility.toDispIPv6(portDtl.getIV6LinkAddressManual());
                String[] v6LinkAddressFull = strV6LinkAddress.split(":");
                String v6LinkAddressHarf = v6LinkAddressFull[4] + ":" + v6LinkAddressFull[5] + ":" + v6LinkAddressFull[6] + ":" + v6LinkAddressFull[7];
                setV6LinkAddress.add(v6LinkAddressHarf);
            }
            setV6GlobalAddressMode.add(portDtl.getBV6GlobalAddressMode());
            if (!portDtl.getBV6GlobalAddressMode() && !Arrays.equals(portDtl.getIV6GlobalAddressManual(), invalidIpv6Address)) {
                setV6GlobalAddress.add(SJctrIscsiUtility.getIpv6AddrString(portDtl.getIV6GlobalAddressManual()));
            }
            if (!portDtl.getBV6GlobalAddressMode() && !Arrays.equals(portDtl.getIV6GlobalAddress2Manual(), invalidIpv6Address)) {
                setV6GlobalAddress2.add(SJctrIscsiUtility.getIpv6AddrString(portDtl.getIV6GlobalAddress2Manual()));
            }
            if (!Arrays.equals(portDtl.getIV6GateWayAddress(), invalidIpv6Address)) {
                setV6GateWayAddress.add(SJctrIscsiUtility.getIpv6AddrString(portDtl.getIV6GateWayAddress()));
            }
            setPortSecuritySwitch.add(portDtl.isBPortSecuritySwitch());
            setPortSpeed.add(portDtl.getByUserChannelSpeed());
            setTcpPortNumber.add(portDtl.getITcpPortNumber());
            setSelectiveAck.add(portDtl.getBAvailableSelectiveACK());
            setDelayedAck.add(portDtl.getBAvailableDelayedACK());
            setMaxWinSize.add(portDtl.getITcpWindowSize());
            setEthernetMtuSize.add(portDtl.getIMtuSize());
            setKeepAliveTimer.add(portDtl.getiKeepAliveTimer());
            setVlanTagging.add(portDtl.getBAvailableVlanTagging());
            setVlanId.add(portDtl.getIVlanId());
            setIsnsServerMode.add(portDtl.getBIsnsServerMode());
            setIsnsIpType.add(portDtl.getIIsnsIpType());
            if (portDtl.getIIsnsIpType() == 0) {
                setIsnsIpAddress.add(SJctrPortUtility.toDispIPv4(portDtl.getIIsnsV4Address()));
            } else if (portDtl.getIIsnsIpType() == 1) {
                setIsnsIpAddress.add(SJctrIscsiUtility.getIpv6AddrString(portDtl.getIIsnsV6Address()));
            }
            setIsnsTcpPortNumber.add(portDtl.getIIsnsTcpPortNumber());
            setChapUserName.add(portDtl.getStrUserName());
            if (portDtl.getIVPortMode() != 1) continue;
            vportMode = true;
        }
        if (vportMode) {
            this.ipv4AddrDataModel.getCheckBoxDataModel().setEnable(false);
            this.ipv4AddrDataModel.getTextBoxDataModel().setEnable(false);
        } else if (this.targetPortDetailList.size() > 1) {
            this.ipv4AddrDataModel.getCheckBoxDataModel().setEnable(false);
            this.ipv4AddrDataModel.getTextBoxDataModel().setEnable(false);
        } else if (setV4IPAddress.size() == 1) {
            this.ipv4AddrDataModel.setTextboxValue((String)setV4IPAddress.iterator().next());
        }
        if (vportMode) {
            this.ipv4SubnetDataModel.getTextBoxDataModel().setEnable(false);
            this.ipv4SubnetDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setV4SubnetMask.size() == 1) {
            this.ipv4SubnetDataModel.setTextboxValue((String)setV4SubnetMask.iterator().next());
        }
        if (vportMode) {
            this.ipv4GatewayDataModel.getTextBoxDataModel().setEnable(false);
            this.ipv4GatewayDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setV4GateWayAddress.size() == 1) {
            this.ipv4GatewayDataModel.setTextboxValue((String)setV4GateWayAddress.iterator().next());
        }
        if (vportMode) {
            this.ipv6ModeDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.ipv6ModeDataModel.getRadioButtonGroupDataModel().setEnable("COM_DISABLE", false);
            this.ipv6ModeDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (this.targetPortDetailList.size() > 1) {
            this.ipv6ModeDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.defaultIPv6Mode = false;
            if (setV6Mode.size() == 1 && !((Boolean)setV6Mode.iterator().next()).booleanValue()) {
                this.ipv6ModeDataModel.setSelectRadioDisable();
            }
        } else if (this.targetPortDetailList.get(0).getBV6Mode()) {
            this.ipv6ModeDataModel.setSelectRadioEnable();
            this.defaultIPv6Mode = true;
        } else {
            this.ipv6ModeDataModel.setSelectRadioDisable();
            this.defaultIPv6Mode = false;
        }
        if (vportMode) {
            this.ipv6LocalAddrDataModel.getRadioButtonGroupDataModel().setEnable(false);
            this.ipv6LocalAddrDataModel.getCheckBoxDataModel().setEnable(false);
        } else {
            if (setV6LinkAddressMode.size() == 1) {
                if (((Boolean)setV6LinkAddressMode.iterator().next()).booleanValue()) {
                    this.ipv6LocalAddrDataModel.setSelectRadioAuto();
                } else {
                    this.ipv6LocalAddrDataModel.setSelectRadioManual();
                }
            }
            if (setV6LinkAddress.size() == 1) {
                this.ipv6LocalAddrDataModel.setTextboxValue((String)setV6LinkAddress.iterator().next());
            }
        }
        if (vportMode) {
            this.ipv6GlobalAddrDataModel.getRadioButtonGroupDataModel().setEnable(false);
            this.ipv6GlobalAddrDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setV6GlobalAddressMode.size() == 1) {
            if (((Boolean)setV6GlobalAddressMode.iterator().next()).booleanValue()) {
                this.ipv6GlobalAddrDataModel.setSelectRadioFirst();
            } else {
                this.ipv6GlobalAddrDataModel.setSelectRadioSecond();
            }
        }
        if (vportMode) {
            this.ipv6GlobalAddr1DataModel.getCheckBoxDataModel().setEnable(false);
            this.ipv6GlobalAddr1DataModel.getTextBoxDataModel().setEnable(false);
        } else if (setV6GlobalAddress.size() == 1) {
            this.ipv6GlobalAddr1DataModel.setTextboxValue((String)setV6GlobalAddress.iterator().next());
        }
        if (vportMode) {
            this.ipv6GlobalAddr2DataModel.getCheckBoxDataModel().setEnable(false);
            this.ipv6GlobalAddr2DataModel.getTextBoxDataModel().setEnable(false);
        } else if (setV6GlobalAddress2.size() == 1) {
            this.ipv6GlobalAddr2DataModel.setTextboxValue((String)setV6GlobalAddress2.iterator().next());
        }
        if (vportMode) {
            this.ipv6GatewayDataModel.getCheckBoxDataModel().setEnable(false);
            this.ipv6GatewayDataModel.getTextBoxDataModel().setEnable(false);
        } else if (setV6GateWayAddress.size() == 1) {
            this.ipv6GatewayDataModel.setTextboxValue((String)setV6GateWayAddress.iterator().next());
        }
        this.selectPortAttributeComboBox();
        if (setPortSecuritySwitch.size() == 1) {
            if (((Boolean)setPortSecuritySwitch.iterator().next()).booleanValue()) {
                this.portSecurityDataModel.setSelectRadioEnable();
            } else {
                this.portSecurityDataModel.setSelectRadioDisable();
            }
        }
        SJctrComboBoxDataModel portSpeedComboBox = (SJctrComboBoxDataModel)this.portSpeedDataModel.getDataModel("COM_SPEED");
        if (setPortSpeed.size() == 1) {
            SJmoPortDetail portDtl = this.targetPortDetailList.get(0);
            strSpeedName = Byte.toString(SJctrEditPortsKindAC.getChannelSpeedToRmi(portDtl.getByUserChannelSpeed(), portDtl.getByDKCChannelSpeed()));
            portSpeedComboBox.removeItem("");
        } else {
            strSpeedName = "";
        }
        portSpeedComboBox.setSelection(strSpeedName);
        if (vportMode) {
            this.tcpPortNumberDataModel.getCheckBoxDataModel().setEnable(false);
            this.tcpPortNumberDataModel.getTextBoxDataModel().setEnable(false);
        } else if (setTcpPortNumber.size() == 1) {
            this.tcpPortNumberDataModel.setTextboxValue(Integer.toString((Integer)setTcpPortNumber.iterator().next()));
        }
        SJctrTextBoxDataModel tcpPortNumTextBox = this.tcpPortNumberDataModel.getTextBoxDataModel();
        Object tcpPortNumDataObject = tcpPortNumTextBox.getManageData();
        ((SJctrDataObject)tcpPortNumDataObject).setData(KEY_MIN, KEY_MIN_ONE);
        ((SJctrDataObject)tcpPortNumDataObject).setData(KEY_MAX, KEY_TCP_MAX);
        if (vportMode) {
            this.selectiveAckDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.selectiveAckDataModel.getRadioButtonGroupDataModel().setEnable("COM_DISABLE", false);
            this.selectiveAckDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setSelectiveAck.size() == 1) {
            if (((Boolean)setSelectiveAck.iterator().next()).booleanValue()) {
                this.selectiveAckDataModel.setSelectRadioEnable();
            } else {
                this.selectiveAckDataModel.setSelectRadioDisable();
            }
        }
        if (vportMode) {
            this.delayedAckDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.delayedAckDataModel.getRadioButtonGroupDataModel().setEnable("COM_DISABLE", false);
            this.delayedAckDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setDelayedAck.size() == 1) {
            if (((Boolean)setDelayedAck.iterator().next()).booleanValue()) {
                this.delayedAckDataModel.setSelectRadioEnable();
            } else {
                this.delayedAckDataModel.setSelectRadioDisable();
            }
        }
        SJctrComboBoxDataModel maxWinSizeComboBox = this.maxWindowSizeDataModel.getComboBoxDataModel();
        if (vportMode) {
            maxWinSizeComboBox.setEnable(false);
            this.maxWindowSizeDataModel.getCheckBoxDataModel().setEnable(false);
            strMaxWinSize = "";
        } else if (setMaxWinSize.size() == 1) {
            strMaxWinSize = Integer.toString((Integer)setMaxWinSize.iterator().next());
            maxWinSizeComboBox.removeItem("");
        } else {
            strMaxWinSize = "";
        }
        maxWinSizeComboBox.setSelection(strMaxWinSize);
        SJctrComboBoxDataModel ethernetMtuSizeComboBox = this.ethernetMtuSizeDataModel.getComboBoxDataModel();
        if (vportMode) {
            ethernetMtuSizeComboBox.setEnable(false);
            this.ethernetMtuSizeDataModel.getCheckBoxDataModel().setEnable(false);
            strEthernetMtuSize = "";
        } else if (setEthernetMtuSize.size() == 1) {
            strEthernetMtuSize = Integer.toString((Integer)setEthernetMtuSize.iterator().next());
            ethernetMtuSizeComboBox.removeItem("");
        } else {
            strEthernetMtuSize = "";
        }
        ethernetMtuSizeComboBox.setSelection(strEthernetMtuSize);
        if (vportMode) {
            this.keepAliveTimerDataModel.getCheckBoxDataModel().setEnable(false);
            this.keepAliveTimerDataModel.getTextBoxDataModel().setEnable(false);
        } else if (setKeepAliveTimer.size() == 1) {
            this.keepAliveTimerDataModel.setTextboxValue(Integer.toString((Integer)setKeepAliveTimer.iterator().next()));
        }
        SJctrTextBoxDataModel keepAliveTextBox = this.keepAliveTimerDataModel.getTextBoxDataModel();
        Object keepAliveDataObject = keepAliveTextBox.getManageData();
        ((SJctrDataObject)keepAliveDataObject).setData(KEY_MIN, KEY_KAT_MIN);
        ((SJctrDataObject)keepAliveDataObject).setData(KEY_MAX, KEY_KAT_MAX);
        if (vportMode) {
            this.vlanDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.vlanDataModel.getRadioButtonGroupDataModel().setEnable("COM_DISABLE", false);
            this.vlanDataModel.getCheckBoxDataModel().setEnable(false);
            this.vlanDataModel.getTextBoxDataModel().setEnable(false);
        } else {
            if (setVlanTagging.size() == 1) {
                if (((Boolean)setVlanTagging.iterator().next()).booleanValue()) {
                    this.vlanDataModel.setSelectRadioEnable();
                } else {
                    this.vlanDataModel.setSelectRadioDisable();
                }
            }
            if (!this.vlanDataModel.isSelectedDisable()) {
                if (setVlanId.size() == 1) {
                    this.vlanDataModel.setTextboxValue(Integer.toString((Integer)setVlanId.iterator().next()));
                } else {
                    this.vlanDataModel.setTextboxValue("");
                }
            }
        }
        SJctrTextBoxDataModel vlanIdTextBox = this.vlanDataModel.getTextBoxDataModel();
        Object vlanIdDataObject = vlanIdTextBox.getManageData();
        ((SJctrDataObject)vlanIdDataObject).setData(KEY_MIN, KEY_MIN_ONE);
        ((SJctrDataObject)vlanIdDataObject).setData(KEY_MAX, KEY_VLAN_MAX);
        if (vportMode) {
            this.isnsServerDataModel.getRadioButtonGroupDataModel().setEnable("COM_ENABLE", false);
            this.isnsServerDataModel.getRadioButtonGroupDataModel().setEnable("COM_DISABLE", false);
            this.isnsServerDataModel.getCheckBoxDataModel().setEnable(false);
        } else if (setIsnsServerMode.size() == 1) {
            if (((Boolean)setIsnsServerMode.iterator().next()).booleanValue()) {
                this.isnsServerDataModel.setSelectRadioEnable();
                this.defaultIsnsMode = true;
            } else {
                this.isnsServerDataModel.setSelectRadioDisable();
            }
        }
        if (vportMode) {
            this.isnsIpAddrDataModel.getRadioButtonGroupDataModel().setEnable(false);
            this.isnsIpAddrDataModel.getCheckBoxDataModel().setEnable(false);
            this.isnsIpAddrDataModel.getTextBoxDataModel().setEnable(false);
            this.isnsTcpNumDataModel.getTextBoxDataModel().setEnable(false);
        }
        if (setIsnsIpType.size() == 1) {
            if ((Integer)setIsnsIpType.iterator().next() == 0) {
                this.isnsIpAddrDataModel.setSelectRadioIpv4();
            } else if ((Integer)setIsnsIpType.iterator().next() == 1) {
                this.isnsIpAddrDataModel.setSelectRadioIpv6();
            }
            if (setIsnsIpAddress.size() == 1) {
                this.isnsIpAddrDataModel.setTextboxValue((String)setIsnsIpAddress.iterator().next());
            }
            if (setIsnsTcpPortNumber.size() == 1) {
                this.isnsTcpNumDataModel.setTextboxValue(Integer.toString((Integer)setIsnsTcpPortNumber.iterator().next()));
            }
        }
        SJctrTextBoxDataModel isnsTcpPortNumTextBox = this.isnsTcpNumDataModel.getTextBoxDataModel();
        Object isnsTcpPortNumDataObject = isnsTcpPortNumTextBox.getManageData();
        ((SJctrDataObject)isnsTcpPortNumDataObject).setData(KEY_MIN, KEY_MIN_ONE);
        ((SJctrDataObject)isnsTcpPortNumDataObject).setData(KEY_MAX, KEY_TCP_MAX);
        if (setChapUserName.size() == 1) {
            this.chapUserNameDataModel.setTextboxValue((String)setChapUserName.iterator().next());
        }
    }

    private void selectPortAttributeComboBox() {
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        SJmoPortAttributeInfo firstPortAttributeInfo = this.targetPortAttributeInfoList.get(0);
        String attributeName = Byte.toString(firstPortAttributeInfo.getByPortKind());
        for (SJmoPortAttributeInfo portAttributeInfo : this.targetPortAttributeInfoList) {
            if (firstPortAttributeInfo.getByPortKind() == portAttributeInfo.getByPortKind()) continue;
            attributeName = "";
            portAttributeComboBox.clearSelection();
        }
        if (attributeName != "") {
            portAttributeComboBox.removeItem("");
        }
        portAttributeComboBox.setSelection(attributeName);
    }

    @Override
    public boolean checkEndData() {
        String chkUserName;
        Matcher matcherUserName;
        SJctrCheckBoxDataModel portAttributeCheckBox = (SJctrCheckBoxDataModel)this.portAttributeDataModel.getDataModel("COM_CHECKBOX");
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        SJctrCheckBoxDataModel portSpeedCheckBox = (SJctrCheckBoxDataModel)this.portSpeedDataModel.getDataModel("COM_CHECKBOX");
        SJctrComboBoxDataModel portSpeedComboBox = (SJctrComboBoxDataModel)this.portSpeedDataModel.getDataModel("COM_SPEED");
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJcRoleResourceContainer rolecontainer = authorizeContainer.getRoleResourceContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        boolean retpp = true;
        if (portAttributeCheckBox.isSelect() && !rolecontainer.checkAuthority(78)) {
            retpp = false;
        }
        if (retpp && this.portSecurityDataModel.getCheckBoxDataModel().isSelect()) {
            if (!rolecontainer.checkAuthority(79)) {
                retpp = false;
            }
            if (this.portSecurityDataModel.isSelectedEnable() && !ppcontainer.checkPP(SJctrLicenseContainer.PPID_LUNM)) {
                retpp = false;
            }
        }
        if (retpp && (portSpeedCheckBox.isSelect() || this.ipv4AddrDataModel.isSelectCheckBox() || this.ipv4SubnetDataModel.isSelectCheckBox() || this.ipv4GatewayDataModel.isSelectCheckBox() || this.ipv6ModeDataModel.isSelectCheckBox() || this.ipv6LocalAddrDataModel.isSelectCheckBox() || this.ipv6GlobalAddrDataModel.isSelectCheckBox() || this.ipv6GatewayDataModel.isSelectCheckBox() || this.ipv6GlobalAddr1DataModel.isSelectCheckBox() || this.ipv6GlobalAddr2DataModel.isSelectCheckBox()) && !rolecontainer.checkAuthority(80)) {
            retpp = false;
        }
        if (retpp && (this.chapUserNameDataModel.isSelectCheckBox() || this.secretDataModel.isSelectCheckBox()) && !rolecontainer.checkAuthority(81)) {
            retpp = false;
        }
        if (!retpp) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_NOT_AUTHORIZED);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.chapUserNameDataModel.isSelectCheckBox() && !(matcherUserName = patternChapUserName.matcher(chkUserName = this.chapUserNameDataModel.getTextboxValue())).matches()) {
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_CHAPUSERNAME);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.secretDataModel.isSelectCheckBox()) {
            String chkSecret = this.secretDataModel.getTextboxValue();
            Matcher matcherSecret = patternSecret.matcher(chkSecret);
            if (!matcherSecret.matches()) {
                SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_SECRET);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!this.secretDataModel.equalsReEnterSecret()) {
                SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_RE_ENTER_SECRET);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        List<?> modelPortLunInfoList = this.getCache(SJmoGetPortLunInfo.class);
        Collections.sort(modelPortLunInfoList);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.targetPortDetailList.size());
        boolean result = true;
        for (SJmoPortDetail targetPortDetail : this.targetPortDetailList) {
            if (portAttributeCheckBox.isSelect()) {
                String sSelectAttr = portAttributeComboBox.getSelection();
                if (sSelectAttr == null || sSelectAttr.length() == 0) {
                    SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
                    SJcException exp = err.createException();
                    throw exp;
                }
                int portLunInfoIndex = Collections.binarySearch(modelPortLunInfoList, targetPortDetail);
                if (portLunInfoIndex < 0) {
                    SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJmoPortLunInfo modelPortLunInfo = (SJmoPortLunInfo)modelPortLunInfoList.get(portLunInfoIndex);
                if (modelPortLunInfo.getAlPortLun().size() > 0) {
                    result = false;
                    SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_LUN_EXISTS);
                    SJmoPortIndex errKey = new SJmoPortIndex();
                    errKey.setSPort(targetPortDetail.getSPort());
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData(errKey, err);
                    errList.add(errColumn);
                }
            }
            if (!portSpeedCheckBox.isSelect()) continue;
            SJmoChaDetail chaDetail = this.portchaDataMap.get(targetPortDetail.getSPort());
            if (chaDetail == null) {
                SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV4);
                SJcException exp = err.createException();
                throw exp;
            }
            byte bySelectSpeed = Byte.valueOf(portSpeedComboBox.getSelection());
            byte byUserChannelSpeed = SJctrEditPortsKindAC.getUserChannelSpeedFromRmi(bySelectSpeed);
            if (byUserChannelSpeed == 3) continue;
            byte byRmiChannelSpeed = SJctrEditPortsKindAC.getChannelSpeedToRmi(byUserChannelSpeed, (byte)0);
            if (SJctrEditPortsKindAC.isSupportChannelSpeed(chaDetail.getByCHAPackageType(), targetPortDetail.getSFPDataTransferRate(), byRmiChannelSpeed)) continue;
            result = false;
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_NOT_SUPPORTED_SPEED);
            SJmoPortIndex errKey = new SJmoPortIndex();
            errKey.setSPort(targetPortDetail.getSPort());
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(errKey, err);
            errList.add(errColumn);
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(this.parentTbl, errList);
            SJctrError errInfo = ((SJctrErrorColumnData)errList.get(0)).getError();
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.createConfirmData();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SJctrEditIscsiPortsData createConfirmData() {
        SJcException exp;
        SJctrCheckBoxDataModel portAttributeCheckBox = (SJctrCheckBoxDataModel)this.portAttributeDataModel.getDataModel("COM_CHECKBOX");
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        SJctrCheckBoxDataModel portSpeedCheckBox = (SJctrCheckBoxDataModel)this.portSpeedDataModel.getDataModel("COM_CHECKBOX");
        SJctrComboBoxDataModel portSpeedComboBox = (SJctrComboBoxDataModel)this.portSpeedDataModel.getDataModel("COM_SPEED");
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>(this.targetPortDetailList.size());
        ArrayList<SJmoPortAttributeInfo> confirmPortAttributeInfoList = new ArrayList<SJmoPortAttributeInfo>(this.targetPortAttributeInfoList.size());
        for (SJmoPortDetail targetPortDetail : this.targetPortDetailList) {
            SJmoPortDetail createPortDetail;
            block91: {
                SJctrError err;
                SJcException exp2;
                block90: {
                    SJctrError err2;
                    block89: {
                        block88: {
                            createPortDetail = null;
                            try {
                                createPortDetail = (SJmoPortDetail)targetPortDetail.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                this.getLogUty().putlog("editPortsDC", "PortDetail clone fail", e, 40000);
                                continue;
                            }
                            if (this.ipv4AddrDataModel.isSelectCheckBox()) {
                                int[] iIpv4IPAddr = SJctrPortUtility.splitIPv4String(this.ipv4AddrDataModel.getTextboxValue());
                                createPortDetail.setIV4IPAddress(iIpv4IPAddr);
                            }
                            if (this.ipv4SubnetDataModel.isSelectCheckBox()) {
                                int[] iIpv4SubnetMask = SJctrPortUtility.splitIPv4String(this.ipv4SubnetDataModel.getTextboxValue());
                                createPortDetail.setIV4NetMaskAddress(iIpv4SubnetMask);
                            }
                            if (this.ipv4GatewayDataModel.isSelectCheckBox()) {
                                int[] iIpv4Gateway = SJctrPortUtility.splitIPv4String(this.ipv4GatewayDataModel.getTextboxValue());
                                createPortDetail.setIV4GateWayAddress(iIpv4Gateway);
                            }
                            if (!this.ipv6ModeDataModel.isSelectCheckBox()) break block88;
                            boolean bV6Mode = this.ipv6ModeDataModel.isSelectedEnable();
                            if (bV6Mode) {
                                int[] iIpv6IPAddr;
                                boolean inputAutoFlg;
                                createPortDetail.setBV6Mode(bV6Mode);
                                if (this.ipv6LocalAddrDataModel.isSelectCheckBox()) {
                                    inputAutoFlg = this.ipv6LocalAddrDataModel.isSelectedAuto();
                                    createPortDetail.setBV6LinkAddressMode(inputAutoFlg);
                                    if (!inputAutoFlg) {
                                        String ipv6LocalAddr = IPV6_LOCAL_HEARD + this.ipv6LocalAddrDataModel.getTextboxValue();
                                        int[] iIpv6IPAddr2 = this.splitIPv6String(ipv6LocalAddr);
                                        createPortDetail.setIV6LinkAddressManual(iIpv6IPAddr2);
                                    }
                                }
                                if (this.ipv6GlobalAddr1DataModel.isSelectCheckBox()) {
                                    inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                    createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                                    if (!inputAutoFlg) {
                                        iIpv6IPAddr = this.splitIPv6String(this.ipv6GlobalAddr1DataModel.getTextboxValue());
                                        createPortDetail.setIV6GlobalAddressManuals(iIpv6IPAddr);
                                    }
                                } else if (this.ipv6GlobalAddrDataModel.isSelectCheckBox()) {
                                    inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                    createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                                }
                                if (this.ipv6GlobalAddr2DataModel.isSelectCheckBox()) {
                                    inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                    createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                                    if (!inputAutoFlg) {
                                        iIpv6IPAddr = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                                        if (!this.ipv6GlobalAddr2DataModel.getTextboxValue().equals("::") && !this.ipv6GlobalAddr2DataModel.getTextboxValue().equals("")) {
                                            iIpv6IPAddr = this.splitIPv6String(this.ipv6GlobalAddr2DataModel.getTextboxValue());
                                        }
                                        createPortDetail.setIV6GlobalAddress2Manuals(iIpv6IPAddr);
                                    }
                                }
                                if (this.ipv6GatewayDataModel.isSelectCheckBox()) {
                                    int[] iIpv6Gateway = this.splitIPv6String(this.ipv6GatewayDataModel.getTextboxValue());
                                    createPortDetail.setIV6GateWayAddress(iIpv6Gateway);
                                }
                                break block89;
                            } else {
                                if (!this.ipv6ModeDataModel.isSelectedDisable()) {
                                    this.getLogUty().putlog("createConfirmData", "IPv6 is no check and Disable", 30000);
                                    SJctrError err3 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                                    SJcException exp3 = err3.createException();
                                    throw exp3;
                                }
                                createPortDetail.setBV6Mode(bV6Mode);
                            }
                            break block89;
                        }
                        if (this.defaultIPv6Mode) {
                            if (this.ipv6LocalAddrDataModel.isSelectCheckBox()) {
                                boolean inputAutoFlg = this.ipv6LocalAddrDataModel.isSelectedAuto();
                                createPortDetail.setBV6LinkAddressMode(inputAutoFlg);
                                if (!inputAutoFlg) {
                                    String strIpv6IPAddr = IPV6_LOCAL_HEARD + this.ipv6LocalAddrDataModel.getTextboxValue();
                                    int[] iIpv6IPAddr = this.splitIPv6String(strIpv6IPAddr);
                                    createPortDetail.setIV6LinkAddressManual(iIpv6IPAddr);
                                }
                            }
                            if (this.ipv6GlobalAddr1DataModel.isSelectCheckBox()) {
                                boolean inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                                if (!inputAutoFlg) {
                                    int[] iIpv6IPAddr = this.splitIPv6String(this.ipv6GlobalAddr1DataModel.getTextboxValue());
                                    createPortDetail.setIV6GlobalAddressManuals(iIpv6IPAddr);
                                }
                            } else if (this.ipv6GlobalAddrDataModel.isSelectCheckBox()) {
                                boolean inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                            }
                            if (this.ipv6GlobalAddr2DataModel.isSelectCheckBox()) {
                                boolean inputAutoFlg = this.ipv6GlobalAddrDataModel.isSelectedFirst();
                                createPortDetail.setBV6GlobalAddressMode(inputAutoFlg);
                                if (!inputAutoFlg) {
                                    int[] iIpv6IPAddr = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                                    if (!this.ipv6GlobalAddr2DataModel.getTextboxValue().equals("::") && !this.ipv6GlobalAddr2DataModel.getTextboxValue().equals("")) {
                                        iIpv6IPAddr = this.splitIPv6String(this.ipv6GlobalAddr2DataModel.getTextboxValue());
                                    }
                                    createPortDetail.setIV6GlobalAddress2Manuals(iIpv6IPAddr);
                                }
                            }
                            if (this.ipv6GatewayDataModel.isSelectCheckBox()) {
                                int[] iIpv6Gateway = this.splitIPv6String(this.ipv6GatewayDataModel.getTextboxValue());
                                createPortDetail.setIV6GateWayAddress(iIpv6Gateway);
                            }
                        } else if (this.targetPortDetailList.size() == 1) {
                            boolean checkBoxFlg = false;
                            checkBoxFlg |= this.ipv6LocalAddrDataModel.isSelectCheckBox();
                            checkBoxFlg |= this.ipv6GlobalAddrDataModel.isSelectCheckBox();
                            checkBoxFlg |= this.ipv6GlobalAddr1DataModel.isSelectCheckBox();
                            checkBoxFlg |= this.ipv6GlobalAddr2DataModel.isSelectCheckBox();
                            if (checkBoxFlg |= this.ipv6GatewayDataModel.isSelectCheckBox()) {
                                this.getLogUty().putlog("createConfirmData", "IPv6 is no check and Disable", 30000);
                                SJctrError err4 = new SJctrError(10, 22, EDITISCSIPORTS_MSG_IPV6_DISABLE);
                                SJcException exp4 = err4.createException();
                                throw exp4;
                            }
                        }
                    }
                    if (this.portSecurityDataModel.isSelectCheckBox()) {
                        if (!this.portSecurityDataModel.isSelectedEnable() && !this.portSecurityDataModel.isSelectedDisable()) {
                            this.getLogUty().putlog("createConfirmData", "Selective ACK isn't Selected", 30000);
                            SJctrError err5 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            SJcException exp5 = err5.createException();
                            throw exp5;
                        }
                        createPortDetail.setBPortSecuritySwitch(this.portSecurityDataModel.isSelectedEnable());
                    }
                    if (portSpeedCheckBox.isSelect()) {
                        String selectSpeed = portSpeedComboBox.getSelection();
                        if (selectSpeed == "") {
                            this.getLogUty().putlog("createConfirmData", "Selective ACK isn't Selected", 30000);
                            SJctrError err6 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp2 = err6.createException();
                            throw exp2;
                        }
                        byte speed = Byte.valueOf(selectSpeed);
                        createPortDetail.setByUserChannelSpeed(SJctrEditPortsKindAC.getUserChannelSpeedFromRmi(speed));
                        createPortDetail.setByDKCChannelSpeed((byte)0);
                    }
                    if (this.tcpPortNumberDataModel.isSelectCheckBox()) {
                        try {
                            createPortDetail.setITcpPortNumber(Integer.valueOf(this.tcpPortNumberDataModel.getTextboxValue()));
                        }
                        catch (Exception e) {
                            this.getLogUty().putlog("createConfirmData", "TCP Port Number has no data", 30000);
                            SJctrError err7 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp2 = err7.createException();
                            throw exp2;
                        }
                    }
                    if (this.selectiveAckDataModel.isSelectCheckBox()) {
                        boolean selectiveACKFlg = this.selectiveAckDataModel.isSelectedEnable();
                        if (!selectiveACKFlg && !this.selectiveAckDataModel.isSelectedDisable()) {
                            this.getLogUty().putlog("createConfirmData", "Selective ACK isn't Selected", 30000);
                            SJctrError err8 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp2 = err8.createException();
                            throw exp2;
                        }
                        createPortDetail.setBAvailableSelectiveACK(selectiveACKFlg);
                    }
                    if (this.delayedAckDataModel.isSelectCheckBox()) {
                        boolean delayedACKFlg = this.delayedAckDataModel.isSelectedEnable();
                        if (!delayedACKFlg && !this.delayedAckDataModel.isSelectedDisable()) {
                            this.getLogUty().putlog("createConfirmData", "Delayed ACK isn't Selected", 30000);
                            SJctrError err9 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp2 = err9.createException();
                            throw exp2;
                        }
                        createPortDetail.setBAvailableDelayedACK(delayedACKFlg);
                    }
                    if (this.maxWindowSizeDataModel.isSelectCheckBox()) {
                        String selection = this.maxWindowSizeDataModel.getSelectionComboBox();
                        try {
                            createPortDetail.setITcpWindowSize(Integer.valueOf(selection));
                        }
                        catch (Exception e) {
                            this.getLogUty().putlog("createConfirmData", "Maximum Window Size isn't Selected", 30000);
                            err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp = err.createException();
                            throw exp;
                        }
                    }
                    if (this.ethernetMtuSizeDataModel.isSelectCheckBox()) {
                        String selection = this.ethernetMtuSizeDataModel.getSelectionComboBox();
                        try {
                            createPortDetail.setIMtuSize(Integer.valueOf(selection));
                        }
                        catch (Exception e) {
                            this.getLogUty().putlog("createConfirmData", "Ethernet MTU Size isn't Selected", 30000);
                            err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp = err.createException();
                            throw exp;
                        }
                    }
                    if (this.keepAliveTimerDataModel.isSelectCheckBox()) {
                        String keepAliveTimer = this.keepAliveTimerDataModel.getTextboxValue();
                        try {
                            createPortDetail.setIKeepAliveTimer(Integer.valueOf(keepAliveTimer));
                        }
                        catch (Exception e) {
                            this.getLogUty().putlog("createConfirmData", "iSNS Server Mode is Disable", 30000);
                            err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp = err.createException();
                            throw exp;
                        }
                    }
                    if (this.vlanDataModel.isSelectCheckBox()) {
                        boolean bTaggingMode = this.vlanDataModel.isSelectedEnable();
                        createPortDetail.setBAvailableVlanTagging(bTaggingMode);
                        if (bTaggingMode) {
                            String vlanId = this.vlanDataModel.getTextboxValue();
                            try {
                                createPortDetail.setIVLANID(Integer.valueOf(vlanId));
                            }
                            catch (Exception e) {
                                this.getLogUty().putlog("createConfirmData", "VLAN isn't Selected", 30000);
                                err2 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                                SJcException exp6 = err2.createException();
                                throw exp6;
                            }
                        } else if (!this.vlanDataModel.isSelectedDisable()) {
                            this.getLogUty().putlog("createConfirmData", "Selective ACK isn't Selected", 30000);
                            SJctrError err10 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp2 = err10.createException();
                            throw exp2;
                        }
                    }
                    if (!this.isnsServerDataModel.isSelectCheckBox()) break block90;
                    boolean bIsnsMode = this.isnsServerDataModel.isSelectedEnable();
                    createPortDetail.setBIsnsServerMode(bIsnsMode);
                    if (bIsnsMode) {
                        if (this.isnsIpAddrDataModel.isSelectCheckBox()) {
                            boolean ipv4Flg = this.isnsIpAddrDataModel.isSelectedIpv4();
                            boolean ipv6Flg = this.isnsIpAddrDataModel.isSelectedIpv6();
                            if (ipv4Flg) {
                                createPortDetail.setIIsnsIpType(SJctrPortUtility.KEY_ISNS_TYPE_V4);
                                int[] ipv4Addr = SJctrPortUtility.splitIPv4String(this.isnsIpAddrDataModel.getTextboxValue());
                                createPortDetail.setIIsnsV4Address(ipv4Addr);
                            } else {
                                if (!ipv6Flg) {
                                    this.getLogUty().putlog("createConfirmData", "iSNS IPaddress isn't Selected", 30000);
                                    err2 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                                    SJcException exp7 = err2.createException();
                                    throw exp7;
                                }
                                createPortDetail.setIIsnsIpType(SJctrPortUtility.KEY_ISNS_TYPE_V6);
                                int[] ipv6Addr = this.splitIPv6String(this.isnsIpAddrDataModel.getTextboxValue());
                                createPortDetail.setIIsnsV6Address(ipv6Addr);
                            }
                        }
                        if (this.isnsTcpNumDataModel.isSelectCheckBox()) {
                            String isnsTcpPortNum = this.isnsTcpNumDataModel.getTextboxValue();
                            try {
                                createPortDetail.setIIsnsTcpPortNumber(Integer.valueOf(isnsTcpPortNum));
                            }
                            catch (Exception e) {
                                this.getLogUty().putlog("createConfirmData", "iSNS IPaddress isn't Selected", 30000);
                                err2 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                                SJcException exp8 = err2.createException();
                                throw exp8;
                            }
                        }
                        break block91;
                    } else if (!this.isnsServerDataModel.isSelectedDisable()) {
                        this.getLogUty().putlog("createConfirmData", "Selective ACK isn't Selected", 30000);
                        SJctrError err11 = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                        exp2 = err11.createException();
                        throw exp2;
                    }
                    break block91;
                }
                if (this.defaultIsnsMode) {
                    if (this.isnsIpAddrDataModel.isSelectCheckBox()) {
                        boolean ipv4Flg = this.isnsIpAddrDataModel.isSelectedIpv4();
                        boolean ipv6Flg = this.isnsIpAddrDataModel.isSelectedIpv6();
                        if (ipv4Flg) {
                            createPortDetail.setIIsnsIpType(SJctrPortUtility.KEY_ISNS_TYPE_V4);
                            int[] ipv4Addr = SJctrPortUtility.splitIPv4String(this.isnsIpAddrDataModel.getTextboxValue());
                            createPortDetail.setIIsnsV4Address(ipv4Addr);
                        } else {
                            if (!ipv6Flg) {
                                this.getLogUty().putlog("createConfirmData", "iSNS IPaddress isn't Selected", 30000);
                                err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                                exp = err.createException();
                                throw exp;
                            }
                            createPortDetail.setIIsnsIpType(SJctrPortUtility.KEY_ISNS_TYPE_V6);
                            int[] ipv6Addr = this.splitIPv6String(this.isnsIpAddrDataModel.getTextboxValue());
                            createPortDetail.setIIsnsV6Address(ipv6Addr);
                        }
                    }
                    if (this.isnsTcpNumDataModel.isSelectCheckBox()) {
                        String isnsTcpPortNum = this.isnsTcpNumDataModel.getTextboxValue();
                        try {
                            createPortDetail.setIIsnsTcpPortNumber(Integer.valueOf(isnsTcpPortNum));
                        }
                        catch (Exception e) {
                            this.getLogUty().putlog("createConfirmData", "iSNS IPaddress isn't Selected", 30000);
                            err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                            exp = err.createException();
                            throw exp;
                        }
                    }
                } else {
                    boolean checkBoxFlg = false;
                    checkBoxFlg |= this.isnsIpAddrDataModel.isSelectCheckBox();
                    if (checkBoxFlg |= this.isnsTcpNumDataModel.isSelectCheckBox()) {
                        this.getLogUty().putlog("createConfirmData", "iSNS Server Mode is Disable", 30000);
                        SJctrError err12 = new SJctrError(10, 22, EDITISCSIPORTS_MSG_ISNSSERVER_DISABLE);
                        exp2 = err12.createException();
                        throw exp2;
                    }
                }
            }
            if (this.chapUserNameDataModel.isSelectCheckBox()) {
                String strChapUserName = this.chapUserNameDataModel.getTextboxValue();
                createPortDetail.setStrUserName(strChapUserName);
            }
            if (this.secretDataModel.isSelectCheckBox()) {
                String strSecret = this.secretDataModel.getTextboxValue();
                createPortDetail.setStrSecret(strSecret);
            }
            confirmPortDetailList.add(createPortDetail);
        }
        Iterator<SJmoPortIndex> i$ = this.targetPortAttributeInfoList.iterator();
        while (true) {
            if (!i$.hasNext()) {
                Collections.sort(confirmPortDetailList);
                Collections.sort(confirmPortAttributeInfoList);
                Collections.sort(this.targetPortDetailList);
                SJctrEditIscsiPortsData confirmData = new SJctrEditIscsiPortsData();
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_ADDR, this.ipv4AddrDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_SUBNET, this.ipv4SubnetDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_GATEWAY, this.ipv4GatewayDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_MODE, this.ipv6ModeDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_LOCAL_ADDR, this.ipv6LocalAddrDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR, this.ipv6GlobalAddrDataModel.isSelectCheckBox() | this.ipv6GlobalAddr1DataModel.isSelectCheckBox() | this.ipv6GlobalAddr2DataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GATEWAY_ADDR, this.ipv6GatewayDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.ATTRIBUTE, portAttributeCheckBox.isSelect());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.SECURITY, this.portSecurityDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.SPEED, portSpeedCheckBox.isSelect());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.TCP_PORT_NUM, this.tcpPortNumberDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.SEL_ACK, this.selectiveAckDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.DEL_ACK, this.delayedAckDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.MAX_WIN_SIZE, this.maxWindowSizeDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.MTU_SIZE, this.ethernetMtuSizeDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.KEEP_ALIVE_TIMER, this.keepAliveTimerDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.VLAN, this.vlanDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.ISNS_IP, this.isnsIpAddrDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.ISNS_MODE, this.isnsServerDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.ISNS_TCP, this.isnsTcpNumDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.CHAP_USER_NAME, this.chapUserNameDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.SECRET, this.secretDataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR1, this.ipv6GlobalAddr1DataModel.isSelectCheckBox());
                confirmData.setCheckBoxStatus(SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR2, this.ipv6GlobalAddr2DataModel.isSelectCheckBox());
                confirmPortDetailList.trimToSize();
                confirmData.setPortDetailList(confirmPortDetailList);
                confirmPortAttributeInfoList.trimToSize();
                confirmData.setPortAttributeInfoList(confirmPortAttributeInfoList);
                confirmData.setBeforePortDetailList(this.targetPortDetailList);
                ArrayList<SJctrEditIscsiPortsData> confirmDataList = new ArrayList<SJctrEditIscsiPortsData>();
                confirmDataList.add(confirmData);
                this.putCache(SJctrEditIscsiPortsData.class, confirmDataList);
                return confirmData;
            }
            SJmoPortAttributeInfo targetPortAttr = (SJmoPortAttributeInfo)i$.next();
            SJmoPortAttributeInfo createPortAttr = null;
            try {
                createPortAttr = (SJmoPortAttributeInfo)targetPortAttr.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editPortsDC", "PortDetail clone fail", e, 40000);
                continue;
            }
            if (portAttributeCheckBox.isSelect()) {
                String selectAttribute = portAttributeComboBox.getSelection();
                try {
                    createPortAttr.setByPortKind(Byte.valueOf(selectAttribute));
                }
                catch (Exception e) {
                    this.getLogUty().putlog("createConfirmData", "iSNS Server Mode is Disable", 30000);
                    SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
                    exp = err.createException();
                    throw exp;
                }
            }
            confirmPortAttributeInfoList.add(createPortAttr);
        }
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean result = false;
        boolean isSecurityOn = false;
        if (this.portSecurityDataModel.isSelectCheckBox()) {
            if (this.portSecurityDataModel.isSelectedEnable()) {
                isSecurityOn = true;
            }
            for (SJmoPortDetail targetPortDetail : this.targetPortDetailList) {
                boolean targetSecurity = targetPortDetail.isBPortSecuritySwitch();
                if (targetSecurity == isSecurityOn) continue;
                int msgID = 0;
                msgID = isSecurityOn ? EDITISCSIPORTS_MSG_PORT_SECURITY_ON : EDITISCSIPORTS_MSG_PORT_SECURITY_OFF;
                String strFuncID = Integer.toString(201);
                String strModuleID = Integer.toString(22);
                String strMsgID = Integer.toString(msgID);
                SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
                SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
                SJctrUserController uc = this.getOwner();
                SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
                msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrEditIscsiPortsDC.this.checkEndData();
                        SJctrEditIscsiPortsDC.this.finishEvent(msgEvent, dstModel);
                    }
                });
                msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
                this.addUpdateDisp(related);
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private int[] splitIPv6String(String sIpv6Addr) {
        if (sIpv6Addr == null) {
            this.getLogUty().putlog("splitIPv6String", "parameter is null", 30000);
            SJctrError err = new SJctrError(10, 22, EDITISCSIPORTS_ERR_INVALID_DATA_LV7);
            SJcException exp = err.createException();
            throw exp;
        }
        int[] iIpv6Addr = new int[8];
        try {
            iIpv6Addr = SJctrIscsiUtility.splitIPv6String(sIpv6Addr);
        }
        catch (SJcException e) {
            this.getLogUty().putlog("splitIPv6String", "IPv6 check NG", 30000);
            SJctrError err = new SJctrError(201, 22, 105370);
            SJcException exp = err.createException();
            throw exp;
        }
        return iIpv6Addr;
    }
}

