/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editt10pimode;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrPortGroupInfo;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrT10PIKeyValueInfo;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrEditT10PIModeAC
extends SJctrApplyController {
    private static final int LUNM_BASE_TIME = 30;
    private static final int EDIT_TIME = 20;
    private List<SJmoPortDetail> portDtlList = Collections.emptyList();
    private List<SJctrPortGroupInfo> portGrpList = Collections.emptyList();
    protected SJctrError representativeError = null;
    protected Map<Short, SJctrError> portErrorMap = Collections.emptyMap();
    List<SJctrError> resultData = null;

    public SJctrEditT10PIModeAC(List<SJmoPortDetail> portDtlList, List<SJctrPortGroupInfo> portGrpList) {
        this.portDtlList = portDtlList;
        this.portGrpList = portGrpList;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            SanRequest requestData = supplier.newRequest("LUNMupdateT10pi");
            SanList reqPortList = requestData.newList("Ports");
            for (SJctrPortGroupInfo portGrp : this.portGrpList) {
                SanObject t10PIParam = reqPortList.addObj();
                SJmoPortIndex setPort = null;
                for (SJmoPortIndex relatedPort : portGrp.getRelatedPortList()) {
                    int index = Collections.binarySearch(this.portDtlList, (Object)relatedPort);
                    if (index < 0) continue;
                    setPort = relatedPort;
                    break;
                }
                if (setPort == null) continue;
                t10PIParam.putInt("Id", (int)setPort.getSPort());
                t10PIParam.putBoolean("T10pi", portGrp.getT10PIMode());
            }
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateT10pi)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateT10pi)");
            this.checkEditT10PIModeResult(resultObject);
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfaced error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    private void checkEditT10PIModeResult(Object resultObject) throws SanDataException {
        if (!(resultObject instanceof SanResponse)) {
            SJctrError err = new SJctrError(10, 22, 107001);
            throw err.createException();
        }
        SJctrLogUty.info(this.title, "checkEditT10PIModeResult", "get SanResponse.");
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null) {
            SanObject repErrorInfo = responseData.getObj("ErrorInfo");
            this.representativeError = SJctrT10PIKeyValueInfo.checkError(repErrorInfo);
            SJctrLogUty.info(this.title, "checkEditT10PIModeResult", "representativeError = ." + this.representativeError.getFunc() + "/" + this.representativeError.getModule() + "/" + this.representativeError.getError());
        }
        SanList EditT10PIPortList = responseData.getList("Ports");
        this.portErrorMap = new HashMap<Short, SJctrError>(this.portDtlList.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        for (SanObject EditT10PIPort : EditT10PIPortList) {
            SanObject errorInfo = EditT10PIPort.getObj("ErrorInfo");
            SJctrError err = SJctrT10PIKeyValueInfo.checkError(errorInfo);
            int portId = EditT10PIPort.getInt("Id");
            portIndex.setSPort((short)portId);
            SJctrLogUty.info(this.title, "checkEditT10PIModeResult", "Port = " + portId + ",err = " + err.getFunc() + "/" + err.getModule() + "/" + err.getError());
            SJctrPortGroupInfo chkPortGrp = null;
            for (SJctrPortGroupInfo portGrp : this.portGrpList) {
                if (!portGrp.containsPortGroup(portIndex)) continue;
                chkPortGrp = portGrp;
            }
            for (SJmoPortIndex relatedPort : chkPortGrp.getRelatedPortList()) {
                this.portErrorMap.put(relatedPort.getSPort(), err);
            }
        }
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        this.setError(this.representativeError);
        this.resultData = new ArrayList<SJctrError>(this.portDtlList.size());
        for (SJmoPortDetail portDtl : this.portDtlList) {
            SJctrError portError = this.portErrorMap.get(portDtl.getSPort());
            if (portError == null) {
                portError = new SJctrError(10, 22, 107001);
            }
            this.resultData.add(portError);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        return 30 + 20 * this.portGrpList.size();
    }
}

