/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edituuid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevCapacityLUSEColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrUuidColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.edituuid.SJctrEditUuidData;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;

public class SJctrEditUuidConfirmTableModel
extends SJctrTableDataModel {
    public static final String KEY_PTNAME = "COM_COL_PTNAME";
    public static final String KEY_LUNID = "COM_COL_LUNID";
    public static final String KEY_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_UUID = "COM_COL_UUID";
    public static final String KEY_EMUTYPE = "COM_COL_EMUTYPE";
    public static final String KEY_LDEVCAP = "COM_COL_LDEVCAP";
    public static final String KEY_TOTAL_CAPACITY = "COM_TOTAL_CAPACITY";

    public SJctrEditUuidConfirmTableModel() {
        super(false);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrEditUuidData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return new ArrayList();
        }
        SJctrEditUuidData editUuidData = (SJctrEditUuidData)confirmDataList.get(0);
        List<SJmoPortLunInfo> portLunInfoList = editUuidData.getPortLunInfoList();
        if (portLunInfoList == null || portLunInfoList.size() == 0) {
            return new ArrayList();
        }
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>();
        for (SJmoPortLunInfo portLunInfo : portLunInfoList) {
            ArrayList portLunDetailList = portLunInfo.getAlPortLun();
            for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
                SJctrPortLunTableKey tableKey = new SJctrPortLunTableKey(portLunInfo, portLunDetail);
                retList.add(tableKey);
            }
        }
        Collections.sort(retList);
        return retList;
    }

    @Override
    public void makeDataObject() {
        String totalCap = this.makeTotalCapacity();
        ((SJctrTblDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY, totalCap);
        super.makeDataObject();
    }

    private String makeTotalCapacity() {
        long totalCap = this.makeTotalCapacityLong();
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        String result = capUtil.toUnitString(totalCap);
        return result;
    }

    private long makeTotalCapacityLong() {
        long totalCap = 0L;
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCopyLunPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return 0L;
        }
        SJctrCopyLunPathsConfirmData confirmData = (SJctrCopyLunPathsConfirmData)confirmDataList.get(0);
        List<SJctrPortLunTableKey> portLunList = confirmData.getSelectPathList();
        if (portLunList == null || portLunList.size() == 0) {
            return 0L;
        }
        List<SJctrLdevDetailLUSEInfo> ldevDtlList = confirmData.getLdevDetailList();
        if (ldevDtlList == null || ldevDtlList.size() == 0) {
            return 0L;
        }
        for (SJctrPortLunTableKey portLun : portLunList) {
            SJmoPortLunDetail portlunDtl = portLun.getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(portlunDtl.getSLDKC(), portlunDtl.getSCU(), portlunDtl.getSLDEV());
            Collections.sort(ldevDtlList);
            int index = Collections.binarySearch(ldevDtlList, ldevIndex);
            if (index < 0) continue;
            SJctrLdevDetailLUSEInfo ldevDtl = ldevDtlList.get(index);
            totalCap += ldevDtl.getLTotalLBASize();
        }
        return totalCap;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromPortLunTableKey(KEY_PTNAME));
        this.addColumn(new SJctrLunIdColumnFromPortLunTableKey(KEY_LUNID));
        this.addColumn(new SJctrLdevIdColumnFromPortLunTableKey(KEY_LDEVID));
        this.addColumn(new SJctrLdevNameColumnFromPortLunTableKey(KEY_LDEVNAME));
        this.addColumn(new SJctrUuidColumnFromPortLunTableKey(KEY_UUID));
        SJctrEmulationTypeColumnFromPortLunTableKey emuType = new SJctrEmulationTypeColumnFromPortLunTableKey(KEY_EMUTYPE);
        if (SJctrDataController.isHM()) {
            emuType.setSupportColumn(false);
        }
        this.addColumn(emuType);
        this.addColumn(new SJctrLdevCapacityLUSEColumnFromPortLunTableKey(KEY_LDEVCAP));
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrEditUuidData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            this.getLogUty().putlog("setModelData", "confirmData not found");
            return;
        }
        SJctrEditUuidData confirmData = (SJctrEditUuidData)confirmDataList.get(0);
        this.setBasicData(SJmoGetPortDetail.class, confirmData.getPortDetailList());
        this.setBasicData(SJmoGetPortLunInfo.class, confirmData.getPortLunInfoList());
        this.setBasicData(SJmoGetLdevDetail.class, confirmData.getLdevDetailList());
        this.setBasicData(SJctrLdevDetailLUSEInfo.class, confirmData.getLdevDetailList());
        this.setBasicData(SJmoLdevUuidInfo.class, confirmData.getLdevUuidInfoList());
        this.setBasicData(SJmoHostGroupInfo.class, confirmData.getHostGroupInfoList());
        this.setBasicData(SJmoGetLdevNicknameInfo.class, confirmData.getLdevNicknameInfoList());
    }
}

