/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrOperationIscsiBaseAC;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;

public abstract class SJctrOperationIscsiPathBaseAC
extends SJctrOperationIscsiBaseAC {
    private static final long serialVersionUID = 1931511044698373031L;
    protected List<? extends SJmoIscsiTargetPathInfo> applyInfo = new ArrayList<SJmoIscsiTargetPathInfo>();
    protected String functionKey = "";

    protected SanRequest setRequestParam() throws SanDataException {
        SanRequest request = SJdsSupplierMgr.getSupplierMgr().getAgent().newRequest(this.functionKey);
        if (this.functionKey.equals("iSCSIcreateiScsiPaths") || this.functionKey.equals("iSCSIupdateRemoteTargetUsers")) {
            request.putBoolean("ConnectionTest", true);
        }
        SanList reqPortList = request.newList("iScsiPaths");
        for (SJmoIscsiTargetPathInfo sJmoIscsiTargetPathInfo : this.applyInfo) {
            SanObject reqPathObj = reqPortList.addObj();
            SanObject localObj = reqPathObj.newObj("iScsiPort");
            localObj.putInt("Id", (int)sJmoIscsiTargetPathInfo.getSPort());
            if (sJmoIscsiTargetPathInfo.getIVirtualPortID() != -1) {
                SanObject virtualObj = localObj.newObj("iScsiVirtualPort");
                virtualObj.putInt("Id", sJmoIscsiTargetPathInfo.getIVirtualPortID());
            }
            SanObject remotePortObj = reqPathObj.newObj("RemoteiScsiPort");
            this.setRemotePortParam(remotePortObj, sJmoIscsiTargetPathInfo);
        }
        return request;
    }

    private void setRemotePortParam(SanObject remotePortObj, SJmoIscsiTargetPathInfo pathInfo) throws SanDataException {
        if (this.functionKey.equals("iSCSIcreateiScsiPaths") || this.functionKey.equals("iSCSIdeleteiScsiPaths")) {
            remotePortObj.putInt("Function", 0);
        }
        int ipType = pathInfo.getIIpType();
        remotePortObj.putInt("IpType", ipType);
        if (ipType == 0) {
            remotePortObj.putIntArray("Ipv4Address", pathInfo.getIIpv4Address());
        } else if (ipType == 1) {
            remotePortObj.putIntArray("Ipv6Address", pathInfo.getIIpv6Address());
        }
        if (this.functionKey.equals("iSCSIcreateiScsiPaths") || this.functionKey.equals("iSCSIupdateRemoteTargetUsers")) {
            remotePortObj.putInt("TcpPortNumber", pathInfo.getITcpPortNumber());
        }
        SanObject remoteTargetObj = remotePortObj.newObj("RemoteiScsiTarget");
        remoteTargetObj.putString("Name", pathInfo.getStrTargetName());
        this.setChapUserParam(remoteTargetObj, pathInfo);
    }

    private void setChapUserParam(SanObject remoteObj, SJmoIscsiTargetPathInfo pathInfo) throws SanDataException {
        if (this.functionKey.equals("iSCSIcreateiScsiPaths") || this.functionKey.equals("iSCSIupdateRemoteTargetUsers")) {
            SanObject userObj = remoteObj.newObj("iScsiUser");
            int iswitch = pathInfo.getIAuthentSwitch();
            userObj.putInt("AuthSwitch", iswitch);
            int iAuth = pathInfo.getIAuthentMode();
            userObj.putInt("AuthMode", iAuth);
            if (iswitch == 1) {
                if (pathInfo.getStrTargetUserName() != null && !pathInfo.getStrTargetUserName().equals("")) {
                    userObj.putString("UserId", pathInfo.getStrTargetUserName());
                }
                if (pathInfo.getStrTargetSecret() != null && !pathInfo.getStrTargetSecret().equals("")) {
                    userObj.putString("Secret", pathInfo.getStrTargetSecret());
                }
            }
        }
    }

    @Override
    protected void setDetailError(SanResponse resultObject) throws SanDataException {
        SanList iScsiPathList = resultObject.getList("iScsiPaths");
        if (null == iScsiPathList) {
            SJctrLogUty.info(this.title, "setDetailError", "iScsiPortList is null.");
        } else {
            for (int i = 0; i < iScsiPathList.size(); ++i) {
                SanObject iScsiPath = iScsiPathList.getObj(i);
                SanObject errInfo = iScsiPath.getObj("ErrorInfo");
                int[] errMsgId = errInfo.getIntArray("MessageId");
                if (0 == errMsgId[1]) continue;
                SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId, i);
                this.resultData.add(iscsiError);
            }
        }
    }

    @Override
    public int getLeadTime() {
        int leadTime = SJctrIscsiUtility.getLeadTime(this.applyInfo.size(), 8.0, 2010.0);
        return leadTime;
    }
}

