/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.comparator.SJctrRsgInfoRsgNameComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrHostModeOptionTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.SJctrAddNewIscsiHostsDialogDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.addnewchapuser.SJctrAddNewChapUserDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameInfoIncludeNewHost;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrAddPortChapUserErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrAddPortHostErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsAddErrMgr;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsAvailableChapUsersTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsAvailableHostTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsAvailablePortTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsHostModeOptTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsRsgDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsSelectedTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrPortIscsiTargetData;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLoginIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilIscsiTarget;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLoginIscsiNameInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilIscsiTarget;

public class SJctrCreateIscsiTargetsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1006101;
    private static final String DISP_TITLE = "CREATE_ISCSI_TARGETS";
    private static final String KEY_USE_DEF_NAME_TGTALIAS_CHK = "COM_USE_DEF_NAME_TGTALIAS";
    private static final String KEY_TGT_ALIAS_TXT = "COM_ISCSI_TGTALIAS";
    private static final String KEY_TGT_NAME_RADIO = "COM_ISCSI_TGTNAME_TYPE";
    private static final String KEY_USE_DEF_NAME_CHK = "COM_USE_DEF_NAME";
    private static final String KEY_TGT_NAME_TXT = "COM_ISCSI_TGTNAME";
    private static final String KEY_RSG_LIST = "COM_RSGNAME";
    private static final String KEY_HM_LIST = "COM_ISCSI_HOST_MODE";
    private static final String KEY_HM_OPT_TABLE = "COM_TABLE_ISCSI_HOSTMODE_OPT";
    private static final String KEY_HOST_TABLE = "COM_TABLE_HOST";
    public static final String KEY_PORT_TABLE = "COM_TABLE_PORT";
    private static final String KEY_CHAP_AUTH_LIST = "COM_CHAP_AUTH";
    private static final String KEY_AUTH_MODE_RADIO = "COM_AUTH_MODE";
    private static final String KEY_USER_NAME_TXT = "COM_CHAP_USERNAME";
    private static final String KEY_SECRET_TXT = "COM_CHAP_SECRET";
    private static final String KEY_REENT_TXT = "COM_CHAP_SECRET_REENT";
    private static final String KEY_CHAP_USER_TABLE = "COM_TABLE_CHAP_USER";
    private static final String KEY_RADIO_IQN = "COM_IQN";
    private static final String KEY_RADIO_EUI = "COM_EUI";
    private static final String KEY_RADIO_UNIDIRECT = "COM_UNIDIRECTIONAL";
    private static final String KEY_RADIO_MUTUAL = "COM_MUTUAL";
    private static final String KEY_ENABLE = "COM_ENABLE";
    private static final String KEY_DISABLE = "COM_DISABLE";
    private static final String KEY_ADDNEWHOST = "COM_ADDNEWHOST";
    private static final String KEY_ADDNEWCHAPUSER = "COM_ADDNEWCHAPUSER";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_DETAIL = "COM_DETAIL";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_TABLE_SEL = "COM_TABLE_SEL_ISCSI_TARGET";
    private static final String KEY_COM_CHAP_AUTHE_INFO = "COM_CHAP_AUTHE_INFO";
    private static final String KEY_COM_CHAP_AUTHE = "COM_CHAP_AUTHE";
    private static final String KEY_CHAP_USER_TABLE_INFO = "CHAP_USER_TABLE_INFO";
    private static final int CHAP_AUTHE_DISABLE = 1;
    private static final int CHAP_AUTHE_NOT_DISABLE = 0;
    private static final String HM_RESERVE_FORMAT = "[0-9A-F]+ \\[Reserve\\]";
    private static final String KEY_ENABLE_ISCSI_PORT = "ENABLE_ISCSI_PORT";
    private List<SJmoPortIscsiTargetInfo> originIscsiTarget = null;
    private List<SJmoPortDetail> portDetail = null;
    private List<SJmoPortIscsiTargetInfo> targetPortIscsi = null;
    private SJmoSubsystemInfo subsystemInfo = null;
    private TreeMap<Short, SJctrError> errMap = new TreeMap();
    private SJctrResourceGroupUtility rsgUtil = null;
    private SJctrCreateIscsiTargetsRsgDataModel rsgDataModel = null;
    private Map<Short, SJctrPortIscsiTargetData> definedData = null;
    private static boolean chapAuthDisableFlag = false;
    private boolean initializeChapFlag = true;

    public SJctrCreateIscsiTargetsDC() throws SJcException {
        super(0x1006101);
        this.initDataModel();
        this.initListener();
        this.definedData = new HashMap<Short, SJctrPortIscsiTargetData>();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLoginIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortChapUserInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJctrGetSystemOption();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilIscsiTarget();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_USE_DEF_NAME_TGTALIAS_CHK, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), CREATE_TGT_MSG.SEL_DEF_NAME_ALIAS));
        this.addDataObjectModel(KEY_TGT_ALIAS_TXT, new SJctrTextBoxDataModel());
        SJctrRadioButtonGroupDataModel targetNameRadio = new SJctrRadioButtonGroupDataModel();
        targetNameRadio.add(KEY_RADIO_IQN);
        targetNameRadio.add(KEY_RADIO_EUI);
        this.addDataObjectModel(KEY_TGT_NAME_RADIO, SJctrIscsiUtility.addItemSelectEventListener(targetNameRadio, CREATE_TGT_MSG.SEL_TARGET));
        this.addDataObjectModel(KEY_USE_DEF_NAME_CHK, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), CREATE_TGT_MSG.SEL_DEF_NAME));
        this.addDataObjectModel(KEY_TGT_NAME_TXT, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_RSG_LIST, new SJctrCreateIscsiTargetsRsgDataModel());
        this.addDataObjectModel(KEY_HM_LIST, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), CREATE_TGT_MSG.SEL_HOST_MODE));
        this.addDataObjectModel(KEY_HM_OPT_TABLE, new SJctrCreateIscsiTargetsHostModeOptTableModel());
        this.addDataObjectModel(KEY_ENABLE, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), CREATE_TGT_MSG.SEL_ENABLE));
        this.addDataObjectModel(KEY_DISABLE, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), CREATE_TGT_MSG.SEL_DISABLE));
        this.addDataObjectModel(KEY_HOST_TABLE, new SJctrCreateIscsiTargetsAvailableHostTableModel());
        this.addDataObjectModel(KEY_ADDNEWHOST, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), CREATE_TGT_MSG.SEL_ADD_HOST));
        this.addDataObjectModel(KEY_PORT_TABLE, new SJctrCreateIscsiTargetsAvailablePortTableModel());
        this.addDataObjectModel(KEY_CHAP_AUTH_LIST, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), CREATE_TGT_MSG.SEL_CHAP_AUTH));
        SJctrRadioButtonGroupDataModel authModeRadio = new SJctrRadioButtonGroupDataModel();
        authModeRadio.add(KEY_RADIO_UNIDIRECT);
        authModeRadio.add(KEY_RADIO_MUTUAL);
        this.addDataObjectModel(KEY_AUTH_MODE_RADIO, SJctrIscsiUtility.addItemSelectEventListener(authModeRadio, CREATE_TGT_MSG.SEL_AUTH_MODE));
        this.addDataObjectModel(KEY_USER_NAME_TXT, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_SECRET_TXT, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_REENT_TXT, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_CHAP_USER_TABLE, new SJctrCreateIscsiTargetsAvailableChapUsersTableModel());
        this.addDataObjectModel(KEY_ADDNEWCHAPUSER, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), CREATE_TGT_MSG.SEL_ADD_CHAP));
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.setReceiveOnly();
        addButton.setRollBackCheck(true);
        this.addDataObjectModel(KEY_ADD, SJctrIscsiUtility.addItemSelectEventListener(addButton, CREATE_TGT_MSG.SEL_ADD));
        this.addDataObjectModel(KEY_TABLE_SEL, new SJctrCreateIscsiTargetsSelectedTableModel());
        this.addDataObjectModel(KEY_DETAIL, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), CREATE_TGT_MSG.SEL_DETAIL));
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        addButton.setReceiveOnly();
        addButton.setRollBackCheck(true);
        this.addDataObjectModel(KEY_REMOVE, SJctrIscsiUtility.addItemSelectEventListener(removeButton, CREATE_TGT_MSG.SEL_REMOVE));
        this.addDataObjectModel(KEY_COM_CHAP_AUTHE_INFO, new SJctrSimpleDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_DEF_NAME_ALIAS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionIscsiTargetAlias(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_TARGET, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionIscsiTargetName(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_DEF_NAME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionIscsiTargetName(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_HOST_MODE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionHostModePullDown(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_ENABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionHostModeOptBtn(event, dstModel, 1);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_DISABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionHostModeOptBtn(event, dstModel, 0);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_ADD_HOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionAddNewHost(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_CHAP_AUTH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionChapAuthe(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_AUTH_MODE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionAuthMode(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_ADD_CHAP, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionAddNewChapUser(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionAdd(event, dstModel);
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionDetail(event, dstModel);
            }
        });
        this.addMessageEventListener(CREATE_TGT_MSG.SEL_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsDC.this.actionRemove(event, dstModel);
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrCreateIscsiTargetsDC.this.exitSelectIscsiTarget(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> portIndexlList = this.getCache("KEY_SELECTED_PORT_ID");
        if (portIndexlList != null && portIndexlList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Not Found SJmoPortIndex");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoPortIndex> portIndexlList = this.getCache("KEY_SELECTED_PORT_ID");
            this.portDetail = SJctrIscsiUtility.getSJmoPortDetailList(this);
            List<SJmoPortIscsiTargetInfo> portIscsiTargetList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            List<SJmoPortIscsiNameInfo> portIscsiNameList = SJctrIscsiUtility.getSJmoPortIscsiNameInfoList(this);
            List<SJmoPortLoginIscsiNameInfo> portLoginIscsiNameList = SJctrIscsiUtility.getSJmoPortLoginIscsiNameInfoList(this);
            List<SJmoPortChapUserInfo> portChapUserList = SJctrIscsiUtility.getSJmoPortChapUserInfoList(this);
            List<SJmoRSGgetAllRsgs> rsgDetailList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this);
            this.subsystemInfo = SJctrIscsiUtility.getSJmoSubsystemInfo(this);
            boolean transferFlag = false;
            if (portIndexlList == null) {
                portIndexlList = portIscsiTargetList;
            } else {
                transferFlag = true;
            }
            if (transferFlag) {
                List<Object> targetList = this.getAvailableInfoList(portIndexlList, portIscsiTargetList, this.errMap);
                this.targetPortIscsi = targetList;
                Collections.sort(this.targetPortIscsi);
            } else {
                this.targetPortIscsi = portIscsiTargetList;
            }
            this.checkIscsiTargetMaxNum(this.targetPortIscsi, this.errMap);
            boolean remainPortFlag = true;
            Set<Short> portNum = this.errMap.keySet();
            if (portNum.size() >= portIndexlList.size()) {
                remainPortFlag = false;
            }
            this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgDetailList.get(0));
            List<SJmoPortIscsiTargetInfo> targetPortIscsiRsg = this.getAvailableIscsiTargetRsgList(this.targetPortIscsi, this.rsgUtil, true);
            if (remainPortFlag && transferFlag) {
                this.checkPortIscsiTargetId(portIndexlList, this.rsgUtil);
            }
            List<SJmoPortDetail> availablePortList = this.makePortTableList(targetPortIscsiRsg, this.portDetail, this.errMap);
            Collections.sort(availablePortList);
            if (!transferFlag && availablePortList.size() == 0) {
                SJctrError err = new SJctrError(12, 22, 206240);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!remainPortFlag) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Can't find port to create iSCSI targets!!");
                SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
                SJctrUserController uc = this.getWizardWindow().getOwner();
                SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
                ArrayList<SJmoPortDetail> errBasicList = new ArrayList<SJmoPortDetail>();
                ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>();
                for (Short portErrorInfo : portNum) {
                    SJctrError errElement = this.errMap.get(portErrorInfo);
                    SJmoPortDetail onePortDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortId(this.portDetail, portErrorInfo);
                    if (onePortDetail == null) continue;
                    errBasicList.add(onePortDetail);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(onePortDetail, errElement);
                    newErrList.add(errData);
                }
                SJctrCreateIscsiTargetsAvailablePortTableModel errTbl = new SJctrCreateIscsiTargetsAvailablePortTableModel();
                errTbl.setDataController(this);
                errTbl.setPaging(false);
                errTbl.setBasicDataList(errBasicList);
                errTbl.initGuidance(this.getComUtility());
                errTbl.createModelDirect();
                errTbl.divideModelData(this.getProxy().getModelDataMap());
                errTbl.makeDataModel();
                errDC.setParameter(errTbl, newErrList);
                SJctrError err = errDC.getRepresentativeError(newErrList, 4);
                SJcException exp = err.createException();
                exp.setErrDisp(errDisp);
                throw exp;
            }
            this.makeDefineData(portIscsiTargetList);
            this.getProxy().putCache(KEY_ENABLE_ISCSI_PORT, availablePortList);
            this.initializeHostTable(portIscsiNameList, portLoginIscsiNameList);
            this.initializePortTable(availablePortList);
            this.initializeChapUserTable(portChapUserList);
            this.initializeHostModeOptionTable();
            this.initializeIscsiTargetAliasArea();
            this.initializeIscsiTargetNameArea();
            this.initializeRsgArea(this.rsgUtil);
            this.initializeHostModeArea();
            this.initializeChapAuthArea();
            this.initializeAuthModeArea();
            this.initializeUserNameArea();
            this.initializeSecretArea();
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrCreateIscsiTargetsConfirmData confirmData = new SJctrCreateIscsiTargetsConfirmData();
            SJctrCreateIscsiTargetsSelectedTableModel selectedIscsiTargetList = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
            List<Object> rowData = selectedIscsiTargetList.getAllRowData();
            Collections.sort(rowData, new SJctrIscsiTargetAliasComparator());
            confirmData.setIscsiTargetList(rowData);
            confirmData.setNeedData(this);
            ArrayList<SJctrCreateIscsiTargetsConfirmData> confirmDataList = new ArrayList<SJctrCreateIscsiTargetsConfirmData>();
            confirmDataList.add(confirmData);
            this.getProxy().putCache(SJctrCreateIscsiTargetsConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrCreateIscsiTargetsSelectedTableModel tableInfo = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
        List<Object> iscsiTargetList = tableInfo.getAllRowData();
        Collections.sort(iscsiTargetList);
        List<SJmoPortDetail> portDetail = this.getCache(SJmoGetPortDetail.class);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrIscsiUtility iscsiUtil = comUtil.getIscsiUtility();
        iscsiUtil.checkPortSecurityMsg(portDetail, iscsiTargetList, this);
        return false;
    }

    private List<Object> getAvailableInfoList(List<SJmoPortIndex> portList, List<SJmoPortIscsiTargetInfo> infoList, TreeMap<Short, SJctrError> errMap) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (SJmoPortIndex portIndexInfo : portList) {
            int searchRet = Collections.binarySearch(infoList, portIndexInfo);
            if (searchRet >= 0) {
                retVal.add(infoList.get(searchRet));
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAvailableInfoList", "Not Found port#=" + portIndexInfo.getSPort());
            SJctrError errElement = new SJctrError(12, 22, 206513);
            errMap.put(portIndexInfo.getSPort(), errElement);
        }
        return retVal;
    }

    private boolean checkIscsiTargetMaxNum(List<SJmoPortIscsiTargetInfo> portIscsiTargetList, TreeMap<Short, SJctrError> errMap) {
        boolean ret = true;
        for (SJmoPortIscsiTargetInfo portIscsiTargetInfo : portIscsiTargetList) {
            ArrayList<SJmoIscsiTargetInfo> targetList;
            short portId = portIscsiTargetInfo.getSPort();
            if (errMap.containsKey(portId) || (targetList = portIscsiTargetInfo.getAlPortIscsiTarget()).size() < SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkIscsiTargetMaxNum", "No more iscsi targets can be registered in the port. Port#=" + portId);
            SJctrError errElement = new SJctrError(12, 22, 206239);
            errMap.put(portId, errElement);
            ret = false;
        }
        return ret;
    }

    private List<SJmoPortIscsiTargetInfo> getAvailableIscsiTargetRsgList(List<SJmoPortIscsiTargetInfo> portIscsiTargetList, SJctrResourceGroupUtility rsgUtil, boolean firstCheckFlag) {
        ArrayList<SJmoPortIscsiTargetInfo> resultList = new ArrayList<SJmoPortIscsiTargetInfo>();
        List<?> portDetail = this.getCache(SJmoGetPortDetail.class);
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        boolean isAnyFlag = true;
        if (!firstCheckFlag && this.rsgDataModel != null) {
            String key = this.rsgDataModel.getSelection();
            isAnyFlag = key.equals("Any");
        }
        for (SJmoRSGgetRsg rsgInfo : rsgList) {
            ArrayList<SJmoPortIndex> portIndexList = rsgInfo.getPorts();
            for (SJmoPortIndex portIndex : portIndexList) {
                int searchIscsi;
                int searchPort = Collections.binarySearch(portDetail, portIndex);
                if (searchPort < 0 || ((SJmoPortDetail)portDetail.get(searchPort)).getByPortKindNo() != 5 || (searchIscsi = Collections.binarySearch(portIscsiTargetList, portIndex)) < 0) continue;
                boolean loopFlg = true;
                if (!firstCheckFlag && this.rsgDataModel != null && !isAnyFlag) {
                    String key = this.rsgDataModel.getSelection();
                    boolean bl = loopFlg = Integer.valueOf(key).intValue() == rsgInfo.getRsgInfo().getRsgId();
                }
                if (!loopFlg) continue;
                resultList.add(portIscsiTargetList.get(searchIscsi));
            }
        }
        return resultList;
    }

    private void checkPortIscsiTargetId(List<SJmoPortIndex> portList, SJctrResourceGroupUtility rsgUtil) {
        SJmoHostGroupIndex hostGroupIndex = new SJmoHostGroupIndex();
        block0: for (SJmoPortIndex ptIndex : portList) {
            hostGroupIndex.setSPort(ptIndex.getSPort());
            for (short index = 0; index < SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX; index = (short)(index + 1)) {
                hostGroupIndex.setSHostGroup(index);
                boolean rsgFlg = SJctrIscsiUtility.isRsgHostGroupIndex(hostGroupIndex, rsgUtil);
                if (rsgFlg) continue block0;
                if (index != SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX - 1) continue;
                throw SJctrIscsiUtility.makeException(206199);
            }
        }
    }

    private List<SJmoPortDetail> makePortTableList(List<SJmoPortIscsiTargetInfo> portIscsiTargetList, List<SJmoPortDetail> portDetailList, TreeMap<Short, SJctrError> errMap) {
        ArrayList<SJmoPortDetail> portList = new ArrayList<SJmoPortDetail>();
        for (SJmoPortIscsiTargetInfo portIscsiTargetInfo : portIscsiTargetList) {
            short portId = portIscsiTargetInfo.getSPort();
            if (errMap.containsKey(portId)) continue;
            int searchRet = Collections.binarySearch(portDetailList, portIscsiTargetInfo);
            if (searchRet >= 0) {
                portList.add(portDetailList.get(searchRet));
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPortDetail", "Not Found Port-Detail. Port#= " + portId);
            throw SJctrIscsiUtility.makeException(206512);
        }
        return portList;
    }

    private void makeDefineData(List<SJmoPortIscsiTargetInfo> portIscsiTargetList) {
        ArrayList<SJctrChapUserInfoIncludeNewChap> chapList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        for (SJmoPortIscsiTargetInfo portIscsiTargetInfo : portIscsiTargetList) {
            SJctrPortIscsiTargetData iscsiTargetData = new SJctrPortIscsiTargetData();
            ArrayList<SJmoIscsiTargetInfo> targetList = portIscsiTargetInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo targetInfo : targetList) {
                SJctrCreateIscsiTargetInfo newTargetInfo = new SJctrCreateIscsiTargetInfo(targetInfo, chapList);
                iscsiTargetData.addIscsiTarget(newTargetInfo);
            }
            this.definedData.put(portIscsiTargetInfo.getSPort(), iscsiTargetData);
        }
    }

    private void initializeHostTable(List<SJmoPortIscsiNameInfo> portiscsiNameList, List<SJmoPortLoginIscsiNameInfo> portLoginIscsiNameList) {
        SJctrIscsiNameInfoIncludeNewHost hostInfo;
        ArrayList<SJmoIscsiName> iscsiNameList;
        ArrayList<SJctrIscsiNameInfoIncludeNewHost> retList = new ArrayList<SJctrIscsiNameInfoIncludeNewHost>();
        SJctrCreateIscsiTargetsAvailableHostTableModel hostTable = (SJctrCreateIscsiTargetsAvailableHostTableModel)this.getDataObjectModel(KEY_HOST_TABLE);
        HashSet<String> setIscsiNameList = new HashSet<String>();
        for (SJmoPortIscsiNameInfo portIscsiNameInfo : portiscsiNameList) {
            iscsiNameList = portIscsiNameInfo.getAlPortIscsiName();
            for (SJmoIscsiName iscsiName : iscsiNameList) {
                hostInfo = new SJctrIscsiNameInfoIncludeNewHost(iscsiName, false);
                if (!setIscsiNameList.add(hostInfo.toString())) continue;
                retList.add(hostInfo);
            }
        }
        for (SJmoPortLoginIscsiNameInfo portLoginIscsiNameInfo : portLoginIscsiNameList) {
            iscsiNameList = portLoginIscsiNameInfo.getAlPortIscsiName();
            for (SJmoIscsiName iscsiName : iscsiNameList) {
                hostInfo = new SJctrIscsiNameInfoIncludeNewHost(iscsiName, false);
                if (!setIscsiNameList.add(hostInfo.toString())) continue;
                retList.add(hostInfo);
            }
        }
        Collections.sort(retList);
        hostTable.setBasicDataList(retList);
    }

    private void initializePortTable(List<SJmoPortDetail> portDetailList) {
        SJctrCreateIscsiTargetsAvailablePortTableModel portTable = (SJctrCreateIscsiTargetsAvailablePortTableModel)this.getDataObjectModel(KEY_PORT_TABLE);
        portTable.setBasicDataList(portDetailList);
    }

    private void initializeChapUserTable(List<SJmoPortChapUserInfo> portChapUserList) {
        ArrayList<SJctrChapUserInfoIncludeNewChap> newChapList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        SJctrCreateIscsiTargetsAvailableChapUsersTableModel chapTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE);
        int userSeqNo = 0;
        for (SJmoPortChapUserInfo portChapUserInfo : portChapUserList) {
            ArrayList<SJmoChapUserInfo> chapUserList = portChapUserInfo.getAlPortChapUser();
            for (SJmoChapUserInfo chapUserInfo : chapUserList) {
                SJctrChapUserInfoIncludeNewChap newChapInfo = new SJctrChapUserInfoIncludeNewChap(chapUserInfo, userSeqNo, false);
                newChapList.add(newChapInfo);
                ++userSeqNo;
            }
        }
        this.getProxy().putCache(KEY_CHAP_USER_TABLE_INFO, newChapList);
    }

    private void initializeHostModeOptionTable() {
        SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
        SJctrCreateIscsiTargetsHostModeOptTableModel hostModeOptionsTable = (SJctrCreateIscsiTargetsHostModeOptTableModel)this.getDataObjectModel(KEY_HM_OPT_TABLE);
        boolean bReserve = SJctrIscsiUtility.getHostModeReserveOption(this);
        ArrayList<SJctrHostModeOptionTableKey> retList = new ArrayList<SJctrHostModeOptionTableKey>();
        for (int optionNum = 0; optionNum < 128; ++optionNum) {
            boolean bReserveStr;
            if (!bReserve && (bReserveStr = portUtil.toExplanationDisplay(optionNum).equals("Reserved"))) continue;
            retList.add(new SJctrHostModeOptionTableKey(optionNum, 0));
        }
        hostModeOptionsTable.setBasicDataList(retList);
    }

    private void initializeRsgArea(SJctrResourceGroupUtility rsgUtil) {
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        SJctrComUtility comUtil = this.getComUtility();
        this.rsgDataModel = (SJctrCreateIscsiTargetsRsgDataModel)this.getDataObjectModel(KEY_RSG_LIST);
        this.rsgDataModel.setEnableListener(false);
        this.rsgDataModel.addItem("Any");
        Collections.sort(rsgList, new SJctrRsgInfoRsgNameComparator());
        for (SJmoRSGgetRsg rsg : rsgList) {
            SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
            this.rsgDataModel.addItem(String.valueOf(rsgInfo.getRsgId()), SJctrRsgUtility.toRsgIdDisplay(comUtil, rsgInfo));
        }
        this.rsgDataModel.setSelection("Any");
        this.rsgDataModel.setEnableListener(true);
    }

    private void initializeIscsiTargetAliasArea() {
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_TGTALIAS_CHK);
        SJctrTextBoxDataModel targetAliasText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_ALIAS_TXT);
        useDefNameChk.setEnableListener(false);
        useDefNameChk.setSelect(true);
        targetAliasText.setValue(this.getComUtility().getGuidance("ISCSI_TARGET_ALIAS_DEF"));
        targetAliasText.setFixed(true);
        targetAliasText.setLabel("(-)");
        useDefNameChk.setEnableListener(true);
    }

    private void initializeIscsiTargetNameArea() {
        SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_TGT_NAME_RADIO);
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_CHK);
        SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_NAME_TXT);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrIscsiUtility iscsiUtil = comUtil.getIscsiUtility();
        targetNameRadio.setEnableListener(false);
        useDefNameChk.setEnableListener(false);
        String iqnDefName = iscsiUtil.getDefTargetIqnTopName(this.subsystemInfo) + this.getComUtility().getGuidance("STR_IQN_DEF_UNDER_NAME");
        targetNameRadio.setSelect(KEY_RADIO_IQN);
        useDefNameChk.setSelect(true);
        targetNameText.setValue(iqnDefName);
        targetNameText.setFixed(true);
        targetNameText.setLabel("(-)");
        targetNameRadio.setEnableListener(true);
        useDefNameChk.setEnableListener(true);
    }

    private void initializeHostModeArea() {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HM_LIST);
        Boolean bReserveOption = SJctrIscsiUtility.getHostModeReserveOption(this);
        for (byte byHostMode = 0; byHostMode < 80; byHostMode = (byte)(byHostMode + 1)) {
            Pattern pattern;
            String strHostMode = this.getComUtility().getPortUtility().toHostModeDisplay(byHostMode);
            if (!bReserveOption.booleanValue() && (pattern = Pattern.compile(HM_RESERVE_FORMAT)).matcher(strHostMode).matches()) continue;
            comboBox.addItem(Byte.toString(byHostMode), strHostMode);
        }
        comboBox.setSelectedIndex(0);
    }

    private void initializeChapAuthArea() {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_LIST);
        SJctrIscsiUtility utility = this.getComUtility().getIscsiUtility();
        int[] arr$ = SJctrIscsiDataMacro.TARGET_AUTH_SW_LIST;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer nSetValue = arr$[i$];
            comboBox.addItem(String.valueOf(nSetValue), utility.getIscsiTargetAutheString(nSetValue));
        }
        comboBox.setSelectedIndex(1);
    }

    private void initializeAuthModeArea() {
        SJctrRadioButtonGroupDataModel chapAuthRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        chapAuthRadio.setEnableListener(false);
        chapAuthRadio.setSelect(KEY_RADIO_UNIDIRECT);
        chapAuthRadio.setEnableListener(true);
    }

    private void initializeUserNameArea() {
        SJctrTextBoxDataModel userNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        userNameText.setValue("");
        userNameText.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR_OR_BLANK"));
    }

    private void initializeSecretArea() {
        SJctrTextBoxDataModel secretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        SJctrTextBoxDataModel reEnterText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_REENT_TXT);
        secretText.setTrim(false);
        reEnterText.setTrim(false);
        secretText.setValue("");
        reEnterText.setValue("");
        secretText.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR_OR_BLANK"));
    }

    protected void exitSelectIscsiTarget(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectDispIdInfo = (List)param.get("KEY_SEL_ISCSI_EXIT_DISP_ID");
        if (selectDispIdInfo == null || selectDispIdInfo.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitSelectIscsiTarget", "Not Found DispIdInfo");
            return;
        }
        int dispId = (Integer)selectDispIdInfo.get(0);
        switch (dispId) {
            case 0x200A002: {
                this.actionExitHostDialog(param);
                break;
            }
            case 33595529: {
                this.actionExitChapUserDialog(param);
                break;
            }
        }
    }

    private void actionIscsiTargetAlias(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_TGTALIAS_CHK);
        SJctrTextBoxDataModel targetAliasText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_ALIAS_TXT);
        useDefNameChk.setEnableListener(false);
        if (useDefNameChk.isSelect()) {
            targetAliasText.setValue(this.getComUtility().getGuidance("ISCSI_TARGET_ALIAS_DEF"));
            targetAliasText.setFixed(true);
            targetAliasText.setLabel("(-)");
        } else {
            targetAliasText.setValue("");
            targetAliasText.setFixed(false);
            targetAliasText.setLabel(this.getComUtility().getGuidance("ISCSITGT_ALIAS_MAX_CHAR"));
        }
        useDefNameChk.setEnableListener(true);
    }

    private void actionIscsiTargetName(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_TGT_NAME_RADIO);
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_CHK);
        SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_NAME_TXT);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrIscsiUtility iscsiUtil = comUtil.getIscsiUtility();
        targetNameRadio.setEnableListener(false);
        useDefNameChk.setEnableListener(false);
        if (targetNameRadio.getSelect().equals(KEY_RADIO_IQN)) {
            if (useDefNameChk.isSelect()) {
                String iqnDefName = iscsiUtil.getDefTargetIqnTopName(this.subsystemInfo) + this.getComUtility().getGuidance("STR_IQN_DEF_UNDER_NAME");
                targetNameText.setValue(iqnDefName);
                targetNameText.setFixed(true);
                targetNameText.setLabel("(-)");
            } else {
                String iqnDefName = iscsiUtil.getDefTargetIqnTopName(this.subsystemInfo);
                targetNameText.setValue(iqnDefName);
                targetNameText.setFixed(false);
                targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_IQN_SET_MAX_CHAR"));
            }
        } else if (useDefNameChk.isSelect()) {
            List<?> availablePortList = this.getProxy().getCache(KEY_ENABLE_ISCSI_PORT);
            SJmoPortDetail iscsiPort = null;
            if (availablePortList != null && availablePortList.size() != 0) {
                iscsiPort = (SJmoPortDetail)availablePortList.get(0);
            }
            String euiDefName = SJctrIscsiUtility.getDefTargetEuiTopName(iscsiPort, this.subsystemInfo) + this.getComUtility().getGuidance("STR_EUI_DEF_UNDER_NAME");
            targetNameText.setValue(euiDefName);
            targetNameText.setFixed(true);
            targetNameText.setLabel("(-)");
        } else {
            targetNameText.setValue("");
            targetNameText.setFixed(false);
            targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_EUI_SET_MAX_CHAR"));
        }
        targetNameRadio.setEnableListener(true);
        useDefNameChk.setEnableListener(true);
    }

    private void actionHostModePullDown(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrCreateIscsiTargetsHostModeOptTableModel hostModeOptionsTable = (SJctrCreateIscsiTargetsHostModeOptTableModel)this.getDataObjectModel(KEY_HM_OPT_TABLE);
        List<Object> allRowList = hostModeOptionsTable.getAllRowData();
        for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : allRowList) {
            sJctrHostModeOptionTableKey.setIOptionStatus(0);
        }
        hostModeOptionsTable.doRefresh();
    }

    private void actionHostModeOptBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel, int status) {
        try {
            SJctrCreateIscsiTargetsHostModeOptTableModel hostModeOptionsTable = (SJctrCreateIscsiTargetsHostModeOptTableModel)this.getDataObjectModel(KEY_HM_OPT_TABLE);
            List<Object> selRowList = hostModeOptionsTable.getSelectedRowData();
            SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HM_LIST);
            SJctrIscsiUtility.checkNotifyOpenVmsOpt33Dialog(selRowList, status, this, comboBox);
            for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : selRowList) {
                sJctrHostModeOptionTableKey.setIOptionStatus(status);
            }
            hostModeOptionsTable.doRefresh();
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void actionAddNewHost(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<Object> availableList;
        List<Object> addList;
        SJctrCreateIscsiTargetsAvailableHostTableModel availableTable = (SJctrCreateIscsiTargetsAvailableHostTableModel)this.getDataObjectModel(KEY_HOST_TABLE);
        HashMap map = new HashMap();
        List<Object> selectIscsiNameList = addList = availableTable.getSelectedRowData();
        map.put("KEY_ISCSI_DIALOG_IN", selectIscsiNameList);
        List<Object> availableIscsiNameList = availableList = availableTable.getAllRowData();
        map.put("KEY_AVAILABLE_ISCSI_NAME", availableIscsiNameList);
        ArrayList iscsiNameList = new ArrayList();
        map.put("KEY_BLOCK_ISCSISTRING", iscsiNameList);
        ArrayList nickNameList = new ArrayList();
        map.put("KEY_BLOCK_NICKNAME", nickNameList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewIscsiHostsDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void actionExitHostDialog(Map<String, List<?>> carryMap) {
        SJctrCreateIscsiTargetsAvailableHostTableModel availableTable = (SJctrCreateIscsiTargetsAvailableHostTableModel)this.getDataObjectModel(KEY_HOST_TABLE);
        List<?> carryIscsiNameList = carryMap.get("KEY_ISCSI_NAME_DIALOG_OUT");
        if (carryIscsiNameList == null || carryIscsiNameList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "KEY_ISCSI_NAME_DIALOG_OUT Not Found!!");
            return;
        }
        SJmoIscsiName iscsiNameInfo = (SJmoIscsiName)carryIscsiNameList.get(0);
        SJctrIscsiNameInfoIncludeNewHost newHostInfo = new SJctrIscsiNameInfoIncludeNewHost(iscsiNameInfo, true);
        ArrayList<SJctrIscsiNameInfoIncludeNewHost> addList = new ArrayList<SJctrIscsiNameInfoIncludeNewHost>();
        addList.add(newHostInfo);
        availableTable.addRowDataTop(addList);
        availableTable.setDirty();
    }

    private void actionAuthMode(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRadioButtonGroupDataModel chapAuthRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        SJctrTextBoxDataModel userNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        SJctrTextBoxDataModel secretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        SJctrTextBoxDataModel reSecretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_REENT_TXT);
        if (chapAuthRadio.getSelect().equals(KEY_RADIO_UNIDIRECT)) {
            userNameText.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR_OR_BLANK"));
            secretText.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR_OR_BLANK"));
        } else {
            userNameText.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
            secretText.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
        }
        reSecretText.setDirty();
    }

    private void actionChapAuthe(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<?> cacheChapList;
        int selectData = 0;
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_LIST);
        SJctrCreateIscsiTargetsAvailableChapUsersTableModel availableTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE);
        if (Integer.valueOf(comboBox.getSelection()) == 2) {
            selectData = 1;
            if (this.initializeChapFlag) {
                this.initializeChapFlag = false;
            } else {
                ArrayList<Object> chapList = new ArrayList<Object>();
                chapList.addAll(availableTable.getAllRowData());
                this.getProxy().putCache(KEY_CHAP_USER_TABLE_INFO, chapList);
            }
            availableTable.doRefresh();
            chapAuthDisableFlag = true;
        } else if (chapAuthDisableFlag && (cacheChapList = this.getCache(KEY_CHAP_USER_TABLE_INFO)) != null) {
            availableTable.doRefresh();
            availableTable.addRowData(cacheChapList);
            chapAuthDisableFlag = false;
        }
        SJctrSimpleDataModel chapAuthinfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_COM_CHAP_AUTHE_INFO);
        ((SJctrDataObject)chapAuthinfo.getManageData()).setData(KEY_COM_CHAP_AUTHE, selectData);
        chapAuthinfo.setDirty();
    }

    private void actionAddNewChapUser(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<Object> addList;
        SJctrCreateIscsiTargetsAvailableChapUsersTableModel availableTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE);
        HashMap map = new HashMap();
        List<Object> selectChapUserList = addList = availableTable.getSelectedRowData();
        map.put("ADD_NEW_CHAPUSER_DATA_SELECT", selectChapUserList);
        ArrayList availableList = new ArrayList();
        map.put("ADD_NEW_CHAPUSER_DATA_INVALID", availableList);
        ArrayList<SJctrChapUserInfoIncludeNewChap> newChapList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        List<Object> allChapList = availableTable.getAllRowData();
        for (SJctrChapUserInfoIncludeNewChap sJctrChapUserInfoIncludeNewChap : allChapList) {
            if (!sJctrChapUserInfoIncludeNewChap.isNewChap()) continue;
            newChapList.add(sJctrChapUserInfoIncludeNewChap);
        }
        map.put("ADD_NEW_CHAPUSER_DATA_NEW_LIST", newChapList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewChapUserDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void actionExitChapUserDialog(Map<String, List<?>> carryMap) {
        SJctrCreateIscsiTargetsAvailableChapUsersTableModel availableTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE);
        List<?> newChapUserList = carryMap.get("ADD_NEW_CHAPUSER_DATA");
        if (newChapUserList == null || newChapUserList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "actionExitChapUserDialog", "KEY_ADD_NEW_CHAPUSER_DATA Not Found!!");
            return;
        }
        SJctrChapUserInfoIncludeNewChap newChapUserInfo = (SJctrChapUserInfoIncludeNewChap)newChapUserList.get(0);
        newChapUserInfo.setUserSeqNo(availableTable.getAllRowData().size());
        ArrayList<SJctrChapUserInfoIncludeNewChap> addList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        addList.add(newChapUserInfo);
        availableTable.addRowDataTop(addList);
        availableTable.setDirty();
    }

    private void actionAdd(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        boolean canAddFlg = false;
        try {
            SJmoPortDetail portDetail;
            SJctrTableDataModel errTbl;
            ArrayList<SJctrErrorColumnData> newErrList;
            SJctrErrorDataController errDC;
            SJctrUserController uc;
            SJctrRelatedDispDataObject errDisp;
            List<Object> chapSelectRow;
            List<Object> hostSelectRow;
            List<Object> portSelectRow;
            List<SJmoRSGgetAllRsgs> rsgDetailList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgDetailList.get(0));
            SJctrCreateIscsiTargetsAvailablePortTableModel portTable = (SJctrCreateIscsiTargetsAvailablePortTableModel)this.getDataObjectModel(KEY_PORT_TABLE);
            List<Object> addPortList = portSelectRow = portTable.getSelectedRowData();
            SJctrCreateIscsiTargetsAvailableHostTableModel hostTable = (SJctrCreateIscsiTargetsAvailableHostTableModel)this.getDataObjectModel(KEY_HOST_TABLE);
            List<Object> addHostList = hostSelectRow = hostTable.getSelectedRowDataOrder();
            SJctrTextBoxDataModel userNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
            String newUserName = userNameText.getValue();
            SJctrCreateIscsiTargetsAvailableChapUsersTableModel chapTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE);
            List<Object> addChapList = chapSelectRow = chapTable.getSelectedRowData();
            SJctrCreateIscsiTargetsSelectedTableModel selectIscsiTable = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
            SJctrCreateIscsiTargetsAddErrMgr errMgr = new SJctrCreateIscsiTargetsAddErrMgr(addPortList.size(), addHostList.size(), addChapList.size());
            this.resetRscUtil();
            this.checkSecret();
            canAddFlg = this.canAddNewInfo(addPortList, addHostList, addChapList, newUserName, errMgr);
            List<SJctrError> hostErrAnyPortList = null;
            List<SJctrError> chapErrAnyPortList = null;
            if (canAddFlg) {
                hostErrAnyPortList = errMgr.getHostErrAnyPortList();
                chapErrAnyPortList = errMgr.getChapErrAnyPortList();
                ArrayList<SJctrIscsiNameInfoIncludeNewHost> setHostList = new ArrayList<SJctrIscsiNameInfoIncludeNewHost>();
                for (int errpos = 0; errpos < addHostList.size(); ++errpos) {
                    SJctrError errElement = hostErrAnyPortList.get(errpos);
                    if (errElement.getError() != -1) continue;
                    SJctrIscsiNameInfoIncludeNewHost addHostData = (SJctrIscsiNameInfoIncludeNewHost)addHostList.get(errpos);
                    setHostList.add(addHostData);
                }
                ArrayList<SJctrChapUserInfoIncludeNewChap> setChapList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
                for (int errpos = 0; errpos < addChapList.size(); ++errpos) {
                    SJctrError errElement = chapErrAnyPortList.get(errpos);
                    if (errElement.getError() != -1) continue;
                    SJctrChapUserInfoIncludeNewChap addChapData = (SJctrChapUserInfoIncludeNewChap)addChapList.get(errpos);
                    setChapList.add(addChapData);
                }
                ArrayList<SJctrCreateIscsiTargetInfo> newIscsiTargetList = new ArrayList<SJctrCreateIscsiTargetInfo>();
                List<?> utilList = this.getCache(SJmoGetRscUtilIscsiTarget.class);
                SJmoRscUtilIscsiTarget rscIscsiTarget = (SJmoRscUtilIscsiTarget)utilList.get(0);
                for (SJmoPortDetail sJmoPortDetail : addPortList) {
                    short sPort = sJmoPortDetail.getSPort();
                    SJctrPortIscsiTargetData ctrData = this.definedData.get(sPort);
                    SJctrCreateIscsiTargetInfo newIscsiTargetInfo = new SJctrCreateIscsiTargetInfo();
                    newIscsiTargetInfo.setSPort(sPort);
                    newIscsiTargetInfo.setSIscsiTarget(ctrData.acquireIscsiTargetId(rscIscsiTarget, sPort, rsgUtil, this.rsgDataModel));
                    this.collectIscsiTargetAliasArea(newIscsiTargetInfo);
                    this.collectIscsiTargetNameArea(sJmoPortDetail, newIscsiTargetInfo);
                    this.collectHostModeArea(newIscsiTargetInfo);
                    this.collectHostModeOptionArea(newIscsiTargetInfo);
                    this.collectChapAuthArea(newIscsiTargetInfo);
                    this.collectAuthModeArea(newIscsiTargetInfo);
                    this.collectUserNameArea(newIscsiTargetInfo);
                    this.collectSecretArea(newIscsiTargetInfo);
                    ArrayList<SJmoIscsiName> newHostList = new ArrayList<SJmoIscsiName>();
                    newHostList.addAll(setHostList);
                    Collections.sort(newHostList, new Comparator<SJmoIscsiName>(){

                        @Override
                        public int compare(SJmoIscsiName iscsiName1, SJmoIscsiName iscsiName2) {
                            int retComp = iscsiName1.getStrIscsiName().compareTo(iscsiName2.getStrIscsiName());
                            if (retComp == 0) {
                                retComp = iscsiName1.getStrIscsiNickName().compareTo(iscsiName2.getStrIscsiNickName());
                            }
                            return retComp;
                        }
                    });
                    newIscsiTargetInfo.setAlIscsiName(newHostList);
                    ArrayList<SJmoChapUserInfo> newChapList = new ArrayList<SJmoChapUserInfo>();
                    Collections.sort(setChapList, new Comparator<SJmoChapUserInfo>(){

                        @Override
                        public int compare(SJmoChapUserInfo chapUser1, SJmoChapUserInfo chapUser2) {
                            int retComp = chapUser1.getStrUserName().compareTo(chapUser2.getStrUserName());
                            return retComp;
                        }
                    });
                    newChapList.addAll(setChapList);
                    newIscsiTargetInfo.setAlUserInfo(newChapList);
                    newIscsiTargetInfo.setIDataMode(2);
                    newIscsiTargetInfo.setInitiatorChapUserList(setChapList);
                    ctrData.addIscsiTarget(newIscsiTargetInfo);
                    newIscsiTargetList.add(newIscsiTargetInfo);
                }
                selectIscsiTable.addRowDataTop(newIscsiTargetList);
                ArrayList<ArrayList<SJctrCreateIscsiTargetInfo>> storeRscList = new ArrayList<ArrayList<SJctrCreateIscsiTargetInfo>>();
                storeRscList.add(newIscsiTargetList);
                rscIscsiTarget.setRsvData(storeRscList);
                utilList = new ArrayList();
                utilList.add(rscIscsiTarget);
                this.putCache(SJmoGetRscUtilIscsiTarget.class, utilList);
                this.updateFooter();
            }
            if (errMgr.isPortErrExist()) {
                errDisp = this.createDialog(SJctrErrorDataController.class, null);
                uc = this.getWizardWindow().getOwner();
                errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
                newErrList = new ArrayList<SJctrErrorColumnData>();
                List<SJctrError> portErrList = errMgr.getPortErrList();
                for (int errpos = 0; errpos < portErrList.size(); ++errpos) {
                    SJctrError sJctrError = portErrList.get(errpos);
                    if (sJctrError.getError() == -1) continue;
                    SJctrErrorColumnData errData = new SJctrErrorColumnData((Comparable)addPortList.get(errpos), sJctrError);
                    newErrList.add(errData);
                }
                errDC.setParameter(this.getDataObjectModel(KEY_PORT_TABLE), newErrList);
                SJctrError err3 = errDC.getRepresentativeError(newErrList);
                SJcException sJcException = err3.createException();
                sJcException.setErrDisp(errDisp);
                throw sJcException;
            }
            if (errMgr.isHostErrExist(hostErrAnyPortList)) {
                errDisp = this.createDialog(SJctrErrorDataController.class, null);
                uc = this.getWizardWindow().getOwner();
                errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
                newErrList = new ArrayList();
                errTbl = new SJctrAddPortHostErrorTableModel();
                errTbl.setDataController(this);
                errTbl.setPaging(false);
                for (int portIndex = 0; portIndex < addPortList.size(); ++portIndex) {
                    List<SJctrError> list = errMgr.getHostErrListAll(portIndex);
                    for (int hostIndex = 0; hostIndex < addHostList.size(); ++hostIndex) {
                        SJctrError err2 = list.get(hostIndex);
                        if (err2.getError() == -1) continue;
                        portDetail = (SJmoPortDetail)addPortList.get(portIndex);
                        short sPort = portDetail.getSPort();
                        SJctrIscsiNameInfoIncludeNewHost addHost = (SJctrIscsiNameInfoIncludeNewHost)addHostList.get(hostIndex);
                        SJctrIscsiNameWithTgInfo iscsiNameInfo = ((SJctrAddPortHostErrorTableModel)errTbl).addBasicData(sPort, addHost);
                        SJctrErrorColumnData errData = new SJctrErrorColumnData(iscsiNameInfo, err2);
                        newErrList.add(errData);
                    }
                }
                errTbl.initGuidance(this.getComUtility());
                errTbl.setBasicData(SJmoGetPortDetail.class, this.getCache(SJmoGetPortDetail.class));
                errTbl.setBasicData(SJmoGetPortIscsiTargetInfo.class, this.getCache(SJmoGetPortIscsiTargetInfo.class));
                errTbl.makeDataModel();
                errDC.setParameter(errTbl, newErrList, this.getHostErrorTableComparator());
                hostTable.setDirty();
                selectIscsiTable.setDirty();
                SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
                footer.setDirty();
                SJctrError sJctrError = errDC.getRepresentativeError(newErrList);
                SJcException exp = sJctrError.createException();
                exp.setErrDisp(errDisp);
                throw exp;
            }
            if (errMgr.isChapErrExist(chapErrAnyPortList)) {
                errDisp = this.createDialog(SJctrErrorDataController.class, null);
                uc = this.getWizardWindow().getOwner();
                errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
                newErrList = new ArrayList();
                errTbl = new SJctrAddPortChapUserErrorTableModel();
                errTbl.setDataController(this);
                errTbl.setPaging(false);
                for (int portIndex = 0; portIndex < addPortList.size(); ++portIndex) {
                    List<SJctrError> list = errMgr.getChapUserErrListAll(portIndex);
                    for (int chapIndex = 0; chapIndex < addChapList.size(); ++chapIndex) {
                        SJctrError err = list.get(chapIndex);
                        if (err.getError() == -1) continue;
                        portDetail = (SJmoPortDetail)addPortList.get(portIndex);
                        short sPort = portDetail.getSPort();
                        SJctrChapUserInfoIncludeNewChap addChap = (SJctrChapUserInfoIncludeNewChap)addChapList.get(chapIndex);
                        SJctrChapUserWithTgInfo chapUserInfo = ((SJctrAddPortChapUserErrorTableModel)errTbl).addBasicData(sPort, addChap);
                        SJctrErrorColumnData errData = new SJctrErrorColumnData(chapUserInfo, err);
                        newErrList.add(errData);
                    }
                }
                errTbl.initGuidance(this.getComUtility());
                errTbl.setBasicData(SJmoGetPortDetail.class, this.getCache(SJmoGetPortDetail.class));
                errTbl.setBasicData(SJmoGetPortIscsiTargetInfo.class, this.getCache(SJmoGetPortIscsiTargetInfo.class));
                errTbl.makeDataModel();
                errDC.setParameter(errTbl, newErrList);
                hostTable.setDirty();
                selectIscsiTable.setDirty();
                SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
                footer.setDirty();
                SJctrError sJctrError = errDC.getRepresentativeError(newErrList);
                SJcException exp = sJctrError.createException();
                exp.setErrDisp(errDisp);
                throw exp;
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void checkSecret() {
        SJctrCreateIscsiTargetsAvailableChapUsersTableModel availableTable;
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        SJctrTextBoxDataModel UserNametextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        SJctrTextBoxDataModel reEnterTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_REENT_TXT);
        SJctrComboBoxDataModel cmbChapAuth = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_LIST);
        int iChapAuthSel = Integer.valueOf(cmbChapAuth.getSelection());
        if (iChapAuthSel == 1 && (availableTable = (SJctrCreateIscsiTargetsAvailableChapUsersTableModel)this.getDataObjectModel(KEY_CHAP_USER_TABLE)).getSelectedRowCount() <= 0) {
            throw SJctrIscsiUtility.makeException(206244);
        }
        if (UserNametextBox.getValue().length() == 0) {
            if (radioBtnGrp.getSelect().equals(KEY_RADIO_UNIDIRECT)) {
                if (secretTextBox.getValue().length() > 0 || reEnterTextBox.getValue().length() > 0) {
                    throw SJctrIscsiUtility.makeException(206224);
                }
            } else {
                throw SJctrIscsiUtility.makeException(206223);
            }
        }
        if (secretTextBox.getValue().compareTo(reEnterTextBox.getValue()) != 0) {
            throw SJctrIscsiUtility.makeException(206221);
        }
    }

    private boolean canAddNewInfo(List<SJmoPortDetail> portDetailList, List<SJctrIscsiNameInfoIncludeNewHost> newHostList, List<SJctrChapUserInfoIncludeNewChap> newChapList, String newChapUserName, SJctrCreateIscsiTargetsAddErrMgr errMgr) {
        boolean ret = true;
        List<SJmoRSGgetAllRsgs> rsgDetailList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgDetailList.get(0));
        SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
        for (int setNum = 0; setNum < portDetailList.size(); ++setNum) {
            SJctrError portErr;
            SJctrError portErr2;
            String defIscsiTargetAlias;
            String iscsiTargetAlias;
            List<?> utilList;
            SJmoRscUtilIscsiTarget rscIscsiTarget;
            List<SJctrError> iscsiNameErrList = errMgr.getHostErrListAll(setNum);
            List<SJctrError> chapUserErrList = errMgr.getChapUserErrListAll(setNum);
            SJmoPortDetail portDetail = portDetailList.get(setNum);
            short sPort = portDetail.getSPort();
            SJctrPortIscsiTargetData portIscsiInfo = this.definedData.get(sPort);
            short targetId = portIscsiInfo.acquireIscsiTargetId(rscIscsiTarget = (SJmoRscUtilIscsiTarget)(utilList = this.getCache(SJmoGetRscUtilIscsiTarget.class)).get(0), sPort, rsgUtil, this.rsgDataModel);
            if (targetId >= SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddNewInfo", "iSCSI Target ID is over the maximum.");
                SJctrError portErr3 = errMgr.getPortErr(setNum);
                portErr3.setFunc(12);
                portErr3.setModule(22);
                portErr3.setError(206202);
                ret = false;
            }
            if ((iscsiTargetAlias = this.getIscsiTargetAlias(sPort, targetId)).length() == 0) {
                SJctrLogUty.warn("SJctrCreateIscsiTargetsDC", "canAddNewInfo", "The iSCSI Target Alias is not entered.");
                SJctrError portErr4 = errMgr.getPortErr(setNum);
                portErr4.setFunc(12);
                portErr4.setModule(22);
                portErr4.setError(206196);
                ret = false;
            }
            if ((defIscsiTargetAlias = iscsiUtil.getDefIscsiTargetAlias(sPort)).equals(iscsiTargetAlias)) {
                SJctrLogUty.warn("SJctrCreateIscsiTargetsDC", "canAddNewInfo", "The specified iSCSI Target Alias overlaps with the default name.");
                portErr2 = errMgr.getPortErr(setNum);
                portErr2.setFunc(12);
                portErr2.setModule(22);
                portErr2.setError(206205);
                ret = false;
            }
            if (portIscsiInfo.containsIscsiTargetAlias(iscsiTargetAlias)) {
                SJctrLogUty.warn("SJctrCreateIscsiTargetsDC", "canAddNewInfo", "The specified iSCSI Target Alias overlaps within port.");
                portErr2 = errMgr.getPortErr(setNum);
                portErr2.setFunc(12);
                portErr2.setModule(22);
                portErr2.setError(206206);
                ret = false;
            }
            String iscsiTargetName = this.getIscsiTargetName(portDetail, targetId);
            String defIscsiTargetName = iscsiUtil.getDefIscsiTargetName(sPort, this.subsystemInfo);
            if (defIscsiTargetName.equals(iscsiTargetName)) {
                SJctrLogUty.warn("SJctrCreateIscsiTargetsDC", "canAddNewInfo", "The specified iSCSI Target Name overlaps with the default name.");
                portErr = errMgr.getPortErr(setNum);
                portErr.setFunc(12);
                portErr.setModule(22);
                portErr.setError(206207);
                ret = false;
            }
            if (portIscsiInfo.containsIscsiTargetName(iscsiTargetName)) {
                SJctrLogUty.warn("SJctrCreateIscsiTargetsDC", "canAddNewInfo", "The specified iSCSI Target Name overlaps within port.");
                portErr = errMgr.getPortErr(setNum);
                portErr.setFunc(12);
                portErr.setModule(22);
                portErr.setError(206208);
                ret = false;
            }
            if (this.checkAddHost(portIscsiInfo, newHostList, iscsiNameErrList)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddHost", "Try to add HBA iSCSI Name is overlapped in this operation!!");
                ret = false;
            }
            if (this.checkAddInitiatorChap(portIscsiInfo, newChapList, sPort, chapUserErrList)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddInitiatorChap", "Try to add CHAP User Name is overlapped in this operation!!");
                ret = false;
            }
            if (portIscsiInfo.containsTargetChapUserName(newChapUserName)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddNewInfo", "The specified Target CHAP User Name overlaps within port.");
                portErr = errMgr.getPortErr(setNum);
                portErr.setFunc(12);
                portErr.setModule(22);
                portErr.setError(206218);
                ret = false;
            }
            int hostNum = 0;
            for (int errpos = 0; errpos < newHostList.size(); ++errpos) {
                SJctrIscsiNameInfoIncludeNewHost hostInfo;
                SJctrError errElement = iscsiNameErrList.get(errpos);
                if (errElement.getError() != -1 || portIscsiInfo.containsHbaIscsiName((hostInfo = newHostList.get(errpos)).getStrIscsiName())) continue;
                ++hostNum;
            }
            if (hostNum + portIscsiInfo.getHbaIscsiNameList().size() > SJctrIscsiDataMacro.PORT_ISCSINAME_MAX) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddNewInfo", "No more HBA iSCSI Name can be registered in the port.");
                SJctrError portErr5 = errMgr.getPortErr(setNum);
                portErr5.setFunc(12);
                portErr5.setModule(22);
                portErr5.setError(206203);
                ret = false;
            }
            int chapNum = 0;
            for (int errpos = 0; errpos < newChapList.size(); ++errpos) {
                SJctrChapUserInfoIncludeNewChap chapInfo;
                SJctrError errElement = chapUserErrList.get(errpos);
                if (errElement.getError() != -1 || portIscsiInfo.containsInitiatorChapUserName((chapInfo = newChapList.get(errpos)).getStrUserName())) continue;
                ++chapNum;
            }
            if (chapNum + portIscsiInfo.getChapUserNameList().size() <= SJctrIscsiDataMacro.PORT_CHAPUSER_MAX) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddNewInfo", "No more CHAP User can be registered in the port.");
            SJctrError portErr6 = errMgr.getPortErr(setNum);
            portErr6.setFunc(12);
            portErr6.setModule(22);
            portErr6.setError(206204);
            ret = false;
        }
        return ret;
    }

    private boolean checkAddHost(SJctrPortIscsiTargetData portIscsiInfo, List<SJctrIscsiNameInfoIncludeNewHost> newHostList, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> iscsiNameSet = new HashSet<String>();
        HashSet<String> hostNameSet = new HashSet<String>();
        for (int index = 0; index < newHostList.size(); ++index) {
            SJctrError iscsiNameErr;
            HashMap<String, String> hostMap;
            String hostStr;
            SJctrError iscsiNameErr2;
            SJctrIscsiNameInfoIncludeNewHost hostInfo = newHostList.get(index);
            String iscsiName = hostInfo.getStrIscsiName();
            String hostName = hostInfo.getStrIscsiNickName();
            if (!iscsiNameSet.add(iscsiName)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddHost", "The specified HBA iSCSI Name overlaps within Selection Hosts.");
                iscsiNameErr2 = errList.get(index);
                iscsiNameErr2.setFunc(12);
                iscsiNameErr2.setModule(22);
                iscsiNameErr2.setError(206209);
            }
            if (hostName.length() != 0 && !hostNameSet.add(hostName)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddHost", "The specified Host Name overlaps within Selection Hosts.");
                iscsiNameErr2 = errList.get(index);
                iscsiNameErr2.setFunc(12);
                iscsiNameErr2.setModule(22);
                iscsiNameErr2.setError(206210);
            }
            if ((hostStr = (hostMap = portIscsiInfo.getHostMap()).get(iscsiName)) != null) {
                if (hostStr.equals(hostName)) continue;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddHost", "The specified Host Name overlaps within port.");
                iscsiNameErr = errList.get(index);
                iscsiNameErr.setFunc(12);
                iscsiNameErr.setModule(22);
                iscsiNameErr.setError(206212);
                ret = true;
                continue;
            }
            if (hostName.length() == 0 || !portIscsiInfo.containsHostName(hostName)) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddHost", "The specified HBA iSCSI Name overlaps within port.");
            iscsiNameErr = errList.get(index);
            iscsiNameErr.setFunc(12);
            iscsiNameErr.setModule(22);
            iscsiNameErr.setError(206211);
            ret = true;
        }
        return ret;
    }

    private boolean checkAddInitiatorChap(SJctrPortIscsiTargetData portIscsiInfo, List<SJctrChapUserInfoIncludeNewChap> newChapList, short sPort, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> chapNameSet = new HashSet<String>();
        for (int index = 0; index < newChapList.size(); ++index) {
            SJctrError chapUserErr;
            SJctrChapUserInfoIncludeNewChap newchapInfo = newChapList.get(index);
            String userName = newchapInfo.getStrUserName();
            if (!chapNameSet.add(userName)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddChap", "The specified Initiator CHAP User Name overlaps within Selection.");
                chapUserErr = errList.get(index);
                chapUserErr.setFunc(12);
                chapUserErr.setModule(22);
                chapUserErr.setError(206213);
                ret = true;
            }
            if (!portIscsiInfo.containsInitiatorChapUserName(userName)) continue;
            if (newchapInfo.isNewChap()) {
                if (portIscsiInfo.containsInitiatorChapUserSeqNo(newchapInfo.getUserSeqNo())) continue;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddChap", "The specified Initiator CHAP User Name overlaps within port.");
                chapUserErr = errList.get(index);
                chapUserErr.setFunc(12);
                chapUserErr.setModule(22);
                chapUserErr.setError(206214);
                ret = true;
                continue;
            }
            short selPort = newchapInfo.getSPort();
            if (sPort == selPort || portIscsiInfo.containsInitiatorChapUserSeqNo(newchapInfo.getUserSeqNo())) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddChap", "The specified Initiator CHAP User Name overlaps within port.");
            SJctrError chapUserErr2 = errList.get(index);
            chapUserErr2.setFunc(12);
            chapUserErr2.setModule(22);
            chapUserErr2.setError(206214);
            ret = true;
        }
        return ret;
    }

    private void actionDetail(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            HashMap param = new HashMap();
            SJctrCreateIscsiTargetsSelectedTableModel selectedTable = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
            List<Object> selectedRows = selectedTable.getSelectedRowData();
            param.put("KEY_SELECTED_ISCSI_TARGETS", selectedRows);
            param.put(SJmoGetPortDetail.class.getName(), SJctrIscsiUtility.getSJmoPortDetailList(this));
            param.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this));
            SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrIscsiTargetPropertiesDC.class, param);
            this.addUpdateDisp(dialogRelated);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void actionRemove(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrCreateIscsiTargetsSelectedTableModel selectedTable = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
        List<Object> selectedRows = selectedTable.removeSelectedRowData();
        for (SJctrCreateIscsiTargetInfo sJctrCreateIscsiTargetInfo : selectedRows) {
            short portId = sJctrCreateIscsiTargetInfo.getSPort();
            SJctrPortIscsiTargetData ctrData = this.definedData.get(portId);
            ctrData.removeIscsiTarget(sJctrCreateIscsiTargetInfo);
        }
        List<?> utilList = this.getCache(SJmoGetRscUtilIscsiTarget.class);
        SJmoRscUtilIscsiTarget sJmoRscUtilIscsiTarget = (SJmoRscUtilIscsiTarget)utilList.get(0);
        this.resetRscUtil();
        ArrayList<List<Object>> storeRscList = new ArrayList<List<Object>>();
        storeRscList.add(selectedRows);
        sJmoRscUtilIscsiTarget.delRsvData(storeRscList);
        utilList = new ArrayList();
        utilList.add(sJmoRscUtilIscsiTarget);
        this.putCache(SJmoGetRscUtilIscsiTarget.class, utilList);
        this.updateFooter();
    }

    private String getIscsiTargetAlias(short portId, short targetId) {
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_TGTALIAS_CHK);
        SJctrTextBoxDataModel targetAliasText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_ALIAS_TXT);
        String iscsiTargetAlias = "";
        iscsiTargetAlias = useDefNameChk.isSelect() ? SJctrIscsiUtility.getDefTargetAlias(portId, targetId) : targetAliasText.getValue();
        return iscsiTargetAlias;
    }

    private String getIscsiTargetName(SJmoPortDetail portDetail, short targetId) {
        SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_TGT_NAME_RADIO);
        SJctrCheckBoxDataModel useDefNameChk = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_USE_DEF_NAME_CHK);
        SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TGT_NAME_TXT);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrIscsiUtility iscsiUtil = comUtil.getIscsiUtility();
        String iscsiTargetName = "";
        if (targetNameRadio.getSelect().equals(KEY_RADIO_IQN)) {
            iscsiTargetName = this.getComUtility().getGuidance("IQN3");
            if (useDefNameChk.isSelect()) {
                String topName = iscsiUtil.getDefTargetIqnTopName(this.subsystemInfo);
                String underName = SJctrIscsiUtility.getDefTargetIqnUnderName(portDetail.getSPort(), targetId);
                iscsiTargetName = iscsiTargetName + topName + underName;
            } else {
                iscsiTargetName = iscsiTargetName + targetNameText.getValue().toLowerCase();
            }
        } else {
            iscsiTargetName = this.getComUtility().getGuidance("EUI3");
            if (useDefNameChk.isSelect()) {
                String topName = SJctrIscsiUtility.getDefTargetEuiTopName(portDetail, this.subsystemInfo);
                String underName = SJctrIscsiUtility.getDefTargetEuiUnderName(portDetail.getSPort(), targetId);
                iscsiTargetName = iscsiTargetName + topName + underName;
            } else {
                iscsiTargetName = iscsiTargetName + targetNameText.getValue().toUpperCase();
            }
        }
        return iscsiTargetName;
    }

    private void collectIscsiTargetNameArea(SJmoPortDetail portDetail, SJmoIscsiTargetInfo targetInfo) {
        String iscsiTargetName = this.getIscsiTargetName(portDetail, targetInfo.getSIscsiTarget());
        targetInfo.setStrIscsiTargetName(iscsiTargetName);
    }

    private void collectIscsiTargetAliasArea(SJmoIscsiTargetInfo targetInfo) {
        String iscsiTargetAlias = this.getIscsiTargetAlias(targetInfo.getSPort(), targetInfo.getSIscsiTarget());
        targetInfo.setStrIscsiTargetAlias(iscsiTargetAlias);
    }

    private void collectHostModeArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HM_LIST);
        targetInfo.setIHostMode(Byte.valueOf(comboBox.getSelection()).byteValue());
    }

    private void collectHostModeOptionArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrCreateIscsiTargetsHostModeOptTableModel hostModeOptionsTable = (SJctrCreateIscsiTargetsHostModeOptTableModel)this.getDataObjectModel(KEY_HM_OPT_TABLE);
        List<Object> allRowList = hostModeOptionsTable.getAllRowData();
        BitSet btSetData = new BitSet();
        for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : allRowList) {
            if (sJctrHostModeOptionTableKey.getIOptionStatus() != 1) continue;
            btSetData.set(sJctrHostModeOptionTableKey.getSOptionNo());
        }
        targetInfo.setBtOption(btSetData);
    }

    private void collectChapAuthArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_LIST);
        targetInfo.setiUserAuthentSwitch(Integer.valueOf(comboBox.getSelection()));
    }

    private void collectAuthModeArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        int nSetType = -1;
        nSetType = radioBtnGrp.getSelect().equals(KEY_RADIO_UNIDIRECT) ? 0 : 1;
        targetInfo.setiAuthentMode(nSetType);
    }

    private void collectUserNameArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        targetInfo.setStrTargetUserName(textBox.getValue());
    }

    private void collectSecretArea(SJmoIscsiTargetInfo targetInfo) {
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        targetInfo.setStrTargetSecret(secretTextBox.getValue());
    }

    @Override
    public void selectNextTask(SJctrActionDefine action) {
        switch (action) {
            case ACT_MAPLUN: {
                this.logUty.putlog("selectNextTask", "Create iSCSI Targets -> Map LUNs");
                SJctrCreateIscsiTargetsSelectedTableModel tableInfo = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
                List<Object> iscsiTargetTableList = tableInfo.getAllRowData();
                Collections.sort(iscsiTargetTableList);
                ArrayList toNextHostIndexList = new ArrayList();
                ArrayList<SJmoIscsiTargetIndex> toNextTargetIndexList = new ArrayList<SJmoIscsiTargetIndex>();
                TreeMap<Short, List<SJctrCreateIscsiTargetInfo>> iscsiTargetMap = new TreeMap<Short, List<SJctrCreateIscsiTargetInfo>>();
                boolean selectedIscsiVboxMix = this.isSelectedIscsiVboxMix(iscsiTargetTableList);
                for (SJctrCreateIscsiTargetInfo sJctrCreateIscsiTargetInfo : iscsiTargetTableList) {
                    BitSet bsOrgHmo = sJctrCreateIscsiTargetInfo.getBtOption();
                    boolean bPortCosolidationHmo = bsOrgHmo.get(88);
                    if (!bPortCosolidationHmo && selectedIscsiVboxMix) {
                        throw SJctrIscsiUtility.makeException(206246);
                    }
                    List<SJctrCreateIscsiTargetInfo> iscsiTargetList = iscsiTargetMap.get(sJctrCreateIscsiTargetInfo.getSPort());
                    if (iscsiTargetList == null) {
                        iscsiTargetList = new ArrayList<SJctrCreateIscsiTargetInfo>();
                        iscsiTargetMap.put(sJctrCreateIscsiTargetInfo.getSPort(), iscsiTargetList);
                    }
                    iscsiTargetList.add(sJctrCreateIscsiTargetInfo);
                    SJmoIscsiTargetIndex toNextIndex = new SJmoIscsiTargetIndex();
                    toNextIndex.setSPort(sJctrCreateIscsiTargetInfo.getSPort());
                    toNextIndex.setSIscsiTarget(sJctrCreateIscsiTargetInfo.getSIscsiTarget());
                    toNextTargetIndexList.add(toNextIndex);
                }
                this.putCache("KEY_SELECT_IT_INDEX", toNextTargetIndexList);
                this.putCache("KEY_SELECT_HG_INDEX", toNextHostIndexList);
                this.updatePortIscsiTargetInfo(iscsiTargetTableList, iscsiTargetMap);
            }
        }
    }

    private void updatePortIscsiTargetInfo(List<SJctrCreateIscsiTargetInfo> createIscsiTargetList, TreeMap<Short, List<SJctrCreateIscsiTargetInfo>> iscsiTargetMap) {
        if (this.originIscsiTarget == null) {
            this.originIscsiTarget = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        }
        ArrayList<SJmoPortIscsiTargetInfo> newPortIscsiTargetList = new ArrayList<SJmoPortIscsiTargetInfo>();
        for (SJmoPortIscsiTargetInfo portIscsiTarget : this.originIscsiTarget) {
            SJmoPortIscsiTargetInfo newPortIscsiTarget;
            block5: {
                newPortIscsiTarget = new SJmoPortIscsiTargetInfo();
                List<SJctrCreateIscsiTargetInfo> targetList = iscsiTargetMap.get(portIscsiTarget.getSPort());
                if (targetList != null) {
                    try {
                        newPortIscsiTarget = (SJmoPortIscsiTargetInfo)portIscsiTarget.clone();
                        newPortIscsiTarget.getAlPortIscsiTarget().addAll(targetList);
                        Collections.sort(newPortIscsiTarget.getAlPortIscsiTarget());
                        break block5;
                    }
                    catch (CloneNotSupportedException e) {
                        this.getLogUty().putlog("mergePortIscsiTargetInfo", "SJmoPortIscsiTargetInfo clone fail", e, 30000);
                        continue;
                    }
                }
                newPortIscsiTarget = portIscsiTarget;
            }
            newPortIscsiTargetList.add(newPortIscsiTarget);
        }
        Collections.sort(newPortIscsiTargetList);
        this.putCache(SJmoGetPortIscsiTargetInfo.class, newPortIscsiTargetList);
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrCreateIscsiTargetsSelectedTableModel tableInfo = (SJctrCreateIscsiTargetsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SEL);
        List<Object> targetList = tableInfo.getAllRowData();
        Collections.sort(targetList);
        if (targetList == null || targetList.size() <= 0) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
            SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
            SJcRoleResourceContainer rolecontainer = authorizeContainer.getRoleResourceContainer();
            if (rolecontainer.checkAuthority(85)) {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
            }
        }
    }

    public void renewAvailablePortData() {
        List<SJmoPortIscsiTargetInfo> targetPortHgRsg = this.getAvailableIscsiTargetRsgList(this.targetPortIscsi, this.rsgUtil, false);
        List<SJmoPortDetail> portList = this.makePortTableList(targetPortHgRsg, this.portDetail, this.errMap);
        SJctrCreateIscsiTargetsAvailablePortTableModel portTable = (SJctrCreateIscsiTargetsAvailablePortTableModel)this.getDataObjectModel(KEY_PORT_TABLE);
        portTable.setBasicDataList(portList);
    }

    private int getVboxId(SJmoIscsiTargetIndex targetIndex) {
        int vBoxId = -1;
        SJmoRSGgetRsg rsg = SJctrIscsiUtility.getRsgInfoIncludeSpecifyIscsiTarget(this.rsgUtil.extractRsg(), targetIndex);
        if (rsg == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getVboxId", "targetIndex is Invalid.");
            throw SJctrIscsiUtility.makeException(107004);
        }
        vBoxId = rsg.getRsgInfo().getVboxIndex().getIndex();
        return vBoxId;
    }

    private Comparator getHostErrorTableComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int retComp = 0;
                SJctrIscsiNameWithTgInfo value1 = (SJctrIscsiNameWithTgInfo)this.getValue(o1);
                SJctrIscsiNameWithTgInfo value2 = (SJctrIscsiNameWithTgInfo)this.getValue(o2);
                retComp = this.compareIscsiName(value1.getIscsiNameInfo(), value2.getIscsiNameInfo());
                if (retComp == 0) {
                    retComp = this.compareTargetInfo(value1.getIscsiTargetInfo(), value2.getIscsiTargetInfo());
                }
                return retComp;
            }

            private Comparable getValue(Object obj) {
                Comparable comp = obj instanceof SJctrErrorColumnData ? ((SJctrErrorColumnData)obj).getKeyObj() : (Comparable)obj;
                return comp;
            }

            private int compareIscsiName(SJmoIscsiName iscsiName1, SJmoIscsiName iscsiName2) {
                int retComp = iscsiName1.getSPort() - iscsiName2.getSPort();
                if (retComp == 0 && (retComp = iscsiName1.getStrIscsiName().compareTo(iscsiName2.getStrIscsiName())) == 0) {
                    retComp = iscsiName1.getStrIscsiNickName().compareTo(iscsiName2.getStrIscsiNickName());
                }
                return retComp;
            }

            private int compareTargetInfo(SJmoIscsiTargetInfo targetInfo1, SJmoIscsiTargetInfo targetInfo2) {
                int retComp = targetInfo1.getSPort() - targetInfo2.getSPort();
                return retComp;
            }
        };
    }

    private boolean isSelectedIscsiVboxMix(List<SJctrCreateIscsiTargetInfo> iscsiTargetTableList) {
        boolean ret = false;
        SJctrCreateIscsiTargetInfo firstIscsiTarget = iscsiTargetTableList.get(0);
        int firstVboxId = this.getVboxId(firstIscsiTarget);
        for (SJctrCreateIscsiTargetInfo iscsiTarget : iscsiTargetTableList) {
            int checkVboxId = this.getVboxId(iscsiTarget);
            if (firstVboxId == checkVboxId) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static enum CREATE_TGT_MSG implements SJctrNotifyState
    {
        SEL_DEF_NAME_ALIAS,
        SEL_TARGET,
        SEL_DEF_NAME,
        SEL_HOST_MODE,
        SEL_ENABLE,
        SEL_DISABLE,
        SEL_ADD_HOST,
        SEL_CHAP_AUTH,
        SEL_AUTH_MODE,
        SEL_ADD_CHAP,
        SEL_ADD,
        SEL_DETAIL,
        SEL_REMOVE;

    }
}

