/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.editiscsitargets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoComparator;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.editiscsitargets.SJctrEditIscsiTargetsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrEditIscsiTargetsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17834049;
    private static final String DISP_TITLE = "EDIT_ISCSI_TARGETS";
    public static final String KEY_AUTH_METHOD_TITLE = "COM_ISCSI_AUTH_METHOD_CHK";
    private static final String KEY_AUTH_METHOD_PULL = "COM_ISCSI_AUTH_METHOD_PULL";
    public static final String KEY_MUTUAL_CHAP_TITLE = "COM_ISCSI_MUTUAL_CHAP_CHK";
    private static final String KEY_MUTUAL_CHAP_RADIO = "COM_ISCSI_MUTUAL_CHAP_RADIO";
    public static final String KEY_CHAP_USER_NAME_TITLE = "COM_ISCSI_CHAP_USER_NAME_CHK";
    private static final String KEY_CHAP_USER_NAME_TEXT = "COM_ISCSI_CHAP_USER_NAME_TEXT";
    public static final String KEY_SECRET_TITLE = "COM_ISCSI_SECRET_CHK";
    private static final String KEY_SECRET_TEXT = "COM_ISCSI_SECRET_TEXT";
    private static final String KEY_CHECKBOX = "COM_CHECKBOX";
    private static final String KEY_NEW_PATHS = "KEY_NEW_PATHS";
    private static final String KEY_RADIO_ENABLE = "COM_ENABLE";
    private static final String KEY_RADIO_DISABLE = "COM_DISABLE";
    Map<String, Object> duplicateMap = new HashMap<String, Object>();
    Map<String, Object> settingMap = new HashMap<String, Object>();
    Map<String, Boolean> boolFlgMap = new HashMap<String, Boolean>();
    private static final String KEY_MAP_AUTH_METHOD = "KEY_MAP_AUTH_METHOD";
    private static final String KEY_MAP_MUTUAL_CHAP = "KEY_MAP_MUTUAL_CHAP";
    private static final String KEY_MAP_USER_NAME = "KEY_MAP_USER_NAME";
    private static final String KEY_EXIST_EMPTY_USER_NAME = "KEY_EXIST_EMPTY_USER_NAME";
    private static final String KEY_CHAP_DISABLE_NO_SET_USER_NAME = "KEY_CHAP_DISABLE_NO_SET_USER_NAME";
    private static final String KEY_EXIST_NONE_STATE = "KEY_EXIST_NONE_STATE";
    private static final String KEY_EXIST_NONE_ENABLE_STATE = "KEY_EXIST_NONE_ENABLE_STATE";
    private static final String AUTH_METHOD_PULL_NAME_BLANK = "NAME_BLANK";

    public SJctrEditIscsiTargetsDC() throws SJcException {
        super(17834049);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrSimpleDataModel authMethodTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_AUTH_METHOD_TITLE, authMethodTitle);
        authMethodTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_AUTH_METHOD_PULL, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.AUTH_METHOD_CHANGE));
        SJctrSimpleDataModel mutualChapTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_MUTUAL_CHAP_TITLE, mutualChapTitle);
        mutualChapTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        SJctrRadioButtonGroupDataModel mutualChapRadio = new SJctrRadioButtonGroupDataModel();
        mutualChapRadio.add(KEY_RADIO_ENABLE);
        mutualChapRadio.add(KEY_RADIO_DISABLE);
        this.addDataObjectModel(KEY_MUTUAL_CHAP_RADIO, SJctrIscsiUtility.addItemSelectEventListener(mutualChapRadio, EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        SJctrSimpleDataModel chapUserNameTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_CHAP_USER_NAME_TITLE, chapUserNameTitle);
        chapUserNameTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_CHAP_USER_NAME_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        SJctrSimpleDataModel secretTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_SECRET_TITLE, secretTitle);
        secretTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_SECRET_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_ISCSI_TARGETS_MSG.SEL_CHANGE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_ISCSI_TARGETS_MSG.AUTH_METHOD_CHANGE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionAuthMethodPullDown(event, dstModel);
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        List<?> iscsiPathList = this.getCache("KEY_SELECTED_ISCSI_PATHS");
        if (null == iscsiPathList) {
            this.logUty.putlog("checkStartData", "Inherited data list is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (0 == iscsiPathList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited data list is zero.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoIscsiTargetPathInfo> selectedTargetPathList = this.getCache("KEY_SELECTED_ISCSI_PATHS");
            SJctrIscsiUtility.getSJmoPortDetailList(this);
            List<SJmoPortIscsiTargetPathInfo> portTargetPathList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
            List<SJmoIscsiTargetPathInfo> editTargetPathList = SJctrIscsiUtility.checkAndGetIscsiTargetPathInfo(portTargetPathList, selectedTargetPathList);
            this.putCache(KEY_NEW_PATHS, editTargetPathList);
            this.setDuplicateEditArea(editTargetPathList);
            this.setSpecifyStateIscsiPaths(editTargetPathList);
            this.initializeAuthMethodArea((Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD));
            this.initializeMutualChapArea((Integer)this.duplicateMap.get(KEY_MAP_MUTUAL_CHAP));
            this.initializeChapUserNameArea((String)this.duplicateMap.get(KEY_MAP_USER_NAME), (Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD));
            this.initializeSecretArea((Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD));
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    private void setDuplicateEditArea(List<SJmoIscsiTargetPathInfo> editIscsiPathList) {
        SJmoIscsiTargetPathInfo baseInfo = editIscsiPathList.get(0);
        int inputAuthMethod = baseInfo.getIAuthentSwitch();
        int inputMutualChap = baseInfo.getIAuthentMode();
        String inputChapUserName = baseInfo.getStrTargetUserName();
        for (SJmoIscsiTargetPathInfo editIscsiPath : editIscsiPathList) {
            inputAuthMethod = this.checkDuplicateInt(inputAuthMethod, editIscsiPath.getIAuthentSwitch());
            inputMutualChap = this.checkDuplicateInt(inputMutualChap, editIscsiPath.getIAuthentMode());
            inputChapUserName = this.checkDuplicateString(inputChapUserName, editIscsiPath.getStrTargetUserName());
            if (inputAuthMethod != -1 || inputMutualChap != -1 || !"".equals(inputChapUserName)) continue;
            break;
        }
        this.duplicateMap.put(KEY_MAP_AUTH_METHOD, inputAuthMethod);
        this.duplicateMap.put(KEY_MAP_MUTUAL_CHAP, inputMutualChap);
        this.duplicateMap.put(KEY_MAP_USER_NAME, inputChapUserName);
    }

    private int checkDuplicateInt(int baseInfo, int checkInfo) {
        int ret = baseInfo;
        if (baseInfo != checkInfo) {
            ret = -1;
        }
        return ret;
    }

    private String checkDuplicateString(String baseInfo, String checkInfo) {
        String ret = baseInfo;
        if (!baseInfo.equals(checkInfo)) {
            ret = "";
        }
        return ret;
    }

    private void setSpecifyStateIscsiPaths(List<SJmoIscsiTargetPathInfo> editIscsiPathList) {
        this.boolFlgMap.put(KEY_EXIST_EMPTY_USER_NAME, false);
        this.boolFlgMap.put(KEY_CHAP_DISABLE_NO_SET_USER_NAME, false);
        this.boolFlgMap.put(KEY_EXIST_NONE_STATE, false);
        this.boolFlgMap.put(KEY_EXIST_NONE_ENABLE_STATE, false);
        for (SJmoIscsiTargetPathInfo editIscsiPath : editIscsiPathList) {
            int authSwitch = editIscsiPath.getIAuthentSwitch();
            int authMode = editIscsiPath.getIAuthentMode();
            int userNameLen = editIscsiPath.getStrTargetUserName().length();
            if (userNameLen == 0) {
                this.boolFlgMap.put(KEY_EXIST_EMPTY_USER_NAME, true);
                if (authSwitch == 1 && authMode == 0) {
                    this.boolFlgMap.put(KEY_CHAP_DISABLE_NO_SET_USER_NAME, true);
                }
            }
            if (authSwitch != 0) continue;
            this.boolFlgMap.put(KEY_EXIST_NONE_STATE, true);
            if (authMode != 1) continue;
            this.boolFlgMap.put(KEY_EXIST_NONE_ENABLE_STATE, true);
        }
    }

    private SJctrCheckBoxDataModel getCheckBoxDataModelinTitle(String titleKey) {
        SJctrCheckBoxDataModel checkBox = null;
        SJctrSimpleDataModel title = (SJctrSimpleDataModel)this.getDataObjectModel(titleKey);
        if (title == null) {
            this.getLogUty().putlog("getCheckBoxDataModelinTitle", "SJctrSimpleDataModel is null. titleKey = " + titleKey);
            throw SJctrIscsiUtility.makeException(107001);
        }
        checkBox = (SJctrCheckBoxDataModel)title.getDataModel(KEY_CHECKBOX);
        return checkBox;
    }

    private void initializeAuthMethodArea(int inputAuthMethod) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_AUTH_METHOD_TITLE);
        checkBox.setSelect(false);
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_AUTH_METHOD_PULL);
        comboBox.setEnableListener(false);
        if (inputAuthMethod == -1) {
            comboBox.addItem(AUTH_METHOD_PULL_NAME_BLANK, "");
        }
        comboBox.addItem(String.valueOf(1), this.getComUtility().getGuidance("CHAP"));
        comboBox.addItem(String.valueOf(0), this.getComUtility().getGuidance("CHAP_NONE"));
        if (inputAuthMethod == -1) {
            comboBox.setSelection(AUTH_METHOD_PULL_NAME_BLANK);
        } else {
            comboBox.setSelection(String.valueOf(inputAuthMethod));
        }
        comboBox.setEnableListener(true);
    }

    private void initializeMutualChapArea(int inputMutualChap) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_MUTUAL_CHAP_TITLE);
        checkBox.setSelect(false);
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_MUTUAL_CHAP_RADIO);
        switch (inputMutualChap) {
            case 0: {
                radioBtnGrp.setSelect(KEY_RADIO_DISABLE);
                break;
            }
            case 1: {
                radioBtnGrp.setSelect(KEY_RADIO_ENABLE);
                break;
            }
        }
    }

    private void initializeChapUserNameArea(String inputChapUserName, int inputAuthMethod) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_CHAP_USER_NAME_TITLE);
        checkBox.setSelect(false);
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USER_NAME_TEXT);
        if (inputAuthMethod == 1) {
            checkBox.setEnable(true);
            textBox.setEnable(true);
            textBox.setValue(inputChapUserName);
            textBox.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
        } else {
            checkBox.setEnable(false);
            textBox.setEnable(false);
            textBox.setValue("");
            textBox.setLabel("(-)");
        }
    }

    private void initializeSecretArea(int inputAuthMethod) {
        SJctrCheckBoxDataModel secretCheckBox = this.getCheckBoxDataModelinTitle(KEY_SECRET_TITLE);
        secretCheckBox.setSelect(false);
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT);
        secretTextBox.setTrim(false);
        if (inputAuthMethod == 1) {
            secretCheckBox.setEnable(true);
            secretTextBox.setEnable(true);
            secretTextBox.setValue("");
            secretTextBox.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
        } else {
            secretCheckBox.setEnable(false);
            secretTextBox.setEnable(false);
            secretTextBox.setValue("");
            secretTextBox.setLabel("(-)");
        }
    }

    private void actionChangeEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
    }

    private void actionAuthMethodPullDown(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrComboBoxDataModel authMethodPull = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_AUTH_METHOD_PULL);
        authMethodPull.removeItem(AUTH_METHOD_PULL_NAME_BLANK);
        authMethodPull.setDirty();
        SJctrCheckBoxDataModel userNameChk = this.getCheckBoxDataModelinTitle(KEY_CHAP_USER_NAME_TITLE);
        SJctrTextBoxDataModel userNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USER_NAME_TEXT);
        SJctrCheckBoxDataModel secretChk = this.getCheckBoxDataModelinTitle(KEY_SECRET_TITLE);
        SJctrTextBoxDataModel secretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT);
        userNameText.setValue("");
        secretText.setValue("");
        userNameChk.setSelect(false);
        secretChk.setSelect(false);
        if (String.valueOf(1).equals(authMethodPull.getSelection())) {
            userNameChk.setEnable(true);
            userNameText.setEnable(true);
            userNameText.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
            secretChk.setEnable(true);
            secretText.setEnable(true);
            secretText.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
        } else {
            userNameChk.setEnable(false);
            userNameText.setEnable(false);
            userNameText.setLabel("(-)");
            secretChk.setEnable(false);
            secretText.setEnable(false);
            secretText.setLabel("(-)");
        }
    }

    @Override
    public boolean checkEndData() {
        try {
            ArrayList selectedIscsiPathList = new ArrayList();
            selectedIscsiPathList.addAll(this.getCache(KEY_NEW_PATHS));
            ArrayList<SJmoIscsiTargetPathInfo> editIscsiPathList = new ArrayList<SJmoIscsiTargetPathInfo>(selectedIscsiPathList.size());
            for (SJmoIscsiTargetPathInfo selectedIscsiPath : selectedIscsiPathList) {
                try {
                    SJmoIscsiTargetPathInfo clonePathInfo = (SJmoIscsiTargetPathInfo)selectedIscsiPath.clone();
                    editIscsiPathList.add(clonePathInfo);
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("checkEndData", "CloneNotSupportedException");
                    throw SJctrIscsiUtility.makeException(107001);
                }
            }
            SJctrEditIscsiTargetsConfirmData confirmData = new SJctrEditIscsiTargetsConfirmData();
            this.checkChapUserNameInput();
            this.checkMisMatchEditArea();
            this.collectEditArea(editIscsiPathList);
            Collections.sort(editIscsiPathList, new SJctrIscsiTargetPathInfoComparator());
            confirmData.setIscsiPathList(editIscsiPathList);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditIscsiTargetsConfirmData> confirmDataList = new ArrayList<SJctrEditIscsiTargetsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditIscsiTargetsConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    private void checkChapUserNameInput() {
        SJctrTextBoxDataModel userNameText;
        if (this.isSelectCheckBoxinTitle(KEY_CHAP_USER_NAME_TITLE) && (userNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USER_NAME_TEXT)).getValue().length() == 0) {
            throw SJctrIscsiUtility.makeException(206197);
        }
    }

    private boolean isSelectCheckBoxinTitle(String titleKey) {
        boolean ret = false;
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(titleKey);
        if (checkBox != null) {
            ret = checkBox.isSelect();
        }
        return ret;
    }

    private void checkMisMatchEditArea() {
        boolean isEditUserName = this.isSelectCheckBoxinTitle(KEY_CHAP_USER_NAME_TITLE);
        boolean isEditSecret = this.isSelectCheckBoxinTitle(KEY_SECRET_TITLE);
        this.reflectAuthMethodAndMutualChapState();
        this.checkChangeChapState(isEditUserName, isEditSecret);
        this.checkForceSetState(isEditUserName, isEditSecret);
        this.checkNoXorSetState(isEditUserName, isEditSecret);
    }

    private void reflectAuthMethodAndMutualChapState() {
        this.settingMap.put(KEY_MAP_AUTH_METHOD, (Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD));
        this.settingMap.put(KEY_MAP_MUTUAL_CHAP, (Integer)this.duplicateMap.get(KEY_MAP_MUTUAL_CHAP));
        this.settingMap.put(KEY_MAP_USER_NAME, (String)this.duplicateMap.get(KEY_MAP_USER_NAME));
        if (this.isSelectCheckBoxinTitle(KEY_AUTH_METHOD_TITLE)) {
            this.settingMap.put(KEY_MAP_AUTH_METHOD, this.getAuthMethodSelectState());
        }
        if (this.isSelectCheckBoxinTitle(KEY_MUTUAL_CHAP_TITLE)) {
            this.settingMap.put(KEY_MAP_MUTUAL_CHAP, this.getMutualChapSelectState());
        }
    }

    private int getAuthMethodSelectState() {
        int authMethod = -1;
        SJctrComboBoxDataModel authMethodCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_AUTH_METHOD_PULL);
        try {
            authMethod = Integer.parseInt(authMethodCombo.getSelection());
        }
        catch (NumberFormatException e) {
            this.getLogUty().putlog("getAuthMethodSelectState", "An error occurs in processing of paseint.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return authMethod;
    }

    private int getMutualChapSelectState() {
        int setType = -1;
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_MUTUAL_CHAP_RADIO);
        if (radioBtnGrp.getSelect().equals(KEY_RADIO_DISABLE)) {
            setType = 0;
        } else if (radioBtnGrp.getSelect().equals(KEY_RADIO_ENABLE)) {
            setType = 1;
        }
        return setType;
    }

    private void checkChangeChapState(boolean isEditUserName, boolean isEditSecret) {
        boolean isEditUserOrSecret;
        if (this.boolFlgMap.get(KEY_EXIST_NONE_STATE).booleanValue() && !this.isSelectCheckBoxinTitle(KEY_AUTH_METHOD_TITLE) && (isEditUserOrSecret = isEditUserName | isEditSecret)) {
            throw SJctrIscsiUtility.makeException(206277);
        }
    }

    private void checkForceSetState(boolean isEditUserName, boolean isEditSecret) {
        boolean isNoUserName = this.chkForceSetNoUserName();
        boolean isChapDisableNoUserName = this.chkForceSetChapDisableNoUserName();
        boolean isNoneEnable = this.chkForceSetNoneEnable();
        if (isNoUserName || isChapDisableNoUserName || isNoneEnable) {
            boolean isEditUserXorSecret = isEditUserName ^ isEditSecret;
            boolean isEditUserAndSecret = isEditUserName & isEditSecret;
            if (isEditUserXorSecret) {
                throw SJctrIscsiUtility.makeException(206224);
            }
            if (!isEditUserAndSecret) {
                throw SJctrIscsiUtility.makeException(206278);
            }
        }
    }

    private boolean chkForceSetNoUserName() {
        boolean ret = false;
        if (this.boolFlgMap.get(KEY_EXIST_EMPTY_USER_NAME).booleanValue() && (Integer)this.settingMap.get(KEY_MAP_AUTH_METHOD) == 1 && (Integer)this.settingMap.get(KEY_MAP_MUTUAL_CHAP) == 1) {
            ret = true;
        }
        return ret;
    }

    private boolean chkForceSetChapDisableNoUserName() {
        boolean ret = false;
        if (this.boolFlgMap.get(KEY_CHAP_DISABLE_NO_SET_USER_NAME).booleanValue() && (Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD) == -1 && (Integer)this.settingMap.get(KEY_MAP_AUTH_METHOD) == -1 && (Integer)this.settingMap.get(KEY_MAP_MUTUAL_CHAP) == 1) {
            ret = true;
        }
        return ret;
    }

    private boolean chkForceSetNoneEnable() {
        boolean ret = false;
        if (this.boolFlgMap.get(KEY_EXIST_NONE_ENABLE_STATE).booleanValue() && (Integer)this.duplicateMap.get(KEY_MAP_MUTUAL_CHAP) == -1 && (Integer)this.settingMap.get(KEY_MAP_AUTH_METHOD) == 1 && (Integer)this.settingMap.get(KEY_MAP_MUTUAL_CHAP) == -1) {
            ret = true;
        }
        return ret;
    }

    private void checkNoXorSetState(boolean isEditUserName, boolean isEditSecret) {
        boolean isEditUserXorSecret;
        boolean isChapDisable = this.chkNoXorSetChapDisableState();
        boolean isChapDisableNoUserName = this.chkNoXorSetChapDisableNoUserName();
        if ((isChapDisable || isChapDisableNoUserName) && (isEditUserXorSecret = isEditUserName ^ isEditSecret)) {
            throw SJctrIscsiUtility.makeException(206279);
        }
    }

    private boolean chkNoXorSetChapDisableState() {
        boolean ret = false;
        if (this.boolFlgMap.get(KEY_EXIST_EMPTY_USER_NAME).booleanValue() && (Integer)this.settingMap.get(KEY_MAP_AUTH_METHOD) == 1 && (Integer)this.settingMap.get(KEY_MAP_MUTUAL_CHAP) == 0) {
            ret = true;
        }
        return ret;
    }

    private boolean chkNoXorSetChapDisableNoUserName() {
        boolean ret = false;
        if (this.boolFlgMap.get(KEY_CHAP_DISABLE_NO_SET_USER_NAME).booleanValue() && ((Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD) == -1 || (Integer)this.duplicateMap.get(KEY_MAP_AUTH_METHOD) == 1) && (Integer)this.duplicateMap.get(KEY_MAP_MUTUAL_CHAP) == -1 && (Integer)this.settingMap.get(KEY_MAP_AUTH_METHOD) == 1 && (Integer)this.settingMap.get(KEY_MAP_MUTUAL_CHAP) == -1) {
            ret = true;
        }
        return ret;
    }

    private void collectEditArea(List<SJmoIscsiTargetPathInfo> pathInfoList) {
        if (this.isSelectCheckBoxinTitle(KEY_AUTH_METHOD_TITLE)) {
            this.collectAuthMethodArea(pathInfoList);
        }
        if (this.isSelectCheckBoxinTitle(KEY_MUTUAL_CHAP_TITLE)) {
            this.collectMutualChapArea(pathInfoList);
        }
        if (this.isSelectCheckBoxinTitle(KEY_CHAP_USER_NAME_TITLE)) {
            this.collectUserNameArea(pathInfoList);
        }
        if (this.isSelectCheckBoxinTitle(KEY_SECRET_TITLE)) {
            this.collectSecretArea(pathInfoList);
        }
    }

    private void collectAuthMethodArea(List<SJmoIscsiTargetPathInfo> pathInfoList) {
        int authMethod = this.getAuthMethodSelectState();
        if (authMethod == -1) {
            this.getLogUty().putlog("collectAuthMethodArea", "Authentication Method combo box is not selected.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        for (SJmoIscsiTargetPathInfo targetInfo : pathInfoList) {
            targetInfo.setIAuthentSwitch(authMethod);
            if (authMethod != 0) continue;
            targetInfo.setStrTargetUserName("");
            targetInfo.setStrTargetSecret("");
        }
    }

    private void collectMutualChapArea(List<SJmoIscsiTargetPathInfo> pathInfoList) {
        int setType = this.getMutualChapSelectState();
        if (setType == -1) {
            this.getLogUty().putlog("collectMutualChapArea", "Mutual CHAP radio button is not selected.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        for (SJmoIscsiTargetPathInfo targetInfo : pathInfoList) {
            targetInfo.setIAuthentMode(setType);
        }
    }

    private void collectUserNameArea(List<SJmoIscsiTargetPathInfo> pathInfoList) {
        SJctrTextBoxDataModel userNameBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USER_NAME_TEXT);
        String userName = userNameBox.getValue();
        for (SJmoIscsiTargetPathInfo targetInfo : pathInfoList) {
            targetInfo.setStrTargetUserName(userName);
        }
    }

    private void collectSecretArea(List<SJmoIscsiTargetPathInfo> pathInfoList) {
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT);
        String secret = secretTextBox.getValue();
        for (SJmoIscsiTargetPathInfo targetInfo : pathInfoList) {
            targetInfo.setStrTargetSecret(secret);
        }
    }

    public static enum EDIT_ISCSI_TARGETS_MSG implements SJctrNotifyState
    {
        SEL_CHANGE,
        AUTH_METHOD_CHANGE;

    }
}

