/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.relhostreserve.release;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.LUNMgetHostReserved;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetailComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.properties.SJctrHostReserveDC;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.release.SJctrRelHostReserveAC;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.release.SJctrRelHostReserveConfirmDC;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.release.SJctrRelHostReserveConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrRelHostReserveSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RESET_HOST_RESERVED";
    private static final Class<?> CONFIRM_DC = SJctrRelHostReserveConfirmDC.class;
    public static final String KEY_TABLE = "COM_TABLE";
    public static int HOSTRSV_ERR_INVALID_DATA_LEVEL7 = 107001;
    public static int HOSTRSV_ERR_INVALID_DATA_LEVEL4 = 107002;
    public static int HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4 = 106501;
    public static int HOSTRSV_ERR_HG_NOT_EXIST_LEVEL4 = 106502;
    public static int HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4 = 105297;
    public static int HOSTRSV_ERR_LUNPATH_NOT_EXIST_LEVEL4 = 106506;
    public static int HOSTRSV_ERR_LDEV_RSG_INVALID_LEVEL4 = 105298;
    public static int HOSTRSV_ERR_LDEV_RSG_INVALID_LEVEL7 = 105424;
    public static int HOSTRSV_ERR_SysRSG_HG = 205164;
    public static int HOSTRSV_ERR_SysRSG_LDEV = 205165;
    static final SJctrPortLunDetailComparator PORTLUN_COMP = new SJctrPortLunDetailComparator();
    private boolean needPasword = false;
    private String REL_HOST_RESERVE = "PASS_IDS_LUNM_FORCERST";

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        List<Object> targetList = wizard.getCache("KEY_PORTLUN_TO_RSTHOSTRSV");
        SJctrHostReserveDC parentDC = (SJctrHostReserveDC)wizard.getParentDC();
        ArrayList<SJctrError> errList = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, -1);
            errList.add(oneError);
        }
        boolean checkResult = this.checkSelectedData(wizard, targetList, errList);
        if (!checkResult) {
            SJctrError firstError = null;
            ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>();
            for (int errpos = 0; errpos < errList.size(); ++errpos) {
                SJctrError errElement = errList.get(errpos);
                if (errElement.getError() == -1) continue;
                SJctrErrorColumnData errData = new SJctrErrorColumnData((Comparable)targetList.get(errpos), errElement);
                newErrList.add(errData);
                if (firstError != null) continue;
                firstError = errElement;
            }
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            SJctrRelatedDispDataObject rel = parentDC.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)parentDC.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, newErrList);
            SJcException exp = firstError.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        SJctrRelHostReserveConfirmData confirmData = this.createConfirmData(wizard, targetList);
        ArrayList<SJctrRelHostReserveConfirmData> confirmDataList = new ArrayList<SJctrRelHostReserveConfirmData>();
        confirmDataList.add(confirmData);
        wizard.putCache(SJctrRelHostReserveConfirmData.class, confirmDataList);
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrRelHostReserveAC ac = new SJctrRelHostReserveAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        confirmData = (SJctrRelHostReserveConfirmData)confirmDataList.get(0);
        List<SJctrPortLunTableKey> portLunTblKeyList = confirmData.getTargetPortLunList();
        ac.setApplyList(portLunTblKeyList);
        wizard.addConfirmData(ac, related);
        if (uc.getAuthorizeContainer().getSystemParamContainer().isLocalHost()) {
            this.needPasword = true;
        }
    }

    public boolean checkSelectedData(SJctrWizardWindowDC wizard, List<Object> targetList, List<SJctrError> errList) {
        SJmoPortIndex oneModelPt;
        SJmoPortLunDetail portLunDetail;
        SJctrPortLunTableKey portLunTableKey;
        boolean result = true;
        if (targetList == null || targetList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        for (int i = 0; i < targetList.size(); ++i) {
            portLunTableKey = (SJctrPortLunTableKey)targetList.get(i);
            SJmoPortLunInfo portLunInfo = portLunTableKey.getPortLunInfo();
            portLunDetail = portLunTableKey.getPortLunDetail();
            if (portLunInfo != null && portLunDetail != null) continue;
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moPortHGInfoList = wizard.getCache(SJmoGetPortHostGroupInfo.class);
        List<?> moPortITInfoList = wizard.getCache(SJmoGetPortIscsiTargetInfo.class);
        if (!(moPortHGInfoList != null && moPortHGInfoList.size() != 0 || moPortITInfoList != null && moPortITInfoList.size() != 0)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSelectedData", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moAllRsgList = wizard.getCache(SJmoGetRSGgetAllRsgs.class);
        if (moAllRsgList == null || moAllRsgList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(wizard.getOwner(), (SJmoRSGgetAllRsgs)moAllRsgList.get(0));
        List<?> moPortLunInfoList = wizard.getCache(SJmoGetPortLunInfo.class);
        if (moPortLunInfoList == null || moPortLunInfoList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSelectedData", "SJmoGetPortLunInfo Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        portLunTableKey = (SJctrPortLunTableKey)targetList.get(0);
        portLunDetail = portLunTableKey.getPortLunDetail();
        short sPort = portLunDetail.getSPort();
        short sHG = portLunDetail.getSHostGroup();
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(sPort);
        int searchIdx = -1;
        if (moPortHGInfoList != null && moPortHGInfoList.size() > 0) {
            searchIdx = Collections.binarySearch(moPortHGInfoList, portIndex);
        }
        boolean iscsiFlg = false;
        if (searchIdx < 0 && moPortITInfoList != null && moPortITInfoList.size() > 0) {
            searchIdx = Collections.binarySearch(moPortITInfoList, portIndex);
            iscsiFlg = true;
        }
        if (searchIdx < 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean rsgFlg = false;
        if (!iscsiFlg) {
            oneModelPt = (SJmoPortHostGroupInfo)moPortHGInfoList.get(searchIdx);
            ArrayList hgArray = ((SJmoPortHostGroupInfo)oneModelPt).getAlPortHostGroup();
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup(sHG);
            searchIdx = Collections.binarySearch(hgArray, hgIndex);
            if (searchIdx < 0) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_NOT_EXIST_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
            rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
            if (sysRsgFlg) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_SysRSG_HG);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            oneModelPt = (SJmoPortIscsiTargetInfo)moPortITInfoList.get(searchIdx);
            ArrayList<SJmoIscsiTargetInfo> itArray = ((SJmoPortIscsiTargetInfo)oneModelPt).getAlPortIscsiTarget();
            SJmoIscsiTargetIndex itIndex = new SJmoIscsiTargetIndex();
            itIndex.setSPort(sPort);
            itIndex.setSIscsiTarget(sHG);
            searchIdx = Collections.binarySearch(itArray, itIndex);
            if (searchIdx < 0) {
                SJctrError err = new SJctrError(10, 22, 206521);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup(sHG);
            rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        if ((searchIdx = Collections.binarySearch(moPortLunInfoList, portIndex)) < 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortLunInfo moPortLunInfo = (SJmoPortLunInfo)moPortLunInfoList.get(searchIdx);
        ArrayList moPortLunDtlList = moPortLunInfo.getAlPortLun();
        Collections.sort(moPortLunDtlList, PORTLUN_COMP);
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            portLunTableKey = (SJctrPortLunTableKey)targetList.get(errpos);
            portLunDetail = portLunTableKey.getPortLunDetail();
            searchIdx = Collections.binarySearch(moPortLunDtlList, portLunTableKey.getPortLunDetail(), PORTLUN_COMP);
            if (searchIdx < 0) {
                result = false;
                SJctrError errElement = errList.get(errpos);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(HOSTRSV_ERR_LUNPATH_NOT_EXIST_LEVEL4);
                continue;
            }
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setSLdkc(portLunDetail.getSLDKC());
            ldevIndex.setSCu(portLunDetail.getSCU());
            ldevIndex.setSLdev(portLunDetail.getSLDEV());
            int rsgId = rsgUtil.getRsgId(ldevIndex);
            rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (!rsgFlg) {
                result = false;
                SJctrError errElement = errList.get(errpos);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(HOSTRSV_ERR_LDEV_RSG_INVALID_LEVEL7);
                continue;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(ldevIndex);
            if (!sysRsgFlg) continue;
            result = false;
            SJctrError errElement = errList.get(errpos);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(HOSTRSV_ERR_SysRSG_LDEV);
        }
        return result;
    }

    private SJctrRelHostReserveConfirmData createConfirmData(SJctrWizardWindowDC wizard, List<Object> targetList) {
        SJctrRelHostReserveConfirmData confirmData = new SJctrRelHostReserveConfirmData();
        ArrayList<SJctrPortLunTableKey> portLunTblKeyList = new ArrayList<SJctrPortLunTableKey>(targetList.size());
        ArrayList<SJmoPortDetail> portDetailList = new ArrayList<SJmoPortDetail>(targetList.size());
        ArrayList<SJmoLdevDetail> ldevDetailList = new ArrayList<SJmoLdevDetail>(targetList.size());
        ArrayList<SJmoLdevNicknameInfo> ldevNickInfoList = new ArrayList<SJmoLdevNicknameInfo>(targetList.size());
        ArrayList<LUNMgetHostReserved> hostReserveList = new ArrayList<LUNMgetHostReserved>(targetList.size());
        SJctrPortLunTableKey tblKey = (SJctrPortLunTableKey)targetList.get(0);
        short sPort = tblKey.getPortLunInfo().getSPort();
        short sHG = tblKey.getPortLunDetail().getSHostGroup();
        List<?> moPortDtlList = wizard.getCache(SJmoGetPortDetail.class);
        if (moPortDtlList == null || moPortDtlList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createConfirmData", "SJmoPortDetail Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moLdevDtlList = wizard.getCache(SJmoGetLdevDetail.class);
        if (moLdevDtlList == null || moLdevDtlList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createConfirmData", "SJmoLdevDetail Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moLdevNickList = wizard.getCache(SJmoGetLdevNicknameInfo.class);
        if (moLdevNickList == null || moLdevNickList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createConfirmData", "SJmoLdevNicknameInfo Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(sPort);
        int index = Collections.binarySearch(moPortDtlList, portIndex);
        SJmoPortDetail moPortDtl = (SJmoPortDetail)moPortDtlList.get(index);
        SJctrHostReserveDC parentDc = (SJctrHostReserveDC)wizard.getParentDC();
        List<LUNMgetHostReserved> getHostReservedLunList = parentDc.getHostReservedList(tblKey);
        if (getHostReservedLunList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createConfirmData", "Getting Host-Reserved info failed.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        for (int i = 0; i < targetList.size(); ++i) {
            tblKey = (SJctrPortLunTableKey)targetList.get(i);
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setSLdkc(tblKey.getPortLunDetail().getSLDKC());
            ldevIndex.setSCu(tblKey.getPortLunDetail().getSCU());
            ldevIndex.setSLdev(tblKey.getPortLunDetail().getSLDEV());
            index = Collections.binarySearch(moLdevDtlList, ldevIndex);
            SJmoLdevDetail moLdevDtl = (SJmoLdevDetail)moLdevDtlList.get(index);
            index = Collections.binarySearch(moLdevNickList, ldevIndex);
            SJmoLdevNicknameInfo moLdevNickInfo = (SJmoLdevNicknameInfo)moLdevNickList.get(index);
            short sLun = tblKey.getPortLunDetail().getSLUN();
            LUNMgetHostReserved hstRsv = new LUNMgetHostReserved();
            hstRsv.sHostGroupId = sHG;
            hstRsv.sLun = sLun;
            for (int j = 0; j < getHostReservedLunList.size(); ++j) {
                if (getHostReservedLunList.get(j).getSLUN() != sLun) continue;
                hstRsv.lHostReserved = getHostReservedLunList.get((int)j).lHostReserved;
                break;
            }
            portLunTblKeyList.add(tblKey);
            portDetailList.add(moPortDtl);
            ldevDetailList.add(moLdevDtl);
            ldevNickInfoList.add(moLdevNickInfo);
            hostReserveList.add(hstRsv);
        }
        Collections.sort(portLunTblKeyList);
        Collections.sort(portDetailList);
        Collections.sort(ldevDetailList);
        Collections.sort(ldevNickInfoList);
        Collections.sort(hostReserveList);
        confirmData.setTargetPortLunList(portLunTblKeyList);
        confirmData.setPortDetailList(portDetailList);
        confirmData.setLdevDetailList(ldevDetailList);
        confirmData.setLdevNickInfoList(ldevNickInfoList);
        confirmData.setHostReserveList(hostReserveList);
        return confirmData;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public String getPassId() {
        String passId = super.getPassId();
        if (this.needPasword) {
            passId = this.getComUtility().getGuidance("COMMON", this.REL_HOST_RESERVE);
        }
        return passId;
    }
}

