/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.managerscusage;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.managerscusage.SJctrViewManageRscUsageSummaryModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetCvdevInfo;
import sanproject.sn2.model.data.system.SJmoCvdevInfo;

public class SJctrViewManageRscUsageDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664500;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String GUIDE_MAX_ALLOWED = "MAX_ALLOWED";
    private static final String GUIDE_BRACKET_LEFT = "BRACKET_LEFT";
    private static final String GUIDE_BRACKET_RIGHT = "BRACKET_RIGHT";

    public SJctrViewManageRscUsageDC() throws SJcException {
        super(34664500);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrViewManageRscUsageSummaryModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetCvdevInfo kind = new SJmoGetCvdevInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        List<?> cvdevList = this.getCache(SJmoGetCvdevInfo.class);
        if (null == cvdevList) {
            this.logUty.putlog("checkConstructData", "Cvdev info list is null.");
            SJctrError err = new SJctrError(30, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == cvdevList.size()) {
            this.logUty.putlog("checkConstructData", "Size of cvdev data list is zero.");
            SJctrError err = new SJctrError(30, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrViewManageRscUsageSummaryModel summary = (SJctrViewManageRscUsageSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        summary.setNumOfCacheManageDevices(this.getNumOfCacheManageDevicesString((SJmoCvdevInfo)cvdevList.get(0)));
        return true;
    }

    public String getNumOfCacheManageDevicesString(SJmoCvdevInfo cvdevInfo) {
        String numOfCvdev = "?";
        if (null != cvdevInfo) {
            int maxCvdevNum = cvdevInfo.getIMaxCvdevCnt();
            int useCvdevNum = cvdevInfo.getIUsedCvdevCnt();
            numOfCvdev = Integer.toString(useCvdevNum) + " " + this.getComUtility().getGuidance(GUIDE_BRACKET_LEFT) + this.getComUtility().getGuidance(GUIDE_MAX_ALLOWED) + " " + Integer.toString(maxCvdevNum) + this.getComUtility().getGuidance(GUIDE_BRACKET_RIGHT);
        }
        return numOfCvdev;
    }
}

