/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmoncus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrParityGroupPropertyDC;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrSelectByParityGroupsPGDetailData;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrSelectByParityGroupsTableModel;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrSelectByParityGroupsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595448;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.SELECT_BY_ARRAY_GROUPS;
    private static final String KEY_AVAILABLE_PGS = "COM_AVAILABLE_PGS";
    private static final String KEY_DETAIL = "COM_DETAIL";
    private static final SJctrArrayGroupIndexComparator PG_COMP = new SJctrArrayGroupIndexComparator();

    public SJctrSelectByParityGroupsDC() throws SJcException {
        super(33595448);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrSelectByParityGroupsTableModel pgTable = new SJctrSelectByParityGroupsTableModel();
        this.addDataObjectModel(KEY_AVAILABLE_PGS, pgTable);
        SJctrButtonDataModel viewCuMatrixButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, viewCuMatrixButton);
        viewCuMatrixButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectByParityGroupsDC.this.fireMessageEvent(SELECT_BY_PG_MSG.SELECT_DETAIL);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_BY_PG_MSG.SELECT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectByParityGroupsDC.this.makePGDetail(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> cuLdevInfo = this.getCache("COM_NUM_OF_LDEVS_PER_CU");
        if (null == cuLdevInfo) {
            this.logUty.putlog("checkConstructData", "View data is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoPgDetail> pgDetails = SJctrOptionMonitorUtility.getSJmoPgDetail(this);
        List<SJmoPgScatteredInfo> pgSctInfo = SJctrOptionMonitorUtility.getSJmoPgScatteredInfo(this);
        List<SJmoPgLdevInfo> pgLdevInfo = SJctrOptionMonitorUtility.getSJmoPgLdevInfo(this);
        ArrayList<SJctrSelectByParityGroupsPGDetailData> pgTableInfo = new ArrayList<SJctrSelectByParityGroupsPGDetailData>();
        HashMap pgInfoTmp = new HashMap();
        HashMap<Integer, SJmoPgLdevInfo> pgLdevMap = new HashMap<Integer, SJmoPgLdevInfo>();
        for (SJmoPgLdevInfo pgLdev : pgLdevInfo) {
            pgLdevMap.put(pgLdev.getIndex(), pgLdev);
        }
        for (SJmoPgDetail pgInfo : pgDetails) {
            if (!SJctrOptionMonitorUtility.isMonParityGroup(pgInfo.getFB4())) continue;
            HashMap<String, Integer> cusMap = new HashMap<String, Integer>();
            int tmpIndex = pgInfo.getIndex();
            SJmoPgLdevInfo pgLdev = (SJmoPgLdevInfo)pgLdevMap.get(tmpIndex);
            if (pgLdev != null) {
                ArrayList pgLdevs = pgLdev.getAlLdevIndex();
                for (SJmoLdevIndex ldev : pgLdevs) {
                    short cuNo = ldev.getSCu();
                    String cuStr = SJctrOptionMonitorUtility.getCUNumberString(cuNo);
                    cusMap.put(cuStr, Integer.valueOf(cuNo));
                }
            }
            pgInfoTmp.put(pgInfo.getIndexKey(), cusMap);
        }
        for (SJmoPgScatteredInfo pgSct : pgSctInfo) {
            HashMap parentPGCUs = (HashMap)pgInfoTmp.get(pgSct.getIndexKey());
            if (null == parentPGCUs) continue;
            ArrayList childPGsInfo = pgSct.getAlPgIndex();
            for (SJmoPgIndex childPG : childPGsInfo) {
                String childPGIndexKey = childPG.getIndexKey();
                HashMap childPGCUs = (HashMap)pgInfoTmp.get(childPGIndexKey);
                if (null == childPGCUs) continue;
                parentPGCUs.putAll(childPGCUs);
                pgInfoTmp.remove(childPGIndexKey);
            }
        }
        int[] cuLdevs = (int[])cuLdevInfo.get(0);
        HashMap<String, SJmoPgDetail> pgDetailMap = new HashMap<String, SJmoPgDetail>();
        for (SJmoPgDetail pgDetailInfo : pgDetails) {
            pgDetailMap.put(pgDetailInfo.getIndexKey(), pgDetailInfo);
        }
        for (String pgIndexKey : pgInfoTmp.keySet()) {
            SJmoPgDetail pgDetailInfo;
            HashMap pgCus = (HashMap)pgInfoTmp.get(pgIndexKey);
            if (null == pgCus || 1 > pgCus.size() || (pgDetailInfo = (SJmoPgDetail)pgDetailMap.get(pgIndexKey)) == null) continue;
            SJctrSelectByParityGroupsPGDetailData tableData = new SJctrSelectByParityGroupsPGDetailData();
            tableData.setPgDetailInfo(pgDetailInfo);
            ArrayList<SJctrMonitorCUInfo> monCUInfo = new ArrayList<SJctrMonitorCUInfo>();
            for (String strCuNo : pgCus.keySet()) {
                int cuNo = (Integer)pgCus.get(strCuNo);
                SJctrMonitorCUInfo cuInfo = new SJctrMonitorCUInfo(strCuNo, (short)cuNo, cuLdevs[cuNo]);
                monCUInfo.add(cuInfo);
            }
            tableData.setCusInfo(monCUInfo);
            pgTableInfo.add(tableData);
        }
        if (0 == pgTableInfo.size()) {
            SJctrError err = new SJctrError(51, 22, 105230);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrSelectByParityGroupsTableModel pgTable = (SJctrSelectByParityGroupsTableModel)this.getDataObjectModel(KEY_AVAILABLE_PGS);
        Collections.sort(pgTableInfo, PG_COMP);
        pgTable.setBasicDataList(pgTableInfo);
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        ArrayList<Integer> selectCUs = new ArrayList<Integer>();
        SJctrSelectByParityGroupsTableModel pgTable = (SJctrSelectByParityGroupsTableModel)this.getDataObjectModel(KEY_AVAILABLE_PGS);
        List<Object> selectPGList = pgTable.getSelectedRowData();
        for (SJctrSelectByParityGroupsPGDetailData sJctrSelectByParityGroupsPGDetailData : selectPGList) {
            List<SJctrMonitorCUInfo> pgCusInfo = sJctrSelectByParityGroupsPGDetailData.getCusInfo();
            for (SJctrMonitorCUInfo cuInfo : pgCusInfo) {
                short cuNo = cuInfo.getSCu();
                if (selectCUs.contains(cuNo)) continue;
                selectCUs.add(Integer.valueOf(cuNo));
            }
        }
        this.putCache(SJctrSelectByParityGroupsDC.class, selectCUs);
        return ret;
    }

    private void makePGDetail(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrSelectByParityGroupsTableModel pgTable = (SJctrSelectByParityGroupsTableModel)this.getDataObjectModel(KEY_AVAILABLE_PGS);
        List<Object> selectPGList = pgTable.getSelectedRowData();
        HashMap param = new HashMap();
        param.put(SJctrSelectByParityGroupsPGDetailData.class.getName(), selectPGList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrParityGroupPropertyDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    public static enum SELECT_BY_PG_MSG implements SJctrNotifyState
    {
        SELECT_DETAIL;

    }
}

