/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import sanproject.serverux.dataimpl.TierInfoPerPbTSMMonitor;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPbTSMFrequencyDistributionInfo;

public abstract class SJctrAverageNumberOfIoDataModelBase
extends SJctrSimpleDataModel {
    protected SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = null;
    protected TierInfoPerPbTSMMonitor[] tierInfoPerPbTSMMonitor = null;

    protected abstract long getIoPh(TierInfoPerPbTSMMonitor var1);

    protected abstract String getKeyAverageNumOfIoTotal();

    protected abstract String getKeyAverageNumOfIoTier();

    protected abstract String getIoPhNameStr();

    @Override
    protected void makeDataObject() {
        ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), "?");
        SJctrPbTsmUtility.initializeTierData(this, this.getKeyAverageNumOfIoTier(), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "?", "?"));
        this.pbtsmInfo = SJctrPbTsmUtility.getPbtsmInfoEntirePoolData(this.getDataController());
        this.tierInfoPerPbTSMMonitor = this.pbtsmInfo.getTierInfoPerPbTSMMonitor();
        if (null != this.tierInfoPerPbTSMMonitor && 0 < this.tierInfoPerPbTSMMonitor.length) {
            long totalIoPh = this.getTotalIoPh();
            this.makeTotalIoph(totalIoPh);
            this.makeIophEachTier(totalIoPh);
            SJctrPbTsmUtility.makeUnmountedTierRmiData(this.tierInfoPerPbTSMMonitor, (SJctrSimpleDataModel)this, this.getKeyAverageNumOfIoTier(), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "-", "-"));
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "makeDataObject", "tierInfoPerPbTSMMonitor is null or size illegal.");
        }
    }

    protected long getTotalIoPh() {
        long tierTotalIoPH = -2L;
        for (int tierNum = 0; tierNum < this.tierInfoPerPbTSMMonitor.length; ++tierNum) {
            TierInfoPerPbTSMMonitor tierInfo = this.tierInfoPerPbTSMMonitor[tierNum];
            if (tierInfo != null) {
                long tierIoPH = this.getIoPh(tierInfo);
                if (tierIoPH > -1L) {
                    if (tierTotalIoPH <= -1L) {
                        tierTotalIoPH = 0L;
                    }
                    tierTotalIoPH += tierIoPH;
                    continue;
                }
                if (tierIoPH == -1L) {
                    if (tierTotalIoPH != -2L) continue;
                    tierTotalIoPH = -1L;
                    continue;
                }
                SJctrLogUty.error(this.getClass().getSimpleName(), "getTotalIoPh", "tierIoPH is illegal.");
                continue;
            }
            SJctrLogUty.error(this.getClass().getSimpleName(), "getTotalIoPh", "tierInfo[" + tierNum + "] is null.");
        }
        return tierTotalIoPH;
    }

    protected void makeTotalIoph(long totalIoPh) {
        if (totalIoPh > -1L) {
            String strIoph = String.valueOf(totalIoPh);
            ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), strIoph);
        } else if (totalIoPh == -1L) {
            ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), "-");
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "makeTotalIoph", "totalIoph is illegal.");
        }
    }

    protected void makeIophEachTier(long tierTotalIoPh) {
        String strFuncName = "makeIophEachTier";
        for (int tierNum = 0; tierNum < this.tierInfoPerPbTSMMonitor.length; ++tierNum) {
            TierInfoPerPbTSMMonitor tierInfo = this.tierInfoPerPbTSMMonitor[tierNum];
            if (tierInfo != null) {
                long tierIoPh = this.getIoPh(tierInfo);
                if (tierIoPh >= 0L) {
                    long tierHitRate = SJctrPbTsmUtility.getTierHitRate(tierIoPh, tierTotalIoPh);
                    String tierIoHitRateStr = SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), String.valueOf(tierIoPh), String.valueOf(tierHitRate));
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), tierIoHitRateStr);
                } else if (tierIoPh == -1L) {
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "-", "-"));
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierIoPh of tierInfoPerPbTSMMonitor[" + tierNum + "] is illegal.");
                }
                this.getLogUty().putlog(strFuncName, this.getIoPhNameStr() + " Tier[" + tierNum + "] is " + tierIoPh);
                continue;
            }
            SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierInfoPerPbTSMMonitor[" + tierNum + "] is null.");
        }
    }
}

