/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.util.ArrayList;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;

public class SJctrBasicUsableCapacityDataModel
extends SJctrSimpleDataModel {
    private static final String KEY_TOTAL_BASIC_USABLE_CAPACITY_TOTAL = "COM_TOTAL_BASIC_USABLE_CAPACITY_TOTAL";
    private static final String KEY_TOTAL_BASIC_USABLE_CAPACITY_TIER = "COM_TOTAL_BASIC_USABLE_CAPACITY_TIER";
    private static final String KEY_USED_BASIC_USABLE_CAPACITY_RATIO_TOTAL = "COM_USED_BASIC_USABLE_CAPACITY_RATIO_TOTAL";
    private static final String KEY_USED_BASIC_USABLE_CAPACITY_RATIO_TIER = "COM_USED_BASIC_USABLE_CAPACITY_RATIO_TIER";
    private static final int TIER1 = 1;

    @Override
    protected void makeDataObject() {
        this.makeDataObjectForBasicUsableCapa();
    }

    private void makeDataObjectForBasicUsableCapa() {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        String strInitialize = "? " + lLeft + "?" + " " + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_BASIC_USABLE_CAPACITY_TOTAL, "?");
        SJctrPbTsmUtility.initializeTierData(this, KEY_TOTAL_BASIC_USABLE_CAPACITY_TIER, "?");
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_BASIC_USABLE_CAPACITY_RATIO_TOTAL, strInitialize);
        SJctrPbTsmUtility.initializeTierData(this, KEY_USED_BASIC_USABLE_CAPACITY_RATIO_TIER, strInitialize);
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(this.getDataController());
        this.makeBasicUsableCapacity(poolDetail);
    }

    private void makeBasicUsableCapacity(SJmoPoolDetail poolDetail) {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        long lActualTotalPages = 0L;
        long lActualUsedPages = 0L;
        ArrayList<SJmoPoolTierInfo> alTierInfo = poolDetail.getAlTierInfo();
        if (null != alTierInfo && 0 < alTierInfo.size()) {
            for (SJmoPoolTierInfo tierInfo : alTierInfo) {
                if (tierInfo.getSTierNum() != 1) continue;
                lActualTotalPages = tierInfo.getLActualTotalPages();
                lActualUsedPages = tierInfo.getLActualUsedPages();
                break;
            }
        }
        long lPoolFmcActualPages = poolDetail.getLPoolFmcActualPages();
        long lPoolPageSize = poolDetail.getPageSize();
        long lPoolCapa = lActualTotalPages * lPoolPageSize;
        String strTotalCapacity = "?";
        strTotalCapacity = lPoolFmcActualPages == 0L ? "-" : this.getStrCapacity(lPoolCapa);
        ((SJctrDataObject)this.getManageData()).setData("COM_TOTAL_BASIC_USABLE_CAPACITY_TIER1", strTotalCapacity);
        ((SJctrDataObject)this.getManageData()).setData("COM_TOTAL_BASIC_USABLE_CAPACITY_TIER2", "-");
        ((SJctrDataObject)this.getManageData()).setData("COM_TOTAL_BASIC_USABLE_CAPACITY_TIER3", "-");
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_BASIC_USABLE_CAPACITY_TOTAL, "-");
        String strUsedCapacityRatio = "? " + lLeft + "?" + " " + percent + lRight;
        if (lPoolFmcActualPages == 0L) {
            strUsedCapacityRatio = "- " + lLeft + "-" + " " + percent + lRight;
        } else {
            long lPoolUsedCapa = lActualUsedPages * lPoolPageSize;
            String strUsedCapacity = this.getStrCapacity(lPoolUsedCapa);
            SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
            String strUsedRatio = poolUtility.capaRatioCalculation(lPoolUsedCapa, lPoolCapa);
            strUsedCapacityRatio = strUsedCapacity + " " + lLeft + strUsedRatio + percent + lRight;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_USED_BASIC_USABLE_CAPACITY_RATIO_TIER1", strUsedCapacityRatio);
        ((SJctrDataObject)this.getManageData()).setData("COM_USED_BASIC_USABLE_CAPACITY_RATIO_TIER2", "-");
        ((SJctrDataObject)this.getManageData()).setData("COM_USED_BASIC_USABLE_CAPACITY_RATIO_TIER3", "-");
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_BASIC_USABLE_CAPACITY_RATIO_TOTAL, "-");
    }

    private String getStrCapacity(long lCapacity) {
        String strFuncName = "getStrCapacity";
        String strCapacity = "?";
        if (lCapacity > -1L) {
            SJctrCapacityUtility capaUtility = this.getComUtility().getCapacityUtility();
            long lBlock = capaUtility.valueOf(lCapacity, SJctrCapacityUtility.UNIT.KB);
            strCapacity = capaUtility.toUnitString(lBlock);
        } else {
            this.getLogUty().putlog(strFuncName, "lCapacity is illegal");
        }
        return strCapacity;
    }
}

