/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.util.ArrayList;
import sanproject.serverux.dataimpl.AouVolTierInfo;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetAouVolRelationInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;

public class SJctrCapacityDataModel
extends SJctrSimpleDataModel {
    private static final String KEY_TOTAL_CAPACITY_TOTAL = "COM_TOTAL_CAPACITY_TOTAL";
    private static final String KEY_TOTAL_CAPACITY_TIER = "COM_TOTAL_CAPACITY_TIER";
    private static final String KEY_USED_CAPACITY_RATIO_TOTAL = "COM_USED_CAPACITY_RATIO_TOTAL";
    private static final String KEY_USED_CAPACITY_RATIO_TIER = "COM_USED_CAPACITY_RATIO_TIER";

    @Override
    protected void makeDataObject() {
        int iTransitionDispID = SJctrPbTsmUtility.getAgencyScreenId(this.getDataController());
        if (iTransitionDispID == 2305) {
            this.makeDataObjectForPool();
        } else {
            this.makeDataObjectForVVol();
        }
    }

    private void makeDataObjectForPool() {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        String strInitialize = "? " + lLeft + "?" + " " + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TOTAL, "?");
        SJctrPbTsmUtility.initializeTierData(this, KEY_TOTAL_CAPACITY_TIER, "?");
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TOTAL, strInitialize);
        SJctrPbTsmUtility.initializeTierData(this, KEY_USED_CAPACITY_RATIO_TIER, strInitialize);
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(this.getDataController());
        this.makeCapacityTotalForPool(poolDetail);
        ArrayList<SJmoPoolTierInfo> alTierInfo = poolDetail.getAlTierInfo();
        long lPoolPageSize = poolDetail.getPageSize();
        this.makeCapacityEachTierForPool(alTierInfo, lPoolPageSize);
        String bar = "-";
        String strUnmounted = bar + " " + lLeft + bar + " " + percent + lRight;
        SJctrPbTsmUtility.makeUnmountedTierData(this, KEY_TOTAL_CAPACITY_TIER, bar);
        SJctrPbTsmUtility.makeUnmountedTierData(this, KEY_USED_CAPACITY_RATIO_TIER, strUnmounted);
    }

    private void makeCapacityTotalForPool(SJmoPoolDetail poolDetail) {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        long lPoolPageSize = poolDetail.getPageSize();
        long lPoolPages = poolDetail.getPoolPages();
        long lPoolCapa = lPoolPages * lPoolPageSize;
        String strTotalCapacity = this.getStrCapacity(lPoolCapa);
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TOTAL, strTotalCapacity);
        long lPoolUsedPages = poolDetail.getPoolUsedPages();
        long lPoolUsedCapa = lPoolUsedPages * lPoolPageSize;
        String strUsedCapacity = this.getStrCapacity(lPoolUsedCapa);
        String strUsedRatio = poolUtility.capaRatioCalculation(lPoolUsedCapa, lPoolCapa);
        String strUsedCapacityRatio = strUsedCapacity + " " + lLeft + strUsedRatio + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TOTAL, strUsedCapacityRatio);
    }

    private void makeCapacityEachTierForPool(ArrayList<SJmoPoolTierInfo> alTierInfo, long lPoolPageSize) {
        String strFuncName = "makeCapacityEachTierForPool";
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        if (null != alTierInfo && 0 < alTierInfo.size()) {
            for (SJmoPoolTierInfo tierInfo : alTierInfo) {
                short sTierNum = tierInfo.getSTierNum();
                String strTierNum = String.valueOf(sTierNum);
                long lTotalTier = tierInfo.getLTotalTier();
                long lTotalPage = lTotalTier * lPoolPageSize;
                String strTotalCapacity = this.getStrCapacity(lTotalPage);
                ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TIER + strTierNum, strTotalCapacity);
                long lUseTier = tierInfo.getLUseTier();
                long lUsedPage = lUseTier * lPoolPageSize;
                String strUsedCapacity = this.getStrCapacity(lUsedPage);
                String strUsedRatio = poolUtility.capaRatioCalculation(lUsedPage, lTotalPage);
                String strUsedCapacityRatio = strUsedCapacity + " " + lLeft + strUsedRatio + percent + lRight;
                ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TIER + strTierNum, strUsedCapacityRatio);
            }
        } else {
            this.getLogUty().putlog(strFuncName, "alTierInfo is null or size zero");
        }
    }

    private void makeDataObjectForVVol() {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        String strInitialize = "? " + lLeft + "?" + " " + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TOTAL, "?");
        SJctrPbTsmUtility.initializeTierData(this, KEY_TOTAL_CAPACITY_TIER, "?");
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TOTAL, strInitialize);
        SJctrPbTsmUtility.initializeTierData(this, KEY_USED_CAPACITY_RATIO_TIER, strInitialize);
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(this.getDataController());
        ArrayList<SJmoPoolTierInfo> alTierInfo = poolDetail.getAlTierInfo();
        SJctrPoolGetAouVolRelationInfo aouVolRelation = SJctrPbTsmUtility.getAouVolRelationInfo(this.getDataController());
        this.makeCapacityTotalForVVol(aouVolRelation, poolDetail);
        AouVolTierInfo[] aouVolTierInfoList = aouVolRelation.getObjAouVolTierInfo();
        long lVVolPageSize = aouVolRelation.getLPageCapa();
        long lPoolPageSize = poolDetail.getPageSize();
        this.makeCapacityEachTierForVVol(aouVolTierInfoList, lVVolPageSize, alTierInfo, lPoolPageSize);
        String bar = "-";
        String strUnmounted = bar + " " + lLeft + bar + " " + percent + lRight;
        SJctrPbTsmUtility.makeUnmountedTierData(this, KEY_TOTAL_CAPACITY_TIER, bar);
        SJctrPbTsmUtility.makeUnmountedTierData(this, KEY_USED_CAPACITY_RATIO_TIER, strUnmounted);
    }

    private void makeCapacityTotalForVVol(SJctrPoolGetAouVolRelationInfo aouVolRelation, SJmoPoolDetail poolDetail) {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        long lPoolPageSize = poolDetail.getPageSize();
        long lVVolPageSize = aouVolRelation.getLPageCapa();
        long lPoolPages = poolDetail.getPoolPages();
        long lPoolCapa = lPoolPages * lPoolPageSize;
        String strTotalCapacity = this.getStrCapacity(lPoolCapa);
        ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TOTAL, strTotalCapacity);
        long lUsedPage = aouVolRelation.getLUsedPage();
        long lUsedCapa = lVVolPageSize * lUsedPage;
        String strUsedCapacity = this.getStrCapacity(lUsedCapa);
        String strUsedRatio = poolUtility.capaRatioCalculation(lUsedCapa, lPoolCapa);
        String strUsedCapacityRatio = strUsedCapacity + " " + lLeft + strUsedRatio + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TOTAL, strUsedCapacityRatio);
    }

    private void makeCapacityEachTierForVVol(AouVolTierInfo[] aouVolTierInfoList, long lVVolPageSize, ArrayList<SJmoPoolTierInfo> alTierInfo, long lPoolPageSize) {
        String strFuncName = "makeCapacityEachTierForVVol";
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        if (null != aouVolTierInfoList && null != alTierInfo) {
            for (int iTier = 0; iTier < aouVolTierInfoList.length && iTier < alTierInfo.size(); ++iTier) {
                AouVolTierInfo aouInfo = aouVolTierInfoList[iTier];
                SJmoPoolTierInfo tierInfo = alTierInfo.get(iTier);
                if (tierInfo != null && aouInfo != null) {
                    String strTierNum = String.valueOf(iTier + 1);
                    long lTotalTierPages = tierInfo.getLTotalTier();
                    long lTotalTierCapa = lTotalTierPages * lPoolPageSize;
                    String strTotalCapacity = this.getStrCapacity(lTotalTierCapa);
                    ((SJctrDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY_TIER + strTierNum, strTotalCapacity);
                    long lUseTierPages = aouVolTierInfoList[iTier].getLUseTier();
                    long lUseTierCapa = lVVolPageSize * lUseTierPages;
                    String strVolCapacity = this.getStrCapacity(lUseTierCapa);
                    String strUsedRatio = poolUtility.capaRatioCalculation(lUseTierCapa, lTotalTierCapa);
                    String strUsedCapacityRatio = strVolCapacity + " " + lLeft + strUsedRatio + percent + lRight;
                    ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TIER + strTierNum, strUsedCapacityRatio);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "aouVolTierInfoList[" + iTier + "] or alTierInfo[" + iTier + "] is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "aouVolTierInfoList is null or alTierInfo is null");
        }
    }

    private String getStrCapacity(long lCapacity) {
        String strFuncName = "getStrCapacity";
        String strCapacity = "?";
        if (lCapacity > -1L) {
            SJctrCapacityUtility capaUtility = this.getComUtility().getCapacityUtility();
            long lBlock = capaUtility.valueOf(lCapacity, SJctrCapacityUtility.UNIT.KB);
            strCapacity = capaUtility.toUnitString(lBlock);
        } else {
            this.getLogUty().putlog(strFuncName, "lCapacity is illegal");
        }
        return strCapacity;
    }
}

