/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.common.Robj_interface_PbTSMFrequencyDistributionPool2;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation3;
import sanproject.serverux.dataimpl.POOLgetPagesEachPolicyInfo;
import sanproject.serverux.dataimpl.POOLgetPbTSMFrequencyDistributionEachLane_IN;
import sanproject.serverux.dataimpl.PbTSMFrequencyDistributionPool;
import sanproject.serverux.dataimpl.PbTSMFrequencyDistributionPool2;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoActualDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoTargetDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoTieringPolicyDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrBasicUsableCapacityDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrCapacityDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrCurrentAverageNumberOfIoDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrGetPbTSMFrequencyDistributionEachLaneInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrGraphDataModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPbTSMFrequencyDistributionInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetAouVolRelationInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetPagesEachPolicyInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrTierPropertySummaryModel;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrUsedCapacityRatioTieringPolicyDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPbTSMFrequencyDistributionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolSummary;
import sanproject.sn2.model.connector.kind.SJmoGetPoolTieringPolicy;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTierPropertyDC
extends SJctrDialogDataController {
    private static final String KEY_SELECT_OBJECT_ELEMENT = "COM_SELECT_OBJECT_ELEMENT";
    private static final String KEY_SELECT_TIERING_POLICY_NAME = "COM_SELECT_TIERING_POLICY_NAME";
    private static final String KEY_TOGGLE_PULLDOWN_DISPLAY = "COM_TOGGLE_PULLDOWN_DISPLAY";
    private static final String KEY_SUMMARY_FRAME_TYPE = "COM_SUMMARY_FRAME_TYPE";
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_USED_CAPACITY_RATIO_TIERING_POLICY = "COM_USED_CAPACITY_RATIO_TIERING_POLICY";
    private static final String KEY_AVERAGE_NUMBER_OF_IO_TIERING_POLICY = "COM_AVERAGE_NUMBER_OF_IO_TIERING_POLICY";
    private static final String KEY_GRAPH_DATA = "COM_GRAPH_DATA";
    private static final String KEY_TOTAL_LEGEND_NAME = "COM_TOTAL_LEGEND_NAME";
    private static final int DISP_ID = 34664468;
    private static final int ENTIRE_POOL_FRAME = 0;
    private static final int TIERING_POLICY_FRAME = 1;
    private static final int DP_VOL_FRAME = 2;
    private static final byte KIND_POOL = 0;
    private static final byte KIND_V_VOL = 1;
    private static final int PBTSM_TIER_PARAM_LENGTH_POOL = 2;
    private static final int PBTSM_TIER_PARAM_LENGTH_VVOL = 3;
    private static final short MONMODE_PERIOD = 0;
    private static final short MONMODE_CONTINUOUS = 1;

    public SJctrTierPropertyDC() throws SJcException {
        super(34664468);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrTierPropertySummaryModel());
        this.addDataObjectModel(KEY_GRAPH_DATA, new SJctrGraphDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        boolean bRtn = true;
        List<?> tierParamInfoList = this.getCache("COM_PBTSM_TIER_INFO");
        this.checkSuccessionInfo(tierParamInfoList);
        return bRtn;
    }

    private boolean checkSuccessionInfo(List<?> tierParamInfoList) {
        int iTransitionDispID;
        String strFuncName = "checkSuccessionInfo";
        if (null == tierParamInfoList) {
            this.getLogUty().putlog(strFuncName, "List of PbTSM data is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (2 > tierParamInfoList.size()) {
            this.getLogUty().putlog(strFuncName, "Pool data is insufficient");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (null == tierParamInfoList.get(0)) {
            this.getLogUty().putlog(strFuncName, "Disp data is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (!(tierParamInfoList.get(0) instanceof Integer)) {
            this.getLogUty().putlog(strFuncName, "Disp ID data is invalid.");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if ((iTransitionDispID = ((Integer)tierParamInfoList.get(0)).intValue()) == 2307 && iTransitionDispID == 1537 && 3 > tierParamInfoList.size()) {
            this.getLogUty().putlog(strFuncName, "V-Vol data is insufficient");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (iTransitionDispID != 2305 && iTransitionDispID != 2307 && iTransitionDispID != 1537) {
            this.getLogUty().putlog(strFuncName, "Disp data is invalid");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (null == tierParamInfoList.get(1)) {
            this.getLogUty().putlog(strFuncName, "Pool Index data is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (!(tierParamInfoList.get(1) instanceof SJmoPoolIndex)) {
            this.getLogUty().putlog(strFuncName, "Pool Index data is invalid");
            SJctrPbTsmUtility.SJctrErrorDialog(107001);
        }
        if (iTransitionDispID == 2307 || iTransitionDispID == 1537) {
            if (null == tierParamInfoList.get(2)) {
                this.getLogUty().putlog(strFuncName, "V-Vol Index data is null");
                SJctrPbTsmUtility.SJctrErrorDialog(107001);
            }
            if (!(tierParamInfoList.get(2) instanceof SJmoLdevIndex)) {
                this.getLogUty().putlog(strFuncName, "V-Vol Index data is invalid");
                SJctrPbTsmUtility.SJctrErrorDialog(107001);
            }
        }
        return true;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> setReq = super.getModelDirect();
        int iTransitionDispID = SJctrPbTsmUtility.getAgencyScreenId(this);
        setReq.add(this.createModelDirect(new SJmoGetPoolDetail()));
        setReq.add(this.createModelDirect(new SJmoGetPoolSummary()));
        setReq.add(this.createModelDirect(new SJmoGetPoolTieringPolicy()));
        if (iTransitionDispID == 2305) {
            setReq.add(this.createModelDirect(new SJmoGetPoolNameInfo()));
        } else {
            setReq.add(this.createModelDirect(new SJmoGetHDPRelation()));
            setReq.add(this.createModelDirect(new SJmoGetLdevDetail()));
            setReq.add(this.createModelDirect(new SJmoGetLdevNicknameInfo()));
        }
        return setReq;
    }

    private SJctrGetDirectWrapper createModelDirect(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        return directWrapper;
    }

    private List<SJmoThroughRmiData> getRmiDataList(SJctrGetDirectWrapper wrapper) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        set.add(wrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> rmiList = map.get(wrapper);
        if (null == rmiList) {
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        return rmiList;
    }

    private PbTSMFrequencyDistributionPool[] createPbTsmRmiIF() {
        PbTSMFrequencyDistributionPool[] rmiargs = new PbTSMFrequencyDistributionPool[1];
        PbTSMFrequencyDistributionPool rmiarg = new PbTSMFrequencyDistributionPool();
        int iTransitionDispID = SJctrPbTsmUtility.getAgencyScreenId(this);
        if (iTransitionDispID == 2305) {
            rmiarg.setByKind((byte)0);
            SJmoPoolIndex poolIndex = SJctrPbTsmUtility.getPoolIndex(this);
            rmiarg.setSPoolId((short)poolIndex.getPoolId());
        } else {
            rmiarg.setByKind((byte)1);
            SJmoLdevIndex vvolIndex = SJctrPbTsmUtility.getLdevIndex(this);
            rmiarg.setSLDKC(vvolIndex.getSLdkc());
            rmiarg.setSCU(vvolIndex.getSCu());
            rmiarg.setSLDEV(vvolIndex.getSLdev());
        }
        rmiargs[0] = rmiarg;
        return rmiargs;
    }

    private POOLgetPbTSMFrequencyDistributionEachLane_IN createPbTsmRmiIfEachLane() {
        POOLgetPbTSMFrequencyDistributionEachLane_IN rmiarg = new POOLgetPbTSMFrequencyDistributionEachLane_IN();
        Robj_interface_PbTSMFrequencyDistributionPool2[] poolLanes = new PbTSMFrequencyDistributionPool2[1];
        PbTSMFrequencyDistributionPool2 poolLane = new PbTSMFrequencyDistributionPool2();
        SJmoPoolIndex poolIndex = SJctrPbTsmUtility.getPoolIndex(this);
        poolLane.setSPoolId((short)poolIndex.getPoolId());
        poolLanes[0] = poolLane;
        rmiarg.setPoolInfo(poolLanes);
        return rmiarg;
    }

    @Override
    public boolean checkConstructData() {
        String strFuncName = "checkConstructData";
        this.getLogUty().putlog(strFuncName, "Start");
        int iDispID = SJctrPbTsmUtility.getAgencyScreenId(this);
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(this);
        this.checkViewTierProperties(poolDetail, iDispID);
        Object[] poolArgInfo = this.createPbTsmRmiIF();
        List<SJmoThroughRmiData> rmiPbTSMList = this.getRmiDataList(this.createModelDirect(new SJmoGetPbTSMFrequencyDistributionInfo(poolArgInfo)));
        this.putCache(SJmoGetPbTSMFrequencyDistributionInfo.class, rmiPbTSMList);
        this.setPbtsmInfoEntirePool();
        this.createSelectObjectToggleButton();
        SJctrComboBoxDataModel tieringPolicyPulldownList = new SJctrComboBoxDataModel();
        tieringPolicyPulldownList.setEnable(false);
        this.addDataObjectModel("COM_TIERING_POLICY_PULLDOWNLIST", tieringPolicyPulldownList);
        this.getManageData().setData(KEY_TOGGLE_PULLDOWN_DISPLAY, false);
        if (iDispID == 2305) {
            this.getManageData().setData(KEY_SUMMARY_FRAME_TYPE, 0);
            if ((poolDetail.getITierControlInfo() & 0x80) != 0) {
                this.getManageData().setData(KEY_TOGGLE_PULLDOWN_DISPLAY, true);
                POOLgetPbTSMFrequencyDistributionEachLane_IN poolLane = this.createPbTsmRmiIfEachLane();
                List<SJmoThroughRmiData> rmiPbTSMEachLaneList = this.getRmiDataList(this.createModelDirect(new SJctrGetPbTSMFrequencyDistributionEachLaneInfo(poolLane)));
                this.putCache(SJctrGetPbTSMFrequencyDistributionEachLaneInfo.class, rmiPbTSMEachLaneList);
                this.setPbtsmInfoTieringPolicy();
                this.setPbtsmPagesInfo();
                this.addDataObjectModel(KEY_USED_CAPACITY_RATIO_TIERING_POLICY, new SJctrUsedCapacityRatioTieringPolicyDataModel());
                this.addDataObjectModel(KEY_AVERAGE_NUMBER_OF_IO_TIERING_POLICY, new SJctrAverageNumberOfIoTieringPolicyDataModel());
            }
        } else {
            this.getManageData().setData(KEY_SUMMARY_FRAME_TYPE, 2);
            this.setAouVolRelationInfo();
        }
        this.setLegendName();
        this.getLogUty().putlog(strFuncName, "End");
        return true;
    }

    private void checkViewTierProperties(SJmoPoolDetail poolDetail, int iDispID) {
        List<?> poolSummaryList = this.getCache(SJmoGetPoolSummary.class);
        SJmoPoolSummary poolSummary = (SJmoPoolSummary)poolSummaryList.get(0);
        if (null == poolDetail || null == poolSummary) {
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        if (2 != poolDetail.getPoolKind() && 3 != poolDetail.getPoolKind()) {
            SJctrPbTsmUtility.SJctrErrorDialog(105486);
        }
        if ((poolDetail.getITierControlInfo() & 0x80) == 0 && !poolSummary.chkBPoolControl(0x40000000)) {
            if (iDispID == 2305) {
                SJctrPbTsmUtility.SJctrErrorDialog(105241);
            } else {
                SJctrPbTsmUtility.SJctrErrorDialog(105242);
            }
        }
    }

    private void createSelectObjectToggleButton() {
        SJctrRadioButtonGroupDataModel selectObjectToggleButton = new SJctrRadioButtonGroupDataModel();
        selectObjectToggleButton.add("COM_ENTIRE_POOL");
        selectObjectToggleButton.add("COM_TIERING_POLICY");
        selectObjectToggleButton.setSelect("COM_ENTIRE_POOL");
        selectObjectToggleButton.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrDataObject) {
                    SJctrDataObject data = (SJctrDataObject)setObject;
                    Integer eventType = (Integer)data.getData(SJctrTierPropertyDC.KEY_SELECT_OBJECT_ELEMENT);
                    if (eventType == 0) {
                        SJctrTierPropertyDC.this.createEntirePoolData();
                    } else {
                        SJctrTierPropertyDC.this.createMaintainData();
                    }
                }
            }
        });
        this.addDataObjectModel("COM_SELECT_OBJECT_TOGGLE_BUTTON", selectObjectToggleButton);
    }

    private void createTieringPolicyPulldownList() {
        String strFuncName = "createTieringPolicyPulldownList";
        SJctrComboBoxDataModel tieringPolicyPulldownList = new SJctrComboBoxDataModel();
        List<?> tieringPolicyList = this.getCache(SJmoGetPoolTieringPolicy.class);
        if (null != tieringPolicyList && 0 < tieringPolicyList.size()) {
            for (SJmoPoolTieringPolicy tieringPolicy : tieringPolicyList) {
                if (null != tieringPolicy) {
                    short sPolicyId = tieringPolicy.getPolicyId();
                    String strPolicyIdKey = String.valueOf(sPolicyId);
                    String strPolicyNameLabel = SJctrPbTsmUtility.getTieringPolicyNameLabel(tieringPolicy);
                    tieringPolicyPulldownList.addItem(strPolicyIdKey, strPolicyNameLabel);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "tieringPolicy is null");
            }
            tieringPolicyPulldownList.setSelectedIndex(0);
        } else {
            this.getLogUty().putlog(strFuncName, "tieringPolicyList is null or size zero");
        }
        tieringPolicyPulldownList.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrTierPropertyDC.this.createEachTieringPolicyData();
                }
            }
        });
        this.addDataObjectModel("COM_TIERING_POLICY_PULLDOWNLIST", tieringPolicyPulldownList);
    }

    private void createEntirePoolData() {
        this.getManageData().setData(KEY_SUMMARY_FRAME_TYPE, 0);
        SJctrRadioButtonGroupDataModel selectObjectToggleButton = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_SELECT_OBJECT_TOGGLE_BUTTON");
        selectObjectToggleButton.setSelect("COM_ENTIRE_POOL");
        SJctrComboBoxDataModel tieringPolicyPulldownList = new SJctrComboBoxDataModel();
        tieringPolicyPulldownList.setEnable(false);
        this.addDataObjectModel("COM_TIERING_POLICY_PULLDOWNLIST", tieringPolicyPulldownList);
        SJctrTierPropertySummaryModel summary = (SJctrTierPropertySummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        if (summary != null) {
            SJctrCurrentAverageNumberOfIoDataModel currentIoData = (SJctrCurrentAverageNumberOfIoDataModel)summary.getDataModel("COM_CURRENT_AVG_NUM_OF_IO");
            currentIoData.setDirty();
            SJctrAverageNumberOfIoActualDataModel actualIoData = (SJctrAverageNumberOfIoActualDataModel)summary.getDataModel("COM_AVERAGE_NUMBER_OF_IO_ACTUAL");
            actualIoData.setDirty();
            SJctrAverageNumberOfIoTargetDataModel targetIoData = (SJctrAverageNumberOfIoTargetDataModel)summary.getDataModel("COM_AVERAGE_NUMBER_OF_IO_TARGET");
            targetIoData.setDirty();
            SJctrCapacityDataModel capacityData = (SJctrCapacityDataModel)summary.getDataModel("COM_CAPACITY");
            capacityData.setDirty();
            SJctrBasicUsableCapacityDataModel basicUsableCapacityData = (SJctrBasicUsableCapacityDataModel)summary.getDataModel("COM_BASIC_USABLE_CAPACITY");
            basicUsableCapacityData.setDirty();
        }
        SJctrGraphDataModel graphData = (SJctrGraphDataModel)this.getDataObjectModel(KEY_GRAPH_DATA);
        graphData.makeDataModel();
        graphData.setDirty();
        this.setLegendName();
    }

    private void createMaintainData() {
        this.createTieringPolicyPulldownList();
        this.createEachTieringPolicyData();
    }

    private void createEachTieringPolicyData() {
        this.getManageData().setData(KEY_SUMMARY_FRAME_TYPE, 1);
        SJctrRadioButtonGroupDataModel selectObjectToggleButton = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_SELECT_OBJECT_TOGGLE_BUTTON");
        selectObjectToggleButton.setSelect("COM_TIERING_POLICY");
        SJctrComboBoxDataModel tieringPolicyPulldownList = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_TIERING_POLICY_PULLDOWNLIST");
        int iTieringPolicyKey = tieringPolicyPulldownList.getSelectedIndex();
        tieringPolicyPulldownList.setEnable(true);
        tieringPolicyPulldownList.setDirty();
        List<?> tieringPolicyList = this.getCache(SJmoGetPoolTieringPolicy.class);
        SJmoPoolTieringPolicy tieringPolicy = (SJmoPoolTieringPolicy)tieringPolicyList.get(iTieringPolicyKey);
        String strTieringPolicy = SJctrPbTsmUtility.getTieringPolicyNameLabel(tieringPolicy);
        this.getManageData().setData(KEY_SELECT_TIERING_POLICY_NAME, " : " + strTieringPolicy);
        SJctrUsedCapacityRatioTieringPolicyDataModel usedDataEachTieringPolicy = (SJctrUsedCapacityRatioTieringPolicyDataModel)this.getDataObjectModel(KEY_USED_CAPACITY_RATIO_TIERING_POLICY);
        usedDataEachTieringPolicy.makeDataObjectForTieringPolicy();
        usedDataEachTieringPolicy.setDirty();
        SJctrTierPropertySummaryModel summary = (SJctrTierPropertySummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        if (summary != null) {
            SJctrAverageNumberOfIoDataModel IoData = (SJctrAverageNumberOfIoDataModel)summary.getDataModel("COM_AVERAGE_NUMBER_OF_IO");
            IoData.setDirty();
            SJctrCapacityDataModel capacityData = (SJctrCapacityDataModel)summary.getDataModel("COM_CAPACITY");
            capacityData.setDirty();
        }
        SJctrAverageNumberOfIoTieringPolicyDataModel iophDataEachTieringPolicy = (SJctrAverageNumberOfIoTieringPolicyDataModel)this.getDataObjectModel(KEY_AVERAGE_NUMBER_OF_IO_TIERING_POLICY);
        iophDataEachTieringPolicy.makeDataObjectForTieringPolicy();
        iophDataEachTieringPolicy.setDirty();
        SJctrGraphDataModel graphData = (SJctrGraphDataModel)this.getDataObjectModel(KEY_GRAPH_DATA);
        graphData.makeDataModel();
        graphData.setDirty();
        this.setLegendName();
    }

    private void setPbtsmInfoEntirePool() {
        Object[] rmiDataList = SJctrPbTsmUtility.getRmiPbtsmInfo(this);
        List<SJctrPbTSMFrequencyDistributionInfo> pbtsmInfoList = this.setPbtsmInfoList(rmiDataList);
        this.putCache("COM_PBTSM_ENTIRE_POOL_DATA", pbtsmInfoList);
    }

    private void setPbtsmInfoTieringPolicy() {
        Object[] rmiDataList = SJctrPbTsmUtility.getRmiPbtsmInfoEachLane(this);
        List<SJctrPbTSMFrequencyDistributionInfo> pbtsmInfoList = this.setPbtsmInfoList(rmiDataList);
        this.putCache("COM_PBTSM_TIERING_POLICY_DATA", pbtsmInfoList);
    }

    private List<SJctrPbTSMFrequencyDistributionInfo> setPbtsmInfoList(Object[] rmiDataList) {
        String strFuncName = "setPbtsmInfoList";
        ArrayList<SJctrPbTSMFrequencyDistributionInfo> pbtsmInfoList = new ArrayList<SJctrPbTSMFrequencyDistributionInfo>();
        if (null != rmiDataList && 0 < rmiDataList.length) {
            for (int i = 0; i < rmiDataList.length; ++i) {
                SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = new SJctrPbTSMFrequencyDistributionInfo(rmiDataList[i]);
                pbtsmInfoList.add(pbtsmInfo);
            }
        } else {
            this.getLogUty().putlog(strFuncName, "rmiDataList is null or size zero");
        }
        return pbtsmInfoList;
    }

    private void setPbtsmPagesInfo() {
        String strFuncName = "setPbtsmPagesInfo";
        ArrayList<SJctrPoolGetPagesEachPolicyInfo> pagesEachPolicyList = new ArrayList<SJctrPoolGetPagesEachPolicyInfo>();
        POOLgetPagesEachPolicyInfo[] rmiDataList = SJctrPbTsmUtility.getRmiPagesEachPolicyInfo(this);
        if (null != rmiDataList && 0 < rmiDataList.length) {
            for (int i = 0; i < rmiDataList.length; ++i) {
                SJctrPoolGetPagesEachPolicyInfo pbtsmPageInfo = new SJctrPoolGetPagesEachPolicyInfo(rmiDataList[i]);
                pagesEachPolicyList.add(pbtsmPageInfo);
            }
        } else {
            this.getLogUty().putlog(strFuncName, "rmiDataList is null or size zero");
        }
        this.putCache("COM_PBTSM_PAGE_TIERING_POLICY_DATA", pagesEachPolicyList);
    }

    protected void setAouVolRelationInfo() {
        ArrayList<SJctrPoolGetAouVolRelationInfo> aouVolRelationList = new ArrayList<SJctrPoolGetAouVolRelationInfo>();
        POOLgetAOUVolRelation3 rmiInfo = SJctrPbTsmUtility.getRmiAOUVolRelation(this);
        SJctrPoolGetAouVolRelationInfo aouInfo = new SJctrPoolGetAouVolRelationInfo(rmiInfo);
        aouVolRelationList.add(aouInfo);
        this.putCache("COM_AOU_VOL_RELATION_DATA", aouVolRelationList);
    }

    private void setLegendName() {
        String strTotalLegendName = "?";
        int iFrameType = (Integer)this.getManageData().getData(KEY_SUMMARY_FRAME_TYPE);
        switch (iFrameType) {
            case 0: {
                strTotalLegendName = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PL);
                break;
            }
            case 1: {
                strTotalLegendName = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.POLICY);
                break;
            }
            case 2: {
                strTotalLegendName = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.VOLUME);
                break;
            }
        }
        SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = SJctrPbTsmUtility.getPbtsmInfo(this);
        short sTierRelocationPolicy = pbtsmInfo.getSTierRelocationPolicy();
        switch (sTierRelocationPolicy) {
            case 0: {
                break;
            }
            case 1: {
                strTotalLegendName = strTotalLegendName + SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.WEIGHTED_AVE);
                break;
            }
        }
        this.getManageData().setData(KEY_TOTAL_LEGEND_NAME, strTotalLegendName);
    }
}

