/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.comdialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrNFLdevInPGInfo;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.pool.com.SJctrWarnCreatePoolTableDataModel;
import sanproject.sn2.controller.wizard.pool.com.SJctrWarnExpandPoolTableDataModel;
import sanproject.sn2.controller.wizard.pool.comdialog.SJctrAvailableTableModel;
import sanproject.sn2.controller.wizard.pool.comdialog.SJctrSelectPoolVolDialogTableModel;
import sanproject.sn2.controller.wizard.pool.createpools.SJctrCreatePoolsAttribute;
import sanproject.sn2.controller.wizard.pool.createpools.SJctrCreatePoolsDC;
import sanproject.sn2.controller.wizard.pool.createpools.SJctrCreatePoolsTierInfo;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolDC;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrSelectPoolVolDialogDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 0x200A022;
    private SJctrSelectPoolVolDialogTableModel selPoolVolTable;
    private SJctrAvailableTableModel selAvailableTable;
    private SJctrComboBoxDataModel extLdevPerformanceCombo = null;
    public static final String KEY_CLASS_SELECT_POOLVOL = "KEY_CLASS_SELECT_POOLVOL";
    public static final String KEY_SEL_POOLVOL_CAND = "KEY_SEL_POOLVOL_CAND";
    public static final String KEY_SEL_POOLTYPE = "KEY_SEL_POOLTYPE";
    public static final String KEY_HRT_FLG = "KEY_HRT_FLG";
    public static final String KEY_DIRECT_MAPPING_FLG = "KEY_DIRECT_MAPPING_FLG";
    public static boolean chkDriveType = true;
    public static boolean chkCacheMode = true;
    private ArrayList<SJctrRelatedDispDataObject> warningMsgList = null;
    public boolean selExtLdevPerformanceFlg = false;
    public HashMap<String, Short> selExtLdevDriveTypeMap = null;
    public boolean hrtFlg = false;
    public boolean directMappingFlg = false;
    private List<SJmoLdevDetail> addedPoolVolDtlList = new ArrayList<SJmoLdevDetail>();

    public SJctrSelectPoolVolDialogDC() {
        super(0x200A022);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.selAvailableTable = new SJctrAvailableTableModel();
        this.addDataObjectModel("COM_AVAILABLE_TABLE", this.selAvailableTable);
        this.selPoolVolTable = new SJctrSelectPoolVolDialogTableModel();
        this.addDataObjectModel("COM_TABLE", this.selPoolVolTable);
        this.extLdevPerformanceCombo = new SJctrComboBoxDataModel();
        this.addDataObjectModel("COM_EXT_LDEV_PERFORMANCE", this.extLdevPerformanceCombo);
        SJctrButtonDataModel add = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD", add);
        add.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectPoolVolDialogDC.this.fireMessageEvent(SELECT_SPV_MSG.ADD);
            }
        });
        add.setRollBackCheck(true);
        SJctrButtonDataModel remove = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_REMOVE", remove);
        remove.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectPoolVolDialogDC.this.fireMessageEvent(SELECT_SPV_MSG.REMOVE);
            }
        });
        remove.setRollBackCheck(true);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_SPV_MSG.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectPoolVolDialogDC.this.addEvent();
            }
        });
        this.addMessageEventListener(SELECT_SPV_MSG.REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectPoolVolDialogDC.this.removeEvent();
            }
        });
    }

    public void addEvent() {
        List<Object> selPoolVolList = null;
        selPoolVolList = this.selAvailableTable.getSelectedRowData();
        if (selPoolVolList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addEvent", "Select Row Count = " + selPoolVolList.size());
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        if (this.selExtLdevPerformanceFlg) {
            this.checkAddExdDriveType(selPoolVolList);
        }
        this.selPoolVolTable.addRowDataTop(selPoolVolList);
        this.selPoolVolTable.setRowSelectionList(selPoolVolList);
        this.selAvailableTable.removeRowData(selPoolVolList);
        this.setDirtyAll();
    }

    public void removeEvent() {
        List<Object> selPoolVolList = null;
        selPoolVolList = this.selPoolVolTable.getSelectedRowData();
        if (selPoolVolList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeEvent", "Select Row Count = " + selPoolVolList.size());
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        if (this.selExtLdevPerformanceFlg) {
            this.checkDelExdDriveType(selPoolVolList);
        }
        this.selAvailableTable.addRowDataTop(selPoolVolList);
        this.selAvailableTable.setRowSelectionList(selPoolVolList);
        this.selPoolVolTable.removeRowData(selPoolVolList);
        this.setDirtyAll();
    }

    @Override
    public boolean checkStartData() {
        List<?> directMappingFlgList;
        List<?> hrtFlgList;
        boolean bRtn = true;
        List<?> basicDataList = null;
        basicDataList = this.getCache(KEY_SEL_POOLVOL_CAND);
        if (basicDataList == null) {
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        if ((hrtFlgList = this.getCache(KEY_HRT_FLG)) != null && !hrtFlgList.isEmpty()) {
            this.hrtFlg = (Boolean)hrtFlgList.get(0);
        }
        if ((directMappingFlgList = this.getCache(KEY_DIRECT_MAPPING_FLG)) != null && !directMappingFlgList.isEmpty()) {
            this.directMappingFlg = (Boolean)directMappingFlgList.get(0);
        }
        return bRtn;
    }

    @Override
    public boolean checkEndData() {
        ArrayList allRsgsList;
        boolean bRtn = true;
        SJctrCreatePoolsDC cpDC = null;
        SJctrExpandPoolDC expDC = null;
        List<Object> selLdevDetailList = null;
        List<?> dcList = null;
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        dcList = this.getCache("KEY_DC");
        if (dcList == null || dcList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "dcList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if ((selLdevDetailList = this.selPoolVolTable.getAllRowData()) == null || selLdevDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "selLdevDetailList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (0 < (allRsgsList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_ALL_RSG))).size()) {
            SJctrResourceGroupUtility util = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)allRsgsList.get(0));
            if (!util.chkSameRsgForLdev(selLdevDetailList)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "Select Pool Vol Resource Group Mixed");
                SJctrPoolUtility.SJctrErrorDialog(106108);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "SJmoRSGgetAllRsgs Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Object obj = dcList.get(0);
        if (obj instanceof SJctrCreatePoolsDC) {
            cpDC = (SJctrCreatePoolsDC)obj;
            bRtn = this.cpCheckEndData(cpDC, selLdevDetailList, poolUtil);
        } else if (obj instanceof SJctrExpandPoolDC) {
            expDC = (SJctrExpandPoolDC)obj;
            bRtn = this.expCheckEndData(expDC, selLdevDetailList, poolUtil);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "Disp Unknown");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.putCache(KEY_CLASS_SELECT_POOLVOL, selLdevDetailList);
        ArrayList<HashMap<String, Short>> extLdevDriveList = new ArrayList<HashMap<String, Short>>();
        extLdevDriveList.add(this.selExtLdevDriveTypeMap);
        this.putCache("KEY_SEL_POOLVOL_EXT_DRIVE", extLdevDriveList);
        return bRtn;
    }

    public boolean cpCheckEndData(SJctrCreatePoolsDC cpDC, List<SJmoLdevDetail> selLdevDetailList, SJctrPoolUtility poolUtil) {
        SJctrCreatePoolsTierInfo cpTier;
        String strTier;
        List<SJmoLdevDetail> notDmPoolVolList;
        boolean ssdFlg;
        boolean bRtn = true;
        byte byBasePoolAttr = 0;
        byte byBaseVolType = 0;
        boolean bBaseCacheMode = true;
        int iCnt = 0;
        List<SJmoPdevDetail> pdevDetailList = null;
        pdevDetailList = cpDC.getCache(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        boolean bPoolType = false;
        if (selLdevDetailList.size() > 1024) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "cpCheckEndData", "Select Ldev Over Setmax");
            SJctrPoolUtility.SJctrErrorDialog(106009);
        }
        if (this.hrtFlg && !(ssdFlg = poolUtil.checkSSDVol(selLdevDetailList))) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "cpCheckEndData", "Select Ldevs are No SSD");
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_SELECTPOOLVOL_NO_SSD);
        }
        if (this.directMappingFlg && (notDmPoolVolList = poolUtil.getNoDmAttributeList(selLdevDetailList)).isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "cpCheckEndData", "notDmPoolVolList is empty");
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_SELECTPOOLVOL_NO_NOTDMLDEV);
        }
        SJctrCreatePoolsAttribute cpAttribute = (SJctrCreatePoolsAttribute)cpDC.getDataObjectModel("COM_ATTR");
        String strAttr = cpAttribute.getSelection();
        byBasePoolAttr = poolUtil.getPoolKind(strAttr, this.getComUtility());
        chkCacheMode = false;
        for (iCnt = 0; iCnt < selLdevDetailList.size(); ++iCnt) {
            byBaseVolType = selLdevDetailList.get(iCnt).getByVolumeType();
            if (byBaseVolType != 1) continue;
            bBaseCacheMode = selLdevDetailList.get(iCnt).getbCasheMode();
            boolean mix = poolUtil.checkMixCacheMode(selLdevDetailList, bBaseCacheMode);
            if (mix) break;
            if (byBasePoolAttr == 8) {
                SJctrPoolUtility.SJctrErrorDialog(106022);
                break;
            }
            chkCacheMode = true;
            break;
        }
        if (byBasePoolAttr == 2 && (strTier = (cpTier = (SJctrCreatePoolsTierInfo)cpDC.getDataObjectModel("COM_TIER")).getSelect()).equals("COM_ENABLE")) {
            bPoolType = true;
        }
        HashMap driveTypeMap = new HashMap();
        ArrayList<HashMap> alDriveAndRaidLevel = new ArrayList<HashMap>();
        alDriveAndRaidLevel.add(driveTypeMap);
        this.getComUtility().getPoolUtility().createSelectPoolBasicData(alDriveAndRaidLevel, selLdevDetailList, pdevDetailList, this.getComUtility(), this.selExtLdevDriveTypeMap);
        this.checkVolumeTypeMix(driveTypeMap, bPoolType);
        return bRtn;
    }

    public boolean expCheckEndData(SJctrExpandPoolDC expDC, List<SJmoLdevDetail> selLdevDetailList, SJctrPoolUtility poolUtil) {
        boolean bRtn = true;
        List<?> poolVolDetailList = null;
        List<SJmoPdevDetail> pdevDetailList = null;
        SJmoPoolVolDetail poolVolDetail = null;
        ArrayList poolVolInfoList = null;
        SJmoPoolVolInfo poolVolInfo = null;
        ArrayList<SJmoLdevDetail> baseLdevDetailList = null;
        SJmoLdevDetail baseLdevDetail = null;
        ArrayList basePoolDetailList = null;
        SJmoPoolDetail basePoolDetail = null;
        int iSetPoolVolNum = 0;
        byte byBasePoolAttr = 0;
        byte byBaseVolType = 0;
        boolean bBaseCacheMode = true;
        int iIndex = 0;
        int iCnt = 0;
        int iTierControlInfo = 0;
        HashMap existPoolMap = null;
        boolean bPoolType = false;
        poolVolDetailList = expDC.getCache("KEY_CLASS_RELATE_POOLVOL");
        pdevDetailList = expDC.getCache(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        poolVolDetail = (SJmoPoolVolDetail)poolVolDetailList.get(0);
        poolVolInfoList = poolVolDetail.getAlPoolInfo();
        iSetPoolVolNum = 1024 - poolVolInfoList.size();
        if (selLdevDetailList.size() > iSetPoolVolNum) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "expCheckEndData", "Select Ldev Over Setmax");
            SJctrPoolUtility.SJctrErrorDialog(106009);
        }
        poolVolInfo = (SJmoPoolVolInfo)poolVolInfoList.get(0);
        baseLdevDetailList = new ArrayList<SJmoLdevDetail>(expDC.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        Collections.sort(baseLdevDetailList);
        iIndex = Collections.binarySearch(baseLdevDetailList, poolVolInfo);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "expCheckEndData", "baseLdevDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        baseLdevDetail = (SJmoLdevDetail)baseLdevDetailList.get(iIndex);
        basePoolDetailList = new ArrayList(expDC.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        Collections.sort(basePoolDetailList);
        iIndex = Collections.binarySearch(basePoolDetailList, poolVolDetail);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "expCheckEndData", "basePoolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.directMappingFlg = 0L != ((basePoolDetail = (SJmoPoolDetail)basePoolDetailList.get(iIndex)).getLPoolOptionFlag() & 0x20000000L);
        bBaseCacheMode = baseLdevDetail.getbCasheMode();
        byBasePoolAttr = basePoolDetail.getPoolKind();
        chkCacheMode = false;
        for (iCnt = 0; iCnt < selLdevDetailList.size(); ++iCnt) {
            byBaseVolType = selLdevDetailList.get(iCnt).getByVolumeType();
            if (byBaseVolType != 1) continue;
            bBaseCacheMode = selLdevDetailList.get(iCnt).getbCasheMode();
            boolean mix = poolUtil.checkMixCacheMode(selLdevDetailList, bBaseCacheMode);
            if (mix) break;
            if (byBasePoolAttr == 8) {
                SJctrPoolUtility.SJctrErrorDialog(106022);
                break;
            }
            chkCacheMode = true;
            break;
        }
        if (((iTierControlInfo = basePoolDetail.getITierControlInfo()) & 0x80) != 0) {
            existPoolMap = poolUtil.createDriveTypeRpmMap(basePoolDetail);
            bPoolType = true;
        } else {
            existPoolMap = poolUtil.createDriveTypeRpmMap(basePoolDetail);
        }
        ArrayList<HashMap> alDriveAndRaidLevel = new ArrayList<HashMap>();
        alDriveAndRaidLevel.add(existPoolMap);
        this.getComUtility().getPoolUtility().createSelectPoolBasicData(alDriveAndRaidLevel, selLdevDetailList, pdevDetailList, this.getComUtility(), this.selExtLdevDriveTypeMap);
        HashMap driveTypeMap = poolUtil.getMapFromList(alDriveAndRaidLevel);
        this.checkVolumeTypeMix(driveTypeMap, bPoolType);
        List<SJmoLdevDetail> ldevDetailList = poolUtil.chengePoolVolInfToLdevDetail(poolVolInfoList, baseLdevDetailList);
        for (SJmoLdevDetail ldevDetail : selLdevDetailList) {
            ldevDetailList.add(ldevDetail);
        }
        Collections.sort(ldevDetailList);
        this.addedPoolVolDtlList = new ArrayList<SJmoLdevDetail>();
        this.addedPoolVolDtlList.addAll(ldevDetailList);
        return bRtn;
    }

    @Override
    protected void dialogOkAction() {
        if (this.warningMsgList == null) {
            this.warningMsgList = new ArrayList();
            try {
                SJctrRelatedDispDataObject nfOnlyRelated;
                SJctrRelatedDispDataObject nf2kRelated;
                SJctrRelatedDispDataObject driveRelated = this.checkDriveWarn();
                if (driveRelated != null) {
                    this.warningMsgList.add(driveRelated);
                }
                if ((nf2kRelated = this.checkNF2KWarn()) != null) {
                    this.warningMsgList.add(nf2kRelated);
                }
                if ((nfOnlyRelated = this.checkNFOnlyPoolWarn()) != null) {
                    this.warningMsgList.add(nfOnlyRelated);
                }
            }
            catch (SJcException ex) {
                this.removeWorningMsgList();
                this.warningMsgList = null;
                SJcException exp = new SJcException(ex.getMsg());
                throw exp;
            }
        }
        if (this.warningMsgList.size() > 0) {
            this.addUpdateDisp(this.warningMsgList.get(0));
            this.warningMsgList.remove(0);
        } else {
            this.warningMsgList = null;
            super.dialogOkAction();
        }
    }

    @Override
    protected void dialogCancelAction() {
        if (this.warningMsgList != null) {
            this.removeWorningMsgList();
            this.warningMsgList = null;
        } else {
            super.dialogCancelAction();
        }
    }

    private void removeWorningMsgList() {
        for (SJctrRelatedDispDataObject related : this.warningMsgList) {
            SJctrUserController uc = this.getOwner();
            uc.removeRelatedDispData(related.uId());
        }
    }

    private SJctrRelatedDispDataObject checkDriveWarn() {
        SJctrRelatedDispDataObject related = null;
        if (this.directMappingFlg) {
            chkDriveType = false;
            chkCacheMode = false;
        }
        if (chkDriveType || chkCacheMode) {
            Object[] nonArg = null;
            SJctrError errCode = new SJctrError(31, 22, 106094);
            SJctrRelatedDispDataObject msgRelated = SJctrComUtility.createMessageDialogFromError(errCode, this);
            SJctrMessageDataController msgDc = (SJctrMessageDataController)this.getOwner().getDataController(msgRelated);
            related = SJctrComUtility.createOkCancelMsgDialog(msgRelated, SJctrComUtility.makeDialogOkActionListener(this, msgDc), SJctrComUtility.makeDialogCancelActionListener(this, msgDc), this, null, null, nonArg);
        }
        return related;
    }

    private SJctrRelatedDispDataObject checkNF2KWarn() {
        SJctrRelatedDispDataObject relatedDisp = null;
        List<SJmoLdevDetail> nf2KSelLdevList = this.getNF2KSelLdev();
        if (nf2KSelLdevList.isEmpty()) {
            return relatedDisp;
        }
        List<?> dcList = this.getCache("KEY_DC");
        Object obj = dcList.get(0);
        if (obj instanceof SJctrCreatePoolsDC) {
            SJctrCreatePoolsDC cpDc = (SJctrCreatePoolsDC)obj;
            relatedDisp = this.checkCpNF2KPoolVol(cpDc, nf2KSelLdevList);
        } else if (obj instanceof SJctrExpandPoolDC) {
            SJctrExpandPoolDC expDc = (SJctrExpandPoolDC)obj;
            relatedDisp = this.checkExpNF2KPoolVol(expDc, nf2KSelLdevList);
        }
        return relatedDisp;
    }

    private List<SJmoLdevDetail> getNF2KSelLdev() {
        List<Object> rowDataList = this.selPoolVolTable.getAllRowData();
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(rowDataList.size());
        for (Object rowData : rowDataList) {
            SJmoLdevDetail selLdev = (SJmoLdevDetail)rowData;
            if (!selLdev.getBVirtSupport() || !selLdev.getBVirtMode()) continue;
            retList.add(selLdev);
        }
        return retList;
    }

    private SJctrRelatedDispDataObject checkCpNF2KPoolVol(SJctrWizardDataController dc, List<SJmoLdevDetail> nf2KSelLdevList) {
        SJctrRelatedDispDataObject relatedDisp = null;
        List<?> ldevDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        List<SJmoPgDetail> pgDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        List<SJmoVdevDetail> vdevDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> scPgList = dc.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        SJctrError representedErr = null;
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(nf2KSelLdevList.size());
        HashSet<SJmoPgDetail> pgDtlSet = new HashSet<SJmoPgDetail>(nf2KSelLdevList.size());
        Map<String, List<SJmoLdevDetail>> pgLdevMap = this.getPGLdevMap(nf2KSelLdevList, pgDtlList, scPgList, pgDtlSet);
        HashSet<SJmoLdevDetail> ldevSet = new HashSet<SJmoLdevDetail>();
        for (SJmoPgDetail pgDtl : pgDtlSet) {
            List<SJmoLdevDetail> pgLdevList = pgLdevMap.get(pgDtl.toString());
            long ldevLbaSize = 0L;
            for (SJmoLdevDetail pgLdev : pgLdevList) {
                ldevLbaSize += pgLdev.getLLDEVLBASize();
            }
            List<SJmoVdevDetail> scVdevList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, scPgList);
            long vdevPhyLba = 0L;
            for (SJmoVdevDetail vdevDtl : scVdevList) {
                vdevPhyLba += vdevDtl.getLVdevPhyMaxLba();
            }
            if (ldevLbaSize <= vdevPhyLba) continue;
            for (SJmoLdevDetail ldevDtl : pgLdevList) {
                if (!ldevSet.add(ldevDtl)) continue;
                if (representedErr == null) {
                    representedErr = new SJctrError(31, 22, 209014);
                }
                SJctrError err = new SJctrError(31, 22, 209015);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDtl, err);
                errColumnList.add(errColumn);
            }
        }
        if (!errColumnList.isEmpty()) {
            ArrayList<SJmoLdevDetail> warnLdevList = new ArrayList<SJmoLdevDetail>(errColumnList.size());
            for (SJctrErrorColumnData errColumn : errColumnList) {
                SJmoLdevDetail warnLdev = (SJmoLdevDetail)errColumn.getKeyObj();
                warnLdevList.add(warnLdev);
            }
            Collections.sort(warnLdevList);
            SJctrWarnCreatePoolTableDataModel table = new SJctrWarnCreatePoolTableDataModel();
            table.setPrimaryKeyData(warnLdevList);
            ArrayList<Map<String, List<SJmoLdevDetail>>> pgLdevMapList = new ArrayList<Map<String, List<SJmoLdevDetail>>>();
            pgLdevMapList.add(pgLdevMap);
            table.setBasicData(SJctrPoolUtility.KEY_PG_SEL_LDEV, pgLdevMapList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL, warnLdevList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, vdevDtlList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF, scPgList);
            List<?> luseList = dc.getCache(SJmoGetLdevLuseInfo.class);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_LUSE_INFO, luseList);
            table.setDataController(this);
            table.initGuidance(this.getOwner().getComUtility());
            table.makeDataModel();
            SJctrRelatedDispDataObject msgRelated = SJctrComUtility.createMessageDialogFromError(representedErr, this);
            SJctrMessageDataController msgDc = (SJctrMessageDataController)this.getOwner().getDataController(msgRelated);
            relatedDisp = SJctrComUtility.createOkCancelMsgDialog(msgRelated, SJctrComUtility.makeDialogOkActionListener(this, msgDc), SJctrComUtility.makeDialogCancelActionListener(this, msgDc), this, table.getTableTitle(), table.getAlignRightColumnList(), table, errColumnList);
        }
        return relatedDisp;
    }

    private SJctrRelatedDispDataObject checkExpNF2KPoolVol(SJctrWizardDataController dc, List<SJmoLdevDetail> nf2KSelLdevList) {
        SJctrRelatedDispDataObject relatedDisp = null;
        List<SJmoPoolVolDetail> poolVolDetailList = dc.getCache("KEY_CLASS_RELATE_POOLVOL");
        SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)poolVolDetailList.get(0);
        List<?> poolDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        SJmoPoolDetail poolDtl = null;
        int searchPool = Collections.binarySearch(poolDtlList, poolVolDtl);
        if (searchPool < 0) {
            return null;
        }
        poolDtl = (SJmoPoolDetail)poolDtlList.get(searchPool);
        List<SJmoPgDetail> pgDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        List<SJmoVdevDetail> vdevDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> scPgList = dc.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        List<SJmoLdevDetail> ldevDtlList = dc.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        SJctrError representedErr = null;
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(nf2KSelLdevList.size());
        HashSet<SJmoPgDetail> pgDtlSet = new HashSet<SJmoPgDetail>(nf2KSelLdevList.size());
        Map<String, List<SJmoLdevDetail>> pgLdevMap = this.getPGLdevMap(nf2KSelLdevList, pgDtlList, scPgList, pgDtlSet);
        Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap = SJctrPoolUtility.makePGPoolVolMap(poolDtl, poolVolDetailList, ldevDtlList, pgDtlList, scPgList);
        representedErr = SJctrPoolUtility.hasNF2KPGPoolVol(poolDtl, poolVolDetailList, ldevDtlList) ? this.checkExpNF2KPoolPgExpantion(pgDtlSet, poolDtl, vdevDtlList, scPgList, pgPoolVolMap, pgLdevMap, errColumnList) : this.checkExpNotNF2KPoolPgExpantion(pgDtlSet, poolDtl, vdevDtlList, scPgList, pgLdevMap, errColumnList);
        if (!errColumnList.isEmpty()) {
            ArrayList<SJmoLdevDetail> warnLdevList = new ArrayList<SJmoLdevDetail>(errColumnList.size());
            for (SJctrErrorColumnData errColumn : errColumnList) {
                SJmoLdevDetail warnLdev = (SJmoLdevDetail)errColumn.getKeyObj();
                warnLdevList.add(warnLdev);
            }
            Collections.sort(warnLdevList);
            SJctrWarnExpandPoolTableDataModel table = new SJctrWarnExpandPoolTableDataModel();
            table.setPrimaryKeyData(warnLdevList);
            ArrayList<SJmoPoolDetail> targetPoolDtlList = new ArrayList<SJmoPoolDetail>();
            targetPoolDtlList.add(poolDtl);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, targetPoolDtlList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL, poolVolDetailList);
            ArrayList<Map<SJmoPgDetail, List<SJmoPoolVolInfo>>> pgPoolVolMapList = new ArrayList<Map<SJmoPgDetail, List<SJmoPoolVolInfo>>>();
            pgPoolVolMapList.add(pgPoolVolMap);
            table.setBasicData(SJctrPoolUtility.KEY_PG_POOLVOL, pgPoolVolMapList);
            ArrayList<Map<String, List<SJmoLdevDetail>>> pgLdevMapList = new ArrayList<Map<String, List<SJmoLdevDetail>>>();
            pgLdevMapList.add(pgLdevMap);
            table.setBasicData(SJctrPoolUtility.KEY_PG_SEL_LDEV, pgLdevMapList);
            ArrayList<SJmoLdevDetail> basicLdevList = new ArrayList<SJmoLdevDetail>(ldevDtlList.size());
            basicLdevList.addAll(warnLdevList);
            HashSet<String> ldevSet = new HashSet<String>(ldevDtlList.size());
            for (SJmoPgDetail pgDtl : pgPoolVolMap.keySet()) {
                List<SJmoPoolVolInfo> poolVolInfoList = pgPoolVolMap.get(pgDtl);
                for (SJmoPoolVolInfo poolVol : poolVolInfoList) {
                    int searchLdev;
                    if (!ldevSet.add(poolVol.toString()) || 0 > (searchLdev = Collections.binarySearch(ldevDtlList, poolVol))) continue;
                    basicLdevList.add(ldevDtlList.get(searchLdev));
                }
            }
            Collections.sort(basicLdevList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL, basicLdevList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, vdevDtlList);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF, scPgList);
            List<?> luseList = dc.getCache(SJmoGetLdevLuseInfo.class);
            table.setBasicData(SJctrPoolUtility.KEY_CLASS_LUSE_INFO, luseList);
            table.setDataController(this);
            table.initGuidance(this.getOwner().getComUtility());
            table.makeDataModel();
            SJctrRelatedDispDataObject msgRelated = SJctrComUtility.createMessageDialogFromError(representedErr, this);
            SJctrMessageDataController msgDc = (SJctrMessageDataController)this.getOwner().getDataController(msgRelated);
            relatedDisp = SJctrComUtility.createOkCancelMsgDialog(msgRelated, SJctrComUtility.makeDialogOkActionListener(this, msgDc), SJctrComUtility.makeDialogCancelActionListener(this, msgDc), this, table.getTableTitle(), table.getAlignRightColumnList(), table, errColumnList);
        }
        return relatedDisp;
    }

    private SJctrError checkExpNF2KPoolPgExpantion(Set<SJmoPgDetail> pgDtlSet, SJmoPoolDetail poolDtl, List<SJmoVdevDetail> vdevDtlList, List<SJmoPgScatteredInfo> scPgList, Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap, Map<String, List<SJmoLdevDetail>> pgLdevMap, List<SJctrErrorColumnData> errColumnList) {
        SJctrError representedErr = new SJctrError(31, 22, SJctrPoolUtility.RESULT_NORMAL);
        int recommendExpRate = 100;
        int savingRate = SJctrPoolUtility.getPoolSavingRate(poolDtl);
        if (20 <= savingRate) {
            recommendExpRate = SJctrPoolUtility.getMaxRecommendExpantionRate(savingRate);
        }
        HashSet<SJmoLdevDetail> ldevSet = new HashSet<SJmoLdevDetail>();
        for (SJmoPgDetail pgDtl : pgDtlSet) {
            List<SJmoPoolVolInfo> poolVolList = pgPoolVolMap.get(pgDtl);
            List<SJmoLdevDetail> pgLdevList = pgLdevMap.get(pgDtl.toString());
            List<SJmoVdevDetail> scVdevList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, scPgList);
            int expantionRate = SJctrPoolUtility.getPGExpantionRate(poolDtl, scVdevList, poolVolList, pgLdevList);
            if (expantionRate <= recommendExpRate) continue;
            for (SJmoLdevDetail ldevDtl : pgLdevList) {
                if (!ldevSet.add(ldevDtl)) continue;
                if (representedErr.getError() == SJctrPoolUtility.RESULT_NORMAL) {
                    representedErr.setError(209020);
                }
                SJctrError err = new SJctrError(31, 22, 209021);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDtl, err);
                errColumnList.add(errColumn);
            }
        }
        return representedErr;
    }

    private SJctrError checkExpNotNF2KPoolPgExpantion(Set<SJmoPgDetail> pgDtlSet, SJmoPoolDetail poolDtl, List<SJmoVdevDetail> vdevDtlList, List<SJmoPgScatteredInfo> scPgList, Map<String, List<SJmoLdevDetail>> pgLdevMap, List<SJctrErrorColumnData> errColumnList) {
        SJctrError representedErr = new SJctrError(31, 22, SJctrPoolUtility.RESULT_NORMAL);
        HashSet<SJmoLdevDetail> ldevSet = new HashSet<SJmoLdevDetail>();
        for (SJmoPgDetail pgDtl : pgDtlSet) {
            List<SJmoLdevDetail> pgLdevList = pgLdevMap.get(pgDtl.toString());
            List<SJmoVdevDetail> scVdevList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, scPgList);
            int expantionRate = SJctrPoolUtility.getPGExpantionRate(poolDtl, scVdevList, null, pgLdevList);
            if (expantionRate <= 100) continue;
            for (SJmoLdevDetail ldevDtl : pgLdevList) {
                if (!ldevSet.add(ldevDtl)) continue;
                if (representedErr.getError() == SJctrPoolUtility.RESULT_NORMAL) {
                    representedErr.setError(209018);
                }
                SJctrError err = new SJctrError(31, 22, 209019);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDtl, err);
                errColumnList.add(errColumn);
            }
        }
        return representedErr;
    }

    private Map<String, List<SJmoLdevDetail>> getPGLdevMap(List<SJmoLdevDetail> ldevDtlList, List<SJmoPgDetail> pgDtlList, List<SJmoPgScatteredInfo> scPgList, Set<SJmoPgDetail> pgDtlSet) {
        HashMap<String, List<SJmoLdevDetail>> pgLdevMap = new HashMap<String, List<SJmoLdevDetail>>(ldevDtlList.size());
        HashMap<String, List<SJmoPgIndex>> scPgMap = new HashMap<String, List<SJmoPgIndex>>(pgDtlList.size());
        for (SJmoLdevDetail ldevdtl : ldevDtlList) {
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(ldevdtl.getIFB4());
            pgIndex.setPG(ldevdtl.getIPG());
            String pgKey = pgIndex.toString();
            List<SJmoPgIndex> scPGIndexList = (List<SJmoPgIndex>)scPgMap.get(pgKey);
            if (scPGIndexList == null) {
                scPGIndexList = SJctrPoolUtility.getScatteredPGIndexList(pgIndex, scPgList);
                Collections.sort(scPGIndexList);
                for (SJmoPgIndex scPg : scPGIndexList) {
                    scPgMap.put(scPg.toString(), scPGIndexList);
                }
            }
            for (SJmoPgIndex scPgIndex : scPGIndexList) {
                ArrayList<SJmoLdevDetail> pgLdevList = (ArrayList<SJmoLdevDetail>)pgLdevMap.get(scPgIndex.toString());
                if (pgLdevList == null) {
                    int searchPG = Collections.binarySearch(pgDtlList, scPgIndex);
                    if (searchPG < 0) continue;
                    pgDtlSet.add(pgDtlList.get(searchPG));
                    pgLdevList = new ArrayList<SJmoLdevDetail>(ldevDtlList.size());
                    pgLdevMap.put(scPgIndex.toString(), pgLdevList);
                }
                pgLdevList.add(ldevdtl);
            }
        }
        return pgLdevMap;
    }

    protected void checkVolumeTypeMix(HashMap volumeTypeMap, boolean bPoolHDT) {
        chkDriveType = false;
        Set driveTypeSet = volumeTypeMap.keySet();
        Set<String> driveTypeKeyNotExtRankSet = this.getComUtility().getPoolUtility().getAllDriveTypeMapKey(volumeTypeMap);
        int iMixableMax = 1;
        if (bPoolHDT) {
            iMixableMax = 3;
        }
        if (driveTypeKeyNotExtRankSet.size() > iMixableMax) {
            chkDriveType = true;
        } else {
            for (String strDriveKey : driveTypeSet) {
                HashMap driveMap = (HashMap)volumeTypeMap.get(strDriveKey);
                if (driveMap.size() <= 1) continue;
                chkDriveType = true;
                break;
            }
        }
    }

    @Override
    public void makeDataModel() {
        this.initSelExtLdevDriveType();
        super.makeDataModel();
        this.initSelExtLdevPerformanceComb();
    }

    protected void checkAddExdDriveType(List<SJmoLdevDetail> ldevDtlList) {
        int iVolumeType = -1;
        if (ldevDtlList != null) {
            String strSlt = this.extLdevPerformanceCombo.getSelection();
            for (int iCnt = 0; iCnt < ldevDtlList.size(); ++iCnt) {
                SJmoLdevDetail LdevDtl = ldevDtlList.get(iCnt);
                iVolumeType = LdevDtl.getByVolumeType();
                if (iVolumeType != 1) continue;
                this.selExtLdevDriveTypeMap.put(LdevDtl.getIndexKey(), Short.valueOf(strSlt));
            }
        }
    }

    protected void checkDelExdDriveType(List<SJmoLdevDetail> ldevDtlList) {
        int iVolumeType = -1;
        String strLIndex = "";
        for (int iCnt = 0; iCnt < ldevDtlList.size(); ++iCnt) {
            SJmoLdevDetail LdevDtl = ldevDtlList.get(iCnt);
            iVolumeType = LdevDtl.getByVolumeType();
            strLIndex = LdevDtl.getIndexKey();
            if (iVolumeType != 1 || !this.selExtLdevDriveTypeMap.containsKey(strLIndex)) continue;
            this.selExtLdevDriveTypeMap.remove(strLIndex);
        }
    }

    protected void initSelExtLdevPerformanceComb() {
        this.selExtLdevPerformanceFlg = this.checkExtVolume();
        this.setSelExtLdevPerformance(this.selExtLdevPerformanceFlg);
    }

    protected void initSelExtLdevDriveType() {
        List<?> selExtDriveTypeList = this.getCache("KEY_SEL_POOLVOL_EXT_DRIVE");
        this.selExtLdevDriveTypeMap = selExtDriveTypeList != null ? (HashMap)((HashMap)selExtDriveTypeList.get(0)).clone() : new HashMap();
        ArrayList<HashMap<String, Short>> alSetExtDriveTypeList = new ArrayList<HashMap<String, Short>>();
        alSetExtDriveTypeList.add(this.selExtLdevDriveTypeMap);
        this.selPoolVolTable.setBasicData(SJctrPoolUtility.KEY_CLASS_EXT_LDEV_PERFORMANCE, alSetExtDriveTypeList);
    }

    protected void setSelExtLdevPerformance(boolean bCombBoxEnable) {
        if (this.extLdevPerformanceCombo.getSelectedIndex() >= 0) {
            this.extLdevPerformanceCombo.removeAllItems();
        }
        this.extLdevPerformanceCombo.setEnable(bCombBoxEnable);
        if (bCombBoxEnable) {
            if (this.checkSelectMixablePool()) {
                this.extLdevPerformanceCombo.addItem(Short.toString((short)0), this.getComUtility().getGuidance("MIDDLE"));
                this.extLdevPerformanceCombo.setSelection(Short.toString((short)0));
            } else {
                this.extLdevPerformanceCombo.addItem(Short.toString((short)2), this.getComUtility().getGuidance("HIGH"));
                this.extLdevPerformanceCombo.addItem(Short.toString((short)0), this.getComUtility().getGuidance("MIDDLE"));
                this.extLdevPerformanceCombo.addItem(Short.toString((short)1), this.getComUtility().getGuidance("LOW"));
                this.extLdevPerformanceCombo.setSelection(Short.toString((short)0));
            }
        } else {
            this.extLdevPerformanceCombo.addItem(SJctrPoolUtility.HAIFUN_STR);
            this.extLdevPerformanceCombo.setSelection(SJctrPoolUtility.HAIFUN_STR);
        }
    }

    protected boolean checkExtVolume() {
        SJmoLdevDetail LdevDtl;
        int iIndex;
        boolean bRet = false;
        List<Object> selAvailableTableList = this.selAvailableTable.getAllRowData();
        List<Object> selPoolVolTableList = this.selPoolVolTable.getAllRowData();
        for (iIndex = 0; iIndex < selAvailableTableList.size(); ++iIndex) {
            LdevDtl = (SJmoLdevDetail)selAvailableTableList.get(iIndex);
            if (LdevDtl.getByVolumeType() != 1) continue;
            bRet = true;
            break;
        }
        if (!bRet) {
            for (iIndex = 0; iIndex < selPoolVolTableList.size(); ++iIndex) {
                LdevDtl = (SJmoLdevDetail)selPoolVolTableList.get(iIndex);
                if (LdevDtl.getByVolumeType() != 1) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    protected boolean checkSelectMixablePool() {
        Object obj;
        boolean bRet = false;
        SJctrCreatePoolsDC cpDC = null;
        SJctrExpandPoolDC expDC = null;
        List<?> dcList = null;
        dcList = this.getCache("KEY_DC");
        if (dcList == null || dcList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSelectMixablePool", "dcList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if ((obj = dcList.get(0)) instanceof SJctrCreatePoolsDC) {
            cpDC = (SJctrCreatePoolsDC)obj;
            SJctrCreatePoolsAttribute cpAttribute = (SJctrCreatePoolsAttribute)cpDC.getDataObjectModel("COM_ATTR");
            String strAttr = cpAttribute.getSelection();
            bRet = strAttr.equals(this.getComUtility().getGuidance("DYNAMIC_SNAPSHOT"));
        } else if (obj instanceof SJctrExpandPoolDC) {
            expDC = (SJctrExpandPoolDC)obj;
            List<?> poolDetailList = expDC.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDetailList.get(0);
            if (poolDtl.getPoolKind() == 8) {
                bRet = true;
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSelectMixablePool", "Disp Unknown");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return bRet;
    }

    private SJctrRelatedDispDataObject checkNFOnlyPoolWarn() {
        SJctrRelatedDispDataObject related = null;
        List<?> dcList = this.getCache("KEY_DC");
        Object obj = dcList.get(0);
        ArrayList<SJmoLdevDetail> poolVolList = new ArrayList<SJmoLdevDetail>();
        List<SJmoPgDetail> allPgDetailList = null;
        if (this.addedPoolVolDtlList.size() != 0) {
            poolVolList.addAll(this.addedPoolVolDtlList);
            allPgDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        } else {
            for (Object selPoolVol : this.selPoolVolTable.getAllRowData()) {
                poolVolList.add((SJmoLdevDetail)selPoolVol);
            }
            allPgDetailList = this.getCache("KEY_CLASS_CP_ALL_PG");
        }
        Set<SJmoPgDetail> PgDetailSet = SJctrParityGroupUtility.getPgListFromLdevList(poolVolList, allPgDetailList);
        List<SJmoPgEncryptionInfo> pgEncinfList = this.getCache(SJctrEncryptionKeyDef.KEY_CLASS_PGENCRYPTIONINFO);
        List<SJmoLdevDetail> ldevDtls = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        List<SJmoHDPRelationByPool> hdpRelationByPools = this.getCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        List<SJmoLdevStatusInfo> pgLdevStatusInfos = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_STATUS);
        List<SJmoPgLdevInfo> pgLdevInfos = this.getCache(SJctrPoolUtility.KEY_CLASS_PGLDEV_INFO);
        List<SJmoPdevDetail> pdevDetails = this.getCache(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        List<SJmoDCRInfo> dcrList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DCR);
        List<SJmoLdevGuardInfo> druList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_GUARD);
        List<SJmoPgScatteredInfo> pgScatteredInfos = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        SJctrNFLdevInPGInfo pgInfo = new SJctrNFLdevInPGInfo();
        pgInfo.setPgEncryptionInfos(pgEncinfList);
        pgInfo.setComUtil(this.getComUtility());
        pgInfo.setPgLdevInfos(pgLdevInfos);
        pgInfo.setPdevDetails(pdevDetails);
        pgInfo.setPgLdevStatusInfos(pgLdevStatusInfos);
        pgInfo.setDcrInfos(dcrList);
        pgInfo.setLdevGuardInfos(druList);
        pgInfo.setLdevDetails(ldevDtls);
        pgInfo.setHdpRelationByPools(hdpRelationByPools);
        pgInfo.setPgScatteredInfos(pgScatteredInfos);
        if (obj instanceof SJctrCreatePoolsDC) {
            pgInfo.setDcName(SJctrNFLdevInPGInfo.ENUM_DC_NAME.CREATE_POOL);
        } else if (obj instanceof SJctrExpandPoolDC) {
            pgInfo.setDcName(SJctrNFLdevInPGInfo.ENUM_DC_NAME.EXPAND_POOL);
            ArrayList poolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
            SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(0);
            pgInfo.setPoolId(poolDetail.getPoolId());
        }
        if (SJctrParityGroupUtility.checkNfOnlyPgList(PgDetailSet, pgInfo) && SJctrParityGroupUtility.isVirtModeMixedInPg(PgDetailSet)) {
            SJctrError errCode = new SJctrError(31, 22, 206350);
            related = SJctrComUtility.createMessageDialogFromError(errCode, this);
            SJctrMessageDataController msgDc = (SJctrMessageDataController)this.getOwner().getDataController(related);
            msgDc.addButton(SJctrMessageDataController.MD_OK, SJctrComUtility.makeDialogOkActionListener(this, msgDc));
        }
        return related;
    }

    public static enum SELECT_SPV_MSG implements SJctrNotifyState
    {
        ADD,
        REMOVE;

    }
}

