/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDC;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;

public class SJctrEditPoolsTierBufRelocationArea
extends SJctrCheckBoxAreaDataModel {
    private SJctrTextBoxDataModel relocationTier1TextBox = new SJctrTextBoxDataModel();
    private SJctrTextBoxDataModel relocationTier2TextBox = new SJctrTextBoxDataModel();
    private SJctrTextBoxDataModel relocationTier3TextBox = new SJctrTextBoxDataModel();
    private SJctrEditPoolsDC edPDC = null;
    private SJctrComUtility comUtil = null;

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.addDataModel("COM_BUFFER_RELOCATION_TIER1", this.relocationTier1TextBox);
        this.addDataModel("COM_BUFFER_RELOCATION_TIER2", this.relocationTier2TextBox);
        this.addDataModel("COM_BUFFER_RELOCATION_TIER3", this.relocationTier3TextBox);
        this.comUtil = util;
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
    }

    public void initTierBufRelocationArea(boolean bSelEnaOrDis, String strSelMultiTierKey) {
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.edPDC.getCache("KEY_CLASS_CHK_EDIT_POOLDTL"));
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 1);
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 2);
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 3);
        if (!bSelEnaOrDis) {
            this.setEnableCheckBox(false);
        } else if (strSelMultiTierKey == null || strSelMultiTierKey.equals("COM_DISABLE")) {
            this.setEnableCheckBox(false);
        }
    }

    public void refTierBufRelocationArea(String strSelMultiTierKey) {
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.edPDC.getCache("KEY_CLASS_CHK_EDIT_POOLDTL"));
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 1);
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 2);
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 3);
    }

    private void initTierTextArea(boolean bSelEnaOrDis, String strSelMultiTierKey, List<SJmoPoolDetail> poolDtlList, int iTierNum) {
        String strMinBufRelocation = "";
        String strMaxBufRelocation = "";
        String strTierText = "";
        int sDefBufRelocation = -1;
        boolean bActivityFlg = false;
        if (!bSelEnaOrDis) {
            this.refTierText(strMinBufRelocation, strMaxBufRelocation, strTierText, bActivityFlg, iTierNum);
            return;
        }
        for (int i = 0; i < poolDtlList.size(); ++i) {
            SJmoPoolDetail poolDtl = poolDtlList.get(i);
            int sBufRelocation = -1;
            if ((poolDtl.getITierControlInfo() & 0x80) != 128) {
                HashSet poolDriveTypeSet;
                if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_ENABLE")) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initTierTextArea", "DP Kind Error PoolID = " + poolDtl.getPoolId());
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                if ((poolDriveTypeSet = this.getComUtility().getPoolUtility().getDriveTypeRpminPool(poolDtl.getAlPoolPgKind())).size() < iTierNum) continue;
                sBufRelocation = 2;
            } else {
                if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_DISABLE")) continue;
                if (strSelMultiTierKey == null || strSelMultiTierKey.equals("COM_ENABLE")) {
                    SJmoPoolTierInfo defPoolTierInf = this.getTierInfo(poolDtl.getAlTierInfo(), iTierNum);
                    if (defPoolTierInf == null) continue;
                    sBufRelocation = defPoolTierInf.getSTierRelocateCapa();
                    if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_ENABLE")) {
                        bActivityFlg = true;
                    }
                }
            }
            if (sDefBufRelocation < 0) {
                sDefBufRelocation = sBufRelocation;
            }
            if (sDefBufRelocation == sBufRelocation) continue;
            sDefBufRelocation = -1;
            break;
        }
        strTierText = sDefBufRelocation < 0 ? "" : SJctrComUtility.toDecString(sDefBufRelocation);
        if (bActivityFlg) {
            strMinBufRelocation = SJctrComUtility.toDecString(2);
            strMaxBufRelocation = SJctrComUtility.toDecString(40);
        }
        this.refTierText(strMinBufRelocation, strMaxBufRelocation, strTierText, bActivityFlg, iTierNum);
    }

    private void refTierTextArea(String strSelMultiTierKey, List<SJmoPoolDetail> poolDtlList, int iTierNum) {
        String strMinBufRelocation = "";
        String strMaxBufRelocation = "";
        String strTierText = "";
        boolean bActivityFlg = false;
        strTierText = this.getTierText(iTierNum).getValue();
        this.refTierText(strMinBufRelocation, strMaxBufRelocation, new String(""), true, iTierNum);
        if (strSelMultiTierKey.equals("COM_ENABLE")) {
            if (iTierNum == 1) {
                strMinBufRelocation = SJctrComUtility.toDecString(2);
                strMaxBufRelocation = SJctrComUtility.toDecString(40);
                this.refTierText(strMinBufRelocation, strMaxBufRelocation, strTierText, true, iTierNum);
            } else {
                for (int iCnt = 0; iCnt < poolDtlList.size(); ++iCnt) {
                    SJmoPoolDetail poolDtl = poolDtlList.get(iCnt);
                    if ((poolDtl.getITierControlInfo() & 0x80) != 0) {
                        SJmoPoolTierInfo defPoolTierInf = this.getTierInfo(poolDtl.getAlTierInfo(), iTierNum);
                        if (defPoolTierInf == null) continue;
                        bActivityFlg = true;
                        break;
                    }
                    HashSet poolDriveTypeSet = this.getComUtility().getPoolUtility().getDriveTypeRpminPool(poolDtl.getAlPoolPgKind());
                    if (poolDriveTypeSet.size() < iTierNum) continue;
                    bActivityFlg = true;
                    break;
                }
                if (bActivityFlg) {
                    strMinBufRelocation = SJctrComUtility.toDecString(2);
                    strMaxBufRelocation = SJctrComUtility.toDecString(40);
                }
                this.refTierText(strMinBufRelocation, strMaxBufRelocation, strTierText, bActivityFlg, iTierNum);
            }
        } else if (strSelMultiTierKey.equals("COM_DISABLE")) {
            this.refTierText(strMinBufRelocation, strMaxBufRelocation, strTierText, false, iTierNum);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "refTierTextArea", "Multi-Tier Pool Selection Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    private SJmoPoolTierInfo getTierInfo(ArrayList<SJmoPoolTierInfo> alPoolTier, int iTierNum) {
        SJmoPoolTierInfo poolTierInf = null;
        for (int iTierCnt = 0; iTierCnt < alPoolTier.size(); ++iTierCnt) {
            if (iTierNum != alPoolTier.get(iTierCnt).getSTierNum()) continue;
            poolTierInf = alPoolTier.get(iTierCnt);
            break;
        }
        return poolTierInf;
    }

    private SJctrTextBoxDataModel getTierText(int iTierNum) {
        SJctrTextBoxDataModel retText = null;
        switch (iTierNum) {
            case 1: {
                retText = this.relocationTier1TextBox;
                break;
            }
            case 2: {
                retText = this.relocationTier2TextBox;
                break;
            }
            case 3: {
                retText = this.relocationTier3TextBox;
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getTierText", "Tier Num Error Tier Num = " + iTierNum);
            }
        }
        return retText;
    }

    private void refTierText(String strMin, String strMax, String strText, boolean bEnable, int iTierNum) {
        SJctrTextBoxDataModel tierText = this.getTierText(iTierNum);
        tierText.setMin(strMin);
        tierText.setMax(strMax);
        tierText.setValue(strText);
        tierText.setEnable(bEnable);
    }

    public String getStrTierBufRelocationText(int iTierNum) {
        SJctrTextBoxDataModel tiertextBox = this.getTierText(iTierNum);
        return tiertextBox.getValue();
    }

    public boolean isTextBoxEnable(int iTierNum) {
        SJctrTextBoxDataModel tiertextBox = this.getTierText(iTierNum);
        return tiertextBox.isEnable();
    }
}

