/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.edittieringpolicies;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.pool.comdialog.changetieringpolicies.SJctrChangeTieringPoliciesDC;
import sanproject.sn2.controller.wizard.pool.comdialog.changetieringpolicies.SJctrChangeTieringPoliciesData;
import sanproject.sn2.controller.wizard.pool.edittieringpolicies.SJctrEditTieringPoliciesConfirmData;
import sanproject.sn2.controller.wizard.pool.edittieringpolicies.SJctrEditTieringPoliciesSubWizard;
import sanproject.sn2.controller.wizard.pool.edittieringpolicies.SJctrTieringPoliciesTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelationbyPool;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolTieringPolicy;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicyIndex;

public class SJctrEditTieringPoliciesDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831761;
    private static final String KEY_TIER_POLICY_TABLE = "COM_TABLE";
    private static final String KEY_CHANGE_BTN = "COM_CHANGE_BTN";
    private List<SJmoPoolTieringPolicy> tieringPolicyList = null;
    private List<SJmoPoolTieringPolicy> edittTeringPolicyList = null;
    private List<SJmoPoolDetail> poolDtlList = null;
    private List<SJmoHDPRelationByPool> hdpRelationByPoolList = null;
    private Map<Short, Integer> vvolNumMap = null;
    private Set<Short> tieringPolicyCheckPolicyIdSet = null;
    private Set<Short> allocationThresholdCheckPolicyIdSet = null;
    private SJctrTieringPoliciesTableModel tierPoliciesTable = null;

    public SJctrEditTieringPoliciesDC() {
        super(17831761);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("EDIT_TIERING_POLICIES");
    }

    private void initDataModel() {
        this.tierPoliciesTable = new SJctrTieringPoliciesTableModel();
        this.addDataObjectModel(KEY_TIER_POLICY_TABLE, this.tierPoliciesTable);
        SJctrButtonDataModel changeBtn = new SJctrButtonDataModel();
        changeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditTieringPoliciesDC.this.changeAction();
            }
        });
        this.addDataObjectModel(KEY_CHANGE_BTN, changeBtn);
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    @Override
    public boolean checkConstructData() {
        List<?> modelTieringPolicyList;
        this.poolDtlList = this.getCache(SJmoGetPoolDetail.class);
        if (this.poolDtlList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolDtlList null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.hdpRelationByPoolList = this.getCache(SJmoGetHDPRelationbyPool.class);
        if (this.hdpRelationByPoolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "hdpRelationList null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if ((modelTieringPolicyList = this.getCache(SJmoGetPoolTieringPolicy.class)) == null || modelTieringPolicyList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "tieringPolicyList null or Empty");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.tieringPolicyList = new ArrayList<SJmoPoolTieringPolicy>(modelTieringPolicyList.size());
        for (SJmoPoolTieringPolicy modelTieringPolicy : modelTieringPolicyList) {
            try {
                SJmoPoolTieringPolicy cloneData = (SJmoPoolTieringPolicy)modelTieringPolicy.clone();
                this.tieringPolicyList.add(cloneData);
            }
            catch (CloneNotSupportedException e) {
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
        }
        Collections.sort(this.tieringPolicyList);
        return true;
    }

    @Override
    public void makeDataModel() {
        this.edittTeringPolicyList = new ArrayList<SJmoPoolTieringPolicy>(this.tieringPolicyList.size());
        this.vvolNumMap = new HashMap<Short, Integer>(this.tieringPolicyList.size());
        this.tieringPolicyCheckPolicyIdSet = new HashSet<Short>(this.tieringPolicyList.size());
        this.allocationThresholdCheckPolicyIdSet = new HashSet<Short>(this.tieringPolicyList.size());
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        for (SJmoPoolTieringPolicy tieringPolicy : this.tieringPolicyList) {
            short policyId = tieringPolicy.getPolicyId();
            this.vvolNumMap.put(policyId, 0);
        }
        for (SJmoPoolDetail poolDtl : this.poolDtlList) {
            if (!poolUtility.isPoolTypeHDT(poolDtl)) continue;
            int search = Collections.binarySearch(this.hdpRelationByPoolList, (Object)poolDtl);
            if (search < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeDataModel", "POOL ID = " + poolDtl.toString());
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            SJmoHDPRelationByPool hddbypool = this.hdpRelationByPoolList.get(search);
            ArrayList hdpRelationPoolList = hddbypool.getAlDPVOLInfo();
            for (SJmoHDPRelation hdpRelation : hdpRelationPoolList) {
                short tierPolicyId = hdpRelation.getSTierLevel();
                Integer vVolNum = this.vvolNumMap.get(tierPolicyId);
                if (vVolNum == null) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "makeDataModel", "LDEVID = " + hdpRelation.toString() + ", policyID is = " + vVolNum);
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                Integer n = vVolNum;
                Integer n2 = vVolNum = Integer.valueOf(vVolNum + 1);
                this.vvolNumMap.put(tierPolicyId, vVolNum);
            }
        }
        ArrayList<Map<Short, Integer>> vvolNumList = new ArrayList<Map<Short, Integer>>();
        vvolNumList.add(this.vvolNumMap);
        this.tierPoliciesTable.setTableKeyList(this.tieringPolicyList);
        this.tierPoliciesTable.setBasicData(SJctrEditTieringPoliciesSubWizard.SJctrGetVVolNumMap.class, vvolNumList);
        super.makeDataModel();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.edittTeringPolicyList == null || this.edittTeringPolicyList.isEmpty()) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
        }
    }

    private void changeAction() {
        SJmoPoolTieringPolicyIndex policyInfo;
        List<Object> selRoWList;
        SJcRoleResourceContainer roleRscContainer;
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        if (!ppcontainer.checkPP(SJctrLicenseContainer.PPID_DP) || !ppcontainer.checkPP(SJctrLicenseContainer.PPID_HDTPM)) {
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_PP_NOTINSTALL);
        }
        if (!(roleRscContainer = this.getOwner().getAuthorizeContainer().getRoleResourceContainer()).checkAuthority(123)) {
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_PP_NOTINSTALL);
        }
        if ((selRoWList = this.tierPoliciesTable.getSelectedRowData()).size() != 1) {
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        if (SJctrPoolUtility.isSystemDefinedPolicy(policyInfo = (SJmoPoolTieringPolicyIndex)selRoWList.get(0))) {
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_EDIT_SYSTEMDEF_POLICY);
        }
        HashMap map = new HashMap();
        map.put("DD84_POLICYDATA", selRoWList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrChangeTieringPoliciesDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrEditTieringPoliciesDC.this.exitChangePolicyAction(map);
                }
            }
        });
    }

    private void exitChangePolicyAction(Map<String, List<?>> carryMap) {
        List<?> getList = carryMap.get("DD84_CHG_POLICYDATA");
        if (getList == null || getList.isEmpty()) {
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJctrChangeTieringPoliciesData changeTieringPolicyData = (SJctrChangeTieringPoliciesData)getList.get(0);
        List<Object> rowData = this.tierPoliciesTable.getSelectedRowData();
        if (!rowData.isEmpty()) {
            SJmoPoolTieringPolicy policyInfo = (SJmoPoolTieringPolicy)rowData.get(0);
            int search_EditData = Collections.binarySearch(this.edittTeringPolicyList, (Object)policyInfo);
            if (search_EditData < 0) {
                this.edittTeringPolicyList.add(policyInfo);
                Collections.sort(this.edittTeringPolicyList);
            }
            SJmoPoolTieringPolicy chgPolicyInfo = changeTieringPolicyData.getTieringPolicyInfo();
            policyInfo.setPolicyName(chgPolicyInfo.getStrPolicyName());
            policyInfo.setST1Max(chgPolicyInfo.getST1Max());
            policyInfo.setST1Min(chgPolicyInfo.getST1Min());
            policyInfo.setST3Max(chgPolicyInfo.getST3Max());
            policyInfo.setST3Min(chgPolicyInfo.getST3Min());
            if (changeTieringPolicyData.isTieringPolicyCheck()) {
                this.tieringPolicyCheckPolicyIdSet.add(policyInfo.getPolicyId());
            }
            if (changeTieringPolicyData.isAllocationThresholdCheck()) {
                this.allocationThresholdCheckPolicyIdSet.add(policyInfo.getPolicyId());
            }
            this.tierPoliciesTable.doRefresh();
            this.tierPoliciesTable.addRowSelectionList(rowData);
            this.getWizardWindow().rollback();
            this.updateFooter();
        }
    }

    public SJctrEditTieringPoliciesConfirmData createConfirmData() {
        SJctrEditTieringPoliciesConfirmData confirmData = new SJctrEditTieringPoliciesConfirmData();
        confirmData.setTierPolicyInfo(this.edittTeringPolicyList);
        ArrayList<Map<Short, Integer>> vvolNumList = new ArrayList<Map<Short, Integer>>();
        vvolNumList.add(this.vvolNumMap);
        confirmData.setVVolNumData(vvolNumList);
        confirmData.setTieringPolicyCheckPolicyIdSet(this.tieringPolicyCheckPolicyIdSet);
        confirmData.setAllocationThresholdCheckPolicyIdSet(this.allocationThresholdCheckPolicyIdSet);
        ArrayList<SJctrEditTieringPoliciesConfirmData> list = new ArrayList<SJctrEditTieringPoliciesConfirmData>(1);
        list.add(confirmData);
        this.putCache("EDIT_TIERPOLICYS_CONFIRMDATA", list);
        return confirmData;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPoolTieringPolicy();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHDPRelationbyPool();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

