/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.shrinkpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrArrayGroupFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevAttributeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrLdevNameFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrVirtualizationModeColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrVirtualizationSpaceUsedColumnFromLdevDetail;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolVolCapacityColumnFromLdevDetail;
import sanproject.sn2.controller.wizard.pool.shrinkpool.SJctrShrinkPoolConfirmDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrShrinkPoolVolumesTableModel
extends SJctrTableDataModel {
    public SJctrShrinkPoolVolumesTableModel() {
        super(false);
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrLdevIdColumnFromLdevDetail("COM_COL_LDEVID"));
        this.addColumn(new SJctrLdevNameFromLdevDetailColumn("COM_COL_LDEVNAME"));
        this.addColumn(new SJctrArrayGroupFromLdevDetailColumn("COM_COL_ARYGRP"));
        SJctrEmulationTypeFromLdevDetailColumn emuTypeCulm = new SJctrEmulationTypeFromLdevDetailColumn("COM_COL_EMUTYPE");
        if (SJctrDataController.isHM()) {
            emuTypeCulm.setSupportColumn(false);
        }
        this.addColumn(emuTypeCulm);
        this.addColumn(new SJctrPoolVolCapacityColumnFromLdevDetail("COM_COL_LDEVCAP"));
        this.addColumn(new SJctrLdevAttributeFromLdevDetailColumn("COM_COL_ATTR"));
        this.addColumn(new SJctrVirtualizationModeColumnFromLdevDetail("COM_COL_VIRTUAL_MODE"));
        this.addColumn(new SJctrVirtualizationSpaceUsedColumnFromLdevDetail("COM_COL_VIRTUAL_SPACE_USED"));
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        ArrayList<Object> mainKeyList = new ArrayList();
        SJctrShrinkPoolConfirmDC spConfDC = (SJctrShrinkPoolConfirmDC)this.getDataController();
        ArrayList ldevDtlList = new ArrayList(spConfDC.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        ArrayList selectPoolDetaList = new ArrayList(spConfDC.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        if (null == ldevDtlList || 0 == ldevDtlList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "CacheData is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        Collections.sort(ldevDtlList);
        mainKeyList = ldevDtlList;
        if (null == selectPoolDetaList || 0 == selectPoolDetaList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "CacheData is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, selectPoolDetaList);
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        for (int iCnt = 0; iCnt < mainKeyList.size(); ++iCnt) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)mainKeyList.get(iCnt);
            if (SJctrLdevUtility.isOpenVolume(ldevDtl)) {
                bOpenFlg = true;
                break;
            }
            if (!SJctrLdevUtility.isMFVolume(ldevDtl)) continue;
            bMFFlg = true;
            break;
        }
        this.setCapacityFlg(true);
        this.setMainframeVolumeFlg(bMFFlg);
        this.setOpenVolumeFlg(bOpenFlg);
        this.setDpVolumeFlg(true);
        return mainKeyList;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        ArrayList ldevNameInfList = new ArrayList(this.getDataController().getProxy().getCache(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO));
        if (null == ldevNameInfList || 0 == ldevNameInfList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setModelData", "CacheData is null or size 0");
        }
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO, ldevNameInfList);
    }

    @Override
    protected void makeCapacityUnitInfo() {
    }
}

