/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.RCErrorDetail;
import sanproject.serverux.dataimpl.RCErrorInf;
import sanproject.serverux.dataimpl.RJiHAsetCreatePair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetDeletePair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetSeparatePair_OUT;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationRcBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrOperationHaPairBaseAC
extends SJctrOperationRcBaseAC {
    protected List<SJmoHAPairVolInfo> applyInfo = new ArrayList<SJmoHAPairVolInfo>();
    protected static final int DEFAULT_SSID = 0;
    protected static final int RANGE_THE_VOLUME = 0;
    protected static final int RANGE_GROUP_VOLUME = 1;

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        int funcErc = 210;
        int moduleErc = 22;
        int delegateErc = 0;
        SJctrError error = new SJctrError(funcErc, moduleErc, delegateErc);
        this.resultData = new ArrayList();
        RCErrorInf errInfo = null;
        if (resultObject instanceof RJiHAsetCreatePair_OUT) {
            errInfo = (RCErrorInf)((RJiHAsetCreatePair_OUT)resultObject).getDataObject();
        } else if (resultObject instanceof RJiHAsetSeparatePair_OUT) {
            errInfo = (RCErrorInf)((RJiHAsetSeparatePair_OUT)resultObject).getDataObject();
        } else if (resultObject instanceof RJiHAsetReconstructPair_OUT) {
            errInfo = (RCErrorInf)((RJiHAsetReconstructPair_OUT)resultObject).getDataObject();
        } else if (resultObject instanceof RJiHAsetDeletePair_OUT) {
            errInfo = (RCErrorInf)((RJiHAsetDeletePair_OUT)resultObject).getDataObject();
        } else if (resultObject instanceof RCErrorInf) {
            errInfo = (RCErrorInf)resultObject;
        } else {
            error.setError(107001);
            this.resultData.add(error);
        }
        if (null != errInfo) {
            funcErc = errInfo.ErrorPart / 100;
            moduleErc = errInfo.ErrorPart % 100;
            RCErrorDetail[] errDetail = errInfo.tDetail;
            if (null != errDetail) {
                for (int i = 0; i < errDetail.length; ++i) {
                    RCErrorDetail detail = errDetail[i];
                    int code = -1;
                    if (null != detail) {
                        code = detail.ErrCode;
                    }
                    SJctrLogUty.info(this.getClass().getSimpleName(), "setApplyResult", "index: " + i + " func: " + funcErc + " module: " + moduleErc + " code: " + code);
                    if (null == detail || detail.ErrCode == 0) continue;
                    SJctrRcOperationError optError = new SJctrRcOperationError(funcErc, moduleErc, detail.ErrCode, i);
                    this.resultData.add(optError);
                }
            }
        }
        if (this.resultData.size() > 0) {
            this.setError((SJctrError)this.resultData.get(0));
        } else {
            this.setError(error);
        }
    }

    protected void putAluaError(Map<String, SJctrError> mapError, SanResponse aluaResult) throws SanDataException {
        if (mapError != null && aluaResult != null) {
            SanList ldevs = aluaResult.getList("Ldevs");
            for (SanObject ldev : ldevs) {
                SanObject errorInfo = ldev.getObj("ErrorInfo");
                int errorCode = errorInfo.getInt("ErrorCode");
                if (0 == errorCode) continue;
                int[] id = ldev.getIntArray("Id");
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex((short)id[0], (short)id[1], (short)id[2]);
                String key = ldevIndex.getIndexKey();
                int[] messageId = errorInfo.getIntArray("MessageId");
                SJctrError error = new SJctrError(messageId[0] / 100, messageId[0] % 100, messageId[1]);
                mapError.put(key, error);
            }
        }
    }

    protected void putPairError(Map<String, SJctrError> mapError, RCErrorInf errInfo) {
        if (mapError != null && errInfo != null) {
            RCErrorDetail[] details;
            int func = errInfo.ErrorPart / 100;
            int module = errInfo.ErrorPart % 100;
            for (RCErrorDetail detail : details = errInfo.tDetail) {
                int errorCode = detail.ErrCode;
                if (0 == errorCode) continue;
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(detail.pLDKC, (short)detail.pCu, (short)detail.pLdev);
                String key = ldevIndex.getIndexKey();
                SJctrError error = new SJctrError(func, module, errorCode);
                mapError.put(key, error);
            }
        }
    }

    protected void setApplyResult(Map<String, SJctrError> mapError) {
        SJctrError normal = new SJctrError(210, 22, 0);
        this.resultData = new ArrayList();
        int index = 0;
        for (SJmoHAPairVolInfo haPair : this.applyInfo) {
            SJmoReplicationPairVolInfo ldevIndex = SJctrHaUtility.getLocalVolume(haPair);
            SJctrError err = mapError.get(ldevIndex.getIndexKey());
            if (err != null) {
                SJctrRcOperationError error = new SJctrRcOperationError(err.getFunc(), err.getModule(), err.getError(), index);
                this.resultData.add(error);
            }
            ++index;
        }
        if (this.resultData.size() > 0) {
            this.setError((SJctrError)this.resultData.get(0));
        } else {
            this.setError(normal);
        }
    }

    @Override
    public int getLeadTime() {
        int ret = SJctrRemoteReplicationUtility.getLeadTime(this.applyInfo.size(), 256, 20);
        return ret;
    }
}

