/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrAvailableLdevTableModelForLdev;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrAvailableLdevTableModelForLun;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrrAssignSVolPairsTableModel;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairConfirmData;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.selectsvol.SJctrCapacityFilterDataModel;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.selectsvol.SJctrPortHGCapacityFilterDataModel;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.selectsvol.SJctrSelObjCmbDataModel;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.selectsvol.SJctrSelectSVolDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrAssignSVolDC
extends SJctrSelectSVolDC {
    private static final int DISP_ID = 17832081;
    private static final String TITLE = "ASSIGN_SVOLS";
    private SJctrTIPairGetExecuter tiPairGetExcuter = null;
    private SJmoTiPvolStatus tiPVolStatus = null;
    private SJmoTiSnapshotPairList tiSSPairList = null;
    private List<SJmoHUVMVirtualLdev> vLdevList = Collections.emptyList();

    public SJctrAssignSVolDC() throws SJcException {
        super(17832081);
        this.optCreatePair = false;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    @Override
    protected void initDataModel() {
        this.capFilterDataModel = new SJctrCapacityFilterDataModel();
        this.addDataObjectModel("COM_LDEVCAPINF", this.capFilterDataModel);
        this.excludeSVolDataModel = new SJctrCheckBoxDataModel();
        this.addDataObjectModel("COM_EXCPAIRVOL_VCHK", this.excludeSVolDataModel);
        this.excludeSVolDataModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignSVolDC.this.changeExcludeVolume();
            }
        });
        this.cmbSelectBy = new SJctrComboBoxDataModel();
        this.addDataObjectModel("COM_CMB_SELECT_BY", this.cmbSelectBy);
        this.selObjCmpDataModel = new SJctrSelObjCmbDataModel();
        this.addDataObjectModel("COM_SELOBJ_CMB", this.selObjCmpDataModel);
        this.ptHGFilterDataModel = new SJctrPortHGCapacityFilterDataModel();
        this.addDataObjectModel("COM_PT_HG_FILTER", this.ptHGFilterDataModel);
        this.availableTable = new SJctrAvailableLdevTableModelForLun();
        this.addDataObjectModel("COM_TABLE_AVAILABLE_LUNS", this.availableTable);
        this.availableTableForLdev = new SJctrAvailableLdevTableModelForLdev();
        this.addDataObjectModel("COM_TABLE_AVAILABLE_LDEV", this.availableTableForLdev);
        this.selectedTable = new SJctrrAssignSVolPairsTableModel();
        this.addDataObjectModel("COM_TABLE_SELECTED", this.selectedTable);
        SJctrButtonDataModel setBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_SET", setBtn);
        setBtn.setRollBackCheck(true);
        setBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignSVolDC.this.setAction();
            }
        });
        SJctrButtonDataModel clearBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_CLEAR", clearBtn);
        clearBtn.setRollBackCheck(true);
        clearBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignSVolDC.this.clearAction();
            }
        });
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    @Override
    protected void setSVol() {
        super.setSVol();
        this.updateFooter();
    }

    @Override
    protected void clearAction() {
        super.clearAction();
        this.updateFooter();
    }

    @Override
    public void makeDataModel() {
        this.ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(this.portLunList, this.ldevDtlList);
        this.tiPairGetExcuter.setModelData(this.poolNameList, this.ssGrpMgr, this.tiSSPairList, this.tiPVolStatus, this.ldevLUPathMap);
        this.createTiPairList = this.tiPairGetExcuter.getAvailablePairInfo(this);
        if (this.createTiPairList.isEmpty()) {
            SJctrCreateTIPairUtility.createError(206165);
        }
        boolean bCascadeEnable = ((SJctrCreateTIPairInfo)this.createTiPairList.get(0)).isBCascade();
        this.ldevCapMap = new HashMap(this.ldevDtlList.size());
        HashSet<Long> pVolCapSet = new HashSet<Long>(this.createTiPairList.size());
        SJmoLdevIndex searchLdev = new SJmoLdevIndex();
        for (SJctrCreateTIPairInfo pairInfo : this.createTiPairList) {
            searchLdev = pairInfo.getPVolIndex();
            int index = Collections.binarySearch(this.ldevDtlList, searchLdev);
            if (index < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeDataModel", "LdevDetail not Found.");
                SJctrCreateTIPairUtility.createError(107002);
            }
            int ldevIndexKey = SJctrReplicationUtility.getLdevIndexKey(searchLdev);
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)this.ldevDtlList.get(index);
            long capacity = ldevDtl.getLLDEVLBASize();
            this.ldevCapMap.put(ldevIndexKey, capacity);
            pVolCapSet.add(capacity);
        }
        Set<Integer> haRsvSet = SJctrReplicationUtility.getHaReserveLdevSet(this.vLdevList);
        List<SJmoLdevDetail> availableSVolLdevListBaseLdev = SJctrCreateTIPairUtility.getAvailableSVOL(this.ldevDtlList, pVolCapSet, this.rsgUtil, this.ldevStatusInfoList, haRsvSet, this.pairVolMgr, this.tiPVolStatus, bCascadeEnable, null);
        List<SJmoLdevDetail> availableSVolLdevList = null;
        availableSVolLdevList = bCascadeEnable ? SJctrCreateTIPairUtility.getLdevListOfExistingLuPath(availableSVolLdevListBaseLdev) : availableSVolLdevListBaseLdev;
        if (availableSVolLdevList.isEmpty() && availableSVolLdevListBaseLdev.isEmpty()) {
            SJctrCreateTIPairUtility.createError(206168);
        }
        this.sVolCapList = new ArrayList(availableSVolLdevListBaseLdev.size());
        this.availableSVolPathList = new ArrayList(availableSVolLdevListBaseLdev.size());
        this.assignedSVolSet = new HashSet(availableSVolLdevListBaseLdev.size());
        for (SJmoLdevDetail sVolLdev : availableSVolLdevListBaseLdev) {
            List luPathList;
            int sVolIndexKey = sVolLdev.getIndex();
            long sVolCap = sVolLdev.getLLDEVLBASize();
            this.ldevCapMap.put(sVolIndexKey, sVolCap);
            int index = Collections.binarySearch(this.sVolCapList, sVolCap);
            if (index < 0) {
                int insertIndex = -(index + 1);
                this.sVolCapList.add(insertIndex, sVolCap);
            }
            if ((luPathList = (List)this.ldevLUPathMap.get(sVolIndexKey)) != null) {
                this.availableSVolPathList.addAll(luPathList);
            }
            if (!this.checkTISVol(sVolLdev)) continue;
            this.assignedSVolSet.add(sVolIndexKey);
        }
        this.unmapSVolList = new ArrayList(this.assignedSVolSet.size());
        this.unmapSVolLdevList = new ArrayList(this.assignedSVolSet.size());
        this.replaceSVolSet = new HashSet(this.assignedSVolSet.size());
        this.availableSVolList = new ArrayList(availableSVolLdevListBaseLdev.size());
        Collections.sort(this.availableSVolPathList);
        Collections.sort(availableSVolLdevListBaseLdev);
        this.availableSVolList.addAll(availableSVolLdevListBaseLdev);
        super.makeDataModel();
    }

    @Override
    public boolean checkStartData() {
        List<?> getList = null;
        while (true) {
            if ((getList = this.getCache("KEY_SELECTED_PVOL")) != null && !getList.isEmpty()) {
                this.tiPairGetExcuter = SJctrTIPairGetExecuter.createTIPairGetExecuter_PVol();
                break;
            }
            getList = this.getCache("KEY_SELECTED_PVOL_MU");
            if (getList != null && !getList.isEmpty()) {
                this.tiPairGetExcuter = SJctrTIPairGetExecuter.createTIPairGetExecuter_PVolMU();
                break;
            }
            getList = this.getCache("KEY_SELECTED_SSGRP");
            if (getList != null && !getList.isEmpty()) {
                this.tiPairGetExcuter = SJctrTIPairGetExecuter.createTIPairGetExecuter_SSGrp();
                break;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "There is no Cache Data.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        this.tiPairGetExcuter.checkInputData(getList);
        return true;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.checkModelData();
        return ret;
    }

    @Override
    protected void checkModelData() {
        super.checkModelData();
        List<?> tiSSPairInfoList = this.getCache(SJmoGetTiSnapshotPairList.class);
        if (tiSSPairInfoList == null || tiSSPairInfoList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoTiSnapshotPairList is null or Empty.");
            SJctrCreateTIPairUtility.createError(107002);
        }
        this.tiSSPairList = (SJmoTiSnapshotPairList)tiSSPairInfoList.get(0);
        List<?> tiPVolStatusList = this.getCache(SJmoGetTiPvolStatus.class);
        if (tiPVolStatusList == null || tiPVolStatusList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoTiPvolStatus is null or Empty.");
            SJctrCreateTIPairUtility.createError(107002);
        }
        this.tiPVolStatus = (SJmoTiPvolStatus)tiPVolStatusList.get(0);
        this.vLdevList = this.getCache(SJmoGetHUVMVirtualLdev.class);
        if (this.vLdevList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortLunInfo is null.");
            SJctrCreateTIPairUtility.createError(107002);
        }
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        if (!this.checkAssignSVolPair()) {
            SJctrCreateTIPairUtility.createError(205092);
        }
        return ret;
    }

    @Override
    public SJctrCreateTIPairConfirmData createConfirmData() {
        SJctrCreateTIPairConfirmData confirmData = new SJctrCreateTIPairConfirmData();
        ArrayList<SJmoLdevDetail> confirmLdevDtlList = new ArrayList<SJmoLdevDetail>(this.ldevDtlList.size());
        ArrayList<SJmoLdevNicknameInfo> confirmLdevNameList = new ArrayList<SJmoLdevNicknameInfo>(this.ldevNameList.size());
        ArrayList<SJmoPortDetail> confirmPortDtlList = new ArrayList<SJmoPortDetail>(this.portDtlList.size());
        ArrayList<SJmoPortHostGroupInfo> confirmPortHgList = new ArrayList<SJmoPortHostGroupInfo>(this.portHgInfoList.size());
        ArrayList<SJmoPortIscsiTargetInfo> confirmPortITList = new ArrayList<SJmoPortIscsiTargetInfo>(this.portITInfoList.size());
        ArrayList<SJmoPoolDetail> confirmPoolDtlList = new ArrayList<SJmoPoolDetail>(this.poolDtlList.size());
        ArrayList<SJmoPoolNameInfo> confirmPoolNameList = new ArrayList<SJmoPoolNameInfo>(this.poolNameList.size());
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        HashSet<Integer> ldevIndexKeySet = new HashSet<Integer>(this.createTiPairList.size());
        HashSet<Short> portIdSet = new HashSet<Short>(this.createTiPairList.size());
        HashSet<Integer> poolSet = new HashSet<Integer>(this.unmapSVolList.size());
        ArrayList<SJctrCreateTIPairInfo> assignPairList = new ArrayList<SJctrCreateTIPairInfo>(this.createTiPairList.size());
        for (SJctrCreateTIPairInfo createTiPairInfo : this.createTiPairList) {
            SJmoPoolNameInfo poolNameInfo;
            SJmoPortLunDetail pVolPathInfo;
            SJmoPortLunDetail sVolPathInfo;
            ldevIndex = createTiPairInfo.getSVolIndex();
            if (ldevIndex == null || ldevIndex.getIndex() == -1) continue;
            assignPairList.add(createTiPairInfo);
            if (ldevIndexKeySet.add(ldevIndex.getIndex())) {
                int searchLdevName;
                int searchLdev = Collections.binarySearch(this.ldevDtlList, ldevIndex);
                if (searchLdev >= 0) {
                    confirmLdevDtlList.add((SJmoLdevDetail)this.ldevDtlList.get(searchLdev));
                }
                if ((searchLdevName = Collections.binarySearch(this.ldevNameList, ldevIndex)) >= 0) {
                    confirmLdevNameList.add((SJmoLdevNicknameInfo)this.ldevNameList.get(searchLdevName));
                }
            }
            if ((sVolPathInfo = createTiPairInfo.getSVolLuPathInfo()) != null && sVolPathInfo.getSPort() != -1 && portIdSet.add(sVolPathInfo.getSPort())) {
                SJmoPortDetail portDtl = null;
                int searchPortDtl = Collections.binarySearch(this.portDtlList, sVolPathInfo);
                if (searchPortDtl >= 0) {
                    portDtl = (SJmoPortDetail)this.portDtlList.get(searchPortDtl);
                    confirmPortDtlList.add(portDtl);
                }
                if (portDtl != null) {
                    if (!SJctrPortUtility.isIscsiPort(portDtl)) {
                        int searchPortHg = Collections.binarySearch(this.portHgInfoList, sVolPathInfo);
                        if (searchPortHg >= 0) {
                            confirmPortHgList.add((SJmoPortHostGroupInfo)this.portHgInfoList.get(searchPortHg));
                        }
                    } else {
                        int searchPortIt = Collections.binarySearch(this.portITInfoList, sVolPathInfo);
                        if (searchPortIt >= 0) {
                            SJmoPortIscsiTargetInfo portITInfo = (SJmoPortIscsiTargetInfo)this.portITInfoList.get(searchPortIt);
                            confirmPortITList.add(portITInfo);
                        }
                    }
                }
            }
            if (ldevIndexKeySet.add((ldevIndex = createTiPairInfo.getPVolIndex()).getIndex())) {
                int searchLdevName;
                int searchLdev = Collections.binarySearch(this.ldevDtlList, ldevIndex);
                if (searchLdev >= 0) {
                    confirmLdevDtlList.add((SJmoLdevDetail)this.ldevDtlList.get(searchLdev));
                }
                if ((searchLdevName = Collections.binarySearch(this.ldevNameList, ldevIndex)) >= 0) {
                    confirmLdevNameList.add((SJmoLdevNicknameInfo)this.ldevNameList.get(searchLdevName));
                }
            }
            if ((pVolPathInfo = createTiPairInfo.getPVolLuPathInfo()) != null && pVolPathInfo.getSPort() != -1 && portIdSet.add(pVolPathInfo.getSPort())) {
                SJmoPortDetail portDtl = null;
                int searchPortDtl = Collections.binarySearch(this.portDtlList, pVolPathInfo);
                if (searchPortDtl >= 0) {
                    portDtl = (SJmoPortDetail)this.portDtlList.get(searchPortDtl);
                    confirmPortDtlList.add(portDtl);
                }
                if (portDtl != null) {
                    if (!SJctrPortUtility.isIscsiPort(portDtl)) {
                        int searchPortHg = Collections.binarySearch(this.portHgInfoList, pVolPathInfo);
                        if (searchPortHg >= 0) {
                            confirmPortHgList.add((SJmoPortHostGroupInfo)this.portHgInfoList.get(searchPortHg));
                        }
                    } else {
                        int searchPortIt = Collections.binarySearch(this.portITInfoList, pVolPathInfo);
                        if (searchPortIt >= 0) {
                            SJmoPortIscsiTargetInfo portITInfo = (SJmoPortIscsiTargetInfo)this.portITInfoList.get(searchPortIt);
                            confirmPortITList.add(portITInfo);
                        }
                    }
                }
            }
            if (!poolSet.add((poolNameInfo = createTiPairInfo.getPoolNameInfo()).getPoolId())) continue;
            int searchPoolDtl = Collections.binarySearch(this.poolDtlList, poolNameInfo);
            if (searchPoolDtl >= 0) {
                confirmPoolDtlList.add((SJmoPoolDetail)this.poolDtlList.get(searchPoolDtl));
            }
            confirmPoolNameList.add(poolNameInfo);
        }
        for (SJmoLdevIndex sVolIndex : this.unmapSVolLdevList) {
            int searchPoolName;
            int poolId;
            int ldevIndexKey;
            SJmoLocalReplicationPairVolInfo pairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(sVolIndex);
            if (pairInfo == null || !pairInfo.isVolPos(0x800000)) continue;
            SJmoLdevIndex pVolIndex = pairInfo.getPVolIndex();
            if (pVolIndex != null && ldevIndexKeySet.add(ldevIndexKey = pVolIndex.getIndex())) {
                int searchLdevName;
                int searchLdev = Collections.binarySearch(this.ldevDtlList, pVolIndex);
                if (searchLdev >= 0) {
                    SJmoLdevDetail ldevDtl = (SJmoLdevDetail)this.ldevDtlList.get(searchLdev);
                    confirmLdevDtlList.add(ldevDtl);
                }
                if ((searchLdevName = Collections.binarySearch(this.ldevNameList, pVolIndex)) >= 0) {
                    SJmoLdevNicknameInfo ldevNameInfo = (SJmoLdevNicknameInfo)this.ldevNameList.get(searchLdevName);
                    confirmLdevNameList.add(ldevNameInfo);
                }
            }
            if (!poolSet.add(poolId = pairInfo.getISVolPoolId())) continue;
            SJmoPoolIndex poolIndex = new SJmoPoolIndex();
            poolIndex.setPoolId(poolId);
            int searchPoolDtl = Collections.binarySearch(this.poolDtlList, poolIndex);
            if (searchPoolDtl >= 0) {
                confirmPoolDtlList.add((SJmoPoolDetail)this.poolDtlList.get(searchPoolDtl));
            }
            if ((searchPoolName = Collections.binarySearch(this.poolNameList, poolIndex)) < 0) continue;
            confirmPoolNameList.add((SJmoPoolNameInfo)this.poolNameList.get(searchPoolName));
        }
        confirmData.setCreatePairList(assignPairList);
        confirmData.setUnMapSVolList(this.unmapSVolList);
        confirmData.setUnMapSVolLdevList(this.unmapSVolLdevList);
        Collections.sort(confirmLdevDtlList);
        confirmData.setLdevDtlList(confirmLdevDtlList);
        Collections.sort(confirmLdevNameList);
        confirmData.setLdevNameList(confirmLdevNameList);
        confirmData.setClprInfo(this.clprInfoList);
        Collections.sort(confirmPortDtlList);
        confirmData.setPortDetailInfo(confirmPortDtlList);
        Collections.sort(confirmPortHgList);
        confirmData.setPortHGInfo(confirmPortHgList);
        Collections.sort(confirmPortITList);
        confirmData.setPortITInfo(confirmPortITList);
        confirmData.setPairInfoMgr(this.pairVolMgr);
        confirmData.setTiPvolStatus(this.tiPVolStatus);
        confirmData.setSSGrpInfoMgr(this.ssGrpMgr);
        Collections.sort(confirmPoolDtlList);
        confirmData.setPoolDetail(confirmPoolDtlList);
        Collections.sort(confirmPoolNameList);
        confirmData.setPoolNameList(confirmPoolNameList);
        confirmData.setHDPRelationList(this.hdpRelationList);
        confirmData.setLdevLUPathInfo(this.ldevLUPathMap);
        confirmData.setReplaceSVolSet(this.replaceSVolSet);
        ArrayList<SJctrCreateTIPairConfirmData> list = new ArrayList<SJctrCreateTIPairConfirmData>(1);
        list.add(confirmData);
        this.putCache("ASSIGN_SVOL_CONFIRMDATA", list);
        return confirmData;
    }

    private boolean checkAssignSVolPair() {
        boolean ret = false;
        for (SJctrCreateTIPairInfo createTiPairInfo : this.createTiPairList) {
            SJmoLdevIndex sVolIndex = createTiPairInfo.getSVolIndex();
            if (sVolIndex == null || sVolIndex.getIndex() == -1) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.checkAssignSVolPair()) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        }
    }

    @Override
    protected Set<SJmoGetKind_IF> getKindSet() {
        Set<SJmoGetKind_IF> kindSet = super.getKindSet();
        kindSet.add(new SJmoGetHUVMVirtualLdev());
        kindSet.add(new SJmoGetTiPvolStatus());
        kindSet.add(new SJmoGetTiSnapshotPairList());
        return kindSet;
    }
}

