/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.replication.SJctrTiPvolMuComparator;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrSnapshotGroupErrorTableModel;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter_PVolMU;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetIndex;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTIPairGetExecuter_SSGrp
extends SJctrTIPairGetExecuter_PVolMU {
    private List<SJmoSnapshotSetIndex> selectSSGrpList = Collections.emptyList();
    private final int MAX_SELECT_SSGRP_NUM = 1;

    @Override
    public boolean checkInputData(List<?> inputDataList) {
        for (Object inputData : inputDataList) {
            if (inputData instanceof SJmoSnapshotSetIndex) continue;
            SJctrCreateTIPairUtility.createError(107001);
        }
        this.selectSSGrpList = inputDataList;
        return true;
    }

    @Override
    public boolean checkConstractData() {
        SJmoTiSnapshotPair[] tiSSPairArray = this.tiSSPairList.getSnapshotPair();
        this.selectPVolMuList = new ArrayList(32768);
        for (SJmoSnapshotSetIndex selectSSGrp : this.selectSSGrpList) {
            SJmoTiPvolMu[] pairArray;
            int selSSGrpId = selectSSGrp.getIndex();
            SJmoTiSnapshotPair selectSSGrpPair = null;
            for (SJmoTiSnapshotPair tiSSPair : tiSSPairArray) {
                if (tiSSPair.getSnapshotID() != (long)selSSGrpId) continue;
                selectSSGrpPair = tiSSPair;
                break;
            }
            if (selectSSGrpPair == null) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "TiSnapshotPair not Found. SnapshotGroup = " + SJctrComUtility.toDecString(selSSGrpId));
                SJctrCreateTIPairUtility.createError(106534);
            }
            for (SJmoTiPvolMu tiPair : pairArray = selectSSGrpPair.getPvolMu()) {
                this.selectPVolMuList.add(tiPair);
            }
        }
        if (this.selectPVolMuList.size() > 32768) {
            SJctrCreateTIPairUtility.createError(205160);
        }
        Collections.sort(this.selectPVolMuList, new SJctrTiPvolMuComparator());
        return true;
    }

    @Override
    protected boolean checkGetInfo(List<SJctrCreateTIPairInfo> tiPairList) {
        List<SJmoSnapshotSetInfo> cascadeMixedSnapshotGroupList;
        Set<Integer> snapshotGroupSet = SJctrTiReplicationUtility.getSetSnapshotGroupId(tiPairList = this.checkRSGInfoFromSelectedPairList(tiPairList));
        if (snapshotGroupSet.size() != this.selectSSGrpList.size()) {
            ArrayList<SJmoSnapshotSetInfo> errorSsGList = new ArrayList<SJmoSnapshotSetInfo>();
            for (SJmoSnapshotSetIndex snapshotIndex : this.selectSSGrpList) {
                if (snapshotGroupSet.contains(snapshotIndex.getISnapshotSetId())) continue;
                errorSsGList.add(this.ssGrpMgr.getSnapshotSetInfo(snapshotIndex));
            }
            this.createSnapshotErrorTable(errorSsGList, 206165);
        }
        if ((cascadeMixedSnapshotGroupList = SJctrTiReplicationUtility.getSnpashotGroupListMixedCascadeAttr(tiPairList)).size() >= 1) {
            this.createSnapshotErrorTable(cascadeMixedSnapshotGroupList, 206314);
        }
        if (SJctrTiReplicationUtility.isMixedCascadeAttrForCreateTiPairInfo(tiPairList)) {
            SJctrCreateTIPairUtility.createError(206328);
        }
        return true;
    }

    private void createSnapshotErrorTable(List<SJmoSnapshotSetInfo> snapshotGroupList, int errorCode) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(snapshotGroupList.size());
        Collections.sort(snapshotGroupList);
        for (SJmoSnapshotSetInfo snapshotGroupInfo : snapshotGroupList) {
            SJctrError err = new SJctrError(209, 22, errorCode);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(snapshotGroupInfo, err);
            errColumnList.add(errColumn);
        }
        SJctrSnapshotGroupErrorTableModel errTable = new SJctrSnapshotGroupErrorTableModel();
        errTable.setDataController(this.dc);
        errTable.initGuidance(this.dc.getOwner().getComUtility());
        errTable.createModelDirect();
        errTable.divideModelData(this.dc.getProxy().getModelDataMap());
        errTable.setTableKeyData(snapshotGroupList);
        errTable.makeDataModel();
        SJctrCreateTIPairUtility.createErrorTable(this.dc, errTable, errColumnList);
    }

    @Override
    protected List<SJctrCreateTIPairInfo> checkRSGInfoFromSelectedPairList(List<SJctrCreateTIPairInfo> tiPairList) {
        ArrayList<SJctrCreateTIPairInfo> trnList = new ArrayList<SJctrCreateTIPairInfo>();
        SJctrUserController uc = this.dc.getOwner();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(this.dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this.dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJctrCreateTIPairInfo pair : tiPairList) {
            boolean pRSGflg = SJctrReplicationUtility.checkLocalPairResource(pair.getPVolIndex(), resourceLdevs);
            if (!pRSGflg) continue;
            trnList.add(pair);
        }
        return trnList;
    }
}

