/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.serverux.dataimpl.MRCFErrorDetail;
import sanproject.serverux.dataimpl.MRCFErrorInf;
import sanproject.serverux.dataimpl.MRCFsetCreatePair;
import sanproject.serverux.dataimpl.MRCFsetCrtPairMain;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairInfo;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairsErrorInfo;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrPairConfigInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrCreatePairAC
extends SJctrApplyController {
    List<SJctrError> resultData = null;
    protected final short FUNC_SN2 = 1;
    protected SJctrPairConfigInfo pairConfig = null;
    protected List<SJctrCreatePairInfo> pairList = null;
    private int SET_NUM = 256;
    private int SET_TIME = 5;

    public void setApplyList(SJctrPairConfigInfo pairConfig, List<SJctrCreatePairInfo> pairList) {
        this.pairConfig = pairConfig;
        this.pairList = pairList;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<MRCFsetCrtPairMain> applyList = new ArrayList<MRCFsetCrtPairMain>();
        MRCFsetCrtPairMain crtPairMain = new MRCFsetCrtPairMain();
        crtPairMain.setKind(this.pairConfig.getCopyType());
        crtPairMain.setCopyPace(this.pairConfig.getCopyPace());
        crtPairMain.setSFunc((short)1);
        ArrayList<SJctrCreatePairInfo> applyPairList = new ArrayList<SJctrCreatePairInfo>(this.pairList.size());
        for (SJctrCreatePairInfo pairInfo : this.pairList) {
            if (pairInfo.isExisting()) continue;
            applyPairList.add(pairInfo);
        }
        MRCFsetCreatePair[] setCrtPairArray = new MRCFsetCreatePair[applyPairList.size()];
        for (int index = 0; index < applyPairList.size(); ++index) {
            SJctrCreatePairInfo pairInfo = (SJctrCreatePairInfo)applyPairList.get(index);
            MRCFsetCreatePair crtPair = new MRCFsetCreatePair();
            SJmoLdevIndex pVOLIndex = pairInfo.getPVolIndex();
            crtPair.setPvolLdkc(pVOLIndex.getSLdkc());
            crtPair.setPvolCu(pVOLIndex.getSCu());
            crtPair.setPvolLdev(pVOLIndex.getSLdev());
            crtPair.setSvolLdkc(pairInfo.getSLdkc());
            crtPair.setSvolCu(pairInfo.getSCu());
            crtPair.setSvolLdev(pairInfo.getSLdev());
            crtPair.setMu(pairInfo.getSMuNum());
            setCrtPairArray[index] = crtPair;
        }
        crtPairMain.setCreatePair(setCrtPairArray);
        applyList.add(crtPairMain);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        MRCFErrorInf errorInfo;
        MRCFErrorDetail[] errorDtlArray;
        int errcode = 0;
        int errfunc = 0;
        short copyType = this.pairConfig.getCopyType();
        if (copyType == 0) {
            errfunc = 71;
        } else if (copyType == 1) {
            errfunc = 70;
        }
        int errmodule = 5;
        if (resultObject instanceof MRCFErrorInf && (errorDtlArray = (errorInfo = (MRCFErrorInf)resultObject).getErrorDetail()).length > 0) {
            HashSet<Integer> mix = new HashSet<Integer>();
            ArrayList<SJctrCreatePairsErrorInfo> errorList = new ArrayList<SJctrCreatePairsErrorInfo>(errorDtlArray.length);
            for (int index = 0; index < errorDtlArray.length; ++index) {
                MRCFErrorDetail errorDtl = errorDtlArray[index];
                SJmoLdevIndex pVol = new SJmoLdevIndex();
                pVol.setSLdkc(errorDtl.getPvolLdkc());
                pVol.setSCu(errorDtl.getPvolCu());
                pVol.setSLdev(errorDtl.getPvolLdev());
                SJmoLdevIndex sVol = new SJmoLdevIndex();
                sVol.setSLdkc(errorDtl.getSvolLdkc());
                sVol.setSCu(errorDtl.getSvolCu());
                sVol.setSLdev(errorDtl.getSvolLdev());
                int errorCode = errorDtl.getErrCode();
                if (errorCode != 0) {
                    mix.add(errorCode);
                }
                SJctrError error = new SJctrError(errfunc, errmodule, errorCode);
                SJctrCreatePairsErrorInfo createPairErr = new SJctrCreatePairsErrorInfo(pVol, sVol, error);
                errorList.add(createPairErr);
            }
            if (mix.size() == 0) {
                errcode = 0;
            } else if (mix.size() == 1) {
                errmodule = 5;
                Object[] errArray = mix.toArray();
                errcode = (Integer)errArray[0];
            } else {
                errfunc = 201;
                errmodule = 22;
                errcode = 106039;
            }
            SJctrError result = new SJctrError(errfunc, errmodule, errcode);
            this.setError(result);
            Collections.sort(errorList);
            this.resultData = new ArrayList<SJctrError>(this.pairList.size());
            for (SJctrCreatePairInfo pairInfo : this.pairList) {
                int index;
                SJctrError error = null;
                error = pairInfo.isExisting() ? new SJctrError(209, 22, 0) : ((index = Collections.binarySearch(errorList, pairInfo)) < 0 ? new SJctrError(209, 22, 107005) : ((SJctrCreatePairsErrorInfo)errorList.get(index)).getErrorInfo());
                this.resultData.add(error);
            }
        }
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public int getLeadTime() {
        int leadTime = 0;
        int pairNum = this.pairList.size();
        leadTime = pairNum / this.SET_NUM * this.SET_TIME;
        if (pairNum % this.SET_NUM > 0) {
            leadTime += this.SET_TIME;
        }
        return leadTime;
    }
}

