/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrPairLUPathTableKeyInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrSVolHGNameIscsiTargetAliasColumnFromPairLUPathTableKeyInfo
extends SJctrColumn {
    public SJctrSVolHGNameIscsiTargetAliasColumnFromPairLUPathTableKeyInfo(String key) {
        super(key);
        this.setPartsId("HG_NAME_ISCSI_TARGET_ALIAS");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHostGroupInfo> retList = new ArrayList<SJmoHostGroupInfo>();
        SJctrPairLUPathTableKeyInfo pairLUPathInfo = (SJctrPairLUPathTableKeyInfo)index;
        SJmoPortLunDetail luPathInfo = pairLUPathInfo.getLUPathInfo();
        if (luPathInfo == null) {
            return retList;
        }
        SJmoPortIndex targetHG = null;
        List<?> portHGList = modelData.get(SJmoGetPortHostGroupInfo.class);
        int portIndex = Collections.binarySearch(portHGList, luPathInfo);
        if (portIndex >= 0) {
            SJmoPortHostGroupInfo portHGInfo = (SJmoPortHostGroupInfo)portHGList.get(portIndex);
            ArrayList hgInfoList = portHGInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                if (hgInfo.getSHostGroup() != luPathInfo.getSHostGroup()) continue;
                targetHG = hgInfo;
                break;
            }
        } else {
            List<?> portIscsiTargetList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
            int portIscsiIndex = Collections.binarySearch(portIscsiTargetList, luPathInfo);
            if (portIscsiIndex >= 0) {
                SJmoPortIscsiTargetInfo portIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portIscsiTargetList.get(portIscsiIndex);
                ArrayList<SJmoIscsiTargetInfo> iscsiTargetInfoList = portIscsiTargetInfo.getAlPortIscsiTarget();
                for (SJmoIscsiTargetInfo iscsiTargetInfo : iscsiTargetInfoList) {
                    if (iscsiTargetInfo.getSIscsiTarget() != luPathInfo.getSHostGroup()) continue;
                    targetHG = iscsiTargetInfo;
                    break;
                }
            }
        }
        retList.add((SJmoHostGroupInfo)targetHG);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            Object hgInfo = dataList.get(0);
            if (hgInfo != null) {
                SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
                ret = hgInfo instanceof SJmoHostGroupInfo ? util.toHostGroupNameDisplay((SJmoHostGroupInfo)hgInfo) : (hgInfo instanceof SJmoIscsiTargetInfo ? util.toIscsiTargetAliasDisplay((SJmoIscsiTargetInfo)hgInfo) : "?");
            } else {
                ret = "?";
            }
        }
        return ret;
    }
}

