/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.editscptime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.local.chgscptime.SJctrChangeSCPTimeDC;
import sanproject.sn2.controller.wizard.replication.local.editscptime.SJctrEditSCPTimeConfirmData;
import sanproject.sn2.controller.wizard.replication.local.editscptime.SJctrEditSCPTimeTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationCuOptionInfoMgr;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCuOptionInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationCuOptionInfoMgr;

public class SJctrEditSCPTimeDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830753;
    private static final String DISP_TITLE = "EDIT_SCP_TIME";
    private static final String KEY_TABLE_EDIT_SCP_TIME = "COM_TABLE_SCP_TIME";
    private static final String KEY_CHANGE_SCP_TIME = "COM_CHANGE_SCP_TIME";

    public SJctrEditSCPTimeDC() {
        super(17830753);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_EDIT_SCP_TIME, new SJctrEditSCPTimeTableModel());
        SJctrButtonDataModel changeSCPTimeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_CHANGE_SCP_TIME, changeSCPTimeButton);
        changeSCPTimeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditSCPTimeDC.this.fireMessageEvent(EDIT_SCP_TIME.SELECT_CHANGE_SCP_TIME);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_SCP_TIME.SELECT_CHANGE_SCP_TIME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSCPTimeDC.this.makeChangeSCPTime(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrEditSCPTimeDC.this.exitDialogAction(param);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    private void makeChangeSCPTime(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        HashMap param = new HashMap();
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_EDIT_SCP_TIME);
        List<Object> selectedCu = table.getSelectedRowData();
        if (selectedCu.size() == 0) {
            this.getLogUty().putlog("makeChangeSCPTime", "not selected");
            return;
        }
        param.put("KEY_SELECTED_CU", selectedCu);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrChangeSCPTimeDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRemoteReplicationCuOptionInfoMgr kind = new SJmoGetRemoteReplicationCuOptionInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        Object inhelitedObj;
        List<?> newScpTimeList = null;
        newScpTimeList = carryMap.get("KEY_NEW_SCP_TIME");
        if (newScpTimeList != null && newScpTimeList.size() > 0 && (inhelitedObj = newScpTimeList.get(0)) != null) {
            int newScpTime = (Integer)inhelitedObj;
            SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_EDIT_SCP_TIME);
            List<Object> selectedCu = table.getSelectedRowData();
            for (Object cuInfo : selectedCu) {
                ((SJmoRemoteReplicationCuOptionInfo)cuInfo).setISusScpTime(newScpTime);
            }
            table.doRefresh();
            table.addRowSelectionList(selectedCu);
            this.updateFooter();
        }
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationCuOptionInfoMgr cuOptInfoMgr = this.getSJmoRemoteReplicationCuOptionInfoMgr();
            List<SJmoRemoteReplicationCuOptionInfo> cuOptInfo = this.getEditableCuList(cuOptInfoMgr);
            SJctrEditSCPTimeTableModel scpTimeTbl = (SJctrEditSCPTimeTableModel)this.getDataObjectModel(KEY_TABLE_EDIT_SCP_TIME);
            scpTimeTbl.setBasicDataList(cuOptInfo);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private List<SJmoRemoteReplicationCuOptionInfo> getEditableCuList(SJmoRemoteReplicationCuOptionInfoMgr cuOptInfoMgr) {
        List<SJmoRemoteReplicationCuOptionInfo> retList = null;
        SJmoRemoteReplicationCuOptionInfo[] cupotlist = cuOptInfoMgr.getRemoteReplicationCUOptionInfoList();
        if (null == cupotlist) {
            this.getLogUty().putlog("getEditableCuList", "Information of CU option list is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        retList = Arrays.asList(cupotlist);
        if (retList.size() == 0) {
            this.getLogUty().putlog("getEditableCuList", "Information of CU option length is zero");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(retList);
        return retList;
    }

    @Override
    public boolean checkEndData() {
        SJctrEditSCPTimeConfirmData confirmData = new SJctrEditSCPTimeConfirmData();
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_EDIT_SCP_TIME);
        List<Object> cuOptInfo = table.getAllRowData();
        confirmData.setCuOptInfo(cuOptInfo);
        ArrayList<SJctrEditSCPTimeConfirmData> confirmDataList = new ArrayList<SJctrEditSCPTimeConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditSCPTimeConfirmData.class, confirmDataList);
        SJctrReplicationUtility.setFinishChangeCheck(this, false);
        return true;
    }

    private SJmoRemoteReplicationCuOptionInfoMgr getSJmoRemoteReplicationCuOptionInfoMgr() {
        List<?> cuOptInfoMgrList = this.getCache(SJmoGetRemoteReplicationCuOptionInfoMgr.class);
        if (null == cuOptInfoMgrList) {
            this.getLogUty().putlog("SJmoRemoteReplicationCuOptionInfoMgr", "Information of CU option is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 >= cuOptInfoMgrList.size()) {
            this.getLogUty().putlog("SJmoRemoteReplicationCuOptionInfoMgr", "Information of CU option length is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRemoteReplicationCuOptionInfoMgr cuOptInfoMgr = (SJmoRemoteReplicationCuOptionInfoMgr)cuOptInfoMgrList.get(0);
        if (null == cuOptInfoMgr) {
            this.getLogUty().putlog("SJmoRemoteReplicationCuOptionInfoMgr", "Information of CU option is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        try {
            cuOptInfoMgr = (SJmoRemoteReplicationCuOptionInfoMgr)cuOptInfoMgr.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogUty().putlog("SJmoRemoteReplicationCuOptionInfoMgr", "Information of CU option cannot clone.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return cuOptInfoMgr;
    }

    public static enum EDIT_SCP_TIME implements SJctrNotifyState
    {
        SELECT_CHANGE_SCP_TIME;

    }
}

