/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.releasereservectgs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.com.SJctrCTGInfo;
import sanproject.sn2.controller.wizard.replication.local.releasereservectgs.SJctrReleaseReserveConsistencyGroupsAC;
import sanproject.sn2.controller.wizard.replication.local.releasereservectgs.SJctrReleaseReserveConsistencyGroupsConfirmDC;
import sanproject.sn2.controller.wizard.replication.local.releasereservectgs.SJctrReleaseReserveConsistencyGroupsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationConsistencyGroupInfoMgr;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationConsistencyGroupInfoMgr;

public class SJctrReleaseReserveConsistencyGroupsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RELEASE_RESERVED_CTG";
    private static final Class<?> CONFIRM_DC = SJctrReleaseReserveConsistencyGroupsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrReleaseReserveConsistencyGroupsAC ac = new SJctrReleaseReserveConsistencyGroupsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJctrCTGInfo> inheritedList = dc.getProxy().getCache("KEY_SELECTED_CTG");
            if (null == inheritedList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == inheritedList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoLocalReplicationConsistencyGroupInfoMgr> allCtgInfoList = SJctrReplicationUtility.getSJctrCTGInfo(dc);
            SJmoLocalReplicationConsistencyGroupInfoMgr allCtgInfo = allCtgInfoList.get(0);
            List<SJctrCTGInfo> ctgInfo = SJctrReplicationUtility.checkAndGetExistCtglInfo(inheritedList, allCtgInfo);
            if (!SJctrReplicationUtility.isCtgStatusMFReserved(ctgInfo)) {
                dc.getLogUty().putlog("constructConfirmData", "CTG is not reserved.");
                SJctrError err = new SJctrError(209, 22, 106170);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrReleaseReserveConsistencyGroupsConfirmData confirmData = new SJctrReleaseReserveConsistencyGroupsConfirmData();
            ArrayList<SJctrReleaseReserveConsistencyGroupsConfirmData> confirmDataList = new ArrayList<SJctrReleaseReserveConsistencyGroupsConfirmData>();
            confirmData.setCTGInfo(ctgInfo);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrReleaseReserveConsistencyGroupsConfirmData.class, confirmDataList);
            ac.setApplyData(confirmData);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException exp) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(exp, 107002);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetLocalReplicationConsistencyGroupInfoMgr kind = new SJmoGetLocalReplicationConsistencyGroupInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }
}

