/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addssids;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.wizard.replication.com.SJctrItemSelectListenerRemoteConnectBase;
import sanproject.sn2.controller.wizard.replication.remote.addssids.SJctrAddSsidsSubWizard;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;

public class SJctrItemSelectListenerAddSsids
extends SJctrItemSelectListenerRemoteConnectBase {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        SJctrDataController dc = event.getSource().getDataController();
        SJctrUserController uc = dc.getOwner();
        if (event.isSelect()) {
            List<SJmoRemoteReplicationRCUInfo> selectedConnList = this.getSelectedRowRCUInfoFromToTopTable(event);
            SJmoRemoteReplicationRCUInfo rcuInfo = selectedConnList.get(0);
            if (rcuInfo == null) {
                uc.getLogUty().putlog("selectChanged", "SJmoRemoteReplicationRCUInfo is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (rcuInfo.getICUFree() != 0) {
                uc.getLogUty().putlog("selectChanged", "Can't add ssid because connection type selected connection is not cu.");
                SJctrError err = new SJctrError(210, 22, 206062);
                SJcException exp = err.createException();
                throw exp;
            }
            if (rcuInfo.getINumofSSID() >= 4) {
                uc.getLogUty().putlog("selectChanged", "Can't add ssid because max ssids already has be set.");
                SJctrError err = new SJctrError(210, 22, 206060);
                SJcException exp = err.createException();
                throw exp;
            }
            if (rcuInfo.getRCUOption().getINumofMimPath() > rcuInfo.getPathInfoList().size()) {
                uc.getLogUty().putlog("selectChanged", "Can't add ssid because set path count under the minimum path count.");
                SJctrError err = new SJctrError(210, 22, 206143);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Object> param = new ArrayList<Object>();
            HashMap<String, List<SJmoRemoteReplicationRCUInfo>> paramMap = new HashMap<String, List<SJmoRemoteReplicationRCUInfo>>();
            paramMap.put("KEY_REMOTE_SELECTED_CONNECTION", selectedConnList);
            param.add(SJctrAddSsidsSubWizard.class);
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }
}

